; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;************************************************************************************************
;
; Calculates self-shielding correction factors for a slab geometry sample within a container.
;
; This program is a user friendly widget program that communicates with a
; program written by John Copley (slab_ss_calc.pro)
;
; Modified out of all recognition starting April 2004 (Inma Peral + John Copley)
;
;
@slab_ss_Plot
@slab_ss_Procs
@slab_ss_Calc


;************************************************************************************************
pro slab_ss_Cleanup,tlb
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,tlb,get_uvalue = pState
;
; Revert to original colors prior to exiting.
tvlct, (*pState).default_colors
;
;s = size((*pState).notify_IDs)
;if (s[0] eq 1) then count = 0 else count = s[2]-1
;;
;; Outer If statement added to accomodate standalone operation of "slab_ss" program.
;if (size(*(*pState).inPtr,/type) eq 8) then begin
;	for j = 0,count do begin
;  	slab_ssInfo = {slab_ssEvent,$
;                  ID:(*pState).notify_IDs[0,j],$
;                  Top:(*pState).notify_IDs[1,j],$
;                  Handler:0l,$
;                  inPtr:ptr_new(*(*pState).inPtr)}
;  	if (widget_info((*pState).notify_IDs[0,j],/valid_id)) then begin $
;      widget_control,(*pState).notify_IDs[0,j],send_event = slab_ssInfo
;  	endif
;	endfor
;endif
;free_ptr,(*pState).inPtr
;
wdelete,(*pState).winPix
ptr_free,(*pState).phiPtr
ptr_free,(*pState).ssfPtr
ptr_free,(*pState).fcscPtr
ptr_free,(*pState).fccPtr
ptr_free,(*pState).safPtr
ptr_free,(*pState).tsPtr
ptr_free,(*pState).tcPtr
ptr_free,pState
;
return
;
end


;************************************************************************************************
pro slab_ss_Quit,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,/destroy
;
end


;************************************************************************************************
pro slabHFBSAngles,event
;************************************************************************************************
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
widget_control,(*pState).butt_phi,set_value = "HFBS detector angles"
widget_control,(*pState).butt_phi,sensitive=0
widget_control,(*pState).butt_DCS,set_button=0
widget_control,(*pState).butt_user,set_button=0
widget_control,(*pState).butt_HFBS,set_button=1
default_colors=(*pState).default_colors
detangles = dblarr(16)
detangles = [14.46,20.98,27.08,32.31,36.0,43.75,51.5,59.25,67.0,$
             74.75,82.5,90.25,98.0,105.75,113.5,121.5]
;
ptr_free,(*pState).phiPtr
(*pState).phiPtr = ptr_new(detangles,/no_copy)
slab_ss_calc,(*pState).sigtS,(*pState).sigtC,(*pState).psi0,*(*pState).phiPtr,(*pState).signconv,$
	ssf=ssf,fcsc=fcsc,fcc=fcc,saf=saf,transm_s=transm_s,transm_c=transm_c,ts0=ts0,tc0=tc0
ptr_free,(*pState).ssfPtr
ptr_free,(*pState).fcscPtr
ptr_free,(*pState).fccPtr
ptr_free,(*pState).safPtr
ptr_free,(*pState).tsPtr
ptr_free,(*pState).tcPtr
(*pState).ssfPtr=ptr_new(ssf,/no_copy)
(*pState).fcscPtr=ptr_new(fcsc,/no_copy)
(*pState).fccPtr=ptr_new(fcc,/no_copy)
(*pState).safPtr=ptr_new(saf,/no_copy)
(*pState).tsPtr=ptr_new(transm_s,/no_copy)
(*pState).tcPtr=ptr_new(transm_c,/no_copy)
(*pState).ts0=ts0
(*pState).tc0=tc0
;
id=lonarr(4)
id[0]=widget_info(event.top,find_by_uname='L-L')
id[1]=widget_info(event.top,find_by_uname='R-R')
id[2]=widget_info(event.top,find_by_uname='L-R')
id[3]=widget_info(event.top,find_by_uname='R-L')
widget_control,id[0],set_button=1
widget_control,id[1],set_button=0
widget_control,id[2],set_button=0
widget_control,id[3],set_button=0
signconv=[0,0]
;
(*pState).signconv=signconv
;
wset,(*pState).winPix
;colorset
tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
slab_ss_Plot,event
tvlct,default_colors
wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
widget_control,event.top,set_uvalue = pState,/no_copy
;
slab_plotgeom,event.top
;
return
;
end


;************************************************************************************************
pro slabDCSAngles,event
;************************************************************************************************
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
widget_control,(*pState).butt_phi,set_value = "DCS detector angles"
widget_control,(*pState).butt_phi,sensitive=0
widget_control,(*pState).butt_HFBS,set_button=0
widget_control,(*pState).butt_DCS,set_button=1
widget_control,(*pState).butt_user,set_button=0
default_colors=(*pState).default_colors
detangles = dblarr(913)
;
defsysv,'!DAVE_AUXILIARY_DIR',exists=exists
if (exists) then begin
	inputfile = !DAVE_AUXILIARY_DIR+"dcs_DetPos2.dat"
endif else begin
	inputfile = "C:\DAVE_CVS\DAVE\PROGRAMS\auxiliary\"+"dcs_DetPos2.dat"
endelse
;
ndets = 913
detangles = dblarr(ndets)
index=indgen(ndets)
;
catch,errno
if (errno ne 0) then begin
  catch,/cancel
  void = dialog_message(/error,["Unknown error detected",!err_string])
  widget_control,event.top,set_uvalue = pState,/no_copy
  return
endif
;
; display the hourglass symbol to denote we're doing some work here
widget_control,/hourglass
angle = 0.0
num = 0
openr, lun, inputfile, /get_lun
instr = ''
readf,lun,instr
for i = 0,ndets-1 do begin
  readf,lun,num,num,num,num,num,num,num,num,angle
  detangles[i] = angle
endfor
free_lun,lun
index = sort(detangles)
detangles=detangles[index]
;
ptr_free,(*pState).phiPtr
(*pState).phiPtr = ptr_new(detangles,/no_copy)
slab_ss_calc,(*pState).sigtS,(*pState).sigtC,(*pState).psi0,*(*pState).phiPtr,(*pState).signconv,$
	ssf=ssf,fcsc=fcsc,fcc=fcc,saf=saf,transm_s=transm_s,transm_c=transm_c,ts0=ts0,tc0=tc0
ptr_free,(*pState).ssfPtr
ptr_free,(*pState).fcscPtr
ptr_free,(*pState).fccPtr
ptr_free,(*pState).safPtr
ptr_free,(*pState).tsPtr
ptr_free,(*pState).tcPtr
(*pState).ssfPtr=ptr_new(ssf,/no_copy)
(*pState).fcscPtr=ptr_new(fcsc,/no_copy)
(*pState).fccPtr=ptr_new(fcc,/no_copy)
(*pState).safPtr=ptr_new(saf,/no_copy)
(*pState).tsPtr=ptr_new(transm_s,/no_copy)
(*pState).tcPtr=ptr_new(transm_c,/no_copy)
(*pState).ts0=ts0
(*pState).tc0=tc0
;
id=lonarr(4)
id[0]=widget_info(event.top,find_by_uname='L-L')
id[1]=widget_info(event.top,find_by_uname='R-R')
id[2]=widget_info(event.top,find_by_uname='L-R')
id[3]=widget_info(event.top,find_by_uname='R-L')
widget_control,id[0],set_button=0
widget_control,id[1],set_button=1
widget_control,id[2],set_button=0
widget_control,id[3],set_button=0
signconv=[1,1]
;
(*pState).signconv=signconv
;
wset,(*pState).winPix
;colorset
tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
slab_ss_Plot,event
tvlct,default_colors
wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
widget_control,event.top,set_uvalue = pState,/no_copy
;
slab_plotgeom,event.top
;
return
;
end


;************************************************************************************************
pro slabuserAngles,event
;************************************************************************************************
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
widget_control,(*pState).butt_phi,sensitive=1
widget_control,(*pState).butt_HFBS,set_button=0
widget_control,(*pState).butt_DCS,set_button=0
widget_control,(*pState).butt_user,set_button=1
default_colors=(*pState).default_colors
phistart = (*pState).phistart_def
phistop  = (*pState).phistop_def
phistep  = (*pState).phistep_def
phivals=[phistart,phistop,phistep]
phivals=strjoin(string(phivals,format='(f7.2)'),',')
;
widget_control,(*pState).butt_phi,set_value = phivals
nangles = 1+fix((phistop-phistart)/phistep)
phi = phistart+phistep*dindgen(nangles)
ptr_free,(*pState).phiPtr
(*pState).phiPtr = ptr_new(phi,/no_copy)
;
slab_ss_calc,(*pState).sigtS,(*pState).sigtC,(*pState).psi0,*(*pState).phiPtr,(*pState).signconv,$
	ssf=ssf,fcsc=fcsc,fcc=fcc,saf=saf,transm_s=transm_s,transm_c=transm_c,ts0=ts0,tc0=tc0
ptr_free,(*pState).ssfPtr
ptr_free,(*pState).fcscPtr
ptr_free,(*pState).fccPtr
ptr_free,(*pState).safPtr
ptr_free,(*pState).tsPtr
ptr_free,(*pState).tcPtr
(*pState).ssfPtr=ptr_new(ssf,/no_copy)
(*pState).fcscPtr=ptr_new(fcsc,/no_copy)
(*pState).fccPtr=ptr_new(fcc,/no_copy)
(*pState).safPtr=ptr_new(saf,/no_copy)
(*pState).tsPtr=ptr_new(transm_s,/no_copy)
(*pState).tcPtr=ptr_new(transm_c,/no_copy)
(*pState).ts0=ts0
(*pState).tc0=tc0
;
wset,(*pState).winPix
;colorset
tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
slab_ss_Plot,event
tvlct,default_colors
wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
widget_control,event.top,set_uvalue = pState,/no_copy
;
slab_plotgeom,event.top
;
return
;
end


;************************************************************************************************
pro slab_signhelp,event
;************************************************************************************************
compile_opt strictarr
;
message=[$
	'The angle psi0 is the angle between the forward normal and the incident beam direction.',$
	'',$
	'The angle 2theta is the scattering angle.',$
	'',$
	'If the sign convention is such that with psi0 > 0 the forward normal points to the left'+$
	' and 2theta > 0 is to the left, choose "L-L".',$
	'',$
	'If the sign convention is such that with psi0 > 0 the forward normal points to the right'+$
	' and 2theta > 0 is to the right, choose "R-R".',$
	'',$
	'If the sign convention is such that with psi0 > 0 the forward normal points to the left'+$
	' and 2theta > 0 is to the right, choose "L-R".',$
	'',$
	'If the sign convention is such that with psi0 > 0 the forward normal points to the right'+$
	' and 2theta > 0 is to the left, choose "R-L".']
res=dialog_message(message,/information)
end


;************************************************************************************************
pro slab_signconv,event
;************************************************************************************************
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
uname=widget_info(event.id,/uname)
id=lonarr(4)
id[0]=widget_info(event.top,find_by_uname='L-L')
id[1]=widget_info(event.top,find_by_uname='R-R')
id[2]=widget_info(event.top,find_by_uname='L-R')
id[3]=widget_info(event.top,find_by_uname='R-L')
widget_control,id[0],set_button=0
widget_control,id[1],set_button=0
widget_control,id[2],set_button=0
widget_control,id[3],set_button=0
id=widget_info(event.id,find_by_uname=uname)
widget_control,id,set_button=1
case uname of
	'L-L': signconv=[0,0]
	'R-R': signconv=[1,1]
	'L-R': signconv=[0,1]
	'R-L': signconv=[1,0]
endcase
;
(*pState).signconv=signconv
;
widget_control,event.top,set_uvalue = pState
;
slab_ss_calc,(*pState).sigtS,(*pState).sigtC,(*pState).psi0,*(*pState).phiPtr,(*pState).signconv,$
	ssf=ssf,fcsc=fcsc,fcc=fcc,saf=saf,transm_s=transm_s,transm_c=transm_c,ts0=ts0,tc0=tc0
ptr_free,(*pState).ssfPtr
ptr_free,(*pState).fcscPtr
ptr_free,(*pState).fccPtr
ptr_free,(*pState).safPtr
ptr_free,(*pState).tsPtr
ptr_free,(*pState).tcPtr
(*pState).ssfPtr=ptr_new(ssf,/no_copy)
(*pState).fcscPtr=ptr_new(fcsc,/no_copy)
(*pState).fccPtr=ptr_new(fcc,/no_copy)
(*pState).safPtr=ptr_new(saf,/no_copy)
(*pState).tsPtr=ptr_new(transm_s,/no_copy)
(*pState).tcPtr=ptr_new(transm_c,/no_copy)
(*pState).ts0=ts0
(*pState).tc0=tc0
wset,(*pState).winPix
;colorset
tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
slab_ss_Plot,event
tvlct,(*pState).default_colors
wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
widget_control,event.top,set_uvalue = pState
;
slab_plotgeom,event.top
;
end


;************************************************************************************************
pro slab_plotoptions,event
;************************************************************************************************
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
uname=widget_info(event.id,/uname)
id=widget_info(event.id,find_by_uname=uname)
;
if (uname eq "Symbols") then begin
	set=widget_info(id,/button_set)
	widget_control,id,set_button=1-set
	(*pState).show_sym=1-(*pState).show_sym
	wset,(*pState).winPix
	tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
	slab_ss_Plot,event
	tvlct,(*pState).default_colors
	wset,(*pState).winVis
	device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
	widget_control,event.top,set_uvalue = pState
	return
endif
;
if (uname eq "Smallsym") then begin
	set=widget_info(id,/button_set)
	widget_control,id,set_button=1-set
	(*pState).small_sym=1-(*pState).small_sym
	wset,(*pState).winPix
	tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
	slab_ss_Plot,event
	tvlct,(*pState).default_colors
	wset,(*pState).winVis
	device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
	widget_control,event.top,set_uvalue = pState
	return
endif
;
set=widget_info(id,/button_set)
widget_control,id,set_button=1-set
index=fix(strmid(uname,4))
;
case index of
	0: begin
		for k=0,5 do begin
			(*pState).toplot[k]=0
			uname='plot'+strcompress(string(k+1),/remove_all)
			id=widget_info(event.top,find_by_uname=uname)
			widget_control,id,set_button=0
		endfor
		uname='plot0'
		id=widget_info(event.top,find_by_uname=uname)
		widget_control,id,set_button=1
		uname='plot9'
		id=widget_info(event.top,find_by_uname=uname)
		widget_control,id,set_button=0
	end
	9: begin
		for k=0,5 do begin
			(*pState).toplot[k]=1
			uname='plot'+strcompress(string(k+1),/remove_all)
			id=widget_info(event.top,find_by_uname=uname)
			widget_control,id,set_button=1
		endfor
		uname='plot0'
		id=widget_info(event.top,find_by_uname=uname)
		widget_control,id,set_button=0
		uname='plot9'
		id=widget_info(event.top,find_by_uname=uname)
		widget_control,id,set_button=1
	end
	else: begin
		(*pState).toplot[index-1]=1-(*pState).toplot[index-1]
		nset=total((*pState).toplot)
		uname='plot0'
		id=widget_info(event.top,find_by_uname=uname)
		if (nset eq 0) then val=1 else val=0
		widget_control,id,set_button=val
		uname='plot9'
		id=widget_info(event.top,find_by_uname=uname)
		if (nset eq 6) then val=1 else val=0
		widget_control,id,set_button=val
	end
endcase
;
wset,(*pState).winPix
;colorset
tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
slab_ss_Plot,event
tvlct,(*pState).default_colors
wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
;
widget_control,event.top,set_uvalue = pState
;
end

;************************************************************************************************
pro slab_ss_Help,event
;************************************************************************************************
;
compile_opt strictarr
;
;res=dialog_message("Sorry. Help is not presently available.")
;return
;pdf_file = !DAVE_AUXILIARY_DIR+'asc.pdf'
pdf_file = !DAVE_PDFHELP_DIR+'Self_slab_calc.pdf'
void = launch_help(pdf_file,tlb = event.top)
return
end


;************************************************************************************************
pro slab_plotgeom,tlb
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,tlb,get_uvalue = pState
;
;(*pState).bangx=!x
;(*pState).bangy=!y
;(*pState).bangp=!p
;
; Change the margins so that there are no margins.  Store the
; existing margins and restore them before returning.
xmargin = !x.margin
ymargin = !y.margin
!x.margin = [0.0,0.0]
!y.margin = [0.0,0.0]
;
xsize=(*pState).win2xsize
ysize=(*pState).win2ysize
smallsize=ysize < xsize
xrange = [-0.5,0.5]*xsize/smallsize
yrange = [-0.5,0.5]*ysize/smallsize
;
wset,(*pState).winVis2
;
signconv=(*pState).signconv*2-1
;
tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
plot,[0,0],[1,1],psym = 0,$
	xstyle = 5,ystyle = 5, $
	xrange = xrange,yrange = yrange
;
; Plot incident beam with arrow.
color=2
wid=0.002
lgth=0.45
oplot,[1,-1,-1,1,1]*wid,[-1,-1,0,0,-1]*lgth,color=color,thick=1
oplot,[0,-0.025],[-0.15,-0.2],color=color,thick=2
oplot,[0,+0.025],[-0.15,-0.2],color=color,thick=2
;
; Plot detector angle range.
angle1=min(*(*pState).phiPtr*signconv[1])
angle2=max(*(*pState).phiPtr*signconv[1])
dangle=10.0
nangle=fix((angle2-angle1)/dangle+1.01) > 1
if (nangle gt 1) then begin
	dangle=(angle2-angle1)/(nangle-1)
	angles=angle1+findgen(nangle)*dangle
endif else angles=0.5*(angle1+angle2)
c=cos(angles*!dtor)
s=sin(angles*!dtor)
c1=cos((angles+155)*!dtor)
s1=sin((angles+155)*!dtor)
c2=cos((angles-155)*!dtor)
s2=sin((angles-155)*!dtor)
color=4
lgth=0.45
tip=0.025
for k=0,nangle-1 do begin
	oplot,[0.0,lgth]*s[k],[0.0,lgth]*c[k],thick=1,color=color
	oplot,[lgth,lgth]*s[k]+[0,tip]*s1[k],[lgth,lgth]*c[k]+[0,tip]*c1[k],thick=1,color=color
	oplot,[lgth,lgth]*s[k]+[0,tip]*s2[k],[lgth,lgth]*c[k]+[0,tip]*c2[k],thick=1,color=color
endfor
if (nangle gt 1) then oplot,lgth*s,lgth*c,color=color,thick=2
tvlct,(*pState).default_colors
;
; Plot slab.
color=1
angle=-(*pState).psi0*!dtor*signconv[0]
c=cos(angle)
s=sin(angle)
hwid=0.125
hthk=0.005
oplot,[-1,1,1,-1,-1]*hwid*c+[1,1,-1,-1,1]*hthk*s,$
			[-1,1,1,-1,-1]*hwid*s+[-1,-1,1,1,-1]*hthk*c,thick=2,color=color
polyfill,[-1,1,1,-1,-1]*hwid*c+[1,1,-1,-1,1]*hthk*s,$
			[-1,1,1,-1,-1]*hwid*s+[-1,-1,1,1,-1]*hthk*c,thick=2,color=color
;
!x.margin = xmargin
!y.margin = ymargin
;!x=(*pState).bangx
;!y=(*pState).bangy
;!p=(*pState).bangp


end


;************************************************************************************************
pro slab_ss_event,event
;************************************************************************************************
;
compile_opt strictarr
;
;
widget_control,event.top,get_uvalue = pState
;
default_colors=(*pState).default_colors
;
case event.id of
;
	(*pState).butt_save: begin
;		defsysv,'!dave_defaults',exists=exists
;		if (exists) then begin
;			path=(*pState).workDir
;			outputfile=dialog_pickfile(dialog_parent=event.top,path=path,filter='*.txt',/write,title='Output file')
;		endif else begin
;			outputfile=dialog_pickfile(dialog_parent=event.top,filter='*.txt',/write,title='Output file')
;		endelse

        path=(*pState).workDir
        outputfile=dialog_pickfile(dialog_parent=event.top,path=path,filter='*.txt',/write,title='Output file')

		if (strlowcase(strmid(outputfile,strlen(outputfile)-4)) ne '.txt') then outputfile=outputfile+'.txt'
		if(outputfile eq "") then begin
			res=dialog_message("No file has been selected.")
			return
		endif
;
		openw,u,outputfile,/get_lun
;		names=(*pState).names
		k=0
		printf,u,format='(a10,f12.4)',"thicknessS ",(*pState).thicknessS
		printf,u,format='(a10,f12.4)',"sigmatS    ",(*pState).sigmatS
		printf,u,format='(a10,f12.4)',"thicknessC ",(*pState).thicknessC
		printf,u,format='(a10,f12.4)',"sigmatC    ",(*pState).sigmatC
		printf,u,format='(a10,f12.4)',"psi0       ",(*pState).psi0
		widget_control,(*pState).butt_phi,get_value=phivals
;
		case phivals[0] of
			'DCS detector angles': printf,u,format='(a20)',"DCS detector angles "
			'HFBS detector angles': printf,u,format='(a20)',"HFBS detector angles"
			else: begin
				printf,u,format='(a20)',"                    "
				phi=*(*pState).phiPtr
				phistart=phi[0]
				nphi=n_elements(phi)
				phistop=phi[nphi-1]
				phistep=(phistop-phistart)/(nphi-1)
 				printf,u,format='(a10,d12.4)',"phistart  ",phistart
   			printf,u,format='(a10,d12.4)',"phistop   ",phistop
   			printf,u,format='(a10,d12.4)',"phistep   ",phistep
			end
		endcase
;
		free_lun,u
	end
;
	(*pState).butt_restore: begin
;		defsysv,'!dave_defaults',exists=exists
;		if (exists) then begin
;			path=(*!dave_defaults).workDir
;			inputfile=dialog_pickfile(dialog_parent=event.top,path=path,filter='*.txt',/read,title='Input file')
;		endif else begin
;			inputfile=dialog_pickfile(dialog_parent=event.top,filter='*.txt',/read,title='Input file')
;		endelse
        path = (*pState).workDir
        inputfile=dialog_pickfile(dialog_parent=event.top,path=path,filter='*.txt',/read,title='Input file')
		if (strlowcase(strmid(inputfile,strlen(inputfile)-4)) ne '.txt') then inputfile=inputfile+'.txt'
		if(inputfile eq "") then begin
			res=dialog_message("No file has been selected.")
			return
		endif
		;widget_control,event.top,get_uvalue = pState
		;if (file_test(inputfile)) then begin
		openr,u,inputfile,/get_lun
		void="thickness "
		;     12345678901234567890
		name="xxxxxxxxxxxxxxxxxxxx"
		k=0
		thicknessS=1.0
		sigmatS=1.0
		sigtS=1.0
		thicknessC=1.0
		sigmatC=1.0
		sigtC=1.0
		psi0=0.0d
		phistart=0.0d
		phistep=0.0d
		readf,u,format='(a10,f12.4)',void,thicknessS
		readf,u,format='(a10,f12.4)',void,sigmatS
		readf,u,format='(a10,f12.4)',void,thicknessC
		readf,u,format='(a10,f12.4)',void,sigmatC
		readf,u,format='(a10,f12.4)',void,psi0
		sigtS=thicknessS*sigmatS
		sigtC=thicknessC*sigmatC
		(*pState).thicknessS=thicknessS
		(*pState).sigmatS=sigmatS
		(*pState).sigtS=sigtS
		(*pState).thicknessC=thicknessC
		(*pState).sigmatC=sigmatC
		(*pState).sigtC=sigtC
		(*pState).psi0=psi0
		readf,u,format='(a20)',name
;
		case name of
			'HFBS detector angles': begin
				free_lun,u
				slabHFBSangles,event
			end
			'DCS detector angles ': begin
	   		free_lun,u
				slabDCSangles,event
			end
			'                    ':  begin
				readf,u,format='(a10,d12.4)',void,phistart
				readf,u,format='(a10,d12.4)',void,phistop
				readf,u,format='(a10,d12.4)',void,phistep
				phivals=[phistart,phistop,phistep]
				widget_control,(*pState).butt_thicknessS,set_value=string((*pState).thicknessS,format='(f7.3)')
				widget_control,(*pState).butt_sigmatS,set_value=string((*pState).sigmatS,format='(f7.3)')
				widget_control,(*pState).butt_sigtS,set_value=string(sigtS,format='(f7.3)')
				widget_control,(*pState).butt_thicknessC,set_value=string((*pState).thicknessC,format='(f7.3)')
				widget_control,(*pState).butt_sigmatC,set_value=string((*pState).sigmatC,format='(f7.3)')
				widget_control,(*pState).butt_sigtC,set_value=string((*pState).sigtC,format='(f7.3)')
				widget_control,(*pState).butt_psi0,set_value=string((*pState).psi0,format='(f7.3)')
				widget_control,(*pState).butt_DCS,set_button=0
				widget_control,(*pState).butt_HFBS,set_button=0
				widget_control,(*pState).butt_user,set_button=1
				phivals=strjoin(string(phivals,format='(f7.2)'),',')
				widget_control,(*pState).butt_phi,set_value=phivals
				nangles = 1+fix((phistop-phistart)/phistep)
				phi = phistart+phistep*dindgen(nangles)
				ptr_free,(*pState).phiPtr
				(*pState).phiPtr = ptr_new(phi,/no_copy)
				slab_ss_calc,(*pState).sigtS,(*pState).sigtC,(*pState).psi0,*(*pState).phiPtr,(*pState).signconv,$
					ssf=ssf,fcsc=fcsc,fcc=fcc,saf=saf,transm_s=transm_s,transm_c=transm_c,ts0=ts0,tc0=tc0
				ptr_free,(*pState).ssfPtr
				ptr_free,(*pState).fcscPtr
				ptr_free,(*pState).fccPtr
				ptr_free,(*pState).safPtr
				ptr_free,(*pState).tsPtr
				ptr_free,(*pState).tcPtr
				(*pState).ssfPtr=ptr_new(ssf,/no_copy)
				(*pState).fcscPtr=ptr_new(fcsc,/no_copy)
				(*pState).fccPtr=ptr_new(fcc,/no_copy)
				(*pState).safPtr=ptr_new(saf,/no_copy)
				(*pState).tsPtr=ptr_new(transm_s,/no_copy)
				(*pState).tcPtr=ptr_new(transm_c,/no_copy)
				(*pState).ts0=ts0
				(*pState).tc0=tc0
				wset,(*pState).winPix
				;colorset
  			tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
	  		slab_ss_Plot,event
				tvlct,(*pState).default_colors
				wset,(*pState).winVis
				device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
				widget_control,event.top,set_uvalue = pState
				slab_plotgeom,event.top
				free_lun,u
			end
		endcase
	end
;
; Handle plot output user preference.
  (*pState).butt_plotssf: begin
  	(*pState).plotwhat=0
  	wset,(*pState).winPix
  	;colorset
  	tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
		slab_ss_Plot,event,/redraw
		tvlct,default_colors
		wset,(*pState).winVis
		device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
		widget_control,event.top,set_uvalue = pState
	end
;
	(*pState).butt_plotint: begin
		res=dialog_message("Sorry, this option is not presently available.")
		widget_control,(*pState).butt_plotssf,/set_button
		widget_control,(*pState).butt_plotint,set_button=0
		event.id=(*pState).butt_plotssf
		return
	end
;
  (*pState).butt_plotord: begin
  		res=dialog_message("Sorry, this option is not presently available.")
   	widget_control,(*pState).butt_plotssf,/set_button
   	widget_control,(*pState).butt_plotord,set_button=0
   	event.id=(*pState).butt_plotssf
    return
  end
;
	else: begin
  ; Handle the input parameters.
  	widget_control,(*pState).butt_phi,get_value = phivals
	;
	; First handle the case where phivals = 'HFBS detector angles' or 'DCS detector angles'.
		if ((phivals eq 'HFBS detector angles') or (phivals eq 'DCS detector angles')) then begin
			widget_control,(*pState).butt_sigmatS,get_value = sigmatS
			sigmatS=float(sigmatS)
			if(n_elements(sigmatS) eq 1) then sigmatS=sigmatS[0]
			slab_ss_checkinput,event,"sigmatS",sigmatS,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
			  widget_control,event.top,set_uvalue = pState
			  return
			endif
;
			widget_control,(*pState).butt_sigmatC,get_value = sigmatC
			sigmatC=float(sigmatC)
			if(n_elements(sigmatC) eq 1) then sigmatC=sigmatC[0]
			slab_ss_checkinput,event,"sigmatC",sigmatC,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
			  widget_control,event.top,set_uvalue = pState
			  return
			endif
;
			widget_control,(*pState).butt_thicknessS,get_value=thicknessS
			thicknessS=float(thicknessS)
			if(n_elements(thicknessS) eq 1) then thicknessS=thicknessS[0]
			slab_ss_checkinput,event,"thicknessS",thicknessS,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
				widget_control,event.top,set_uvalue = pState
				return
			endif
;
			widget_control,(*pState).butt_thicknessC,get_value=thicknessC
			thicknessC=float(thicknessC)
			if(n_elements(thicknessC) eq 1) then thicknessC=thicknessC[0]
			slab_ss_checkinput,event,"thicknessC",thicknessC,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
				widget_control,event.top,set_uvalue = pState
				return
			endif
;
			widget_control,(*pState).butt_psi0,get_value = psi0
			psi0=float(psi0)
			if(n_elements(psi0) eq 1) then psi0=psi0[0]
		 	slab_ss_checkinput,event,"psi0",psi0,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
				widget_control,event.top,set_uvalue = pState
				return
			endif
;
			sigtS=sigmatS*thicknessS
			widget_control,(*pState).butt_sigtS,set_value = string(sigtS,format='(f7.3)')
			(*pState).sigtS=sigmatS*thicknessS
			(*pState).sigmatS=sigmatS
			(*pState).thicknessS=thicknessS
;
			sigtC=sigmatC*thicknessC
			widget_control,(*pState).butt_sigtC,set_value = string(sigtC,format='(f7.3)')
			(*pState).sigtC=sigmatC*thicknessC
			(*pState).sigmatC=sigmatC
			(*pState).thicknessC=thicknessC
;
			(*pState).psi0=psi0
			widget_control,event.top,set_uvalue=pState
			if (phivals eq 'HFBS detector angles') then slabHFBSangles,event
			if (phivals eq 'DCS detector angles')  then slabDCSangles,event
		endif
;
		if ((phivals ne 'HFBS detector angles') and (phivals ne 'DCS detector angles')) then begin
;
			phi_changed=event.id eq (*pState).butt_phi
;
; Check the phivals string. If it's unchanged, and the event occurred at the phivals widget, return.
			if (phi_changed and phivals eq (*pState).old_phivals) then return
;
;			Save the string.
			phivals_string=phivals
;
;			Split the string and check that it has 3 numerical components.
;			Calling them start, stop and step, check that start < stop and step > 0.
; 		If something is not right, and the event occurred at the phivals widget, return.
			phivals=strsplit(phivals,', ',/extract)
			if (n_elements(phivals) eq 3) then begin
					if (total(stregex(phivals,'^ *[0-9.-]* *$',/boolean)) eq 3) then begin
						nums=float(phivals)
					if (phi_changed and (nums[0] ge nums[1] or nums[2] le 0.0)) then return
				endif else if (phi_changed) then return
			endif else if (phi_changed) then return
;
;			If everything is OK, store the old string in *pState and proceed.
			(*pState).old_phivals=phivals_string
;
			slab_ss_checkinput,event,"phivals",phivals,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
			  widget_control,event.top,set_uvalue = pState
			  return
			endif
			philo = phivals[0]
			phihi = phivals[1]
			dphi = phivals[2]
			phivals=strjoin(string(phivals,format='(f7.2)'),',')
  		philo=double(philo)
	  	phihi=double(phihi)
	  	dphi=double(dphi)
;
			slab_ss_checkinput,event,"angles",[philo,phihi,dphi],ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
			  widget_control,event.top,set_uvalue = pState
			  return
			endif
;
			nangles = 1.01+fix((phihi-philo)/dphi)
			phi = philo+dphi*dindgen(nangles)
;
;Now check the other quantities.
 			widget_control,(*pState).butt_sigmatS,get_value = sigmatS
 			widget_control,(*pState).butt_thicknessS,get_value = thicknessS
 			widget_control,(*pState).butt_sigmatC,get_value = sigmatC
 			widget_control,(*pState).butt_thicknessC,get_value = thicknessC
 			widget_control,(*pState).butt_psi0,get_value = psi0
 			sigmatS=float(sigmatS)
 			thicknessS=float(thicknessS)
 			sigmatC=float(sigmatC)
 			thicknessC=float(thicknessC)
 			psi0=float(psi0)
;
  		if(n_elements(sigmatS) eq 1) then sigmatS=sigmatS[0]
	  	if(n_elements(thicknessS) eq 1) then thicknessS=thicknessS[0]
  		if(n_elements(sigmatC) eq 1) then sigmatC=sigmatC[0]
	  	if(n_elements(thicknessC) eq 1) then thicknessC=thicknessC[0]
	  	if(n_elements(psi0) eq 1) then psi0=psi0[0]
;
	  	slab_ss_checkinput,event,"sigmatS",sigmatS,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
			  widget_control,event.top,set_uvalue = pState
			  return
			endif
;
	  	slab_ss_checkinput,event,"sigmatC",sigmatC,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
			  widget_control,event.top,set_uvalue = pState
			  return
			endif
;
			slab_ss_checkinput,event,"thicknessS",thicknessS,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
		  	widget_control,event.top,set_uvalue = pState
		  	return
			endif
;
			slab_ss_checkinput,event,"thicknessC",thicknessC,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
		  	widget_control,event.top,set_uvalue = pState
		  	return
			endif
;
	 		slab_ss_checkinput,event,"psi0",psi0,ok,messages
			if (not ok) then begin
				res=dialog_message(messages)
		  	widget_control,event.top,set_uvalue = pState
		  	return
			endif
;
	  	sigtS=sigmatS*thicknessS
	  	widget_control,(*pState).butt_sigtS,set_value = string(sigtS,format='(f7.3)')
	  	sigtC=sigmatC*thicknessC
	  	widget_control,(*pState).butt_sigtC,set_value = string(sigtC,format='(f7.3)')
;
			ptr_free,(*pState).phiPtr
			(*pState).phiPtr = ptr_new(phi,/no_copy)
;
			slab_ss_calc,sigtS,sigtC,psi0,*(*pState).phiPtr,(*pState).signconv,$
				ssf=ssf,fcsc=fcsc,fcc=fcc,saf=saf,transm_s=transm_s,transm_c=transm_c,ts0=ts0,tc0=tc0
;
			ptr_free,(*pState).ssfPtr
			ptr_free,(*pState).fcscPtr
			ptr_free,(*pState).fccPtr
			ptr_free,(*pState).safPtr
			ptr_free,(*pState).tsPtr
			ptr_free,(*pState).tcPtr
			(*pState).ssfPtr=ptr_new(ssf,/no_copy)
			(*pState).fcscPtr=ptr_new(fcsc,/no_copy)
			(*pState).fccPtr=ptr_new(fcc,/no_copy)
			(*pState).safPtr=ptr_new(saf,/no_copy)
			(*pState).tsPtr=ptr_new(transm_s,/no_copy)
			(*pState).tcPtr=ptr_new(transm_c,/no_copy)
			(*pState).ts0=ts0
			(*pState).tc0=tc0
  		(*pState).sigmatS=sigmatS
  		(*pState).sigtS=sigtS
	  	(*pState).thicknessS=thicknessS
  		(*pState).sigmatC=sigmatC
  		(*pState).sigtC=sigtC
	  	(*pState).thicknessC=thicknessC
	  	(*pState).psi0=psi0
;
			wset,(*pState).winPix
;colorset
	  	tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
  		slab_ss_Plot,event
			tvlct,default_colors
			wset,(*pState).winVis
			device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
			widget_control,event.top,set_uvalue = pState
			slab_plotgeom,event.top
		endif
	end
;
endcase
;
widget_control,event.top,set_uvalue = pState
;
end


;************************************************************************************************
pro slab_ss,$
;      	inPtr=inPtr,$
      	group_leader = group_leader,$
;      	notify_ids = notify_ids,  $
       register_name = register_name, $
       workDir=workDir,_EXTRA=etc
;************************************************************************************************
;
compile_opt strictarr
;
; Slab sample with possible container.
;
; Following 3 statements added to accomodate standalone operation of "slab_ss" program.
;if (n_elements(notify_IDs) eq 0) then notify_IDs=[0l,0l]
;if (not ptr_valid(inPtr)) then inPtr=ptr_new(1)
if (n_elements(group_leader) eq 0) then group_leader=0l
if (n_elements(register_name) eq 0) then register_name = 'slab_ss'
if (n_elements(workDir) eq 0) then begin
    workDir = (n_elements((*!dave_defaults).workDir) gt 0)? (*!dave_defaults).workDir : ''
endif
;
; Only allow one instance to be running.
if (xregistered(register_name)) then begin
	res=dialog_message("Only one instance of this program may be running.",/information)
	return
endif
;
!x.margin = [10,3]
!y.margin = [4,2]
;
;davesysvars ; comment out by RTA
; loadct,0,/silent
; Use Alan's routine to load some colors.
default_colors=bindgen(256,3)
tvlct,default_colors,/get       ; get current color settings
;
; Default plot options
toplot=bytarr(6)+1
;
; Initial (default) values of thicknesses and cross sections.
thicknessS_def=0.1
thicknessC_def=0.1
sigmatS_def=1.0
sigmatC_def=0.01
psi0_def=45.0
thicknessS=thicknessS_def
thicknessC=thicknessC_def
sigmatS=sigmatS_def
sigmatC=sigmatC_def
psi0=psi0_def
sigtS=sigmatS*thicknessS
sigtC=sigmatC*thicknessC
;
; Default scattering angles.
phistart_def=double(-30.0)
phistop_def=double(140.0)
phistep_def=double(0.2)
phistart=phistart_def
phistop=phistop_def
phistep=phistep_def
;
; Detector angles.
nangles=1.01+fix((phistop-phistart)/phistep)
phi=phistart + phistep*dindgen(nangles)
dimension=n_elements(phi)
ssf=fltarr(dimension)
fcsc=fltarr(dimension)
fcc=fltarr(dimension)
saf=fltarr(dimension)
transm_s=fltarr(dimension)
transm_c=fltarr(dimension)
;
; By default self shielding factors are plotted.
plotwhat=0
; Maximun number of plots
max_n_plots=10
;
; Define "names" to be used when the conditions are saved
;names=['thickness','sigmat','sigt','psi0','phistart','phistop','phistep']
;
; Screen size, used to size the widget.
xysize=get_screen_size()
;
; Create the widget.
tlb=widget_base(/row,title = $
	'Self-Shielding Calculator for Slab Geometry: sample plus container',$
	mbar = bar,tlb_frame_attr = 1,group_leader = group_leader)
	filemenu = WIDGET_BUTTON(bar, VALUE='File', /MENU)
		void = widget_button(filemenu,value = 'Write results to an ascii file',$
			event_pro = 'slab_ss_WriteFactors',xsize = buttonSize)
		void = widget_button(filemenu,value = 'Print results to a PS file',$
			event_pro = 'slab_ss_2Printer',xsize = buttonSize,sensitive = 1)
	  butt_save = widget_button(filemenu,value='Save input parameters')
   	butt_restore = widget_button(filemenu,value='Restore input parameters')
		void = widget_button(filemenu,value = 'Help',event_pro = 'slab_ss_Help')
		void = widget_button(filemenu,value = 'Quit',event_pro = 'slab_ss_Quit')
;
	angle_optionsmenu =widget_button(bar,value='Angles',/menu)
		butt_user  = widget_button(angle_optionsmenu,value = 'Start, stop and step in 2theta (deg)',$
			event_pro = 'slabuserangles',/checked_menu,xsize = buttonSize,sensitive = 1)
		butt_DCS  = widget_button(angle_optionsmenu,value = 'DCS Detector Angles',$
			event_pro = 'slabDCSAngles',/checked_menu,xsize = buttonSize,sensitive = 1)
		butt_HFBS = widget_button(angle_optionsmenu,value = 'HFBS Detector Angles',$
			event_pro = 'slabHFBSAngles',/checked_menu,xsize = buttonSize,sensitive=1)
;
	widget_control,butt_HFBS,set_button=0
	widget_control,butt_DCS,set_button=0
	widget_control,butt_user,/set_button
;
	plot_optionsmenu =widget_button(bar,value='Plot options',/menu)
		butt_plotnone = widget_button(plot_optionsmenu,value = 'Clear',$
			event_pro = 'slab_plotoptions', uname = 'plot0',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_plotSSF = widget_button(plot_optionsmenu,value = 'f_S ("SSF")',$
			event_pro = 'slab_plotoptions', uname = 'plot1',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_plotfcsc = widget_button(plot_optionsmenu,value = 'f_{C,SC}',$
			event_pro = 'slab_plotoptions', uname = 'plot2',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_plotfcc = widget_button(plot_optionsmenu,value = 'f_{C,C}',$
			event_pro = 'slab_plotoptions', uname = 'plot3',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_plotSAF = widget_button(plot_optionsmenu,value = 'g ("SAF")',$
			event_pro = 'slab_plotoptions', uname = 'plot4',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_plotT_S = widget_button(plot_optionsmenu,value = 'T_S',$
			event_pro = 'slab_plotoptions', uname = 'plot5',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_plotT_C = widget_button(plot_optionsmenu,value = 'T_C',$
			event_pro = 'slab_plotoptions', uname = 'plot6',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_plotall = widget_button(plot_optionsmenu,value = 'All',$
			event_pro = 'slab_plotoptions', uname = 'plot9',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_showsym = widget_button(plot_optionsmenu,value = 'Hide symbols',$
			event_pro = 'slab_plotoptions', uname = 'Symbols',/checked_menu,$
			xsize = buttonSize,sensitive=1,/separator)
		butt_smallsym = widget_button(plot_optionsmenu,value = 'Small symbols',$
			event_pro = 'slab_plotoptions', uname = 'Smallsym',/checked_menu,$
			xsize = buttonSize,sensitive=1,/separator)
;
	widget_control,butt_plotnone,set_button=0
	widget_control,butt_plotSSF,/set_button
	widget_control,butt_plotfcsc,/set_button
	widget_control,butt_plotfcc,/set_button
	widget_control,butt_plotSAF,/set_button
	widget_control,butt_plotT_S,/set_button
	widget_control,butt_plotT_C,/set_button
	widget_control,butt_plotall,/set_button
	widget_control,butt_showsym,set_button=0
	widget_control,butt_smallsym,set_button=1
;
	sign_optionsmenu =widget_button(bar,value='Sign conventions',/menu)
		butt_LL = widget_button(sign_optionsmenu,value = 'L-L',$
			event_pro = 'slab_signconv',uname = 'L-L',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_RR = widget_button(sign_optionsmenu,value = 'R-R',$
			event_pro = 'slab_signconv',uname = 'R-R',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_LR = widget_button(sign_optionsmenu,value = 'L-R',$
			event_pro = 'slab_signconv',uname = 'L-R',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		butt_RL = widget_button(sign_optionsmenu,value = 'R-L',$
			event_pro = 'slab_signconv',uname = 'R-L',/checked_menu,$
			xsize = buttonSize,sensitive=1)
		void = widget_button(sign_optionsmenu,value = 'Help',$
			event_pro = 'slab_signhelp',$
			xsize = buttonSize,sensitive=1)
	widget_control,butt_LL,set_button=0
	widget_control,butt_RR,set_button=1
	widget_control,butt_LR,set_button=0
	widget_control,butt_RL,set_button=0
	signconv=[1,1]
;
	butbase=widget_base(tlb,/col);,xsize = xs)
		anglebase = widget_base(butbase,/row,/frame);,xsize = xs1)
			butt_psi0=cw_field(anglebase,/col,title='Angle psi0 (deg)        ',$;font='TIMESROMAN*14',$
				xsize=6,ysize=1,/string,/all_events,value=string(psi0,format='(f7.3)'))
			psibase=widget_base(anglebase,/col)
				void = widget_label(psibase,value = 'Start, stop and step in 2theta (deg)',$
					frame = 0,/align_center)
				phivals=[phistart,phistop,phistep]
				phivals=strjoin(string(phivals,format='(f7.2)'),',')
				butt_phi = widget_text(psibase,value=phivals,/all_events,/editable)

;		outbase = widget_base(butbase,/row)
;		outbase2 = widget_base(outbase,/frame,/col,/exclusive)
	butt_plotssf = 0
;  	butt_plotssf = widget_button(outbase2,value='Show self-shielding factors',/no_release)
	butt_plotint = 0
; 	butt_plotint = widget_button(outbase2,value='Show scattering intensities',/no_release)
	butt_plotord = 0
; 	butt_plotord = widget_button(outbase2,value='Show summed scattering intensity',/no_release)
;	 	widget_control,butt_plotssf,/set_button
;
		samplebase=widget_base(butbase,/col,/frame);,xsize = xs1)
			void=widget_label(samplebase,value = 'Sample thickness and cross section',frame = 0,/align_center)
		  samplebase1S=widget_base(samplebase,/row)
		  	butt_thicknessS=cw_field(samplebase1S,/col,title='     Thickness (cm)',$;font='TIMESROMAN*14',$
		  		xsize=6,ysize=1,/string,/all_events,value=string(thicknessS,format='(f7.3)'))
		  	butt_sigmatS   =cw_field(samplebase1S,/col,title='Sigma_S (cm-1)            ',$;font='TIMESROMAN*14',$
		  		xsize=6,ysize=1,/string,/all_events,value=string(sigmatS,format='(f7.3)'))
		  	butt_sigtS=cw_field(samplebase1S,/col,title='Product     ',$;font='TIMESROMAN*14',$
		  		xsize=6,ysize=1,/string,/all_events,value=string(sigtS,format='(f7.3)'),/noedit)
			void=widget_label(samplebase,value = 'Container wall thickness and cross section',frame = 0,/align_center)
		  samplebase1C=widget_base(samplebase,/row)
		  	butt_thicknessC=cw_field(samplebase1C,/col,title='Wall thickness (cm)',$;font='TIMESROMAN*14',$
		  		xsize=6,ysize=1,/string,/all_events,value=string(thicknessC,format='(f7.3)'))
		  	butt_sigmatC   =cw_field(samplebase1C,/col,title='Sigma_C (cm-1)            ',$;font='TIMESROMAN*14',$
		  		xsize=6,ysize=1,/string,/all_events,value=string(sigmatC,format='(f7.3)'))
		  	butt_sigtC=cw_field(samplebase1C,/col,title='Product     ',$;font='TIMESROMAN*14',$
		  		xsize=6,ysize=1,/string,/all_events,value=string(sigtC,format='(f7.3)'),/noedit)
		resultbase=widget_base(butbase,/row,/frame)
			result_info_S=cw_field(resultbase,/col,title='Transmission TS_0',$
				xsize=10,ysize=1,/string,value='',/noedit)
			result_info_C=cw_field(resultbase,/col,title='Transmission TC_0',$
				xsize=10,ysize=1,/string,value='',/noedit)
			result_info_T=cw_field(resultbase,/col,title='Total transmission',$
				xsize=10,ysize=1,/string,value='',/noedit)
;
	winlegxsize=xysize[0]*0.5
	winlegysize=xysize[0]*0.25
;
	plotbase = widget_base(tlb,/col)
	buttonSize = 100
;
	butgeom=widget_info(butbase,/geometry)
;
	winxsize = xysize[0]*0.75-butgeom.xsize; -midgeom.xsize
	winysize = xysize[1]*0.5
;
	win = widget_draw(plotbase,xsize = winxsize,ysize = winysize,$
    /button_events,/motion_events,event_pro='slab_ss_WinDraw')
		butbase2 = widget_base(plotbase,/row)
			transbase = widget_base(butbase2,/align_left,/col)
				meantrans = widget_label(transbase,value=' ',xsize=winxsize*0.25)
				mintrans = widget_label(transbase,value=' ',xsize=winxsize*0.25)
			message_area = widget_label(butbase2,value=' ',xsize=winxsize*0.75)
;
;	butgeom=widget_info(butbase,/geometry) ; RTA comment out!
;
win2xsize=butgeom.xsize
win2ysize=winysize-butgeom.ysize
win2 = widget_draw(butbase,xsize = win2xsize,ysize = win2ysize)
;
centertlb,tlb
widget_control,tlb,/realize
;
; Create a pixmap. Get IDs of pixmap and plot window.
!p.charsize = 1.0
window,/free,/pixmap,xsize = winxsize,ysize = winysize
winPix = !d.window
widget_control,win,get_value = winVis
;
widget_control,win2,get_value = winVis2
;
; Get ssf, fcsc, fcc, saf, transm_s, transm_c to be plotted after defining state
slab_ss_calc,sigtS,sigtC,psi0,phi,signconv,ssf=ssf,fcsc=fcsc,fcc=fcc,saf=saf,$
	transm_s=transm_s,transm_c=transm_c,ts0=ts0,tc0=tc0
;
state = {$
	winxsize:winxsize,$
	winysize:winysize,$
;
; Widget IDs
  butt_thicknessS:butt_thicknessS,$
  butt_sigmatS:butt_sigmatS,$
  butt_sigtS:butt_sigtS,$
  butt_thicknessC:butt_thicknessC,$
  butt_sigmatC:butt_sigmatC,$
  butt_sigtC:butt_sigtC,$
;
  butt_psi0:butt_psi0,$
	butt_phi:butt_phi,$
	butt_plotssf:butt_plotssf,$
	butt_plotint:butt_plotint,$
	butt_plotord:butt_plotord,$
	butt_save:butt_save,$
	butt_restore:butt_restore,$
	butt_DCS:butt_DCS,$
	butt_HFBS:butt_HFBS,$
	butt_user:butt_user,$
;
	result_info_S:result_info_S,$
	result_info_C:result_info_C,$
	result_info_T:result_info_T,$
;
	butt_LL:butt_LL,$
	butt_RR:butt_RR,$
	butt_LR:butt_LR,$
	butt_RL:butt_RL,$
;
	meantrans:meantrans,$
	mintrans:mintrans,$
	message:'',$
	message_area:message_area,$
;	names:names,$
	thicknessS:thicknessS,$
	sigmatS:sigmatS,$
	sigtS:sigtS,$
	thicknessC:thicknessC,$
	sigmatC:sigmatC,$
	sigtC:sigtC,$
;
  psi0:psi0,$
	plotwhat:0,$
	beam_ydispl:0.1,$
	beam_wid:0.1,$
	phistart_def:phistart_def,$
	phistop_def:phistop_def,$
	phistep_def:phistep_def,$
	thicknessS_def:thicknessS_def,$
	sigmatS_def:sigmatS_def,$
	thicknessC_def:thicknessC_def,$
	sigmatC_def:sigmatC_def,$
	psi0_def:psi0_def,$
;
; Other stuff.
	winVis:winVis,$
	winPix:winPix,$
	xlo:0.0,$
	ylo:0.0,$
	xhi:1.0,$
	yhi:1.0,$
	mouse:0,$
	xp1:0.0,$
	xp2:0.0,$
	yp1:0.0,$
	yp2:0.0,$
	toplot:toplot,$
	autoscale:1,$
	max_n_plots:max_n_plots,$
	default_colors:default_colors,$
	plotting_geometry:0,$
	phiPtr:ptr_new(phi),$
	ssfPtr:ptr_new(ssf),$
	fcscPtr:ptr_new(fcsc),$
	fccPtr:ptr_new(fcc),$
	safPtr:ptr_new(saf),$
	tsPtr:ptr_new(transm_s),$
	tcPtr:ptr_new(transm_c),$
	ts0:ts0,$
	tc0:tc0,$
;
	signconv:signconv,$
	show_sym:1,$
	small_sym:1,$
	n_plots:0,$
;	inPtr:inPtr,$
  bangx:!x,$
  bangy:!y,$
  bangp:!p,$
 ;
 	winVis2:winVis2,$
 	win2xsize:win2xsize,$
 	win2ysize:win2ysize,$
;
	old_phivals:phivals, $
	workDir:workDir $
;	notify_IDs:notify_IDs $
	}
;
widget_control,tlb,set_uvalue = ptr_new(state)
widget_control,tlb,get_uvalue=pState

pseudoEvent = {event,id:void,top:tlb,handler:0l}
wset,(*pState).winPix
colorset
tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
slab_ss_Plot,pseudoevent
tvlct,default_colors
wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
widget_control,tlb,set_uvalue=pState
;
slab_plotgeom,tlb
;
xmanager,register_name,tlb,/no_block,cleanup = 'slab_ss_Cleanup',$
	event_handler="slab_ss_event"
;
return
end
