; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTGLCleanup,tlb
widget_control,tlb,get_uvalue =pState,/no_copy
wdelete,(*pState).winPix
ptr_free,(*pState).imgPtr
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro doneDTGetLimits,event
widget_control,event.top,get_uvalue = pState,/no_copy
widget_control,(*pState).xd1,get_value = xd1
xd1 = float(xd1[0])
widget_control,(*pState).yd1,get_value = yd1
yd1 = float(yd1[0])
widget_control,(*pState).xd2,get_value = xd2
xd2 = float(xd2[0])
widget_control,(*pState).yd2,get_value = yd2
yd2 = float(yd2[0])
x1 = (*pState).xlim[0]
x2 = (*pState).xlim[1]
y1 = (*pState).ylim[0]
y2 = (*pState).ylim[1]
a = (xd1-xd2)/(x1-x2)
b = xd1-x1*a
c = (yd1-yd2)/(y1-y2)
d = yd1-y1*c
*(*pState).parmPtr = [a,b,c,d]
widget_control,event.top,set_uvalue = pState,/no_copy
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTGetLimitsWinDraw,event
widget_control,event.top,get_uvalue = pState,/no_copy
case event.type of
0: begin  ; button press
	(*pState).mouse = event.press
	if (*pState).mouse eq 4 then begin	; right click;
	  (*pState).getLimits = 0
   	  (*pState).mouse = 0
   	  widget_control,event.top,set_uvalue = pState,/no_copy
	  return
	endif
      widget_control,(*pState).xgroup,get_value = grpVal
      grpVal = fix(grpVal[0])
      (*pState).xLim[grpVal] = event.x
      (*pState).yLim[grpVal] = event.y
      if (*pState).whichpoint eq 0 then begin
        widget_control,(*pState).xgroup,set_value = 1
      endif
   end
else:
endcase

	  wset,(*pState).winPix
	  loadct,0,/silent
	  tvImage,*(*pState).imgPtr,position = (*pState).imgPosition

	  colors = hfbs_getcolor(start = 1,/load)
	  plot,(*pState).xLim,(*pState).yLim,xrange = [0.0,(*pState).winxsize],$
	       yrange = [0.0,(*pState).winysize],xstyle = 5,ystyle = 5,$
	       psym = 8,color = colors.red,/noerase,xmargin = [0,0],ymargin = [0,0]

      widget_control,(*pState).xgroup,get_value = grpVal
      xyouts,(*pState).xLim[0],(*pState).yLim[0],'  1',$
             /data,color = colors.red,charsize = 2.5
      xyouts,(*pState).xLim[1],(*pState).yLim[1],'  2',$
             /data,color = colors.red,charsize = 2.5
	  wset, (*pState).winVis
	  device, copy = [0,0,(*pState).winxsize,(*pState).winysize,0,0,(*pState).winPix]

widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTGetLimits_event,event
;widget_control,event.top,get_uvalue = pState,/no_copy
;widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function DTGetLimits,group_leader = group_leader,imgPtr
tlb = widget_base(group_leader = group_leader,/col,$
                    title = 'Click on two known points for data limits',$
                    /base_align_bottom,/base_align_center,/modal)

winxsize = 600 & winysize = 550
dimensions = GET_SCREEN_SIZE(RESOLUTION=resolution)
winXsize = 0.90*dimensions[0]
winYsize = 0.85*dimensions[1]
win1 = widget_draw(tlb,xsize = winxsize,ysize = winysize,$
         /button_events,event_pro = 'DTGetLimitsWinDraw')

selBase = widget_base(tlb,/row,/base_align_center)

xtypes = ['1st point','2nd point']
xgroup = cw_bgroup(selbase, xtypes, /col, /exclusive,/no_release,$
         frame=1,set_value=0,/return_index)
ptBase1 = widget_base(selBase,/col,/base_align_center)
ptBase2 = widget_base(selBase,/col,/base_align_center)

xd1 = cw_field(ptBase1,title='x[1]',value=0.0,$
                    xsize=8,/string)
yd1 = cw_field(ptBase2,title='y[1]',value=1.0,$
                    xsize=8,/string)
xd2 = cw_field(ptBase1,title='x[2]',value=1.0,$
                    xsize=8,/string)
yd2 = cw_field(ptBase2,title='y[2]',value=2.0,$
                    xsize=8,/string)

thisString = 'Enter data coordinates'
void = widget_label(selBase,value = thisString)
void = widget_button(selBase,value = 'Finished',$
                     event_pro = 'doneDTGetLimits')

;sb_geom = widget_info(selbase,/geom)
;winYsize = 0.96*dimensions[1] - sb_geom.scr_ysize
;widget_control, win1, draw_ysize=winYsize

;centertlb,tlb
widget_control,tlb,/realize, tlb_set_xoffset=0, tlb_set_yoffset=0

widget_control,win1,get_value = winVis
imgPosition = [0.0,0.0,1.0,1.0]
loadct,0,/silent
window,/free,/pixmap,xsize = winxsize,ysize = winysize
winPix = !d.window

imgSize = size(*imgPtr)
if imgSize[0] eq 3 then begin
  newImg = congrid(*imgPtr,3,winxsize,winysize)
endif else begin
  newImg = congrid(*imgPtr,winxsize,winysize)
endelse
wset,winPix
tvImage,newImg,position = imgPosition

wset,winVis
device,copy = [0,0,winxsize,winysize,0,0,winPix]

; Define the plotting symbol..a filled circle
theta = findgen(30)/29.*360.
scale = 1.0
xsym = cos(theta * !dtor) * scale
ysym = sin(theta * !dtor) * scale
usersym, xsym,ysym,/fill
parmPtr = ptr_new(/allocate_heap)
imgPtr = ptr_new(/allocate_heap)
*imgPtr = newImg

state = {winxsize:winxsize,$
         winysize:winysize,$
         imgPtr:imgPtr,$
         winVis:winVis,$
         winPix:winPix,$
         whichPoint:0,$
         imgPosition:imgPosition,$
         xlo:0.0,$
         ylo:0.0,$
         xhi:0.0,$
         yhi:0.0,$
         xp1:0.0,$
         xp2:0.0,$
         yp1:0.0,$
         yp2:0.0,$
         xd1:xd1,$
         yd1:yd1,$
         xd2:xd2,$
         yd2:yd2,$
         xLim:[0.0,0.0],$
         yLim:[1.0,999.0],$
         getLimits:0,$
         xgroup:xgroup,$
         parmPtr:parmPtr,$
         mouse:0}
pState = ptr_new(state)
widget_control,tlb,set_uvalue = pState
xmanager,'DTGetLimits',tlb,cleanup = 'DTGLCleanup'

parmPtr = state.parmPtr
return,parmPtr
end