; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; Written by J.R.D. Copley.
;************************************************************************************************
pro sum_same,x,w,x2,wf,srt
;************************************************************************************************
;
compile_opt strictarr
;
;
; This procedure takes an unsorted array of objects x, each of which has an
; associated weight w. It creates a sorted array x2 and associated weights w2.
; The x2 array only contains the unique values in x, and the associated weight
; w2 is the sum of the weights of the identicals in x.
; The array srt is such that x2=x[srt]; srt may be used with other arrays. For
; example:
; If x=['cows','pigs','pigs','horses','cows','cows'], and w=[11,3,6,10,2,1].
;		x2=['cows','horses','pigs'], and wf=[14,10,9]
; If y=['brown','green','green','white','brown','brown'] then
;		y[srt]=['brown','white','green']
;
;
srt=uniq(x,sort(x))
ind=sort(x)
x2=x[ind]
w2=w[ind]
un=uniq(x2)
n=n_elements(un)
if (n eq 1) then begin
	x2=x[0]
	wf=total(w)
	srt=0
	return
endif
un2=[0,un[0:n-2]+1]
x2=x2[uniq(x2)]
wf=fltarr(n)
for k=0,n-1 do wf[k]=total(w2[un2[k]:un[k]])
end
