; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; Written by J.R.D. Copley.
;************************************************************************************************
pro sample_properties,formula,wavelength=wavelength,database=database,$
	natoms,isotope,atwt,xssct,xsabs,molwt,tot_xssct,tot_xsabs,$
	xsecsPtr=xsecsPtr,inconly=inconly
;************************************************************************************************
;
; Given a chemical formula and a wavelength, this routine returns atomic weights, the molecular
; weight, isotope symbols, numbers of atoms, and various cross sections. The scattering cross
; section either includes or excludes the coherent contribution (inconly=0 or 1 respectively).
;
compile_opt strictarr
;
;
if (n_elements(*xsecsPtr) eq 0) then begin
	xsecsdb,xsecs,xslabels,database=database
	*xsecsPtr=xsecs
endif
;
nquans=n_tags(*xsecsPtr)
nlines=n_elements((*xsecsPtr).(0))
;
if (formula eq "") then begin
	molwt="Empty string"
	return
endif
;
simplify_formula,formula,natoms,isotope
res=where(natoms le 0.0,count)
if (count gt 0.0) then begin
	molwt="Zero subscript not permitted"
	return
endif
;
molwt=0.0
tot_xssct=0.0
tot_xsabs=0.0
n=n_elements(natoms)
atwt=fltarr(n)
xssct=fltarr(n)
xsabs=fltarr(n)
;
lambda0=1.798
if (n_elements(wavelength) eq 1) then ratio=wavelength/lambda0 else ratio=1
;
for m=0,n-1 do begin
	j=where(' '+isotope[m] eq (*xsecsPtr).atsym,count)
	if (count ne 1) then begin
		molwt="Chemical symbol "+isotope[m]+" not found"
		return
	endif
	if (count eq 1) then begin
		atwt[m]=(*xsecsPtr).atwt[j]
		molwt=molwt+natoms[m]*atwt[m]
		if (inconly) then begin
			xssct[m]=(*xsecsPtr).xsinc[j]
		endif else begin
			xssct[m]=(*xsecsPtr).xssct[j]
		endelse
		tot_xssct=tot_xssct+natoms[m]*xssct[m]
		xsabs[m]=(*xsecsPtr).xsabs[j]*ratio
		tot_xsabs=tot_xsabs+natoms[m]*xsabs[m]
	endif
endfor
;
end
