; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; Written by J.R.D. Copley.
;************************************************************************************************
pro readCrossSecs,xsecs,labels,getfromWeb=getfromWeb,flagspecial=flagspecial
;************************************************************************************************
;
compile_opt strictarr
;
;
if (keyword_set(getfromWeb)) then begin
; Read cross sections file off the Web.
	print,'Reading cross sections from the Web'
	destination = 'www.ncnr.nist.gov'
	source = destination+'/resources/n-lengths/list.html'
	cmd = 'GET http://'+source
	socket, unit, destination, 80, /get_lun
	printf, unit, cmd
endif else begin
; Alternatively read in Alan Munter's cross section file
;		(http://webster.ncnr.nist.gov/resources/n-lengths/list.html).
	print,'Reading cross sections from local file.'
	;inputfile=file_which("cross_sections.dat",/include_current_dir)
	inputfile=!DAVE_AUXILIARY_DIR+'cross_sections.dat'
        openr,unit,inputfile,/get_lun
endelse
;
flagspecial=keyword_set(flagspecial)
;
; Determine number of lines of information
content=''
contents=''
nlines=0
match_string='^<td>.*<td>.*<td>.*<td>.*<td>.*<td>.*<td>.*<td>.*<tr>'
while (not eof(unit)) do begin
	readf,unit,content
	if (stregex(content,match_string) ne -1) then begin
		contents=[contents,content]
		nlines=nlines+1
	endif
endwhile
free_lun,unit
;print,'There are',nlines,' lines of information.'
;
; Read each line of information and extract 8 pieces of data.
;1 	 --- 	 Isotope
;2 	--- 	Natural abundance (For radioisotopes the half-life is given instead)
;3 	fm 	bound coherent scattering length
;4 	fm 	bound incoherent scattering length
;5 	barn 	bound coherent scattering cross section
;6 	barn 	bound incoherent scattering cross section
;7 	barn 	total bound scattering cross section
;8 	barn 	absorption cross section for 2200 m/s neutrons
; Also do the following:
; For the elements prepend ' nat-' in column 1
; If flagspecial=1, then
; (1) Replace half-lives with ' 0.0' and '---' with ' 100.0' in column 2.
; (2) Replace bcoh thru xsabs values (columns 3-8) that contain ---, +/- or < with 99991,2,3.
;
xsecs={$
	atsym:strarr(nlines),$; e.g. H or 1H
	atwt:strarr(nlines),$
	atno:strarr(nlines),$
	abund:strarr(nlines),$; e.g. --- or 99.985 or (12.32 a)
	bcoh:strarr(nlines),$; e.g. -3.7390 or 3.26(3) or 5.74-1.483<i>i</i>
	binc:strarr(nlines),$; e.g. --- or 25.274 or (+/-)0.6
	xscoh:strarr(nlines),$; e.g. 1.7583
	xsinc:strarr(nlines),$; e.g. 80.27
	xssct:strarr(nlines),$; e.g. 82.03
	xsabs:strarr(nlines),$; e.g. 0.3326 or 767.(8.)
	xstot:strarr(nlines)}
;
if (flagspecial) then begin
	for k=1,nlines do begin
		content=contents[k]
		parts=strsplit(strcompress(content),'<t[dr]>',/regex,/extract)
		pos=stregex(parts[0],'[A-Z]')
		parts[0]=strtrim(parts[0])
		if (pos eq 1) then parts[0]=' nat-'+strtrim(strmid(parts[0],pos),2)
		if (strpos(parts[1],'(') ne -1) then parts[1]=' 0.0'
		if (strpos(parts[1],'---') ne -1) then parts[1]=' 100.0'
		for j=2,7 do begin
			if (strpos(parts[j],'---') ne -1) then parts[j]=' 99991'
			if (strpos(parts[j],'+/-') ne -1) then parts[j]=' 99992'
			if (strpos(parts[j],'<') ne -1) then parts[j]=' 99993'
			pos=strpos(parts[j],'(')
			if (pos ne -1) then parts[j]=strmid(parts[j],0,pos)
		endfor
		xsecs.(0)[k-1]=parts[0]
		for j=1,7 do xsecs.(j+2)[k-1]=parts[j]
	endfor
endif else begin
	for k=1,nlines do begin
		content=contents[k]
		parts=strsplit(strcompress(content),'<t[dr]>',/regex,/extract)
		pos=stregex(parts[0],'[A-Z]')
		parts[0]=strtrim(parts[0])
		if (pos eq 1) then parts[0]=' nat-'+strtrim(strmid(parts[0],pos),2)
		xsecs.(0)[k-1]=parts[0]
		for j=1,7 do xsecs.(j+2)[k-1]=parts[j]
	endfor
endelse
free_lun,unit
;
labels=['Symbol','At wt','At no.','Abund.','b_coh','b_inc','Sig_c','Sig_i','Sig_S','Sig_A','Sig_T']
end
