; $Id$
;###############################################################################
;
; NAME:
;  DAVE_GET_ALL_IDS
;
; PURPOSE:
;  Returns all ids contained in a particular base.
;
; CATEGORY:
;  DAVE, electronic notebook
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function dave_get_all_ids,base,ntabs

   if (widget_info(base,/name) ne 'BASE') then return,0
   if (n_params() eq 1) then ntabs = 0

   validid = widget_info(base,/child)
   if n_elements(ids) eq 0 then $
      ids = validid else $
      ids = [ids,validid]
   tabstr = ''
   for i = 0,ntabs-1 do tabstr = tabstr+string(9B)
   while (validid ne 0) do begin
      ids = [ids,validid]
      if (widget_info(validid,/name) eq 'BASE') then $
      ids = [ids,dave_get_all_ids(validid,ntabs+1)]
     validid = widget_info(validid,/sibling)
   endwhile
return,ids
end