; $Id$
;###############################################################################
;
; NAME:
;  FT_DETECTOR_GROUP_SELECT
;
; PURPOSE:
;
; CATEGORY:
;  DAVE, Data Analysis, FT Toolkit.
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; +
; NAME:
;
;  FT_DETECTOR_GROUP_SELECT
;
; PURPOSE:
;
;  Provide a user interface that returns the slopes and offsets
;  for linear backgrounds to be subtracted from the data prior
;  to Fourier Transformation in the FT_TOOLKIT.
;
; RETURN VALUE:
;
;  Array of slopes and backgrounds [float array: (2 x ny)].  The first
;  value is slope and the second is background.
;
; AUTHOR:
;
;  Robert Dimeo
;  National Institute of Standards and Technology
;  Center for Neutron Research
;  100 Bureau Drive, Mail Stop 8562
;  Gaithersburg, MD 20899
;  Tel: (301) 975-8135
;  Email: robert.dimeo@nist.gov
;
; CATEGORY:
;
;  Data analysis
;
; REQUIREMENTS
;
;  IDL 6.0 or higher
;
; ADDITIONAL REQUIRED PROGRAMS
;
;  CENTERTLB.PRO
;
; MODIFICATION HISTORY:
;
;  Writing began -- 7/08/04 (RMD)
; -
; *************************************************** ;
pro ft_det_gr_get_values,event
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   msg = ['FT_DET_GR_GET_VALUES',!error_state.msg]
   void = dialog_message(dialog_parent = group_leader,msg)
   return
endif
widget_control,event.top,get_uvalue = pstate
ny = (*pstate).ny
for i = 0,ny-1 do begin
   uname1 = 'SLOPE'+strtrim(string(i+1),2)
   uname2 = 'OFFSET'+strtrim(string(i+1),2)
   id1 = widget_info(event.top,find_by_uname = uname1)
   id2 = widget_info(event.top,find_by_uname = uname2)
   widget_control,id1,get_value = val1 & val1 = float(val1[0])
   widget_control,id2,get_value = val2 & val2 = float(val2[0])
   (*(*pstate).pdata)[*,i] = [val1,val2]
endfor
catch,/cancel
end
; *************************************************** ;
pro ft_det_gr_sel_event,event
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   msg = ['FT_DET_GR_SEL_EVENT',!error_state.msg]
   void = dialog_message(dialog_parent = group_leader,msg)
   return
endif
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
'ACCEPT':      $
   begin
      (*pstate).cancel = 0B
      ft_det_gr_get_values,event
      widget_control,event.top,/destroy
   end
'CANCEL':      $
   begin
      (*pstate).cancel = 1B
      widget_control,event.top,/destroy
   end
'COPY_ONE':    $
   begin
      uname1 = 'SLOPE1'
      uname2 = 'OFFSET1'
      ny = (*pstate).ny
      id1 = widget_info(event.top,find_by_uname = uname1)
      id2 = widget_info(event.top,find_by_uname = uname2)
      widget_control,id1,get_value = val1 & val1 = float(val1[0])
      widget_control,id2,get_value = val2 & val2 = float(val2[0])
      for i = 1,ny-1 do begin
         uname1 = 'SLOPE'+strtrim(string(i+1),2)
         uname2 = 'OFFSET'+strtrim(string(i+1),2)
         id1 = widget_info(event.top,find_by_uname = uname1)
         id2 = widget_info(event.top,find_by_uname = uname2)
         widget_control,id1,set_value = strtrim(string(val1),2)
         widget_control,id2,set_value = strtrim(string(val2),2)
      endfor
   end
else:
endcase
catch,/cancel
end
; *************************************************** ;
function ft_detector_group_select,  group_leader = group_leader,  $
                                    ny = ny,                      $
                                    sub_array = sub_array
; Widget definition module
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   msg = ['FT_DETECTOR_GROUP_SELECT',!error_state.msg]
   void = dialog_message(dialog_parent = group_leader,msg)
   return,0
endif
if n_elements(group_leader) eq 0 then group_leader = 0L
if n_elements(ny) eq 0 then ny = 20
if n_elements(sub_array) eq 0 then sub_array = fltarr(2,ny)
title = 'Specify slope and offset for linear background subtraction'
if group_leader eq 0L then modal = 0 else modal = 1
if group_leader eq 0L then begin
   tlb = widget_base(title = title,  $
      /tlb_frame_attr,/col,modal = modal)
endif else begin
   tlb = widget_base(group_leader = group_leader, title = title,  $
      /tlb_frame_attr,/col,modal = modal)
endelse
;   tlb = widget_base(title = title,  $
;      /tlb_frame_attr,/col) else $
;   tlb = widget_base(group_leader = group_leader, title = title,  $
;      /tlb_frame_attr,/col,/modal)
row_base = widget_base(tlb,/row)
col1 = widget_base(row_base,/col,/base_align_right,/frame)
if ny le 10 then begin
   for i = 0,ny-1 do begin
      text = strtrim(string(i+1),2)
      label1 = 'Slope '+text  & uname1 = 'SLOPE'+text
      label2 = 'Offset '+text & uname2 = 'OFFSET'+text
      row = widget_base(col1,/row)
      val1 = strtrim(string(sub_array[0,i]),2)
      val2 = strtrim(string(sub_array[1,i]),2)
      void = cw_field(row,title = label1,value = val1,uname = uname1)
      void = cw_field(row,title = label2,value = val2,uname = uname2)
   endfor
endif else begin
   for i = 0,9 do begin
      text = strtrim(string(i+1),2)
      label1 = 'Slope '+text  & uname1 = 'SLOPE'+text
      label2 = 'Offset '+text & uname2 = 'OFFSET'+text
      row = widget_base(col1,/row)
      val1 = strtrim(string(sub_array[0,i]),2)
      val2 = strtrim(string(sub_array[1,i]),2)
      void = cw_field(row,title = label1,value = val1,uname = uname1)
      void = cw_field(row,title = label2,value = val2,uname = uname2)
   endfor
   col2 = widget_base(row_base,/col,/base_align_right,/frame)
   for i = 10,ny-1 do begin
      text = strtrim(string(i+1),2)
      label1 = 'Slope '+text  & uname1 = 'SLOPE'+text
      label2 = 'Offset '+text & uname2 = 'OFFSET'+text
      row = widget_base(col2,/row)
      val1 = strtrim(string(sub_array[0,i]),2)
      val2 = strtrim(string(sub_array[1,i]),2)
      void = cw_field(row,title = label1,value = val1,uname = uname1)
      void = cw_field(row,title = label2,value = val2,uname = uname2)
   endfor
endelse
ctrl_base = widget_base(tlb,/row)
void = widget_button(ctrl_base,value = 'Copy group 1 to all',uname = 'COPY_ONE')
void = widget_button(ctrl_base,value = 'Accept',uname = 'ACCEPT')
void = widget_button(ctrl_base,value = 'Cancel',uname = 'CANCEL')
centertlb,tlb
widget_control,tlb,/realize

pdata = ptr_new(/allocate_heap)
*pdata = sub_array
state = {cancel:0B,ny:ny,pdata:pdata}

pstate = ptr_new(state)
widget_control,tlb,set_uvalue = pstate
reg_name = 'ft_det_sel'
event_handler = 'ft_det_gr_sel_event'
xmanager,reg_name,tlb,event_handler = event_handler,no_block = modal
;msg = 'After xmanager'
;void = dialog_message(msg)
; After the call to xmanager we can get out the information
; from the state pointer and then free up the memory
output = *(*pstate).pdata
heap_free,pstate
catch,/cancel
return,output
end
; *************************************************** ;