;===============================================================================
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for polarized beam correction code.
;
; CATEGORY:
;   TAS Reduction

; PARAMETERS
;
; KEYWORDS:
;
pro launch_pbcor, group_leader=gl, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

; Modify the PATH environment variable to include the directory containing
; the polarization correction executables
if (n_elements(!DAVE_TASPOLARIZEDBEAMCOR_DIR) eq 0) then return
currentPATH = GETENV('PATH')
if (strlen(currentPATH) eq 0) then return

case !version.OS of
  'Win32': begin
    sep = ';'
    newPATH =  !DAVE_TASPOLARIZEDBEAMCOR_DIR+'win'+sep+currentPATH
    appname = 'pbcor.exe'
    kword_args = {noshell:1, nowait:1}
  end
  
  'linux': begin
    sep = ':'
    newPATH =  !DAVE_TASPOLARIZEDBEAMCOR_DIR+'linux'+sep+currentPATH
    appname = 'pbcor'
    kword_args = {noshell:1}
  end
  
  'darwin': begin
    sep = ':'
    newPATH =  !DAVE_TASPOLARIZEDBEAMCOR_DIR+'mac'+sep+currentPATH
    appname = 'pbcor'
    kword_args = {noshell:1}
  end
  
  else:
endcase

; modify PATH and launch the external app
setenv, 'PATH='+newPATH
spawn, appname, _EXTRA=kword_args


;case !version.OS of
;  'Win32': spawn, 'pbcor.exe',/noshell,/nowait
;  'linux': spawn,'pbcor',/noshell
;  'darwin':
;
;  else:
;endcase


end
