; $Id$
;###############################################################################
;
; NAME:
;  DTAS_GET_PLOT_INFO
;
; PURPOSE:
;
; CATEGORY:
;  DAVE, TAS, Data Reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dtas_get_plot_info_event,event
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
'DISMISS':  $
   begin
      group_id = widget_info(event.top,find_by_uname = 'PLOT_INFO_CHOICES')
      widget_control,group_id,get_value = choices
      (*pstate).header = choices[0]
      (*pstate).filenames = choices[1]
      (*pstate).treatment = choices[2]
      widget_control,event.top,/destroy
   end
'PLOT_INFO_CHOICES': $
   begin
      widget_control,event.id,get_value = choices
      (*pstate).header = choices[0]
      (*pstate).filenames = choices[1]
      (*pstate).treatment = choices[2]
   end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_get_plot_info,  group_leader = group_leader, choices = choices
if n_elements(choices) eq 0 then choices = [0,0,0]
title = 'Output plot information'
tlb = widget_base(group_leader = group_leader,/tlb_frame_attr,title = title,  $
   /modal,/col)
names = ['Include header','Include file names','Include data treatment']
void = cw_bgroup(tlb,names,/return_index,uname = 'PLOT_INFO_CHOICES', $
   /nonexclusive,set_value = choices)
void = widget_button(tlb,value = 'Accept',uname = 'DISMISS')

centertlb,tlb
widget_control,tlb,/realize
state = {header:0,filenames:0,treatment:0}
pstate = ptr_new(state)
widget_control,tlb,set_uvalue = pstate

reg_name = 'dtas_get_plot_info'
xmanager,reg_name,tlb
info = (*pstate)
ptr_free,pstate
return,info
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
