; $Id$
;###############################################################################
;+
; NAME:
;   tasReducPreferences
;
; PURPOSE:
;   Retrieve or save user preferences for TAS Data Reduction module
;
; CATEGORY:
;   TAS Data Reduction

; PARAMETERS
;
; KEYWORDS:
;   save  -   If set, the user preferences will be save on disk
;   
;   reset -   If set, the user preferences will be reset to their default vales and saved
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Nov 2010
;-
;###############################################################################




;===============================================================================
; NAME:
;   tasReducPreferences
;
; PURPOSE:
;   Main function
;
; PARAMETERS
;
; KEYWORDS:
;
function tasReducPreferences, preferences, save=save, reset=reset
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        print,'tasReducPreferences: Error Encountered'
        print,!ERROR_STATE.MSG
        catch, /cancel
        return, 0
    endif
endif

; ** Version number **
; ** Increment by 1 whenever the preferences structure content changes **
versionNumber = 1

; Retrieve the app directory
appDir = getDAVEConfigDir()
if (n_elements(appDir) le 0) then return, 0
if (~file_test(appDir,/write,/read)) then return, 0
prefFile = appDir+path_sep()+'tasreducpreferences.txt'


; B/c of unusual error resulting from running out of available logical units
; (probably a bug in get_lun); add the following 4 lines to force the use of 
; the same first available file unit every time
lun = 100
while ((fstat(lun)).open && (lun lt 129)) do begin
  lun++
endwhile


if (keyword_set(save) && strcmp(size(preferences,/tname),'STRUCT')) then begin
   ntags = n_tags(preferences)
   tags = tag_names(preferences)
   if (ntags lt 1) then return, 0

   openw, lun, prefFile;, /get_lun
   printf, lun, 'PreferenceVersion : ',strtrim(string(versionNumber),2)
   for i=0,ntags-1 do printf, lun, tags[i] + ' : '+preferences.(i)
   
   close, lun, /force
   
   return, 1
endif

; Check version number
fileVersionNumber = 0
if (file_test(prefFile,/read)) then begin
   buffer = ''
   openr, lun, prefFile;, /get_lun
   readf, lun, buffer
   close, lun, /force

   toks = strtrim(strsplit(buffer[0],':',count=ntok,/extract), 2)
   if (ntok eq 2) then fileVersionNumber = fix(toks[1])
endif
if (versionNumber ne fileVersionNumber) then reset = 1   ; force a reset of the preference file

if (keyword_set(reset) || ~file_test(prefFile,/read)) then begin
   ; Set preferences to their default values and save to file
   preferences = {TASREDUCPREFS $
                  ,show_td:      '0' $    ; 1=Yes, 0=No to show/display door detector info where applicable
                 }

   ntags = n_tags(preferences)
   tags = tag_names(preferences)

   openw, lun, prefFile;, /get_lun
   printf, lun, 'PreferenceVersion : ',strtrim(string(versionNumber),2)
   for i=0,ntags-1 do printf, lun, tags[i] + ' : '+preferences.(i)
   
   close, lun, /force
endif else begin
   ; Retrieve the current preferences from file
   lines = file_lines(prefFile)
   buffer = strarr(lines)
   openr, lun, prefFile;, /get_lun
   readf, lun, buffer
   close, lun, /force
   
   for i=1,lines-1 do begin
      toks = strtrim(strsplit(buffer[i],':',count=ntok,/extract), 2)
      ;toks = strsplit(buffer[i],':',count=ntok,/extract)
      if (ntok gt 1) then begin
         value = (ntok eq 2)? toks[1] : ''
         preferences = (i eq 1)? create_struct(toks[0],value) : $
            create_struct(preferences,toks[0],value)
      endif
   endfor
endelse

return, 1

end

