; $Id$
;###############################################################################
;
; NAME:
;  TAS_TEXT_DISPLAY
;
; PURPOSE:
;
; CATEGORY:
;  DAVE, TAS, Data Reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ttd_event,event
uname = widget_info(event.id,/uname)
if uname eq 'DISMISS' then begin
   widget_control,event.top,/destroy
endif
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_text_display,   group_leader = group_leader,     $
                        notify_ids = notify_ids,         $
                        o = o,                           $
                        title = title,                   $
                        txt = txt,                       $
                        temp = temp,                     $
                        tlb_id = tlb_id,                 $
                        no_center = no_center,           $
                        small = small
tlb_id = 0L
if keyword_set(small) then small = 1B else small = 0B
if keyword_set(no_center) then no_center = 1B else no_center = 0B
if keyword_set(temp) then temp = 1B else temp = 0B
if n_elements(group_leader) eq 0 then group_leader = 0L
if n_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
if n_elements(txt) eq 0 then return
if n_elements(o) eq 0 then return
if not obj_valid(o) then return
if n_elements(title) eq 0 then $
   title = 'TAS Data Contents: '+display_name
register_name = title
if xregistered(register_name) then return
; Create the widgets
tlb = widget_base(/tlb_frame_attr,title = title,/col, $
   group_leader = group_leader)
tlb_id = tlb
if not small then begin
   ysize = 30 & xsize = 80
endif else begin
   ysize = 10 & xsize = 40
endelse
text = widget_text(tlb,value = txt,ysize = ysize,xsize = xsize,/scroll,/editable)
void = widget_button(tlb,value = 'DISMISS',uname = 'DISMISS')
if not no_center then centertlb,tlb
widget_control,tlb,/realize
state = {notify_ids:notify_ids,temp:temp}
widget_control,tlb,set_uvalue = state
xmanager,register_name,tlb,/no_block,event_handler = 'TTD_EVENT'
;widget_control,notify_ids[0],/input_focus
end