; $Id$
;###############################################################################
;
; NAME:
;  DTAS_ZIP__DEFINE
;
; PURPOSE:
;  Class for combining TAS dataf files together as a function of a parameter
;  such as temperature.
;
; CATEGORY:
;  DAVE, TAS, Data Reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; +
;
; -
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dtas_zip::cleanup
ptr_free,self.px,self.py,self.pz,self.pdz,self.pmon,self.treatment
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_zip::get_property, xval = xval,      $
                                 yval = yval,      $
                                 z = z,            $
                                 dz = dz,          $
                                 mon = mon, $
                                 xtitle = xtitle,  $
                                 ytitle = ytitle,  $
                                 xunits = xunits, $
                                 yunits = yunits, $
                                 display_name = display_name,  $
                                 signal_type = signal_type, $
                                 treatment = treatment

if n_elements(*self.treatment) eq 0 then treatment = '' else $
   treatment = *self.treatment
signal_type = 'COMBINED'
display_name = self.display_name
xval = *self.px
yval = *self.py
z = *self.pz
dz = *self.pdz
mon = *self.pmon
xtitle = self.xtitle
ytitle = self.ytitle

return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_zip::set_property, xval = xval,      $
                                 yval = yval,      $
                                 z = z,            $
                                 dz = dz,          $
                                 mon=mon, $
                                 xtitle = xtitle,  $
                                 ytitle = ytitle,  $
                                  xunits = xunits, $
                                 yunits = yunits, $
                                 display_name = display_name,  $
                                 treatment = treatment

if n_elements(xval) ne 0 then *self.px = xval
if n_elements(yval) ne 0 then *self.py = yval
if n_elements(z) ne 0 then *self.pz = z
if n_elements(dz) ne 0 then *self.pdz = dz
if n_elements(mon) ne 0 then *self.pMon = mon
if n_elements(xtitle) ne 0 then self.xtitle = xtitle
if n_elements(ytitle) ne 0 then self.ytitle = ytitle
if n_elements(display_name) ne 0 then self.display_name = display_name
if n_elements(treatment) ne 0 then *self.treatment = treatment
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_zip::create_dave_ptr
x = *self.py
y = *self.px
z = transpose(*self.pz)
dz = transpose(*self.pdz)
xtitle = self.ytitle
ytitle = self.xtitle
xtitle = (strsplit(xtitle,' ',/extract))[0]
ytitle = (strsplit(ytitle,' ',/extract))[0]
specificstr = {title:'COMBINED_DATA' $
              ,Monitor:transpose(*self.pmon) $
              ,pan_filler:!VALUES.F_NAN $
              ,pan_mask:ptr_new(bits2bytes(finite(z))) $
              }
ret =  create_dave_pointer(daveptr,          $
                     instrument = 'TAS', $
                     qty = z,         $
                     qtunits = '',      $
                     qtlabel = 'Corrected Counts',      $
                     err = dz,          $
                     xvals = x,         $
                     xtype = 'POINTS',         $
                     xunits = '',      $
                     xlabel = xtitle,      $
                     yvals = y,         $
                     ytype = 'POINTS',$
                     yunits = '',$
                     ylabel = ytitle,$
                     specificstr = specificstr,$
                     treatment = *self.treatment,  $
                     ermsg = errmsg)
return,daveptr
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_zip::write_dave,dir,detnorm,det
if n_params() eq 0 then cd,current = dir
per_pos = strpos(self.display_name,'.')
if per_pos[0] eq -1 then begin
   filename = self.display_name+'.dave'
endif else begin
   filename = strmid(self.display_name,0,per_pos)+'.dave'
endelse
x = *self.py
y = *self.px
z = transpose(*self.pz)
dz = transpose(*self.pdz)
xtitle = self.ytitle
ytitle = self.xtitle
specificstr = {title:'COMBINED_DATA' $
              ,Monitor:transpose(*self.pmon) $
              ,pan_filler:!VALUES.F_NAN $
              ,pan_mask:ptr_new(bits2bytes(finite(z))) $
              }
ret =  create_dave_pointer(daveptr,          $
                     instrument = 'TAS', $
                     qty = z,         $
                     qtunits = '',      $
                     qtlabel = 'Corrected Counts',      $
                     err = dz,          $
                     xvals = x,         $
                     xtype = 'POINTS',         $
                     xunits = '',      $
                     xlabel = xtitle,      $
                     yvals = y,         $
                     ytype = 'POINTS',$
                     yunits = '',$
                     ylabel = ytitle,$
                     specificstr = specificstr,$
                     treatment = *self.treatment,  $
                     ermsg = errmsg)
save,daveptr,filename = dir+filename
heap_free,daveptr
return,dir+filename
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_zip::Mslice, workDir, dataDir, detnorm, det, wTLB, daveTool
compile_opt idl2

;if n_params() eq 0 then cd,current = dir
;per_pos = strpos(self.display_name,'.')
;if per_pos[0] eq -1 then begin
;  filename = self.display_name+'.dave'
;endif else begin
;  filename = strmid(self.display_name,0,per_pos)+'.dave'
;endelse
x = *self.py
y = *self.px
z = transpose(*self.pz)
dz = transpose(*self.pdz)
xtitle = self.ytitle
ytitle = self.xtitle

xUnit = x*0.0 + 1.0
yUnit = y*0.0 + 1.0

x = x#yUnit
y = xUnit#y

npts = n_elements(z)
data = fltarr(npts,4)
data[*,0] = reform(z,npts)
data[*,1] = reform(dz,npts)
data[*,2] = reform(x,npts)
data[*,3] = reform(y,npts)

labels = ['Corrected Counts','Error',xtitle, ytitle]
units = ['','','','']
unique = [0,0]
unique = strcmp(xtitle,'E',1,/fold_case)? [unique,1] : [unique,0]
unique = strcmp(ytitle,'E',1,/fold_case)? [unique,1] : [unique,0]

dataPtr = ptr_new({data:temporary(data),label:tex2idl(labels),unit:tex2idl(units),instrument:'Triple Axis',is_uniq:unique},/no_copy)
;Self->GetProperty, DAVETOOL=daveTool, DATA_DIRECTORY=dataDir, working_directory=workDir
dcs_mslice, dataPtr=dataPtr, obj_mslice=objMslice, group_leader=wTLB $
  ,DAVETool=daveTool, workDir=workDir, dataDir=dataDir, /no_parmfile
;Self.objMslice = objMslice
;
;; initialize the stepsize params in the Mslice UI to values commensurate with the data
;names = ['dispxstep','dispystep','cutstep']
;values = [binWidths[0],binWidths[1],binWidths[0]]
;;values = [!values.F_NAN,!values.F_NAN,!values.F_NAN]
;objMslice->script,'set_parameter',name=names,value=values

return, 1
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_zip::display
x = *self.px
y = *self.py
z = *self.pz
xtitle = self.xtitle
ytitle = self.ytitle
spectrogram,z,x,y,xtitle = xtitle,ytitle = ytitle,/noskipgaps
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_zip::init
self.px = ptr_new(/allocate_heap)
self.py = ptr_new(/allocate_heap)
self.pz = ptr_new(/allocate_heap)
self.pdz = ptr_new(/allocate_heap)
self.pmon = ptr_new(/allocate_heap)
self.treatment = ptr_new(/allocate_heap)
self.display_name = ''
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dtas_zip__define
define = {  dtas_zip,            $
            px:ptr_new(),        $
            py:ptr_new(),        $
            pz:ptr_new(),        $
            pdz:ptr_new(),       $
            pMon:ptr_new(), $
            treatment:ptr_new(), $
            xtitle:'',           $
            ytitle:'',           $
;            xunits:'', $
;            yunits:'', $
            display_name:''      }
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
