; $Id$
;###############################################################################
;
; NAME:
;  CRS_DTAS_DATA_NEW__DEFINE
;
; PURPOSE:
;  Extend the DTAS_DATA class for the CRS_COMBINE application.  By extending this class,
;  someone else will maintain the basic reader portions of the class.
;
; CATEGORY:
;  DAVE, TAS, Data Reduction
;
; AUTHOR:
;   Larry R. Kneller, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8839
;   E-mail: kneller@nist.gov
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function crs_dtas_data_new::getString,s=s,numbers=numbers,fitstuff=fitstuff,resvals=resvals,_Extra=extra

  
;  hkl = self.hkl
;  s = string(hkl)
;  self.orescalculator->calculate,rm,r0,$
;                                  horizontal=0,$  
;                                  collimatorh=self.collimation,$
;                                  collimatorv=120.0+fltarr(4),$
;                                  mosaic=self.mosaic,$
;                                  dspacing=[self.monodspacing,self.anadspacing],$
;                                  instrument_orient=[1,1],$
;                                  qetrans=[hkl,self.ecen,self.efixed],$
;                                  lattice=self.olattice,$
;                                  closed=closed,$
;                                  tthcorrection=tthcorrection,$
;                                  thcorrection=thcorrection,$
;                                  strout=restext  
;  s = [s,string(thcorrection),string(tthcorrection)]
;
;  if ptr_valid(self.fit_ptr) ne 0 then begin
;    help,*self.fit_ptr,output=output
;    if n_elements(output) eq 1 then ioutput = 0 else ioutput = 1
;      if stregex(output[ioutput],'UNDEFINED',/fold_case,/boolean) eq 0 then begin
;        fitinfo = *self.fit_ptr
;        ;print,'hkl=',hkl
;        ;print,'s=',s
;        ;print,'fitinfo=',transpose(fitinfo.fit_text)
;        wh = where(stregex(fitinfo.fit_text,'Pk Hgt',/fold_case,/boolean) ne 0,count)
;        ;print,'count=',count
;        iTot = 0.0
;        siTot = 0.0
;        for i=0,count-1 do begin
;          line = fitinfo.fit_text[wh[i]]
;          segs = strsplit(line,/extract)
;          iTot = iTot + double(segs[2])
;          siTot = sqrt(siTot^2 + double(segs[4])^2)
;      
;        endfor;i
;        ;help,fitinfo,/struct
;      
;        s = [s,string(iTot),string(sItot)]
;        mon = self->get_monitor()
;        s = [s,string(mon[0])]
;    endif else begin;output
;        itot = 0.0
;        sitot = 1.0
;        mon = 0.0
;    endelse
;endif;ptr_valid
;  sout = ''
;  for i=0,n_elements(s)-1 do begin
;    sout = sout+s[i]+'  '
;  endfor;i
;  s = sout

;LRK - 07/08/09
  ;NOW EXTRACT THE TOTAL AREA FROM THE FIT PARAMETERS IN THE FITCONTAINER AND REPLACE HERE
  hkl = self.hkl

  horizontal=0  
  collimatorh=self.collimationh;self.collimation
  collimatorv=self.collimationv;120.0+fltarr(4)
  mosaic=self.mosaic
;print,'self.monofixed=',self.monofixed
;print,'self.anafixed=',self.anafixed
  dspacing=[self.monodspacing,self.anadspacing]
  instrument_orient=[1,1]
if self.anafixed eq 1 then efixed = -abs(self.efixed) else efixed = abs(self.efixed)
;if self.monofixed eq 1 then efixed = abs(self.efixed)

  qetrans=[hkl,self.ecen,efixed]

  self.orescalculator->calculate,rm,r0,$
                                  horizontal=horizontal,$  
                                  collimatorh=collimatorh,$
                                  collimatorv=collimatorv,$
                                  mosaic=mosaic,$
                                  dspacing=dspacing,$
                                  instrument_orient=instrument_orient,$
                                  qetrans=qetrans,$
                                  lattice=self.olattice,$
                                  closed=closed,$
                                  tthcorrection=tthcorrection,$
                                  thcorrection=thcorrection,$
                                  strout=restext  

  areaInfo = self->totalArea()
  iTot  = areaInfo.area
  siTot = areaInfo.darea
  mon = self->get_Monitor()
  s = [string(hkl),string(thcorrection),string(tthcorrection),string(iTot),string(sItot),string(mon[0])]
  sout = ''
  for i=0,n_elements(s)-1 do begin
    sout = sout+s[i]+'  '
  endfor;i
  s = sout

  numbers = {hkl:hkl,thCorrection:thcorrection,tthcorrection:tthcorrection,Itot:Itot,sItot:sItot,monitor:mon}

  horizontal=0  
  source = 0
  collimatorh=self.collimationh;self.collimation
  collimatorv=self.collimationv;120.0+fltarr(4)
  mosaic=self.mosaic
  dspacing=[self.monodspacing,self.anadspacing]
  instrument_orient=[1,1]
  qetrans=[hkl,self.ecen,self.efixed]
  monofixed = self.monofixed 
  anafixed = self.anafixed
  eifixed = self.monofixed
  effixed = self.anafixed  
  if monofixed eq 1 then feief = 0 else feief = 1  

  ;RESELPS REQUIRES THAT qetrans[4] BE NEGATIVE IF Ef IS FIXED, AND I PLAN TO FOLLOW THAT CONVENTION AT EVERY STAGE OF
  ;COMMUNICATION OF THE RESOLUTION INFORMATION.
  qetrans[4] = ((-1.0)^feief)*abs(qetrans[4]) 
  
  resvals = { $
    bColh1R:collimatorh[0],$
    bColh2R:collimatorh[1],$
    bColh3R:collimatorh[2],$
    bColh4R:collimatorh[3],$
    bColv1R:collimatorv[0],$
    bColv2R:collimatorv[1],$
    bColv3R:collimatorv[2],$
    bColv4R:collimatorv[3],$
    bEtash1R:mosaic[0],$
    bEtasv2R:mosaic[1],$
    bEtam3R:mosaic[2],$
    bEtaa4R:mosaic[3],$
    bDm1R:dspacing[0],$
    bDa2R:dspacing[1],$
    bEpm1R:instrument_orient[0],$
    bEp2R:instrument_orient[1],$
    bQh1R:qetrans[0],$
    bQk2R:qetrans[1],$
    bQl3R:qetrans[2],$
    bEtran4R:qetrans[3],$
    bEin5R:qetrans[4],$
    bSource1R:source,$
    bSourceHFocus:horizontal,$
    ;MORE FAMILIAR NAMES AND GROUPINGS:
    horizontal:horizontal,$
    collimatorh:collimatorh,$
    collimatorv:collimatorv,$
    mosaic:mosaic,$
    dspacing:dspacing,$
    instrument_orient:instrument_orient,$
    qetrans:qetrans,$
    monofixed:monofixed,$ 
    anafixed:anafixed,$
    eifixed:eifixed,$
    effixed:effixed,$
    feief:feief}

  return,1
end;crs_dtas_data_new::getString
function crs_dtas_data_new::getResvals,resvals
  duh = self->getString(resvals=resvals)
  return,1
end;crs_dtas_data_new::getResvals
pro crs_dtas_data_new::setResvals,resVals,noqupdate=noqupdate

  if n_elements(noqupdate) eq 0 then noqupdate = 0

  if n_elements(resvals) eq 0 then begin
    void = dialog_message('No resVals passed to crs_dtas_data_new::resLatvals')
  endif else begin

              ;
              ;self.source = resvals.source
              ;self.horizontal = resvals.horizontal
              self.collimation = resvals.collimatorh
              self.collimationh = resvals.collimatorh
              self.collimationv = resvals.collimatorv
              self.mosaic = resvals.mosaic
              self.dspacing = resvals.dspacing
              self.monodspacing = resvals.dspacing[0]
              self.anadspacing = resvals.dspacing[1]
          ;print,tag_names(resvals)
              self.orientation1 = resvals.INSTRUMENT_ORIENT[0]
              self.orientation2 = resvals.INSTRUMENT_ORIENT[1]

              ;self.qetrans = resvals.qetrans
              
              if noqupdate eq  0 then begin
                self.hkl = resvals.qetrans[0:2]          
                self.ecen = resvals.qetrans[3]
                efixed = resvals.qetrans[4]
                self.efixed = abs(efixed);resvals.qetrans[4]
              endif
          
              self.monofixed = resvals.monofixed
              self.anafixed = resvals.anafixed
          
          
              self.orescalculator->calculate,rm,r0,$
                                             horizontal=resvals.horizontal,$
                                             ;LRK - 042910
                                             ;collimatorh=self.collimation,$
                                             collimatorh = self.collimationh,$
                                             collimatorv = self.collimationv,$
                                             ;
                                             mosaic=self.mosaic,$
                                             dspacing=resvals.dspacing,$
                                             instrument_orient=resvals.instrument_orient,$
                                             qetrans=resvals.qetrans,$
                                             ;lattice=self.lattice,$ ;SHOULDN'T NEED THIS SINCE THE RESCALCULATOR HAS THE SAME OBJECT REFERENCE 
                                                                     ;AS THE DATA OBJECT.
                                             tthcorrection=tthcorrection,$
                                             thcorrection=thcorrection,$
                                             strout=strout




  endelse
end;crs_dtas_data_new::setResvals
function crs_dtas_data_new::getLatvals,latvals
  ;print,'crs_dtas_data_new::getLatvals'
  latvals = self.olattice->getvalues()

;05/18/12
;HOW ABOUT THIS????
  self.orientation1 = latvals.orient1
  self.orientation2 = latvals.orient2

  ;NEED O1,O2:
  orient1 = self.orientation1
  orient2 = self.orientation2

   newlatvals = {a:latvals.A,$
                 b:latvals.B,$
                 c:latvals.C,$
                 alpha:latvals.ALPHA,$
                 beta:latvals.BETA,$
                 gamma:latvals.GAMMA,$
                 astar:latvals.ASTAR,$
                 bstar:latvals.BSTAR,$
                 cstar:latvals.CSTAR,$
                 alphastar:latvals.ALPHASTAR,$
                 betastar:latvals.BETASTAR,$
                 gammastar:latvals.gammastar,$
                 x:latvals.x,$
                 y:latvals.y,$
                 z:latvals.z,$
                 orient1:orient1,$
                 orient2:orient2}
  ;help,latvals,/struct
  latvals = newlatvals
  return,1;newlatvals
end;crs_dtas_data_new::getLatvals
pro crs_dtas_data_new::setLatvals,latVals

  if n_elements(latvals) eq 0 then begin
    void = dialog_message('No latVals passed to crs_dtas_data_new::setLatvals')
  endif else begin
          print,latvals
;              help,latvals,/struct
;              help,self.olattice
;              help,self.orescalculator
              self.orescalculator->getproperty,mylattice=lattice
;              help,lattice
          
              a = latvals.a
              b = latvals.b
              c = latvals.c
          
              alpha = latvals.alpha
              beta  = latvals.beta
              gamma = latvals.gamma
          
              orient1 = latvals.orient1
              orient2 = latvals.orient2
              
              self.olattice->setLattice,a,b,c,alpha,beta,gamma,orient1,orient2
          ;REFRESH THE RES CALCULATION WITH THE NEW LATTICE VALUES.
              self.orescalculator->calculate,rm,r0;,$
          ;                                   horizontal=0,$
          ;                                   collimatorh=self.collimation,$
          ;                                   mosaic=self.mosaic,$
          ;                                   dspacing=[self.monodspacing,self.anadspacing],$
          ;                                   instrument_orient=instrument_orient,$
          ;                                   qetrans=[self.hkl,self.ecen,self.efixed]

  endelse
end;crs_dtas_data_new::setLatvals
function crs_dtas_data_new::getHeader,header
  ret = self->get_property(header=header)
  return,ret
end;crs_dtas_data_new::getHeader
function crs_dtas_data_new::getQ,hkl
  ret = self->get_property(hkl=hkl)
  return,ret
end;crs_dtas_data_new::getQ
function crs_dtas_data_new::getHKL,hkl
  ret = self->get_property(hkl=hkl)
  return,ret
end;crs_dtas_data_new::getHKL




function crs_dtas_data_new::getData,x,y,dy,xtitle,ytitle,title
  ret = 1
;  ret = self->get_Property(data=data)
;  ret = self->get_private(plot_Ptr=plot_Ptr)
;
;  x = *(*plot_ptr).x
;  y = *(*plot_ptr).y
;  dy = *(*plot_ptr).dy

  if ptr_valid(self.xdata) eq 0 or ptr_valid(self.ydata) eq 0 then return,0 
      
  x = *self.xdata
  y = *self.ydata
  dy = *self.dydata
  xtitle =  self.xtitle
  ytitle = self.ytitle
  title = self.title
;  if ptr_valid(plot_ptr) then begin
;    xtitle = (*plot_ptr).xtitle
;    ytitle = (*plot_ptr).ytitle
;    title = (*plot_ptr).title
;  endif else begin
;    xtitle = 'X'
;    ytitle = 'Y'
;    title = 'DATA'
;  endelse

  if (n_elements(y) eq 0) or $
        ((n_elements(y) eq 1) and y[0] eq 0) then begin
          ret=0
  endif

  return,ret
end;crs_dtas_data_new::getData
function crs_dtas_data_new::getDataFit,xfit,yfit
  ret = 1
  ;LRK 042710
  ;THE NEXT CHECK IS ADDED SINCE ATTEMPTING TO DEREFERENC A NULL POINTER
  ;CAN CRASH ALL OF DAVE.
  if ptr_valid(self.xfit) eq 0 or ptr_valid(self.yfit) eq 0 then begin
    ret = 0
    return,ret
  endif
  xfit = *self.xfit
  yfit = *self.yfit
;  self.fitContainer->evaluate,xfit,yout = yfit
  if (n_elements(yfit) eq 0) or $
        ((n_elements(yfit) eq 1) and yfit[0] eq 0) then begin
          ret=0
  endif

  return,ret
end;crs_dtas_data_new::getDataFit
function crs_dtas_data_new::getParmnames,parmnames
  ret = 1
  parmnames = self.fitContainer->getParmnames()
  if n_elements(parmnames) eq 0 then ret = 0
  return,ret
end;crs_dtas_data_new::getParmnames
function crs_dtas_data_new::getParms,parms
  ret = 1
  parms = self.fitContainer->getParms()
  if n_elements(parms) eq 0 then ret = 0
  return,ret
end;crs_dtas_data_new::getParms
function crs_dtas_data_new::getChiSq,ChiSq
  ret = 1
  chisq = self.fitContainer->getChiSq()
  if n_elements(ChiSq) eq 0 then begin
    ChiSq = -1
    ret=0
  endif
  return,ret
end;crs_dtas_data_new::getChiSq
pro crs_dtas_data_new::setPANparmInfo,parminfoout,sout,refit=refit


;CREATE setparms and getparms METHODS
        ;self->setparms,parminfoout

;        help,parminfoOut,/struct

        if n_elements(refit) eq 0 then refit = 0
        
        names = parminfoout.names
        parms = parminfoout.parms
        nparms= parminfoout.nparms
        parmnames = parminfoout.parmnames
;        print,parmnames+string(parms)
        sout = strarr(n_elements(parms)+total(nparms))
        stemp = parmnames+string(parms)
        sout[0] = names[0]
        sout[1:nparms[0]] = stemp[0:nparms[0]-1]
        for i=1,n_elements(names)-1 do begin
          sout[1+i+total(nparms[0:i-1])] = names[i]
          
          sout[1+i+total(nparms[0:i-1])+1:1+i+total(nparms[0:i])] = stemp[total(nparms[0:i-1]):total(nparms[0:i])-1]
        endfor;i
;        print,'sout=',sout


          self.fitcontainer->setstep,parminfoout.step
          self.fitcontainer->setfixed,parminfoout.fixed
          self.fitcontainer->setlowvalues,parminfoout.lovalues
          self.fitcontainer->sethighvalues,parminfoout.hivalues
          self.fitcontainer->sethigh,parminfoout.high
          self.fitcontainer->setlow,parminfoout.low
          self.fitcontainer->setTied,parminfoout.tied
          ;self.fitcontainer->setexpr,parminfoout.expr
          self.fitcontainer->setparms,parminfoout.parms


          if refit eq 1 then begin
            self->fitonegroup
          endif

          x = *self.xdata;*(*self.plot_ptr).x

          ;help,(*self.plot_ptr),/struct
          xfit = *self.xfit;(*self.fit_ptr).x
          ;help,xout,yout
          
          self.fitcontainer->setxvalues,xfit
          
        
        
          self.fitcontainer->evaluate,xfit,yout=yfit
          if ptr_valid(self.yfit) gt 0 then ptr_free,self.yfit
          self.yfit = ptr_new(yfit)
          ;(*self.fit_ptr).yfit = yfit
          self.fitcontainer->setxvalues,x
          

end;crs_dtas_data_new::setPANparms
pro crs_dtas_data_new::getPANparmInfo,parminfo,addgauss=addgauss

        if n_elements(addgauss) eq 0 then addgauss = 0



        duh = self->get_property(fit_ptr=fit_ptr,fitcontainer=fitcontainer)

        if addgauss ne 0 then begin
          
          tempparms = fitcontainer->getparms()
          gparms = [0.0,tempparms[3],tempparms[4]]
          x = *(*self.plot_ptr).x          
          g = obj_new('func',name='pan_gaussian',parms=gparms,xvalues = x)
          fitcontainer->add,g
        endif

        names=fitcontainer->getnames()
        nparms = intarr(fitcontainer->count())
        for i = 0,fitcontainer->count()-1 do begin
          ref = fitcontainer->get(position=i)
          ref->getproperty,parms=theseparms
          nparms[i] = n_elements(theseparms)
        endfor;i

        parmInfo =   {names:names, $
                        nparms:nparms,$
                        step:fitcontainer->getstep(), $
                        fixed:fitcontainer->getfixed(), $
                        lovalues:fitcontainer->getlowvalues(), $
                        hivalues:fitcontainer->gethighvalues(), $
                        high:fitcontainer->gethigh(), $
                        low:fitcontainer->getlow(), $
                        parms:fitcontainer->getparms(), $
                        parmnames:fitcontainer->getparmnames(), $
                        tied:fitcontainer->getTied(),$
                        expr:fitcontainer->getexpr()}

end;crs_dtas_data_new::getPANparms

function crs_dtas_data_new::getFitText,fittext
  self.fitContainer->displayparms,output = fittext
  ret = 1
  if n_elements(fittext) eq 0 then begin
    fittext = 'No Fit Available.'
    ret = 0
  endif
  return,ret
end;crs_dtas_data_new::FitText
function crs_dtas_data_new::totalArea,fitstring=fitstring,output=output
  
  fc = self.fitcontainer
  if fc->count() ne 0 then begin
    fc->displayParmsAndConstraints,output = output    
  endif else begin
    output = 'No Fit'
  endelse

  area = 0.0
  error = 0.0
  fun = fc->get(/all)
  allnames = fc->getnames()
  allparmnames = fc->getparmnames()
  ;print,allnames,allparmnames
  fitstring = strarr(2*n_elements(allnames)+n_elements(allparmnames)+2+2)
  ;help,fitstring
  scount = 0
  for i=0,fc->count()-1 do begin
    fun[i]->getproperty,name=name,parms=parms,parmerror=parmerror,parmnames=parmnames
    fitstring[scount] = '---------------------'
    scount++
    fitstring[scount] = name
    scount++
    for j=0,n_elements(parmnames)-1 do begin
      fitstring[scount] = parmnames[j] + string(parms[j]) + '+/-' + string(parmerror[j]) 
      scount++
      if strupcase(name) eq 'PAN_GAUSSIAN' then begin
          if strupcase(parmnames[j]) eq 'AREA' then begin
            area = area + parms[j]
            error = error + parmerror[j]^2
          endif
      endif    
    endfor;j
  endfor;i
  fitstring[scount] = '---------------------'
  scount++
  chisq = fc->getchisq()
  fitstring[scount] = 'ChiSquared = '+string(chisq)
  scount++

  error = sqrt(error)
  if error eq 0.0 and area eq 0.0 then error = 1.0

  fitstring[scount] = '---------------------'
  scount++
  fitstring[scount] = 'Total Area = '+string(area)+' +/- '+string(error)
  

  return,{area:area,darea:error,output:output,fitstring:fitstring}
end;crs_dtas_data_new::totalArea







;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function crs_dtas_data_new::auto_gauss_fit,msg = msg,_Extra = extra,fit_text = fit_text, $
   n = n,plot_mon = plot_mon,inputparms=inputparms
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   msg = 'Fit failed'
   mess = ['In crs_dtas_data::auto_gauss_fit ',!error_state.msg]
   void = dialog_message(mess)
   return,0
endif

;THIS IS HOW WE GET INPUT PARMS FROM THE USER
if n_elements(inputparms) ne 0 then begin
  n = (N_elements(inputparms)-1)/3
          if n_elements(plot_mon) eq 0 then plot_mon = 0B
          msg = ''
          fit_text = ''
          if n_elements(n) eq 0 then n = 1
          if n_elements(*self.plot_ptr) eq 0 then return,0
          x = *(*self.plot_ptr).x
          if plot_mon then begin
             y = self->get_monitor()
             dy = sqrt(y)
          endif else begin
             y = *(*self.plot_ptr).y
             dy = *(*self.plot_ptr).dy
          endelse
          if total(dy) eq 0.0 then begin
             msg = 'Error bars must be present for the fit'
             return,0
          endif
          
          p = inputparms
endif else begin
          if n_elements(plot_mon) eq 0 then plot_mon = 0B
          msg = ''
          fit_text = ''
          if n_elements(n) eq 0 then n = 1
          if n_elements(*self.plot_ptr) eq 0 then return,0
          x = *(*self.plot_ptr).x
          if plot_mon then begin
             y = self->get_monitor()
             dy = sqrt(y)
          endif else begin
             y = *(*self.plot_ptr).y
             dy = *(*self.plot_ptr).dy
          endelse
          if total(dy) eq 0.0 then begin
             msg = 'Error bars must be present for the fit'
             return,0
          endif
          
          peak_loc = GET_PEAK_POS( x,y,n,fwhm = fwhm,indices = indices)
          
          
          
          indices = fix(indices)
          if n ne n_elements(peak_loc) then begin
             msg = 'Fit failed'
             return,0
          endif
          
          fwhm = abs(fwhm)
          ; Fit with a Gaussian
          bg = min(y)
          for i = 0,n-1 do begin
             if peak_loc[i] eq 0.0 then peak_loc[i] = median(x)
            
             sigma = fwhm[i]/2.354
             center = peak_loc[i]
             area = (y[indices[i]]-bg)*sqrt(2.0*!dpi)*sigma
             if i eq 0 then begin
                init_parms = [bg,area,center,fwhm[i]]
             endif else begin
                init_parms = [init_parms,area,center,fwhm[i]]
             endelse
          endfor
          p = init_parms
endelse;fitinput
;print,'in crs_dtas_data::auto_gauss_fit, p=',p
parinfo = replicate({limited:[0,0], limits:[0.D,0]}, n_elements(p))
; Limit the fwhm to a positive number
np = n_elements(p)
for i = 0,n-1 do begin
   area_index = 3*i+1
   fwhm_index = 3*i+3
   parinfo(fwhm_index).limited(0) = 1
   parinfo(fwhm_index).limits(0) = 0D
   parinfo(area_index).limited(0) = 1
   parinfo(area_index).limits(0) = 0D
endfor
;print,parinfo.value
where_zero = where(y eq 0.0,count_bad)
if count_bad gt 0 then dy[where_zero] = 1D
quiet = 1
yfit = MPCURVEFIT(x, y, 1.d/dy^2, p, dp, $
                  FUNCTION_NAME='crs_dtas_gaussians',status = status, $
                  /autoderivative,quiet = quiet,parinfo = parinfo,chisq = chisq)
dof = n_elements(x)-np
chi_reduced = chisq/dof

;NOW PUT THE FIT FUNCTIONS INTO THE FIT CONTAINER.
;FIRST CLEAR THE CONTAINER
fcount = self.fitcontainer->count()
if fcount ne 0 then begin
  funcs = self.fitcontainer->get(/all)
  self.fitcontainer->remove,/all
  obj_destroy,funcs
endif;fcount
;NOW ADD THE FUNCTIONS:
ngauss = (np-1)/3
boffset = p[0]
bslope = 0.0
bname = 'pan_background'
ob1 = obj_new('func',name=bname,xvalues=x,parms=[boffset,bslope],fixed = [0,1])
;help,ob1
self.fitcontainer->add,ob1
gname = 'pan_gaussian'
tempparms = p
for iii=0,ngauss-1 do begin
  og = obj_new('func',name=gname,xvalues=x,parms=[p[3+3*iii],p[2+3*iii],p[1+3*iii]]);p[1+3*iii:3+3*iii]);[p[1+3*iii],p[1+3*iii]*2.354,p[3+3*iii]])
  self.fitcontainer->add,og
  tempparms[1+3*iii] = p[1+3*iii]
  tempparms[2+3*iii] = p[2+3*iii]
  tempparms[3+3*iii] = p[3+3*iii]
endfor;iii
;print,'self.fitcontainer->count()=',self.fitcontainer->count()

self.fitcontainer->setparms,[tempparms[0],0.0,tempparms[1:*]]
self.fitcontainer->setxvalues,x
self.fitcontainer->evaluate,x,yout = yout


if status gt 0 then begin
   ; Create a fit with a higher density of points
   nx = n_elements(x)
   xhi = max(x,min = xlo)
   nnx = 3*nx
   dx = (xhi-xlo)/(nnx-1.0)
   xsm = xlo+dx*findgen(nnx)
   ;dtas_gaussians,xsm,p,ysm

;   crs_dtas_gaussians,xsm,p,ysm

self.fitcontainer->setxvalues,xsm
self.fitcontainer->evaluate,xsm,yout = ysm
self.fitcontainer->setxvalues,x

   

;   *self.fit_ptr = {x:xsm,yfit:ysm}
   parms = 'Background: '
   pfmt = '(G10.3)'
   efmt = '(G8.2)'
   for i = 0,n-1 do begin
      parms = [parms,'Pk Hgt: ','Center: ','FWHM: ']
   endfor
   
   ;UPDATE INPUT PARAMETERS BASED ON RESULT OF FIT
   if ptr_valid(self.fitinputptr) then ptr_free,self.fitinputptr
   self.fitinputptr = ptr_new(p)


   str = ['____________________','Fit parameters']
   str = [str,parms[0]+ $
          strtrim(string(p[0],format=pfmt),2)+' +/- '+ $
          strtrim(string(dp[0],format=efmt),2)]
   counter = 0
   for j = 0,n-1 do begin
      str = [str,'---Gaussian #'+strtrim(string(j+1),2)+'---']
      for i = 0,2 do begin
          str = [str,parms[counter+1]+' '+ $
                 strtrim(string(p[counter+1],format=pfmt),2)+' +/- '+ $
                 strtrim(string(dp[counter+1],format=efmt),2)]
         counter = counter + 1
      endfor
   endfor
   chi_format = '(G10.4)'
   str = [str,'','Chi-squared: '+strtrim(string(chi_reduced,$
      format = chi_format),2),'------------']
   ret = self->update_treatment(str)
   fit_text = str


   *self.fit_ptr = {x:xsm,yfit:ysm,fit_text:str}

  ;PERFORM THE FIT TO UPDATE CHI-SQUARED          
   self->getPANparmInfo,InInfo
   self->setPANparmInfo,InInfo,/refit

   Area = self->totalArea(fitstring=fitstring,output=output)

   *self.fit_ptr = {x:xsm,yfit:ysm,fit_text:fitString}




endif else begin
   return,0
endelse

return,1
end;crs_dtas_data_new::auto_gauss_fit

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro crs_dtas_data_new::addGaussian,parms
  print,'crs_dtas_data::addGaussian,x,parms  DO I NEED x?'
  parmnames = ['area','center','FWHM']

  peak_loc = GET_PEAK_POS(*self.xdata,*self.ydata,1,fwhm = fwhm)
  
  gparms = [0.0,peak_loc,fwhm]
  g = obj_new('func',name='pan_gaussian',parms=gparms,xvalues = x)
  self.fitcontainer->add,g

end;crs_dtas_data_new::addGaussian

;---------------------------------------
pro crs_dtas_data_new::calculate,rm,r0,closed=closed,$
                                  tthcorrection=tthcorrection,$
                                  thcorrection=thcorrection,$
                                  restext=restext

    catch,es
    ; Error handler
    if (es ne 0) then begin
      print,!error_state.MSG
      tthcorrection=0.0
      thcorrection=0.0
      strout=['Something went wrong in crs_dtas_data_new::calculate:',!error_state.MSG]

      Catch, /CANCEL
      return
    endif

  efixed = abs(self.efixed)
  if self.anafixed eq 1 then efixed = -efixed
;if n_elements(horizontal) eq 0 then horizontal = 0
  self.orescalculator->calculate,rm,r0,$
                                  horizontal=0,$  
                                  collimatorh=self.collimation,$
                                  collimatorv=120.0+fltarr(4),$
                                  mosaic=self.mosaic,$
                                  dspacing=[self.monodspacing,self.anadspacing],$
                                  instrument_orient=[1,1],$
                                  qetrans=[self.hkl,self.ecen,efixed],$
                                  lattice=self.olattice,$
                                  closed=closed,$
                                  tthcorrection=tthcorrection,$
                                  thcorrection=thcorrection,$
                                  strout=restext
end;crs_dtas_data_new::calculate

pro crs_dtas_data_new::cleanup

print,'crs_dtas_data_new::cleanup'
ptr_free,self.data_file_contents,self.collim_ptr,self.xtal_orientation_ptr
ptr_free,self.instrument_ptr,self.motors_ptr,self.lattice_ptr
ptr_free,self.mosaic_ptr,self.econfig_ptr,self.qconfig_ptr
ptr_free,self.treatment_ptr,self.mcf_ptr,self.fit_ptr
ptr_free,self.descriptr,self.header_ptr,self.orientation_ptr,self.anaPkgPtr
if ptr_valid(self.fitinputptr) then ptr_free,self.fitinputptr

if ptr_valid(self.xdata) then ptr_free,self.xdata
if ptr_valid(self.ydata) then ptr_free,self.ydata
if ptr_valid(self.dydata) then ptr_free,self.dydata
if ptr_valid(self.xfit) then ptr_free,self.xfit
if ptr_valid(self.yfit) then ptr_free,self.yfit

heap_free,self.data_ptr
heap_free,self.plot_ptr

if ptr_valid(self.leafinfo) then ptr_free,self.leafinfo
if obj_valid(self.olattice) then obj_destroy,self.olattice
if obj_valid(self.orescalculator) then obj_destroy,self.orescalculator
self->IDLitData::Cleanup

end;crs_dtas_data_new::cleanup



pro crs_dtas_data_new::fitOneGroup, event = event

  ;BORROWED FROM THE opan::fitOneGroup METHOD SO THAT I CAN USE THE PAN
  ;FITTING MACHINERY HERE WITHOUT REINVENTING.

    ; 
    ; This method uses Craig Markwardt's suggestion for a curve-fit interrupt.
    ; This method is for single group fitting only.

  

    oc = self.fitcontainer;(*self.ocurveGroup)[val]

    if oc->count() ne 0 then begin
      parms = oc->getparms()
      parinfo = oc->createParInfo()


      ;data = self.data

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        catch,the_error
        if the_error ne 0 then begin
           catch,/cancel
           msg = 'Fit failed'
           void = dialog_message(!error_state.msg)
           return
        endif
              
        msg = ''
        fit_text = ''
        if n_elements(n) eq 0 then n = 1
;        if n_elements(*self.plot_ptr) eq 0 then begin
;          return
;        endif
;        x = *(*self.plot_ptr).x
;        y = *(*self.plot_ptr).y
;        dy = *(*self.plot_ptr).dy

      x = *self.xdata
      y = *self.ydata
      dy = *self.dydata


;REMOVE NAN's IF THEY EXIST.
  whnan = where(finite(y,/nan) ne 0)
  if whnan[0] ne -1 then begin
    y[whnan] = 0.0
    dy[whnan] = 1000000.0 
  endif

      if n_elements(x) eq 0 then return

      xPtr = ptr_new(x)
      yerr = dy

    ; Try to fit it...
        w = 1.0/yerr^2
        xlim = x
        ylim = y
        wlim = w

       fixers = where(finite(wlim) ne 1,fixerscount)
       if fixerscount ne 0 then wlim[fixers] = 1


        iterargs = {stopBut:0};self.interrupt}
        iterProc = 'pan_iterproc'

        ;NO RESOLUTION, SO JUST PROCEED WITH FIT
;BUT NOTE: THE FUNCTIONCONTAINER MUST ALREADY BE FULL!!!!!!!        
        
          yf = mpcurvefit(xlim, ylim, wlim, parms, sigma, $
                          FUNCTION_NAME='fitfunction', $
                          status = status, $
                          quiet = 1,$
                          itmax = 500,$;(*self.prefs).maxIter, $
                          chisq = chisq, $
                          parinfo = parinfo, $
                          functargs = {oc:oc,xPtr:xPtr},$
                          iterargs = iterargs, $
                          iterProc = iterProc, $
                          /autoderivative, $
                          covar = covar,   $
                          ERRMSG=errmsg)

        if status eq 1 then begin
            ;help,self.oneResPtr,/traceback
                    ptr_free,xPtr
                    if n_elements(sigma) gt 0 then oc->setparmError,sigma
                    dof = n_elements(xlim)-n_elements(parms)
                    chi_reduced = chisq/dof
                    oc->setchisq,chi_reduced
                ; calculate the correlation matrix
                   PCOR = COVAR * 0
                   FOR i = 0, n_elements(parms)-1 DO FOR j = 0, n_elements(parms)-1 DO $
                     PCOR(i,j) = COVAR(i,j)/sqrt(COVAR(i,i)*COVAR(j,j))
                    oc->set_pcor,pcor
            
                    ;;RTA- undo the restricted domain
        endif else begin
          void = dialog_message('Fit Failed for '+file_basename(self.filename))
        endelse
    endif;oc->count

;    self->refresh
;
;    ; Display the parameters
;    self->displayFitParameters
    return
end;crs_dtas_data_new::fitOneGroup




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro crs_dtas_data_new::modifyfitparms
  print,'crs_dtas_data_new::modifyfitparms'
  

   self->getPANparmInfo,InInfo;,addgauss=addgauss
   newInfo = inInfo
;   if refit eq 0 then begin
     enterparminfo,inInfo, $
              ;group_leader = self.tlb, $
              ;notifyIds = notifyIds, $
              /modal, $
              parmInfoOut = parmInfoOut             
     newInfo = parmInfoOut
;   endif
   self->setPANparmInfo,newInfo,sout,refit=refit

  
;THIS NEXT BLOCK COMES UP AGAIN AND AGAIN
  xfit = *self.xfit
  x = *self.xdata
  self.fitcontainer->setxvalues,xfit
  self.fitcontainer->evaluate,xfit,yout=yfit
  if ptr_valid(self.yfit) ne 0 then ptr_free,self.yfit
  self.yfit = ptr_new(yfit)
  self.fitcontainer->setxvalues,x
  
  
  
end;crs_dtas_data_new::modifyfitparms
function crs_dtas_data_new::refit,xfit,yfit,x=x,y=y,dy=dy
  print,'crs_dtas_data_new::refit'
  x = *self.xdata
  y = *self.ydata
  dy = *self.dydata
  xfit = *self.xfit
  
  
  self.fitcontainer->setxvalues,x
  self->fitOneGroup

  self.fitcontainer->setxvalues,xfit
  self.fitcontainer->evaluate,xfit,yout=yfit

  if n_elements(yfit) gt 1 then begin
    ;(*self.fit_ptr).yfit = ptr_new(yfit)
    if ptr_valid(self.yfit) ne 0 then ptr_free,self.yfit
    self.yfit = ptr_new(yfit)
    ret = 1
  endif else begin
    ret = 0
  endelse
  

  self.fitcontainer->setxvalues,x
  
  return,ret
  
end;crs_dtas_data_new::refit
pro crs_dtas_data_new::defaultFit
  print,'crs_dtas_data_new::defaultFit'
  catch,the_error
  if the_error ne 0 then begin
     catch,/cancel
     void = dialog_message(!error_state.msg,title='crs_dtas_data_new::defaultFit')
     return
  endif
          

  if ptr_valid(self.xdata) then begin
      if n_elements(*self.xdata) ne 0 then begin
              x = *self.xdata
              y = *self.ydata
              dy = *self.dydata
            
              xmin = min(x,max=xmax)
              xrange = xmax-xmin
              nfit = 10*n_elements(x)
              xfit = xmin + (dindgen(nfit)/float(nfit-1))*(xmax-xmin)
            
              if ptr_valid(self.xfit) ne 0 then ptr_free,self.xfit
              self.xfit = ptr_new(xfit)
            
            
            
              n = 1
            
                      peak_loc = GET_PEAK_POS( x,y,n,fwhm = fwhm,indices = indices)
                      
                      
                      
                      indices = fix(indices)
                      if n ne n_elements(peak_loc) then begin
                         msg = 'Fit failed'
                      endif
                      
                      fwhm = abs(fwhm)
                      ; Fit with a Gaussian
                      bg = min(y)
                      for i = 0,n-1 do begin
                         if peak_loc[i] eq 0.0 then peak_loc[i] = median(x)
                        
                         sigma = fwhm[i]/2.354
                         center = peak_loc[i]
                         area = (y[indices[i]]-bg)*sqrt(2.0*!dpi)*sigma
                         if i eq 0 then begin
                            init_parms = [bg,area,center,fwhm[i]]
                         endif else begin
                            init_parms = [init_parms,area,center,fwhm[i]]
                         endelse
                      endfor
            
            
                    bparms = [init_parms[0],0.0];offset, slope
                    b = obj_new('func',name='pan_background',parms=bparms,xvalues = x)
                    
                    parmnames = ['area','center','FWHM']
                    gparms = init_parms[1:*]
                    g = obj_new('func',name='pan_gaussian',parms=gparms,xvalues = x)
                    
                    self.fitcontainer->add,b
                    self.fitcontainer->add,g
                    self.fitcontainer->setxvalues,x
                    self->fitOneGroup
            
            ;        xfit = (*self.fit_ptr).x
                    self.fitcontainer->setxvalues,xfit
                    self.fitcontainer->evaluate,xfit,yout=yfit
            
                    ;(*self.fit_ptr).yfit = ptr_new(yfit)
                    if ptr_valid(self.yfit) ne 0 then ptr_free,self.yfit
                    self.yfit = ptr_new(yfit)
            
            
                    self.fitcontainer->setxvalues,x
      endif;NO DATA TO FIT
  endif;ptr_valid(self.xdata)
end;crs_dtas_data_new::defaultFit
function crs_dtas_data_new::scantype,th=th,tth=tth,align=align,_Extra=extra

  th = 0
  tth = 0
  align = 0

if self.isice eq 0 then begin

  ;ICP:
        if ptr_valid(self.header_ptr) ne 0 then begin    
          header = *self.header_ptr
          ;print,transpose(header)
          ;print,n_elements(header)
          if n_elements(header) eq 18 then begin
      ;      print,transpose(header)
      ;      print,header[13]
      ;      print,header[14]
            segs = strsplit(header[13],/extract)
            if double(segs[2]) ne 0.0 then th = 1
            segs = strsplit(header[14],/extract)
            if double(segs[2]) ne 0.0 then tth = 1
          endif else begin
            align = 1
          endelse
        endif

endif else begin

  contents = *self.data_file_contents

  
  datapos = where(stregex(contents,'#',/boolean) eq 0,datacount)
  headerpos = where(stregex(contents,'#',/boolean) ne 0,headercount)

  if headerpos[n_elements(headerpos)-1]  gt datapos[n_elements(datapos)-1] then headerpos = headerpos[0:n_elements(headerpos)-2] 

  whdata = where(datapos gt max(headerpos),whdatacount)
  
  
  header = contents[headerpos]
  datalines = contents[datapos[whdata]]
  A3pos = -1
  A4pos = -1

  for i=0,n_elements(header)-1 do begin
    thscan = 0
    tthscan = 0
    if stregex(header[i],'#Columns',/fold_case,/boolean) ne 0 then begin
      segs = strsplit(header[i],/extract)
      for j=0,n_elements(segs)-1 do begin
        if strupcase(segs[j]) eq 'QX' then qxpos = j-1 
        if strupcase(segs[j]) eq 'QY' then qypos = j-1 
        if strupcase(segs[j]) eq 'QZ' then qzpos = j-1 
        if strupcase(segs[j]) eq 'A3' then a3pos = j-1 
        if strupcase(segs[j]) eq 'A4' then a4pos = j-1 
      endfor;j
    endif;j
  endfor;i

      if datacount gt 1 then begin
        dline1 = datalines[0]
        a3vals = fltarr(datacount)
        a4vals = fltarr(datacount)
        dsegs = strsplit(dline1,/extract)  
        for k=0,datacount-1 do begin
          dsegs = strsplit(datalines[k],/extract)  
          tempA3 = float(dsegs[A3pos])
          tempA4 = float(dsegs[A4pos])
          a3vals[k] = tempA3
          a4vals[k] = tempA4
        endfor;k
        if max(a3vals) - min(a3vals) ne 0 then thscan = 1
        if max(a4vals) - min(a4vals) ne 0 then tthscan = 1
      endif;datacount
  ;endif;#Columns
        th = thscan
        tth = tthscan
  print,'WHAT ABOUT AN ALIGNMENT SCAN IN ICE????????'        
endelse;isice


  return,1

end;crs_dtas_data_new::scantype


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function crs_dtas_data_new::get_property, $  
                                filename = filename,             $
                                contents = contents,             $
                                display_name = display_name,     $
                                treatment = treatment,           $
                                var_names = var_names,           $
                                plot_str = plot_str,             $
                                total_mon = total_mon,           $
                                signal_type = signal_type,       $
                                extension = extension,           $
                                descriptr_str = descriptr_str,   $
                                fit_ptr = fit_ptr,               $
                                time = time,                     $
                                hfield = hfield,                 $
                                shift_value = shift_value,       $
                                second_var_name = second_var_name,  $
                                header = header,                 $
                                data = data,                     $
                                scan = scan $
                                ,anaPkgStr = anaPkgStr $
                                ,anaMode =  anaMode,$
                                  hkl=hkl,$
                                  ecen = ecen,$
                                  efixed = efixed,$                   ;LRK
                                  monofixed = monofixed,$                  ;LRK
                                  anafixed = anafixed,$                   ;LRK
                                  abc = abc,$                ;LRK   
                                  abg = abg,$                ;LRK
                                  collimation = collimation,$        ;LRK
                                  hcollimation = hcollimation,$        ;LRK
                                  vcollimation = vcollimation,$        ;LRK
                                  mosaic = mosaic,$             ;LRK
                                  orientation1 = orientation1,$       ;LRK
                                  orientation2 = orientation2,$       ;LRK
                                  monodspacing = monodspacing,$             ;LRK
                                  anadspacing = anadspacing,$     ;LRK
                                  fitContainer=fitContainer,$     ;LRK
                                  leafinfo=leafinfo,$             ;LRK
                                  olattice=olattice,$
                                  orescalculator=orescalculator,$
                                ;
                                  ;fitInput = fitInput,$      ;LRK
                                  fitInputPtr = fitInputPtr,$      ;LRK
                                  xdata=xdata,ydata=ydata,dydata=dydata,$  ;LRK
                                  xfit=xfit,yfit=yfit,$
                                  xtitle=xtitle,ytitle=ytitle,title=title

  ret = self->dtas_data::get_property(filename = filename,             $
                                      contents = contents,             $
                                      display_name = display_name,     $
                                      treatment = treatment,           $
                                      var_names = var_names,           $
                                      plot_str = plot_str,             $
                                      total_mon = total_mon,           $
                                      signal_type = signal_type,       $
                                      extension = extension,           $
                                      descriptr_str = descriptr_str,   $
                                      fit_ptr = fit_ptr,               $
                                      time = time,                     $
                                      hfield = hfield,                 $
                                      shift_value = shift_value,       $
                                      second_var_name = second_var_name,  $
                                      header = header,                 $
                                      data = data,                     $
                                      scan = scan $
                                      ,anaPkgStr = anaPkgStr $
                                      ,anaMode =  anaMode)

          hkl = self.hkl
          efixed = self.efixed
          ecen = self.ecen
          monofixed = self.monofixed
          anafixed = self.anafixed
          abc = self.abc   
          abg = self.abg
          collimation = self.collimation
          hcollimation = self.collimationh
          vcollimation = self.collimationv
          mosaic = self.mosaic
          orientation1 = self.orientation1
          orientation2 = self.orientation2
          monodspacing = self.monodspacing
          anadspacing = self.anadspacing
          fitcontainer=self.fitcontainer
          leafinfo = self.leafinfo
          olattice = self.olattice
          orescalculator = self.orescalculator
          xdata=self.xdata
          ydata=self.ydata
          dydata=self.dydata
          xtitle=self.xtitle
          ytitle=self.ytitle
          title=self.title
          xfit=self.xfit
          yfit=self.yfit
          
          
          ;LRK - 06/08/09
          if arg_present(fitInput) then begin
             if ptr_valid(self.fitInputptr) ne 0 then begin
                fitInput = *self.fitInputptr
             endif else begin
                fitInput = -1;[0.0,0.0,0.0,0.0]
             endelse
          endif
          if arg_present(fitInputptr) then begin
             if ptr_valid(self.fitInputptr) ne 0 then begin
                fitInputptr = self.fitInputptr
             endif else begin
                fitInputptr = ptr_new([0.0,0.0,0.0,0.0])
             endelse
          endif



return,1
end;crs_dtas_data_new::get_property
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function crs_dtas_data_new::set_property,   $
              filename = filename,                $
              contents = contents,                $
              xvar_name = xvar_name,              $
              yvar_name = yvar_name,              $
              signal_type = signal_type,          $
              data = data,                        $
              display_name = display_name,        $
              hfield = hfield,                    $
              shift_value = shift_value,          $
              second_var_name = second_var_name,  $
              plot_str = plot_str,                $
              descriptr_str = descriptr_str $
              ,anaPkgStr = anaPkgStr $
              ,show_TD = show_TD $
              ,anaPkgUpdData = anaPkgUpdData,$
              hkl=hkl, $
              ecen=ecen,$
              efixed = efixed,$                   ;LRK
              monofixed = monofixed,$                  ;LRK
              anafixed = anafixed,$                   ;LRK
              abc = abc,$                ;LRK   
              abg = abg,$                ;LRK
              collimation = collimation,$        ;LRK
;              collimationh = collimationh,$        ;LRK
;              collimationv = collimationv,$        ;LRK
              hcollimation = hcollimation,$        ;LRK
              vcollimation = vcollimation,$        ;LRK
              mosaic = mosaic,$             ;LRK
              orientation1 = orientation1,$       ;LRK
              orientation2 = orientation2,$       ;LRK
              monodspacing = monodspacing,$             ;LRK
              anadspacing = anadspacing, $     ;LRK
              leafinfo=leafinfo, $             ;LRK
              fitinput=fitinput,$              ;LRK
              xdata=xdata,$
              ydata=ydata,$
              dydata=dydata,$
              xtitle=xtitle,$
              ytitle=ytitle,$
              title=title,$
              xfit=xfit,yfit=yfit
              
              
  ret = self->dtas_data::set_property(filename = filename,                $
                                      contents = contents,                $
                                      xvar_name = xvar_name,              $
                                      yvar_name = yvar_name,              $
                                      signal_type = signal_type,          $
                                      data = data,                        $
                                      display_name = display_name,        $
                                      hfield = hfield,                    $
                                      shift_value = shift_value,          $
                                      second_var_name = second_var_name,  $
                                      plot_str = plot_str,                $
                                      descriptr_str = descriptr_str $
                                      ,anaPkgStr = anaPkgStr $
                                      ,show_TD = show_TD $
                                      ,anaPkgUpdData = anaPkgUpdData)

  ;LRK - 06/08/09
  if n_elements(fitInput) then begin
  ;  YN = dialog_message('',/question)
  ;  if strupcase(yn) eq 'YES' then begin
     if ptr_valid(self.fitInputptr) ne 0 then ptr_free,self.fitinputptr
     self.fitInputptr = ptr_new(fitInput)
  ; endif;YN
  endif
  
  ;LRK = 10/29/09
  if n_elements(xdata) ne 0 then begin
    if ptr_valid(self.xdata) gt 0 then ptr_free,self.xdata
    self.xdata = ptr_new(xdata)
  endif
  if n_elements(ydata) ne 0 then begin
    if ptr_valid(self.ydata) gt 0 then ptr_free,self.ydata
    self.ydata = ptr_new(ydata)
  endif
  if n_elements(dydata) ne 0 then begin
    if ptr_valid(self.dydata) gt 0 then ptr_free,self.dydata
    self.dydata = ptr_new(dydata)
  endif
  if n_elements(xtitle) ne 0 then self.xtitle=xtitle
  if n_elements(ytitle) ne 0 then self.ytitle=ytitle
  if n_elements(title) ne 0 then self.title=title


  if n_elements(xfit) ne 0 then begin
    if ptr_valid(self.xfit) gt 0 then ptr_free,self.xfit
    self.xfit = ptr_new(xfit)
  endif
  if n_elements(yfit) ne 0 then begin
    if ptr_valid(self.yfit) gt 0 then ptr_free,self.yfit
    self.yfit = ptr_new(yfit)
  endif

  
  
  if n_elements(hkl) ne 0 then self.hkl = hkl
  if n_elements(efixed) ne 0 then self.efixed = efixed
  if n_elements(ecen) ne 0 then self.ecen = ecen
  if n_elements(monofixed) ne 0 then self.monofixed = monofixed
  if n_elements(anafixed) ne 0 then self.anafixed = anafixed
  if n_elements(abc) ne 0 then self.abc = abc   
  if n_elements(abg) ne 0 then self.abg = abg
  if n_elements(collimation) ne 0 then begin
    self.collimation = collimation
    self.collimationh = collimation
  endif
  if n_elements(collimationh) ne 0 then begin
    self.collimationh = collimationh
    self.collimation = collimationh  
  endif
  if n_elements(collimationv) ne 0 then self.collimationv = collimationv

  if n_elements(hcollimation) ne 0 then begin
    self.collimationh = hcollimation
    self.collimation = hcollimation  
  endif
  if n_elements(vcollimation) ne 0 then self.collimationv = vcollimation

  if n_elements(mosaic) ne 0 then self.mosaic = mosaic
  if n_elements(orientation1) ne 0 then self.orientation1 = orientation1
  if n_elements(orientation2) ne 0 then self.orientation2 = orientation2
  if n_elements(monodspacing) ne 0 then begin
    self.monodspacing = monodspacing
    self.dspacing[0] = monodspacing
  endif
  if n_elements(anadspacing) ne 0 then begin
    self.anadspacing = anadspacing
    self.dspacing[1] = anadspacing
  endif
  if n_elements(dspacing) eq 2 then begin
    self.anadspacing = dspacing[1]
    self.monodspacing = dspacing[0]
    self.dspacing = dspacing
  endif
  ;void = dialog_message('MAY NEED TO UPDATE self.orescalculator INFORMATION!!!')
  ;print,'MAY NEED TO UPDATE self.orescalculator INFORMATION!!!'
  ;self.orescalculator->calculate,rm,r0,$
  ;                      horizontal=0,$
  ;                      collimatorh=self.collimation,$
  ;                      mosaic=self.mosaic,$
  ;                      dspacing=[self.monodspacing,self.anadspacing],$
  ;                      instrument_orient=instrument_orient,$
  ;                      qetrans=[self.hkl,self.ecen,self.efixed]
  
  
  if n_elements(leafinfo) ne 0 then begin
    ptr_free,self.leafinfo
    self.leafinfo = ptr_new(leafinfo)
  endif 

return,1
end;crs_dtas_data_new::set_property
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pro crs_dtas_data_new::fillitdata
;FOR THE IDLitDataContainer

    res = self->setData('data_file_contents',*self.data_file_contents)
    res = self->setData('display_name',*self.display_name)
    res = self->setData('data',*self.dataPtr)
    res = self->setData('extension',self.extension)
    res = self->setData('add',self.add)
    res = self->setData('scan',self.scan)
    res = self->setData('prf',self.prf)
    res = self->setData('total_mon',self.total_mon)
    res = self->setData('base',self.base)
    res = self->setData('num_pts',self.num_pts)
    res = self->setData('type',self.type)
    res = self->setData('date',self.date)
    res = self->setData('comments',self.comments)
    res = self->setData('header',*self.header_ptr)

    res = self->setData('fit',*self.fit_ptr)  ;THIS SHOULD BE ELIMINATED IN FAVOR OF JUST USING THE FIT CONTAINER
    
    res = self->setData('descriptr',*self.descriptr)
    res = self->setData('mon',self.mon)
    res = self->setData('signal_type',self.signal_type)
    res = self->setData('ytitle',self.ytitle)
    res = self->setData('hfield',self.hfield)
    res = self->setData('shift_value',self.shift_value)

  ;Q and lattice
    res = self->setData('hkl',self.hkl)                    ;SHOULD THESE BE KEPT ONLY IN crs_lattice OBJECT????
    res = self->setData('abc',self.abc)
    res = self->setData('abg',self.abg)

  ;Resolution
    res = self->setData('collimation',self.collimation)    ;SHOULD ALL RESOLUTION ITEMS BE KEPT ONLY IN crs_resCalculator????
    res = self->setData('collimationh',self.collimationh)
    res = self->setData('collimationv',self.collimationv)
    res = self->setData('moasic',self.mosaic)
    res = self->setData('orientation1',self.orientation1)
    res = self->setData('orientation2',self.orientation2)

    res = self->setData('monodspacing',self.monodspacing)
    res = self->setData('anadspacing',self.anadspacing)
    res = self->setData('dspacing',self.dspacing)
    res = self->setData('efixed',self.efixed)
    res = self->setData('ecen',self.ecen)
    res = self->setData('monofixed',self.monofixed)
    res = self->setData('anafixed',self.anafixed)


;              
;              ,olattice:obj_new()           $  ;LRK
;              ,orescalculator:obj_new()     $  ;LRK
;              ,fitcontainer:obj_new()       $  ;LRK


    res = self->setData('leafinfo',self.leafinfo)
    res = self->setData('plot_data',*self.plot_Ptr)
  
;              ;
;              ,plot_ptr:ptr_new()           $
;              ,mcf_ptr:ptr_new()            $
;              ,collim_ptr:ptr_new()         $
;              ,econfig_ptr:ptr_new()        $
;              ,qconfig_ptr:ptr_new()        $
;              ,mosaic_ptr:ptr_new()         $
;              ,instrument_ptr:ptr_new()     $
;              ,motors_ptr:ptr_new()         $
;              ,lattice_ptr:ptr_new()        $
;              ,xtal_orientation_ptr:ptr_new()  $
;              ,second_var_name:''           $
;              ,treatment_ptr:ptr_new()      $
;              ,orientation_ptr:ptr_new() $
;              ,fixedEType:'' $
;              ,fixedEValue:0.0 $
;              ,dSpaceM:0.0 $
;              ,dSpaceA:0.0 $
;              ,isICE:0B $       ; is data from an ICE formated file? 0=>no, 1=>yes
;              ,anaPkgPtr:ptr_new() $ ; info about BT7 analyzer package
;              ,sdesc:'' $
;              ,filename:'' $
;           }



end;crs_dtas_data_new::fillitdata




;---------------------------------------
function crs_dtas_data_new::get_instrumentInfo,restext=restext
;print,'crs_dtas_data_new::get_instrumentInfo'
defsysv,'!debug',exists=exists
if exists eq 0 then defsysv,'!debug',0

if !debug eq 0 then begin
  catch,the_error
  if the_error ne 0 then begin
     catch,/cancel
     void = dialog_message(!error_state.msg,title='crs_dtas_data_new::get_instrumentInfo')
     return,0
  endif
endif;debug

if self.isice ne 1 then begin
  if n_elements(hkl) eq 0 then begin
      dum = self->get_property(hkl=hkl)
      if ptr_valid(self.header_ptr) ne 0 then begin    
        header = *self.header_ptr
        if n_elements(header) gt 11 then begin
          if stregex(header[4],'Collimation',/boolean,/fold_case) then begin
            segs = strsplit(header[3],/extract)
            self.collimation  = float(segs[0:3])
            self.collimationh = self.collimation
            self.collimationv = 120.0 + 0*self.collimationh
            self.collimationv[3] = 240.0

            tempmosaic = float(segs[4:6])
            
;print,'mosaic =',tempmosaic
;print,'crs_dtas_data::get_instrumentInfo: If mosaics are all 0, then we may need to get them from the user!!!!

            mosaic_mon = tempmosaic[0] > 30.0
            mosaic_sh = tempmosaic[1] > 10.0
            mosaic_sv = mosaic_sh
            mosaic_an = tempmosaic[2] > 30.0
;            print,'tempmosaic=',tempmosaic
            self.mosaic       = [mosaic_sh,mosaic_sv,mosaic_mon,mosaic_an];float(segs[4:6])
            self.orientation1 = float(segs[7:9])
            self.orientation2 = float(segs[11:13])
          endif
          if stregex(header[6],'Lattice',/boolean,/fold_case) then begin
            segs = strsplit(header[5],/extract)
            self.abc  = float(segs[0:2])
            self.abg  = float(segs[3:5])
          endif
          if stregex(header[8],'E center',/boolean,/fold_case) then begin
            segs = strsplit(header[7],/extract)
            self.ecen   = float(segs[0])
            self.efixed  = float(segs[2])
            self.monodspacing = float(segs[3])
            self.anadspacing = float(segs[4])
            if stregex(header[8],'EM fixed',/boolean,/fold_case) then self.monofixed = 1 else self.anafixed = 1
            ;if stregex(header[8],'EA fixed',/boolean,/fold_case) then self.anafixed = 1

          endif

        endif
      endif
  endif
endif else begin

  ;LRK - 100611
  ;PARSE AND ICE HEADER
;#FixedE      Ei 14.7
;#Lattice     3.78777 3.78777 6.149 90 90 90
;#Orient      1 0 0 0 0 1
;#MonoSpacing 3.35416
;#AnaSpacing  3.35416
;#MonoVertiFocus SAGITTAL
;#MonoHorizFocus FLAT
  contents = *self.data_file_contents

  datapos = where(stregex(contents,'#',/boolean) eq 0,datacount)
  headerpos = where(stregex(contents,'#',/boolean) ne 0,headercount)

  if headerpos[n_elements(headerpos)-1]  gt datapos[n_elements(datapos)-1] then headerpos = headerpos[0:n_elements(headerpos)-2] 

  whdata = where(datapos gt max(headerpos),whdatacount)
  
  
  header = contents[headerpos]
  datalines = contents[datapos[whdata]]
  qxpos = -1
  qypos = -1
  qzpos = -1
  A3pos = -1
  A4pos = -1
  hkl = [1.0,0,0]

  for i=0,n_elements(header)-1 do begin
    if stregex(header[i],'#Lattice',/fold_case,/boolean) ne 0 then begin
      segs = strsplit(header[i],/extract)
      self.abc  = float(segs[1:3])
      self.abg  = float(segs[4:6])
    endif;#Lattice
    if stregex(header[i],'#Orient',/fold_case,/boolean) ne 0 then begin
      segs = strsplit(header[i],/extract)
      self.orientation1 = float(segs[1:3])
      self.orientation2 = float(segs[4:6])
    endif;#Orient
    if stregex(header[i],'#MonoSpacing',/fold_case,/boolean) ne 0 then begin
      segs = strsplit(header[i],/extract)
      self.monoDSpacing = float(segs[1])
    endif;#MonoSpacing
    if stregex(header[i],'#AnaSpacing',/fold_case,/boolean) ne 0 then begin
      segs = strsplit(header[i],/extract)
      self.anaDSpacing = float(segs[1])
    endif;#AnaSpacing
    if stregex(header[i],'#FixedE',/fold_case,/boolean) ne 0 then begin
      segs = strsplit(header[i],/extract)
      self.efixed = float(segs[2])
      if stregex(segs[1],'Ei',/boolean,/fold_case) then self.monofixed = 1 else self.anafixed = 1      
    endif;#FixedE

    tempmosaic = fltarr(3) + 1.0 ;THIS IS IN MINUTES, I BELIEVE
    mosaic_mon = tempmosaic[0] > 30.0
    mosaic_sh = tempmosaic[1] > 10.0
    mosaic_sv = mosaic_sh
    mosaic_an = tempmosaic[2] > 30.0
    self.mosaic       = [mosaic_sh,mosaic_sv,mosaic_mon,mosaic_an]

    thscan = 0
    tthscan = 0
    if stregex(header[i],'#Columns',/fold_case,/boolean) ne 0 then begin
      segs = strsplit(header[i],/extract)
      for j=0,n_elements(segs)-1 do begin
        if strupcase(segs[j]) eq 'QX' then qxpos = j-1 
        if strupcase(segs[j]) eq 'QY' then qypos = j-1 
        if strupcase(segs[j]) eq 'QZ' then qzpos = j-1 
        if strupcase(segs[j]) eq 'A3' then a3pos = j-1 
        if strupcase(segs[j]) eq 'A4' then a4pos = j-1 
      endfor;j
      
      if datacount gt 1 then begin
        dline1 = datalines[0]
        a3vals = fltarr(datacount)
        a4vals = fltarr(datacount)
        dsegs = strsplit(dline1,/extract)  
        if n_elements(dsegs) gt 1 then begin
          qx = float(dsegs[qxpos])
          qy = float(dsegs[qypos])
          qz = float(dsegs[qzpos])
          self.hkl = [Qx,Qy,Qz]
          hkl = self.hkl
          print,'self.hkl = ',self.hkl
        endif;n_elements(dsegs)
        for k=0,datacount-1 do begin
          dsegs = strsplit(datalines[k],/extract)  
          tempA3 = float(dsegs[A3pos])
          tempA4 = float(dsegs[A4pos])
          a3vals[k] = tempA3
          a4vals[k] = tempA4
        
        endfor;k
        if max(a3vals) - min(a3vals) ne 0 then thscan = 1
        if max(a4vals) - min(a4vals) ne 0 then tthscan = 1
print,'thscan,tthscan=',thscan,tthscan        


      endif;datacount
    endif;stregex(header
  ;endif;#Columns
  
    
  


    
  endfor;i

  segs = strsplit(header[3],/extract)
  collimation = fltarr(4)
  self.collimation  = 40+collimation
  self.collimationh = self.collimation
  self.collimationv = 120.0 + collimation
  self.collimationv[3] = 240.0

  tempmosaic = 20 + fltarr(3)
  

endelse;isice


  
;  help,self.olattice
;  help,self.orescalculator
  self.olattice->setLattice,self.abc[0],self.abc[1],self.abc[2],self.abg[0],self.abg[1],self.abg[2],self.orientation1,self.orientation2
  
 ; print,'HOW IS "horizontal" keyword used?   --- HORIZONATAL FOCUSING'
  self.orescalculator->calculate,rm,r0,$
                                  horizontal=0,$  
                                  collimatorh=self.collimation,$
                                  collimatorv=120.0+fltarr(4),$
                                  mosaic=self.mosaic,$
                                  dspacing=[self.monodspacing,self.anadspacing],$
                                  instrument_orient=[1,1],$
                                  qetrans=[hkl,self.ecen,self.efixed],$
                                  lattice=self.olattice,$
                                  closed=closed,$
                                  tthcorrection=tthcorrection,$
                                  thcorrection=thcorrection,$
                                  strout=restext


;print,'rm=',rm                                      
;print,'r0=',r0
;print,'tthcorrection=',tthcorrection
;print,'thcorrection=',thcorrection
;print,'closed=',closed
  return,1
end;crs_dtas_data_new::get_instrumentInfo


function crs_dtas_data_new::get_hkl
;help,/traceback
;
;print,'crs_dtas_data::get_hkl'  
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   void = dialog_message(!error_state.msg)
   return,0
endif



  if n_elements(hkl) eq 0 then begin
      dum = self->get_property(hkl=hkl)
      if ptr_valid(self.header_ptr) ne 0 then begin    
        header = *self.header_ptr
        if n_elements(header) gt 11 then begin
          if stregex(header[10],'(hkl scan center)',/boolean,/fold_case) then begin
            segs = strsplit(header[9],/extract)
            hkl = float(segs[0:2])
          endif
        endif
      endif
  endif
;   else begin
;      hkl = fltarr(3)
;  endelse
  ret = self->set_property(hkl=hkl)
  return,ret
end;crs_dtas_data_new::get_hkl


function crs_dtas_data_new::dave_parse_ice, dstring,dstruct,    $
                                            header=header_string, $
                                            headText = headText, $
                                            dattaText = dattaText, $
                                            indep_var_pos=indep_var_pos, $
                                            dep_var_pos=dep_var_pos, $
                                            ;,plot_indep_var = plot_indep_var $
                                            lattice=lattice, $
                                            fixedEType=fixedEType, $
                                            fixedEValue=fixedEValue, $
                                            dSpaceM=dSpaceM, $
                                            dSpaceA=dSpaceA, $
                                            orientation=orientation, $
                                            sdesc=sdesc, $
                                            anaPkgStr=anaPkgStr, $
                                            errmsg = errmsg

errmsg = ''
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   errmsg = !error_state.msg
   return,0B
endif
nlines = n_elements(dstring)

header_counter = 0L
data_counter = 0L

; Go through each element of the string array and get out the first data line
; and the last data line
last_line_boolean = 0B
indep_index = -1
dep_index = -1
indep_var_pos = -1
dep_var_pos = -1
latt_index = -1
dsmon_index = -1
dsana_index = -1
fEi_index = -1
orient_index = -1
sdesc_index = -1
lattice = [0.0D,0.0D,0.0D,0.0D,0.0D,0.0D]
orientation = [0.0,0.0,0.0,0.0,0.0,0.0]
fixedEType = ''
fixedEValue = 0.0
dspaceM = 0.0
dspaceA = 0.0
sdesc = ''
anapkg = 0
doOrient = 0

headText = strarr(2,nlines)
ih = 0

for i = 0,nlines-1 do begin
    if (strmid(dstring[i],0,1) ne '#') then continue ; don't analyze data lines
    
    ;toks = strsplit(dstring[i],' ',/extract,count=ntoks)
    toks = strsplit(dstring[i],' ',/extract,count=ntoks)
    headText[0,ih] = toks[0]
    headText[1,ih] = (ntoks ge 2)? strjoin(toks[1:ntoks-1],' ') : ' '
    ih++
    
    case strupcase(toks[0]) of
        '#COLUMNS': begin
            first_data_line = i+1
            titles = toks[1:ntoks-1]
            ncols = ntoks - 1
        end
        '#COMMENT':
        '#SCAN': begin
            indep_var_pos = fix(toks[1]) - 1
            indep_index = (indep_var_pos lt 0)? -1 : 1 
        end
        '#SIGNAL': begin
            dep_var_pos = fix(toks[1]) - 1 ; zero-based index
            dep_index = (dep_var_pos lt 0)? -1 : 1 
        end
        '#LATTICE': begin
          if (ntoks eq 7) then lattice =double([toks[1],toks[2],toks[3],toks[4],toks[5],toks[6]])
        end;LATTICE
        '#FIXEDE': begin
            if (ntoks eq 3) then begin
                fixedEType = toks[1]
                fixedEValue = float(toks[2])
            endif
        end
        '#MONOSPACING': if (ntoks eq 2) then  dspaceM = float(toks[1])
        '#ANASPACING': if (ntoks eq 2) then  dspaceA = float(toks[1])
        '#ORIENT':   begin
            if (ntoks eq 7) then orientation = float([toks[1],toks[2],toks[3],toks[4],toks[5],toks[6]])
            lab1 = 'Orient'+strjoin([toks[1],toks[2],toks[3]])
            lab2 = 'Orient'+strjoin([toks[4],toks[5],toks[6]])
            doOrient = 1
        end
        '#SCANDESCR':   if (ntoks eq 2) then sdesc = toks[1]
        '#ANALYZERDETECTORMODE': begin
            if (ntoks eq 3) then begin
                anaPkg = 1
                anaMode = fix(toks[1])
                anaModeName = strtrim(toks[2],2)
            endif
        end
        '#ANALYZERDETECTORDEVICESOFINTEREST': anaSigDets = toks[1:ntoks-1]
        '#ANALYZERSDGROUP': anaSDDets = toks[1:ntoks-1]
        '#ANALYZERDDGROUP': anaDDDets = toks[1:ntoks-1]
        '#ANALYZERDOORDETECTORGROUP': anaTDDets = toks[1:ntoks-1]
        '#ANALYZERPSDGROUP': anaPSDDets = toks[1:ntoks-1]
        
        else: begin
            ;; check for fit parameters present in some scans at end
            ;; of file
            if (strmatch(toks[0],'*:END*',/fold_case)) then $
              last_data_line = i-1
        end
    endcase

endfor
headText = headText[*,0:ih-2] ; exclude from #column keyword and lower

if n_elements(last_data_line) eq 0 then $
   last_data_line = nlines-1

if ((last_data_line - first_data_line) lt 1) then begin
  errmsg = 'Data block contains no data'
  return,0B
endif
 
data_string = dstring[first_data_line:last_data_line]
ndata = last_data_line-first_data_line+1
data = fltarr(ncols,ndata)
dattaText = strarr(ncols,ndata)
for i = 0,ndata-1 do begin
    ;tmpBuf = strsplit(data_string[i],' ',/extract)
    tmpBuf = strsplit(data_string[i],/extract)
    dattaText[*,i] = tmpBuf
    tmpInd = where(tmpBuf eq 'N/A',indCnt)
    if (indCnt gt 0) then tmpBuf[tmpInd] = 0.0 ;'-999'
    data[*,i] = float(tmpBuf)
endfor

header_indices = where((indgen(nlines) ge last_data_line) or $
   (indgen(nlines) le first_data_line),count_header)
header_string = dstring[header_indices]


; Calculate the basis vectors given two orientation vectors and the hkl values.
; Insert these as additional 'scan' variables in the data immediately after qx, qy, qz and E
; Note: the new scan variables are only meaningful for Q Scans (Q varying)

iqx = where(strupcase(titles) eq 'QX',foundx)
iqy = where(strupcase(titles) eq 'QY',foundy)
iqz = where(strupcase(titles) eq 'QZ',foundz)
if (foundx && foundy && foundz && doOrient) then begin
   qx = reform(data[iqx,*])
   qy = reform(data[iqy,*])
   qz = reform(data[iqz,*])
   orient1 = orientation[0:2]
   orient2 = orientation[3:5] 
   basis = fltarr(3,ndata)
   for i=0,ndata-1 do begin
      hkl = [qx[i],qy[i],qz[i]]
      basis[*,i] = HKLtoBasis(orient1,orient2,hkl)
   endfor
   ;lab1 = 'ORIENT'+strjoin(string(orient1))
   ;lab2 = 'ORIENT'+strjoin(string(orient2))
   ; replace any '-' with '_' in lab1 and lab2
   while ((pos = stregex(lab1,'-')) ne -1) do strput, lab1,'_',pos
   while ((pos = stregex(lab2,'-')) ne -1) do strput, lab2,'_',pos

   ; insert into data and title arrays after qx,qy,qz
   last = max([iqx[0],iqy[0],iqz[0]])
   ;titles = [titles[0:2],lab1,lab2,titles[3:ncols-1]]
   ;data = [data[0:2,*],basis[0:1,*],data[3:ncols-1,*]]
   titles = [titles[0:last],lab1,lab2,titles[last+1:ncols-1]]
   data = [data[0:last,*],basis[0:1,*],data[last+1:ncols-1,*]]
   dattaText = [dattaText[0:last,*],string(basis[0:1,*]),dattaText[last+1:ncols-1,*]]
   
   ; increment indices,counts by 2 if necessary
   ncols += 2
   if (indep_var_pos gt last) then indep_var_pos += 2 
   if (dep_var_pos gt last) then dep_var_pos += 2
endif


; The indep variable
;;;if (indep_index ne -1) then begin
;;;   toks = strsplit(dstring[indep_index],/extract)
;;;   indep_var_pos = fix(toks[1]) - 1
;;;   if (indep_var_pos lt 0) then indep_index = -1 
;;;endif
if (indep_index eq -1) then begin
    ;; find first varying device
    i = -1
    found = -1
    small = 0.001
    while ((++i lt ncols) && (found eq -1)) do begin
        diff = abs(data[i,ndata-1] - data[i,0])
        colHeader = strupcase(titles[i])
        notAMon = colHeader ne 'MONITOR' 
        notADet = colHeader ne 'DETECTOR'
        notTime = colHeader ne 'TIME'
        found = ((diff gt small) && notAMon && notADet && notTime)? i : -1
    endwhile
    
    if (found gt -1) then begin
;        plot_indep_var = titles[found]
        indep_var_pos = found
    endif else begin
;        plot_indep_var = ''
        indep_var_pos = 0
    endelse
endif

; The dep variable. If the signal was not explicitly specified, use the detector
if (dep_index eq -1) then begin
    dep_var_pos = where(strupcase(titles) eq 'DETECTOR')
    dep_var_pos = dep_var_pos[0] - 1 ; zero-based index
endif ;;;else begin
;;;   toks = strsplit(dstring[dep_index],/extract)
;;;   dep_var_pos = fix(toks[1]) - 1 ; zero-based index
;;;endelse

;;; Previously, the dependent column was moved to the last column of the
;;; structure which is the default location for the Signal/Counts.
;;; Now (May, 07) alter this behaviour by also adding an extra column
;;; called 'Signal' and _copy_ the dependent data to it.
;theRest = where(indgen(ncols) ne dep_var_pos)
;data = [data[theRest,*],data[dep_var_pos,*]]
;dattaText = [dattaText[theRest,*],dattaText[dep_var_pos,*]]
;titles = [titles[theRest],titles[dep_var_pos]]
;if (indep_var_pos gt dep_var_pos) then indep_var_pos-- ; shift by 1 if necessary after rearrangement
;dep_var_pos = ncols - 1
;
;data = [data,data[dep_var_pos,*]]
;dattaText = [dattaText,dattaText[dep_var_pos,*]]
;titles = [titles,'Signal']
;nCols++

;; Now (Jul, 10) simply add an extra column
;; called 'Signal' and _copy_ the dependent data to it.
data = [data,data[dep_var_pos,*]]
dattaText = [dattaText,dattaText[dep_var_pos,*]]
titles = [titles,'Signal']
nCols++





; Processing for analyzer package
if (anaPkg) then begin
    ;; sum data from package detectors in use
    ndets = n_elements(anaSigDets)
    for i = 0,ndets-1 do begin
        det_pos = where(titles eq anaSigDets[i],cnt)
        if (cnt) then $
          det_sum = (n_elements(det_sum) gt 0)? det_sum+reform(data[det_pos,*]) : reform(data[det_pos,*])
    endfor
    
    ;; By default, the signal column should be the sum of detectors in
    ;; use
    data[nCols-1,*] = det_sum
    dattaText[nCols-1,*] = string(det_sum)
    
    ;; record analyzer info in a structure
    anaPkgStr = {mode:anaMode $
                 ,signalDets:anaSigDets $
                 ,sigDetsInSum:strjoin(anaSigDets,';',/single) $
                 ,TDDetsInSum:strjoin(anaTDDets,';',/single) $
                 ,SDDets:anaSDDets $
                 ,DDDets:anaDDDets $
                 ,TDDets:anaTDDets $
                 ,PSDDets:anaPSDDets $
                }
endif



; Add an error column
errIndex = where(strupcase(titles) eq 'DETECTORERR',foundErr)
if (foundErr) then begin
  error = reform(data[errIndex,*])
endif else begin
  error = reform(data[nCols-1,*]) ;reform(data[dep_var_pos,*])
  badInd = where(error le 0.0,cnt)
  if (cnt gt 0) then error[badInd] = 1.0
  error = sqrt(error)
endelse
; Create a structure for the data with the titles defined
; as the tag names.
dstruct = create_struct(titles[0],ptr_new(reform(data[0,*])))
for i = 1,nCols-1 do dstruct = create_struct(dstruct,titles[i],ptr_new(reform(data[i,*])))

dattaText = [dattaText,transpose(string(error))]
dstruct = create_struct(dstruct,'ERROR',ptr_new(error,/no_copy))
titles = [titles,'ERROR']

; Add an INDEX column - expected in reduction section of code
dstruct = create_struct('INDEX',ptr_new(indgen(ndata)),dstruct)

titles = ['Data Point',titles]
dattaText = [transpose(string(indgen(ndata)+1)),dattaText]
dattaText = transpose([transpose(titles), transpose(dattaText)])

indep_var_pos++                 ; accommodate INDEX
dep_var_pos++                   ; accommodate INDEX

catch,/cancel
return,1B
end;crs_dtas_data_new::dave_parse_ice

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function crs_dtas_data_new::read_file
  defsysv,'!debug',exists=exists
  if exists eq 0 then defsysv,'!debug',0
  
  if !debug eq 0 then begin
    catch,the_error
    if the_error ne 0 then begin
       catch,/cancel
       void = dialog_message(!error_state.msg,title='In crs_dtas_data_new::read_file')
       if n_elements(lun) ne 0 then free_lun,lun,/force
       return,0
    endif
  endif;debug

  duh = self->dtas_data::read_file()

  duh = self->dave_parse_ice(*self.data_file_contents,dstruct,    $
                                            header=header_string, $
                                            headText = headText, $
                                            dattaText = dattaText, $
                                            indep_var_pos=indep_var_pos, $
                                            dep_var_pos=dep_var_pos, $
                                            ;,plot_indep_var = plot_indep_var $
                                            lattice=lattice, $
                                            fixedEType=fixedEType, $
                                            fixedEValue=fixedEValue, $
                                            dSpaceM=dSpaceM, $
                                            dSpaceA=dSpaceA, $
                                            orientation=orientation, $
                                            sdesc=sdesc, $
                                            anaPkgStr=anaPkgStr, $
                                            errmsg = errmsg)
  
  print,orientation
  print,lattice
  print,dspacem
  duh = self->get_hkl()
  self.orientation1 = double(orientation[0:2])
  self.orientation2 = double(orientation[3:5])

;s={crs_dtas_data_new}
;print,transpose(tag_names(s))
  duh = self->get_instrumentInfo()

  self->calculate


return,1
end;read_file



pro crs_dtas_data_new::combine,allobj

  duh = self->get_property(filename=filename)
;print,'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
;print,'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
;print,'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
;print,'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
;print,'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'


  fullname = file_basename(filename)
  if n_elements(allobj) gt 0 then begin
                ;INITIALLY ASSUME THAT ALL THE OBJECTS SELECTED MATCH UP.

;FIRST CHECK MONITOR VALUES:
duh = self->get_property(total_mon=total_mon)
if total_mon le 0.0 then all_mon = 1.0 else all_mon = total_mon
if all_mon ne 1.0 then begin
  for i=0,n_elements(allobj)-1 do begin
    duh = allobj[i]->get_property(total_mon=total_mon)
    if total_mon le 0.0 then all_mon = 1.0
  endfor;i
endif;all_mon

;                THIS SHOULD BE DONE IN A METHOD INTHE clone OBJECT.
                duh = self->get_property(hkl=hkl,xdata=xdata,ydata=ydata,dydata=dydata,total_mon=total_mon)

                hkl0 = hkl                  
                x0 = *xdata
                if all_mon eq 1.0 then mon0 = all_mon else mon0 = total_mon
                y0 = *ydata
                dy0 = *dydata
                
                for i=0,n_elements(allobj)-1 do begin
                  duh = allobj[i]->get_property(hkl=hkl,xdata=xdata,ydata=ydata,dydata=dydata,total_mon=total_mon,filename=filename)
                  if all_mon eq 1.0 then total_mon = all_mon
                  fullname=fullname+'_'+file_basename(filename)
                  print,i,hkl
                  ;NOW SHUFFLE/AVERAGE DATA TOGETHER.
                  ;THROW ALL TOGETHER ----- NOTE: NEED TO CORRECT BY RELATIVE MONITOR!!!!!!
                  x0  = [x0,*xdata]
                  y0  = [y0,(mon0/total_mon)*(*ydata)]
                  dy0 = [dy0,(mon0/total_mon)*(*dydata)]
                endfor;i

                ;SORT THE DATA
                s = sort(x0)
                
                x0 = x0[s]
                y0 = y0[s]
                dy0 = dy0[s]
;help,x0,y0,dy0
                whnotnan = where(finite(y0,/nan) eq 0,notnancount)
                if notnancount ne n_elements(y0) then begin
                  x0 = x0[whnotnan]
                  y0 = y0[whnotnan]
                  dy0 = dy0[whnotnan]
                endif
;help,x0,y0,dy0
;print,x0
                ;GET ALL UNIQUE VALUES & AVERAGE OVER NON-UNIQUE ONES.                
                tol = 10.0d^5
                u = uniq(floor(x0*tol))  ;GET UNIQUE VALUES TO WITHIN A TOLERANCE OF 0.00001 help,
                xnew = x0[u]
                ynew = y0[u]
                dynew = dy0[u]

                for j=0,n_elements(u)-1 do begin
                  if j eq 0 then i1 = 0 else i1 = u[j-1]
                  i2 = u[j]-1
                  tot = 0.0
                  dtot = 0.0
                  npts = 0.0
                  for i=i1,i2 do begin
                    tot += y0[i]
                    dtot += dy0[i]^2
                    npts++
                  endfor;i

                  ynew[j] = tot/npts
                  dynew[j] = sqrt(dtot)/npts

                endfor;j

                ;UPDATE plot_ptr AND x,y,dy,num_points DATA.    ---- ANYTHING ELSE?????

                ;DETERMINE NEW num_points AT END AFTER ALL x,y,dy VALUES ARE DETERMINED FOR THE SUMMED OBJECT.

                if ptr_valid(self.xdata) gt 0 then ptr_free,self.xdata
                self.xdata = ptr_new(xnew)

                if ptr_valid(self.xfit) gt 0 then ptr_free,self.xfit
                self.xfit = ptr_new(xnew)

                if ptr_valid(self.ydata) gt 0 then ptr_free,self.ydata
                self.ydata = ptr_new(ynew)
                if ptr_valid(self.dydata) gt 0 then ptr_free,self.dydata
                self.dydata = ptr_new(dynew)
                self.num_pts = n_elements(xnew)
                self.filename=fullname

self.fitcontainer->setxvalues,xvalues=xnew

;help,xnew,ynew,dynew
                ;NOW RESET THE PLOT_PTR  ---> IS THAT BEING USED??
                ;help,*self.plot_ptr,/struct
                *(*self.plot_ptr).x = xnew
                *(*self.plot_ptr).y = ynew
                *(*self.plot_ptr).dy = dynew
                (*self.plot_ptr).title = fullname
                self.title=fullname
;print,'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
;print,'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
;print,'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
;print,'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
;print,'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'

      ;REDO THE FIT 
      duh = self->refit()
  ;n_elements(allobj) gt 0                
  endif else begin
    ;JUST LEAVE THE VALUES UNCHANGED
  endelse

end;combine



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function crs_dtas_data_new::crsclone
  print,'crs_dtas_data_new::crsclone'
;  class =  {  crs_dtas_data                    $
;              ,inherits idlitdata $
;              ,data_file_contents:ptr_new() $
;              ,display_name:''             $
;              ,data_ptr:ptr_new()           $
;              ,extension:''                 $
;              ,add:0B                      $
;              ,scan:''                      $
;              ,prf:0L                       $
;              ,tot_mon:0L                   $
;              ,base:''                      $
;              ,num_pts:0                    $
;              ,type:''                      $
;              ,date:''                      $
;              ,time:''                      $
;              ,comments:''                  $
;              ,header_ptr:ptr_new()         $
;              ,fit_ptr:ptr_new()            $
;              ,fitinputptr:ptr_new()        $  ;LRK
;              ,descriptr:ptr_new()          $
;              ,mon:0L                       $
;              ,signal_type:''               $
;              ,ytitle:''                    $
;              ,hfield:0D                    $
;              ,shift_value:0D               $
;              ,hkl:fltarr(3)                $  ;LRK
;              ,abc:fltarr(3)                $  ;LRK   
;              ,abg:fltarr(3)                $  ;LRK 
;              ,collimation:fltarr(4)        $  ;LRK
;              ,mosaic:fltarr(4)             $  ;LRK
;              ,orientation1:fltarr(3)       $  ;LRK
;              ,orientation2:fltarr(3)       $  ;LRK
;              ,monodspacing:0.0             $  ;LRK
;              ,anadspacing:0.0              $  ;LRK
;              ,efixed : 0.0                 $  ;LRK
;              ,ecen : 0.0                   $  ;LRK
;              ,monofixed : 0                $  ;LRK
;              ,anafixed : 0                 $  ;LRK
;              ,olattice:obj_new()           $  ;LRK
;              ,orescalculator:obj_new()     $  ;LRK
;              ,fitcontainer:obj_new()       $  ;LRK
;              ,leafinfo:ptr_new()           $  ;LRK
;              ;
;              ;
;              ;
;              ,plot_ptr:ptr_new()           $
;              ,mcf_ptr:ptr_new()            $
;              ,collim_ptr:ptr_new()         $
;              ,econfig_ptr:ptr_new()        $
;              ,qconfig_ptr:ptr_new()        $
;              ,mosaic_ptr:ptr_new()         $
;              ,instrument_ptr:ptr_new()     $
;              ,motors_ptr:ptr_new()         $
;              ,lattice_ptr:ptr_new()        $
;              ,xtal_orientation_ptr:ptr_new()  $
;              ,second_var_name:''           $
;              ,treatment_ptr:ptr_new()      $
;              ,orientation_ptr:ptr_new() $
;              ,fixedEType:'' $
;              ,fixedEValue:0.0 $
;              ,dSpaceM:0.0 $
;              ,dSpaceA:0.0 $
;              ,isICE:0B $       ; is data from an ICE formated file? 0=>no, 1=>yes
;              ,anaPkgPtr:ptr_new() $ ; info about BT7 analyzer package
;              ,sdesc:'' $
;              ,filename:'' $


;function dtas_data::clone
ret = self->get_private(   econfig_ptr = econfig_ptr,                $
                           qconfig_ptr = qconfig_ptr,                $
                           collim_ptr = collim_ptr,                  $
                           mosaic_ptr = mosaic_ptr,                  $
                           header_ptr = header_ptr,                  $
                           motors_ptr = motors_ptr,                  $
                           data_file_contents = data_file_contents,  $
                           data_ptr = data_ptr,                      $
                           add = add,                                $
                           scan = scan,                              $
                           prf = prf,                                $
                           tot_mon = tot_mon,                        $
                           base = base,                              $
                           num_pts = num_pts,                        $
                           type = type,                              $
                           date = date,                              $
                           time = time,                              $
                           extension = extension,                    $
                           comments = comments,                      $
                           fit_ptr = fit_ptr,                        $
                           mon = mon,                                $
                           shift_value = shift_value,                $
                           plot_ptr = plot_ptr,                      $
                           mcf_ptr = mcf_ptr,                        $
                           instrument_ptr = instrument_ptr,          $
                           lattice_ptr = lattice_ptr,                $
                           xtal_orientation_ptr = xtal_orientation_ptr, $
                           treatment = treatment,                    $
                           display_name = display_name,              $
                           signal_type = signal_type,                $
                           descriptr = descriptr,                    $
                           hfield = hfield,                          $
                           second_var_name = second_var_name,        $
                           orientation_ptr=orientation_ptr $
                           ,fixedEType=fixedEType $
                           ,fixedEValue=fixedEValue $
                           ,dSpaceM=dSpaceM $
                           ,dSpaceA=dSpaceA $
                           ,isICE=isICE $ ; is data from an ICE formated file? 0=>no, 1=>yes
                           ,anaPkgStr=anaPkgStr $
                           ,sdesc=sdesc, $
                           filename = filename)
if n_elements(data_ptr) ne 0 then begin
   if n_elements(*data_ptr) ne 0 then data = *data_ptr
endif
if n_elements(econfig_ptr) ne 0 then begin
   if n_elements(*econfig_ptr) ne 0 then econfig = *econfig_ptr
endif
if n_elements(qconfig_ptr) ne 0 then begin
   if n_elements(*qconfig_ptr) ne 0 then qconfig = *qconfig_ptr
endif
if n_elements(collim_ptr) ne 0 then begin
   if n_elements(*collim_ptr) ne 0 then collim = *collim_ptr
endif
if n_elements(mosaic_ptr) ne 0 then begin
   if n_elements(*mosaic_ptr) ne 0 then mosaic = *mosaic_ptr
endif
if n_elements(motors_ptr) ne 0 then begin
   if n_elements(*motors_ptr) ne 0 then motors = *motors_ptr
endif
if n_elements(data_file_contents) ne 0 then begin
   if n_elements(*data_file_contents) ne 0 then data_file_contents = *data_file_contents
endif

oclone = obj_new('crs_dtas_data_new',/blank)
ret = oclone->set_private(       econfig = econfig,                        $
                                 qconfig = qconfig,                        $
                                 collim = collim,                          $
                                 mosaic = mosaic,                          $
                                 header_ptr = header_ptr,                  $
                                 motors = motors,                          $
                                 _data = data,                              $
                                 data_file_contents = data_file_contents,  $
                                 add = add,                                $
                                 scan = scan,                              $
                                 prf = prf,                                $
                                 shift_value = shift_value,                $
                                 tot_mon = tot_mon,                        $
                                 base = base,                              $
                                 num_pts = num_pts,                        $
                                 type = type,                              $
                                 date = date,                              $
                                 time = time,                              $
                                 comments = comments,                      $
                                 fit_ptr = fit_ptr,                        $
                                 mon = mon,                                $
                                 plot_ptr = plot_ptr,                      $
                                 mcf_ptr = mcf_ptr,                        $
                                 instrument_ptr = instrument_ptr,          $
                                 lattice_ptr = lattice_ptr,                $
                                 xtal_orientation_ptr = xtal_orientation_ptr, $
                                 treatment = treatment,                    $
                                 extension = extension,                    $
                                 display_name = display_name,              $
                                 signal_type = signal_type,                $
                                 descriptr = descriptr,                    $
                                 hfield = hfield,                          $
                                 second_var_name = second_var_name,        $
                                 orientation_ptr=orientation_ptr $
                                 ,fixedEType=fixedEType $
                                 ,fixedEValue=fixedEValue $
                                 ,dSpaceM=dSpaceM $
                                 ,dSpaceA=dSpaceA $
                                 ,isICE=isICE $ ; is data from an ICE formated file? 0=>no, 1=>yes
                                 ,anaPkgStr=anaPkgStr $
                                 ,sdesc=sdesc, $
                                 filename = filename)


;___________________________________________________
;NOW SET THE VALUES SPECIFIC TO crs_dtas_data_new
;___________________________________________________
duh = self->getResvals(resvals)
oclone->setResvals,resVals
duh = self->getLatvals(latvals)
oclone->setLatvals,latVals
duh = self->get_property(filename = filename,             $
                              contents = contents,             $
                              display_name = display_name,     $
                              treatment = treatment,           $
                              var_names = var_names,           $
                              plot_str = plot_str,             $
                              total_mon = total_mon,           $
                              signal_type = signal_type,       $
                              extension = extension,           $
                              descriptr_str = descriptr_str,   $
                              fit_ptr = fit_ptr,               $
                              time = time,                     $
                              hfield = hfield,                 $
                              shift_value = shift_value,       $
                              second_var_name = second_var_name,  $
                              header = header,                 $
                              data = data,                     $
                              scan = scan,$
                              anaPkgStr = anaPkgStr, $
                              anaMode =  anaMode,$
                                hkl=hkl,$
                                ecen = ecen,$
                                efixed = efixed,$                   ;LRK
                                monofixed = monofixed,$                  ;LRK
                                anafixed = anafixed,$                   ;LRK
                                abc = abc,$                ;LRK   
                                abg = abg,$                ;LRK
                                collimation = collimation,$        ;LRK
                                mosaic = mosaic,$             ;LRK
                                orientation1 = orientation1,$       ;LRK
                                orientation2 = orientation2,$       ;LRK
                                monodspacing = monodspacing,$             ;LRK
                                anadspacing = anadspacing,$     ;LRK
                                fitContainer=fitContainer,$     ;LRK
;FITCONTAINER IS MORE COMPLICATED!!!                                
                                ;
                                ;
                                ;
                                ;
                                leafinfo=leafinfo,$             ;LRK
                                fitInputPtr = fitInputPtr,$      ;LRK
                                xdata=xdata,ydata=ydata,dydata=dydata,$
                                xfit=xfit,yfit=yfit,$
                                xtitle=xtitle,ytitle=ytitle,title=title)  ;LRK




duh = oclone->set_property(   $
                            efixed = efixed,$                   ;LRK
                            monofixed = monofixed,$                  ;LRK
                            anafixed = anafixed,$                   ;LRK
                            abc = abc,$                ;LRK   
                            abg = abg,$                ;LRK
                            collimation = collimation,$        ;LRK
                            hcollimation = collimationh,$        ;LRK
                            vcollimation = collimationv,$        ;LRK
;                            collimationh = collimationh,$        ;LRK
;                            collimationv = collimationv,$        ;LRK
                            mosaic = mosaic,$             ;LRK
                            orientation1 = orientation1,$       ;LRK
                            orientation2 = orientation2,$       ;LRK
                            monodspacing = monodspacing,$             ;LRK
                            anadspacing = anadspacing, $     ;LRK
                            leafinfo=*leafinfo, $             ;LRK
                            fitinput=*fitinputPtr,$
                            xdata=*xdata,ydata=*ydata,dydata=*dydata,$
                            xfit=*xfit,yfit=*yfit,$
                            xtitle=xtitle,ytitle=ytitle,title=title)              ;LRK

;SET UP FIT CONTAINER
funcnames = fitcontainer->getnames()
;print,'funcnames=',funcnames

duh = oclone->get_property(fitcontainer=cfc)

oall = fitcontainer->get(/all)

for i=0,n_elements(oall)-1 do begin
  

     ; Now extract the curve information
     oall[i]->getproperty,name = name, $
                          xvalues = xvalues, $
                          step = step, $
                          parms = parms, $
                          fixed = fixed, $
                          fixvalues = fixvalues, $
                          low = low, $
                          lovalues = lovalues, $
                          high = high, $
                          hivalues = hivalues, $
                          tied = tied, $
                          parmError = parmError, $
                          expr = expr

     curveCopy = obj_new('FUNC',name = name, $
                          xvalues = xvalues,$
                          step = step, $
                          parms = parms, $
                          fixed = fixed, $
                          fixvalues = fixvalues, $
                          low = low, $
                          lovalues = lovalues, $
                          high = high, $
                          tied = tied, $
                          hivalues = hivalues, $
                          expr = expr)

    curveCopy->setproperty,parmError = parmError,/calculate
    cfc->add,curveCopy  
  
endfor;i
;cfc->setproperty,xvalues=*xdata
cfc->setxvalues,*xdata  
;self->getPANparmInfo,parminfo
;oclone->setPANParmInfo,parminfo;,/refit

;duh = self->getParmnames(parmnames)
;duh = self->getParms(parms)
;duh = self->getChiSq(ChiSq)
;self->getPANparmInfo,parminfoout
;oclone->setPANparmInfo,parminfoout,/refit
;self->defaultFit

return,oclone
;end
end;crs_dtas_data_new::crsClone

;function crs_dtas_data_new::sum,obj
;
;;  help,obj
;
;  newobj = self->crsclone()
;  duh = self->get_Property(num_points=n1,xdata=px1,ydata=py1,dydata=pdy1)
;  duh = obj->get_Property(num_points=n2,xdata=px2,ydata=py2,dydata=pdy2)
;
;  x1 = *px1
;  y1 = *py1
;  dy1 = *pdy1
;
;  x2 = *px2
;  y2 = *py2
;  dy2 = *pdy2
;  
;  help,x1,y1,dy1,n1
;  help,x2,y2,dy2,n2
;
;  ;ALL OF THE DATA MEMBERS WILL BE PROVIDED BY OBJECT 1 EXCEPT THE SHUFFLED/AVERAGED DATA.
;  
;  newobj->fitOneGroup
;  
;  
;  obj_destroy,newobj
;
;
;
;  help,self,obj
;  return,self
;end;crs_dtas_data_new::sum


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function crs_dtas_data_new::init,  filename = filename,       $
                                   signal_type = signal_type, $
                                   read = read,$
                                   blank=blank,$
                                   _Extra=extra
                                   
                                   
  if n_elements(blank) eq 0 then blank = 0 ;FLAG TO CREATE A BLANK OBJECT FOR SUMMING.
                                   
  self.olattice = obj_new('crs_lattice',1.,1.,1.,90.,90.,90.,[1.,0,0],[0.,1,0])  ;SHOULD RENAME THIS CLASS AT SOME POINT.
  self.orescalculator = obj_new('crs_rescalculator',self.olattice)  ;NOTE: AS IT IS rescal2_calculator REQUIRES A VALID LATTICE OBJECT 
  self.hkl = fltarr(3)                ;LRK
  self.abc = fltarr(3)                ;LRK   
  self.abg = fltarr(3)                ;LRK 
  self.collimation = fltarr(4)        ;LRK
  self.collimationh = fltarr(4)        ;LRK
  self.collimationv = fltarr(4)        ;LRK
  self.mosaic = fltarr(3)             ;LRK
  self.orientation1 = fltarr(3)       ;LRK
  self.orientation2 = fltarr(3)       ;LRK
  self.monodspacing = 0.0             ;LRK
  self.anadspacing = 0.0              ;LRK
  self.efixed = 0.0                   ;LRK
  self.ecen = 0.0                   ;LRK
  self.monofixed = 0                  ;LRK
  self.anafixed = 0                   ;LRK
  self.fitcontainer = obj_new('func_cont')  ;USE THE PAN FIT FUNCTION HERE  ---- NOTE:  THIS IS A BETTER WAY TO DO THINGS: ASSOCIATE ONE
                                            ;                                           FIT CONTAINER WITH EACH DATA GROUP
  ret = self->idlitdatacontainer::init(_Extra=extra)

  if blank eq 0 then begin
    ret = self->dtas_data::init(filename = filename,$
                                signal_type = signal_type,$
                                read = read,_Extra=extra)
  endif else begin
    ret = self->dtas_data::init(_Extra=extra)

  endelse

  ;GET THE x,y,dy VALUES BEFORE FITTING AND USE THEM.
  ret = self->get_private(plot_Ptr=plot_Ptr)
  
  ret = self->get_property(data=data)
  
;  print,'self.ytitle=',self.ytitle
  if n_elements(data) ne 0 then begin
    whmon = where(strupcase(tag_names(data)) eq 'MON',whmoncount)
    if whmoncount ne 0 then self.mondata = ptr_new(*data.mon)   
  endif

  if ptr_valid(plot_ptr) and n_elements(plot_ptr) ne 0 then begin
      
      x = *(*plot_ptr).x
      if ptr_valid(self.xdata) ne 0 then ptr_free,self.xdata
      self.xdata = ptr_new(x)
      y = *(*plot_ptr).y
      if ptr_valid(self.ydata) ne 0 then ptr_free,self.ydata
      self.ydata = ptr_new(y)
      dy = *(*plot_ptr).dy
      if ptr_valid(self.dydata) ne 0 then ptr_free,self.dydata
      self.dydata = ptr_new(dy)
      self.xtitle = (*plot_ptr).xtitle
      self.ytitle = (*plot_ptr).ytitle
      self.title = (*plot_ptr).title
      ;self.anamode = (*plot_ptr).anamode ;WHAT IS THE DEAL WITH anamode?????? This is -1 in self and 0 in plot_ptr.
  endif;ptr_valid
  self->defaultFit

help,*self.data_ptr

return,1
end;init
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro crs_dtas_data_new__define
  class =  {  crs_dtas_data_new,$
               inherits dtas_data,$
               inherits idlitdatacontainer,$
               fitinputptr:ptr_new(),        $  ;LRK
               xdata:ptr_new(),              $  ;LRK - TO FACILITATE CLONING AND ADDING FILES.
               ydata:ptr_new(),              $  ;LRK - TO FACILITATE ADDING FILES.
               dydata:ptr_new(),             $  ;LRK - TO FACILITATE ADDING FILES.
               mondata:ptr_new(),            $  ;TO FURTHER FACILITATE ADDING FILES.
               xtitle:'',                    $  ; 
               ;ytitle:'',                    $  ; THIS GROUP OF VARIABLES WILL ALL COME FROM THE PLOT_PTR
               title:'',                     $  ;LRK - THIS WILL BE EDITED TO BE THE SUMMED TITLE AS NECESSARY
               ;
               relmon:0.0d,                  $  ;---- REALTIVE MONITOR FOR SCALING IS A FLOAT VALUE
               thetaCorrection:0.0d,         $
               twothetaCorrection:0.0d,      $
               xfit:ptr_new(),               $  ;LRK - TO FACILITATE ADDING FILES.
               yfit:ptr_new(),               $  ;LRK - TO FACILITATE ADDING FILES.
               hkl:fltarr(3),                $  ;LRK
               abc:fltarr(3),                $  ;LRK   
               abg:fltarr(3),                $  ;LRK 
               collimation:fltarr(4),        $  ;LRK
               collimationh:fltarr(4),       $  ;LRK
               collimationv:fltarr(4),       $  ;LRK
               mosaic:fltarr(4),             $  ;LRK
               orientation1:fltarr(3),       $  ;LRK
               orientation2:fltarr(3),       $  ;LRK
               monodspacing:0.0,             $  ;LRK
               anadspacing:0.0,              $  ;LRK
               dspacing:[0.0,0.0],           $  ;LRK
               efixed : 0.0,                 $  ;LRK
               ecen : 0.0,                   $  ;LRK
               monofixed : 0,                $  ;LRK
               anafixed : 0,                 $  ;LRK
               olattice:obj_new(),           $  ;LRK
               orescalculator:obj_new(),     $  ;LRK
               fitcontainer:obj_new(),       $  ;LRK
               leafinfo:ptr_new()           $  ;LRK
           }
  
end;crs_dtas_data_new__define
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro crs_dtas_data_new_test, Q = Q, I = I, B = B, A = A
; Simple test program for the
dir = 'c:\dimeo\data\TAS_DATA\'
if n_elements(A) eq 0 then A = 0
if n_elements(Q) eq 0 then Q = 0
if n_elements(I) eq 0 then I = 0
if n_elements(B) eq 0 then B = 0
if Q+I+B eq 0 then Q = 1
Q_file = 'GCSNI047.BT2'
if Q ne 0 then filename = dir+Q_file;'PZN2J042.BT2';      A Q buffer
if I ne 0 then filename = dir+'MNCO1001.BT9';     An I buffer
if B ne 0 then filename = dir+'UCDMN025.BT2';     A B buffer
if A ne 0 then filename = dir+'alignment_curve_1.txt';'mn123036.add'
o = obj_new('crs_dtas_data_new',filename = filename)
;ret = o->read_file()
; If appropriate, correct the data for the resolution volume
;ret = o->fast_background_subtraction(2.0)
;ret = o->resolution_correction()
;ret = o->detailed_balance()
;ret = o->monitor_correction_factor()
;ret = o->get_property(treatment = treatment,var_names = var_names)
ret = o->get_private(type = type,scan = scan)
;print,'Type: ',type
;print,'Scan: ',scan
ret = o->display(psym = 4)
;obj_destroy,o
;window,0
;ret = o->auto_gauss_fit(psym = 4)

;print,'Valid o: ',obj_valid(o)
oclone = o->clone()
;ret = oclone->set_property(xvar_name = 'A3')
;window,1
;;ret = oclone->auto_gauss_fit(psym = 6)
;ret = oclone->display(psym = 6)
;ret = oclone->get_property(contents = contents,treatment = treatment)
obj_destroy,[o,oclone]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro crs_dtas_data_new_ice_test
dir = 'C:\bhd\dave_development\dave\programs\testing\ICE\'
file = dir + 'e-sca1348.bt0'
file = dir + 'i-sca1353.bt0'  ;  problem file
file = dir + 'q-sca1346.bt0'

o = obj_new('dtas_data',filename = file)

obj_destroy,o
end
