; $Id$

;ATTEMPTING TO CALCULATE A RESOLUTION LIMITED PEAK.

function testSharpScan_event,event

    widget_control,event.handler,get_uvalue=pstate

    case event.id of
    (*pstate).go:begin
        widget_control,(*pstate).xfield,get_value=x
        widget_control,(*pstate).yfield,get_value=y
        widget_control,(*pstate).Efield,get_value=En

        ;LOCATION OF FEATURE
        ;En = 0.0
        Q = [x,y,En,0.0]



        ;INSTRUMENT DEF
        horfoc = 0
        horcol = [60,60,60,60]
        ;horcol = 2*horcol
        vercol = [120,120,120,120]
        mosaic = [10,10,30,30]
        monana = [3.354,3.354]
        instr = [1,1]

        ;CRYSTAL DEF
        abc = [2*!PI,2*!PI,2*!PI]
        abg = [90.0,90.0,90.0]

        npts = 201
        ;SCANDEF

        CEN   = 1.0
        STEP  = 0.05
        ;RANGE = npts*step


        START = CEN - npts*step/2.
        ;STOP  = START + (npts-1)*step
        Qx = CEN + STEP*(-0.5 + dindgen(npts)/(npts-1));START+STEP*dindgen(npts)/(npts-1.)
        Qy = Qx;0.0*Qx
        Etran  = 0.0*Qx
        Qz = 0.0*Qx
        Efix = 0.0*Etran+14.7
        feief = 0
        source = 0
        o1 = [0.,1,0]
        o2 = [1.,1,0]

        data  = 0.0*Qx
        xdata = 0.0*Qx

        fmt = '(g8.3)'

        color = [0L,(2L)^8-1,((2L)^8-1)*(2L)^8,((2L)^8-1)*(2L)^16]
        legend = ['','Wide','Narrow']
        legend = legend + '['+strtrim(string(CEN,format=fmt),2)+ $
                          ','+strtrim(string(CEN,format=fmt),2)+ $
                          ','+strtrim(string(Efix,format=fmt),2)+ $
                          ','+strtrim(string(0.,format=fmt),2)+']'
    ;window,0
    ;plot,[-0.01,0.01],[0,200000],/nodata

    (*pstate).drawobj->cleardata
    for j=1,2 do begin

;        horcol[1:2] = horcol[1:2]/j
;        vercol[2:3] = vercol[2:3]/j
;        mosaic[2:3] = mosaic[2:3]/j
        horcol = horcol/j
        vercol = vercol/j
        mosaic = mosaic/j
        ;print,horcol
        ;print,'horcol=',horcol
        for i=0,n_elements(Qx)-1 do begin
;print,'############################
            Qpoint = [Qx[i],Qy[i],Qz[i],Etran[i],Efix[i]]
;print,[qpoint[0:1],qpoint[3],qpoint[2]]-q
            l = obj_new('lattice',abc[0],abc[1],abc[2],abg[0],abg[1],abg[2])
            report = 0
            ;if i eq 51 then report = 1 else report = 0

            c = obj_new('rescal2_calculator',l,horfoc,horcol,vercol,mosaic,monana,instr,Qpoint,feief,source,$
                                             report=report)


            c->calculate,rm,r0,closed=closed


;TOMORROW!!!
;PROBLEM IS THAT THE NUMBERS ARE SO BIG THAT THE NEGATIVE EXPONENT PRODUCES ZERO!
;
;ALSO, WHY IS THE 2x2 BLOCK IN THE Y/E SECTION AND NOT THE Q/Y SECTION???????

;print,Qpoint
            rmscat = l->rtransform(o1,o2,Qpoint,rm)
;print,Qpoint

;if i eq 51 then begin
;            print,r0
;            print,'rmscat='
;            print,rmscat
;            ;if j eq 1 then print,rm else print,(1924.5402/481.13504)*rm
;endif;i
;            print,'rmscat='
;            print,rmscat
;            print,'r0=',r0
;            print,'product=',transpose(Q)#(rmscat#Q)
;            print,'result=',r0*exp(-0.5*transpose(Q)#(rmscat#Q))
            ;print,r0*exp(-0.5*transpose(Q)#(rmscat#Q))
;print,Qpoint,Q
;print,r0*exp(-0.5*transpose(Q)#(rmscat#Q))
            QpointHere = [Qx[i],Qy[i],Efix[i],Qz[i]]
            data[i] = r0*exp(-0.5*transpose(Q-QpointHere[0:3])#(rmscat#(Q-QpointHere[0:3])))
            xdata[i] = Qpoint[0]
            obj_destroy,c
        endfor;i
        ;(*pstate).drawobj->setdata,xdata,data
        (*pstate).drawobj->add,x=xdata,y=data,color=color[j],legend=legend[j],/showlegend,/no_draw
        ;print,data
        ;oplot,xdata,data,color=color[j]
    endfor;j
    (*pstate).drawobj->defaultdraw



    end;go
    else:
    endcase
    return,-1
end;testSharpScan_event


pro testSharpScan_cleanup,id

    widget_control,id,get_uvalue=pstate
    if ptr_valid(pstate) then begin


        if obj_valid((*pstate).drawobj) then obj_destroy,(*pstate).drawobj

        ptr_free,pstate
    endif

end;testSharpScan_cleanup

pro testSharpScan

    tlb = widget_base(title='testSharpScan',/col)

    draw = cwo_drawplot(tlb,xsize=400,ysize=400,obj=drawobj)

    llb = widget_base(tlb,/row)
    Xfield = cw_field(llb,title='XYEZ',/floating,value=1.0,xsize=8)
    Yfield = cw_field(llb,/floating,value=0.0,title='',xsize=8)
    Efield = cw_field(llb,/floating,value=0.0,title='',xsize=8)
    Zfield = cw_field(llb,/floating,value=0.0,title='',xsize=8)
    go = widget_button(llb,value='GO!')
    llb = widget_base(tlb,/row)
    horcol0 = cw_field(llb,title='HORCOL',/integer,value=60,xsize=4)
    horcol1 = cw_field(llb,title='',/integer,value=60,xsize=4)
    horcol2 = cw_field(llb,title='',/integer,value=60,xsize=4)
    horcol3 = cw_field(llb,title='',/integer,value=60,xsize=4)
    llb = widget_base(tlb,/row)
    vercol0 = cw_field(llb,title='VERCOL',/integer,value=120,xsize=4)
    vercol1 = cw_field(llb,title='',/integer,value=120,xsize=4)
    vercol2 = cw_field(llb,title='',/integer,value=120,xsize=4)
    vercol3 = cw_field(llb,title='',/integer,value=120,xsize=4)
    llb = widget_base(tlb,/row)
    mosaicm = cw_field(llb,title='MOSAIC m',/integer,value=10,xsize=4)
    mosaicsh = cw_field(llb,title='sh',/integer,value=10,xsize=4)
    mosaicsv = cw_field(llb,title='sv',/integer,value=30,xsize=4)
    mosaica = cw_field(llb,title='a',/integer,value=30,xsize=4)
    llb = widget_base(tlb,/row)
    mosaicm = cw_field(llb,title='abc',/float,value=2*!PI,xsize=4)
    mosaicsh = cw_field(llb,title='',/float,value=2*!PI,xsize=4)
    mosaicsv = cw_field(llb,title='',/float,value=2*!PI,xsize=4)
    llb = widget_base(tlb,/row)
    mosaicm = cw_field(llb,title='abg',/float,value=90,xsize=4)
    mosaicsh = cw_field(llb,title='',/float,value=90,xsize=4)
    mosaicsv = cw_field(llb,title='',/float,value=90,xsize=4)
    llb = widget_base(tlb,/row)
    mosaicm = cw_field(llb,title='o1',/integer,value=1,xsize=4)
    mosaicsh = cw_field(llb,title='',/integer,value=0,xsize=4)
    mosaicsv = cw_field(llb,title='',/integer,value=0,xsize=4)
    llb = widget_base(tlb,/row)
    mosaicm = cw_field(llb,title='o2',/integer,value=0,xsize=4)
    mosaicsh = cw_field(llb,title='',/integer,value=1,xsize=4)
    mosaicsv = cw_field(llb,title='',/integer,value=0,xsize=4)


    state = {tlb:tlb,draw:draw,drawobj:drawobj,$
             xfield:xfield,yfield:yfield,$
             Efield:Efield,zfield:zfield,go:go}
    pstate = ptr_new(state)
    widget_control,tlb,/realize,set_uvalue=pstate
    xmanager,'testSharpScan',tlb,/no_block,cleanup='testSharpScan_cleanup'
    widget_control,tlb,event_func='testSharpScan_event'
end;testSharpScan