; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    spurion2_harmonics_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;   cwo_drawplot_data
;
;
;METHODS:
;    spurion2_harmonics_data::calculate
;    spurion2_harmonics_data::draw
;    spurion2_harmonics_data::xrange
;    spurion2_harmonics_data::yrange
;    spurion2_harmonics_data::getproperty
;    spurion2_harmonics_data::setproperty
;    spurion2_harmonics_data::cleanup
;    spurion2_harmonics_data::init
;    spurion2_harmonics_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu Jun 01 20:34:13 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_harmonics_data::calculate,rm,r0,Q,Q1,Q2,E,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy


end;calculate


;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_harmonics_data::draw,xscale=xscale,yscale=yscale,win,_ref_Extra=Extra;,rm,r0,Q,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy
        self->calculate,_Extra=extra;,rm,r0,Q,Q1,Q2,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy
;print,xscale,yscale
        if n_elements(xscale) eq 0 then xscale = 1.0
        if n_elements(yscale) eq 0 then yscale = 1.0


        wset,win

        device,get_decomposed=dc
        device,decomposed=1
;print,'self.showdata=',self.showdata
        if self.showdata ne 0 then begin

                thick = 2

                black = 0L
                red = 255L
                green = 256L*red
                blue = 256L*green
                white = red + green + blue
                soothing = 120L + 120L*256L + 215L*256L*256L

;print,'in harmonics draw, showharmonics=',self.showharmonics

;            if self.showharmonic ne 0 then begin
                ;x = *self.xharm
                ;y = *self.yharm

                harmcolor = *self.harmcolor
                for i=0,n_elements(self.showharmonics)-1 do begin
                    if self.showharmonics[i] eq 1 then begin
                        x = (*self.xharm)[*,i]*xscale
                        y = (*self.yharm)[*,i]*yscale
                        oplot,[x],[y],color=harmcolor[i],psym=2,symsize=1
                    endif
                endfor;i
;            endif

        endif;showdata

        device, decomposed = dc

end;spurion2_harmonics_data::draw

;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::xrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_harmonics_data::xrange

    x = *self.xharm

    return,[min(x),max(x)]

end;xrange
;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::yrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_harmonics_data::yrange

    y = *self.yharm

    return,[min(y),max(y)]

end;yrange

;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::getqxymax
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
function spurion2_harmonics_data::getqxymax

    x = *self.xharm
    y = *self.yharm

    return,max(sqrt(x^2 + y^2))

end;getqxymax
;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::getqymax
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
function spurion2_harmonics_data::getqymax

    y = *self.yharm

    return,max(abs(y))

end;getqxymax
;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::getqxmax
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
function spurion2_harmonics_data::getqxmax

    x = *self.xharm

    return,max(abs(x))

end;getqxymax
;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_harmonics_data::getproperty,$
                            showharmonics=showharmonics,$
                            pointnumber=pointnumber,$
                            xproj=xproj,$
                            yproj=yproj,$
                            xcut=xcut,$
                            ycut=ycut,$
                            xy=xy,$
                            xw=xw,$
                            yw=yw,$
                            rm=rm,$
                            r0=r0,$
                            Qx=Qx,$
                            Qy=Qy,$
                            kix=kix,$
                            kiy=kiy,$
                            kfx=kfx,$
                            kfy=kfy,$
                            E=E,$
;                            Q=Q,$
;                            orient1=orient1,$
;                            orient2=orient2,$
;                            astar=astar,$
;                            bstar=bstar,$
;                            cstar=cstar,$
;                            alphastar=alphastar,$
;                            betastar=betastar,$
;                            gammastar=gammastar,$
                            projcolor=projcolor,$
                            cutcolor=cutcolor,$
                            id=id,$
                            ;_extra=extra
                            _ref_extra=extra



                self->cwo_drawplot_data::getproperty,id=id,_extra=extra


                showharmonics = self.showharmonics

                if arg_present(pointnumber) gt 0 then pointnumber = self.pointnumber
                if arg_present(xproj) gt 0 then xproj = self.xproj
                if arg_present(yproj) gt 0 then yproj = self.yproj

                if arg_present(xcut) gt 0 then xcut = self.xcut
                if arg_present(ycut) gt 0 then ycut = self.ycut

                if arg_present(xy) gt 0 then xy = self.xy
                if arg_present(xw) gt 0 then xw = self.xw
                if arg_present(yw) gt 0 then yw = self.yw


                if arg_present(rm) gt 0 then rm = self.rm
                if arg_present(r0) gt 0 then r0 = self.r0
                if arg_present(Qx) gt 0 then Qx = self.Qx
                if arg_present(Qy) gt 0 then Qy = self.Qy
                if arg_present(kix) gt 0 then kix = self.kix
                if arg_present(kiy) gt 0 then kiy = self.kiy
                if arg_present(kfx) gt 0 then kfx = self.kfx
                if arg_present(kfy) gt 0 then kfy = self.kfy

;                if arg_present(Q) gt 0 then Q = self.Q
;                if arg_present(orient1) gt 0 then orient1 = self.orient1
;                if arg_present(orient2) gt 0 then orient2 = self.orient2
                if arg_present(E) gt 0 then E = self.E

;                if arg_present(astar) gt 0 then astar = self.astar
;                if arg_present(bstar) gt 0 then bstar = self.bstar
;                if arg_present(cstar) gt 0 then cstar = self.cstar
;
;                if arg_present(alphastar) gt 0 then alphstar = self.alphastar
;                if arg_present(betastar) gt 0 then betastar = self.betastar
;                if arg_present(gammastar) gt 0 then gammastar = self.gammastar

                if arg_present(showki) eq 1 then showki = self.showki
                if arg_present(showkf) eq 1 then showkf = self.showkf
                if arg_present(showQ) eq 1 then showQ = self.showQ
                if arg_present(showproj) eq 1 then showproj = self.showproj
                if arg_present(showcut) eq 1 then showcut = self.showcut
                if arg_present(showellipse) eq 1 then showellipse = self.showellipse
                if arg_present(showsymbol) eq 1 then showsymbol = self.showsymbol


                if arg_present(projcolor) gt 0 then projcolor = self.projcolor
                if arg_present(cutcolor) gt 0 then cutcolor = self.cutcolor

end;getproperty

;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::setcheckboxproperties
;
;PURPOSE:
;        SET PROPERTIES BASED ON CHECKBOX CONDITIONS IN ONE CALL.
;
;PARAMETERS:
;        vals   THE ARRAY OF CHECKBOX 1's AND 0's
;KEYWORDS:
;        none
;###############################################################################
pro spurion2_harmonics_data::setcheckboxproperties,vals

;['Q Vec','Ki','Kf','Cut','Proj','Ellipse',$
;'Symbol','Al Spheres','Recip. Lat.'],$
    self.showQ  = vals[0]
    self.showki = vals[1]
    self.showkf = vals[2]
    self.showcut = vals[3]
    self.showproj = vals[4]
    self.showellipse = vals[5]
    self.showsymbol = vals[6]

end;setcheckboxproperties


;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_harmonics_data::setproperty,$
                            pointnumber=pointnumber,$
                            showharmonics=showharmonics,$
                            showharmonic=showharmonic,$
                            xproj=xproj,$
                            yproj=yproj,$
                            xcut=xcut,$
                            ycut=ycut,$
                            xw=xw,$
                            yw=yw,$
                            xy=xy,$
                            rm=rm,$
                            r0=r0,$
                            Qx=Qx,$
                            Qy=Qy,$
                            kix=kix,$
                            kiy=kiy,$
                            kfx=kfx,$
                            kfy=kfy,$
                            E=E,$
;                            Q=Q,$
;                            orient1=orient1,$
;                            orient2=orient2,$
;                            astar=astar,$
;                            bstar=bstar,$
;                            cstar=cstar,$
;                            alphastar=alphastar,$
;                            betastar=betastar,$
;                            gammastar=gammastar,$
                            projcolor=projcolor,$
                            cutcolor=cutcolor,$
                            showdata=showdata,$
                            showki = showki,$
                            showkf = showkf,$
                            showQ = showQ,$
                            showproj = showproj,$
                            showcut = showcut,$
                            showellipse = showellipse,$
                            showsymbol = showsymbol,$
                            _ref_extra=extra

                self->cwo_drawplot_data::setproperty,_extra=extra

                if n_elements(showharmonic) gt 0 then self.showharmonic = showharmonic
                if n_elements(showharmonics) eq 16 then self.showharmonics = showharmonics

                if n_elements(pointnumber) gt 0 then self.pointnumber = pointnumber
                if n_elements(showdata) gt 0 then self.showdata = showdata
                if n_elements(xproj) gt 0 then self.xproj = xproj
                if n_elements(yproj) gt 0 then self.yproj = yproj

                if n_elements(xcut) gt 0 then self.xcut = xcut
                if n_elements(ycut) gt 0 then self.ycut = ycut

                if n_elements(xy) gt 0 then self.xy = xy
                if n_elements(xw) gt 0 then self.xw = xw
                if n_elements(yw) gt 0 then self.yw = yw


                if n_elements(rm) gt 0 then self.rm = rm
                if n_elements(r0) gt 0 then self.r0 = r0
                if n_elements(projcolor) gt 0 then self.projcolor = projcolor
                if n_elements(cutcolor) gt 0 then self.cutcolor = cutcolor

                if n_elements(Qx) eq 1 then self.Qx = Qx
                if n_elements(Qy) eq 1 then self.Qy = Qy
                if n_elements(kix) eq 1 then self.kix = kix
                if n_elements(kiy) eq 1 then self.kiy = kiy
                if n_elements(kfx) eq 1 then self.kfx = kfx
                if n_elements(kfy) eq 1 then self.kfy = kfy


                if n_elements(E) eq 1 then self.E = E

;                if n_elements(q)  ge 3 then self.Q  = q[0:2]
;                if n_elements(orient1) eq 3 then self.orient1 = orient1[0:2]
;                if n_elements(orient2) eq 3 then self.orient2 = orient2[0:2]
;
;                if n_elements(astar) eq 1 then self.astar = astar
;                if n_elements(bstar) eq 1 then self.bstar = bstar
;                if n_elements(cstar) eq 1 then self.cstar = cstar
;
;                if n_elements(alphastar) eq 1 then self.alphastar = alphastar
;                if n_elements( betastar) eq 1 then self.betastar  = betastar
;                if n_elements(gammastar) eq 1 then self.gammastar = gammastar

                if n_elements(showki) eq 1 then self.showki = showki
                if n_elements(showkf) eq 1 then self.showkf = showkf
                if n_elements(showQ) eq 1 then self.showQ = showQ
                if n_elements(showproj) eq 1 then self.showproj = showproj
                if n_elements(showcut) eq 1 then self.showcut = showcut
                if n_elements(showellipse) eq 1 then self.showellipse = showellipse
                if n_elements(showsymbol) eq 1 then self.showsymbol = showsymbol

                self->calculate;,rm,r0,xy=xy,xw=xw,yw=yw
end;setproperty


;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_harmonics_data::cleanup
    ;print,'spurion2_harmonics_data::cleanup'

    ptr_free,self.xproj
    ptr_free,self.yproj
    ptr_free,self.xcut
    ptr_free,self.ycut
    ptr_free,self.xharm
    ptr_free,self.yharm
    ptr_free,self.harmcolor
    self->cwo_drawplot_data::cleanup

end;spurion2_harmonics_data::cleanup
;###############################################################################
;
;NAME:
;        spurion2_harmonics_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_harmonics_data::init, $
                                    hvec,kvec,lvec,a,b,c,alpha,beta,gamma,o1,o2,$
                                    Evec,Efix,Eif,$
                                    x,y,sy,$
                                    showharmonics=showharmonics,$
                                    nharm=nharm,pointnumber=pointnumber,$
                                    legend=legend,showdata=showdata,$
                                    showlegend=showlegend,$
                                    Qx=Qx,$            ;Qx,Qy IN THE u,v COORDINATES, i.e. IN THE SCATTERING PLANE.
                                    Qy=Qy,$
                                    kix=kix,$
                                    kiy=kiy,$
                                    kfx=kfx,$
                                    kfy=kfy,$
                                    rm=rm,$
                                    r0=r0,$
                                    projcolor=projcolor,$
                                    xy=xy,$
                                    xw=xw,$
                                    yw=yw,$
                                    id=id,$
                                    showq=showq,$
                                    showki = showki,$
                                    showkf = showkf,$
                                    showproj = showproj,$
                                    showcut = showcut,$
                                    showellipse = showellipse,$
                                    showsymbol = showsymbol,$
                                    _ref_extra=extra


npts  = n_elements(hvec)
nharm = 4
harmcolor = lindgen(nharm^2)
x = dblarr(npts,nharm*nharm)
y = dblarr(npts,nharm*nharm)



        for i=0,npts-1 do begin
            ;GET Qxy, ki,kf
            if eif eq 0 then begin
                init = 1
                final = 0
                Ei = Efix
                Ef = Ei - Evec[i]
            endif else begin
                init = 0
                final = 1
                Ef = Efix
                Ei = Evec[i] + Ef
            endelse

            Qxy = hkl_to_Qxy(hvec[i],kvec[i],lvec[i],a,b,c,alpha,beta,gamma,o1,o2,zhat_hkl=zhat_hkl)

            if Qxy[2] ne 0 then print,'NOTE: harmonics init: Q not in scattering plane!';void = dialog_message('NOTE: Q not in scattering plane!')

            kikf = getkikf(Ei,Ef,Qxy)
            ki = kikf.ki
            kf = kikf.kf
            for n = 1,nharm do begin
                for m=1,nharm do begin
                    x[i,(n-1)+(m-1)*nharm] = n*ki[0] - m*kf[0]
                    y[i,(n-1)+(m-1)*nharm] = n*ki[1] - m*kf[1]
                endfor;m
            endfor;n
        endfor;i

self.xharm = ptr_new(x)
self.yharm = ptr_new(y)

if n_elements(showharmonics) ne 16 then showharmonics = intarr(16)+1
self.showharmonics = showharmonics


red = 255L
green = 256L*red
blue = 256L*green
black = 0L
yellow = red + green
purple = blue + green


harmcolors = [red,blue,green,black,yellow,100L,100L*256L,100L*256L*256L,100L*256L*256L,$
              red,blue,green,purple,100L,100L*256L,100L*256L*256L]

self.harmcolor = ptr_new(harmcolors)

;;GET Qxy, ki,kf
;    if eif eq 0 then begin
;        init = 1
;        final = 0
;        Ei = Efix
;        Ef = Ei - E
;    endif else begin
;        init = 0
;        final = 1
;        Ef = Efix
;        Ei = E + Ef
;    endelse
;
;    Qxy = hkl_to_Qxy(h,k,l,a,b,c,alpha,beta,gamma,o1,o2,zhat_hkl=zhat_hkl)
;
;    if Qxy[2] ne 0 then print,'NOTE: harmonics init: Q not in scattering plane!';void = dialog_message('NOTE: Q not in scattering plane!')
;    kikf = getkikf(Ei,Ef,Qxy)
;    ki = kikf.ki
;    kf = kikf.kf
;
;    self.Qx = Qxy[0]
;    self.Qy = Qxy[1]
;    self.kix = ki[0]
;    self.kiy = ki[1]
;    self.kfx = kf[0]
;    self.kfy = kf[1]
;
;    if n_elements(pointnumber) eq 0 then pointnumber = 0
;    self.pointnumber = pointnumber
;
;    if n_elements(nharm) eq 0 then nharm = 4
;    nharm = 4
;
;    if n_elements(showharmonics) ne 16 then showharmonics = intarr(16)+1
;    self.showharmonics = showharmonics
;
;
;    red = 255L
;    green = 256L*red
;    blue = 256L*green
;    black = 0L
;    yellow = red + green
;    purple = blue + green
;
;
;    hcolors = [red,blue,green,black,yellow,100L,100L*256L,100L*256L*256L,100L*256L*256L,$
;             red,blue,green,purple,100L,100L*256L,100L*256L*256L]
;
;    self.harmcolors = ptr_new(hcolors)
;
;
;    ;COMPUTE HARMONIC COMPONENTS AND ASSOCIATED COLORS
;    harmcolor = lindgen(nharm^2)
;    x = dindgen(nharm^2)
;    y = dindgen(nharm^2)
;    for i=0,nharm-1 do begin
;        for j=0,nharm-1 do begin
;            x[j+i*nharm] = (i+1)*self.kix - (j+1)*self.kfx
;            y[j+i*nharm] = (i+1)*self.kiy - (j+1)*self.kfy
;;            harmcolor[j+i*nharm] = long(255L + (double(i)/(nharm-1))*255L*256L + $
;;                                               (double(i)/(nharm-1))*255L*256L*256L)
;            harmcolor[j+i*nharm] = long( $;255L + $;(double(i)/(nharm-1))*255L*256L + $
;                                               (double(i)/(nharm-1))*255L*256L*256L)
;
;        endfor;j
;    endfor;i
;
;    self.harmcolor = ptr_new(hcolors);harmcolor)
    self.showharmonic = 1

    ret = self->cwo_drawplot_data::init([0],[0],[0],legend=legend,showdata=showdata,id=id,$
                                            showlegend=showlegend,_extra=extra)

    if ret eq 1 then begin

;        if n_elements(showki) eq 1 then self.showki = showki else  self.showki = 1
;        if n_elements(showkf) eq 1 then self.showkf = showkf else  self.showkf = 1
;        if n_elements(showQ) eq 1 then self.showQ = showQ else  self.showQ = 1
;        if n_elements(showproj) eq 1 then self.showproj = showproj else  self.showproj = 1
;        if n_elements(showcut) eq 1 then self.showcut = showcut else  self.showcut = 1
;        if n_elements(showellipse) eq 1 then self.showellipse = showellipse else self.showellipse = 1
;        if n_elements(showsymbol) eq 1 then self.showsymbol = showsymbol else self.showsymbol = 0

        self->calculate;,rm,r0,xy=xy,xw=xw,yw=yw

        return,1
    endif else begin
        return,ret
    endelse

end;init

;###############################################################################
;
;NAME:
;        spurion2_harmonics_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_harmonics_data__define,class

    class = {   spurion2_harmonics_data,$
                inherits cwo_drawplot_data,$
                harmcolor:ptr_new(),$
                xharm:ptr_new(),$
                yharm:ptr_new(),$
                showharmonic:0,$
                showharmonics:intarr(16),$
                pointnumber:0,$
                xproj:ptr_new(),$
                yproj:ptr_new(),$
                xcut:ptr_new(),$
                ycut:ptr_new(),$
                ;
                ;THE NEXT 5 VALUES SHOULD BE SIMPLY PASSED INTO THE OBJECT
                ;AND CALCULATED IN THE ScanPoint OBJECT
                rm:dblarr(4,4),$
                r0:0.0,$
                Qx:0.0,$            ;Qx,Qy IN THE u,v COORDINATES, i.e. IN THE SCATTERING PLANE.
                Qy:0.0,$
                kix:0.0,$
                kiy:0.0,$
                kfx:0.0,$
                kfy:0.0,$
                E:0.0,$
                ;THE NEXT 5 ITEMS STAY IN THIS CLASS
                projcolor:0L,$
                cutcolor:0L,$
                xy:0,$
                xw:0,$
                yw:0,$
                showki:0,$
                showkf:0,$
                showQ:0,$
                showproj:0,$
                showcut:0,$
                showellipse:0,$
                showsymbol:0}


;                ;THE NEXT 3 ITEMS SHOULD NOT BE USED IN THIS CLASS
;                Q: dblarr(3),$
;                orient1:dblarr(3),$
;                orient2:dblarr(3),$
;                ;THE NEXT 6 ITEMS SHOULD NOT BE USED IN THIS CLASS.
;                astar:0.0,$
;                bstar:0.0,$
;                cstar:0.0,$
;                alphastar:0.0,$
;                betastar:0.0,$
;                gammastar:0.0}
end;spurion2_harmonics_data__define
