; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
FUNCTION Ellipsoid::Init, POS=pos, RX=rx, RY=ry, RZ=rz, TRANSMATRIX=transmatrix, DENSITY=density,  $
                      _EXTRA=e

    IF (self->IDLgrModel::Init(_EXTRA=e) NE 1) THEN RETURN, 0

    self.pos = [0.0,0.0,0.0]
    self.rx = 1.0
    self.ry = 1.0
    self.rz = 1.0
    self.transmatrix=[[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]]
    self.density = 1.0
    ;print, 'hi', (transmatrix)
    IF (N_ELEMENTS(pos) EQ 3) THEN $
        self.pos = pos

    IF (N_ELEMENTS(rx) EQ 1) THEN $
        self.rx = rx

    IF (N_ELEMENTS(ry) EQ 1) THEN $
        self.ry = ry

    IF (N_ELEMENTS(rz) EQ 1) THEN $
        self.rz = rz

    IF (N_ELEMENTS(transmatrix) EQ 9) THEN begin
        self.transmatrix = transmatrix
    ;print, 'self transmatrix: ', self.transmatrix
    ;print, 'transmatrix = ', transmatrix
    endif

    IF (N_ELEMENTS(density) EQ 1) THEN $
        self.density = density


    ; Initialize the polygon object that will be used to represent
    ; the orb.
    self.oPoly = OBJ_NEW('IDLgrPolygon', SHADING=1, /REJECT, _EXTRA=e)

    self->Add,self.oPoly

    ; Build the polygon vertices and connectivity based on property settings.
    self->BuildPoly

    RETURN, 1
END

PRO Ellipsoid::Cleanup

    ; Cleanup the polygon object used to represent the orb.
    OBJ_DESTROY, self.oPoly

    ; Cleanup the superclass.
    self->IDLgrModel::Cleanup
END

PRO Ellipsoid::SetProperty, POS=pos, RX=rx, RY=ry, RZ=rz, TRANSMATRIX=transmatrix, DENSITY=density, _EXTRA=e

    ; Pass along extraneous keywords to the superclass and/or to the
    ; polygon used to represent the orb.
    self->IDLgrModel::SetProperty, _EXTRA=e
    self.oPoly->SetProperty, _EXTRA=e

    IF (N_ELEMENTS(pos) EQ 3) THEN $
        self.pos = pos

    IF (N_ELEMENTS(rx) EQ 1) THEN $
        self.rx = rx

    IF (N_ELEMENTS(ry) EQ 1) THEN $
        self.ry = ry

    IF (N_ELEMENTS(rz) EQ 1) THEN $
        self.rz = rz

    IF (N_ELEMENTS(transmatrix) EQ 9) THEN $
    begin
       ; print, 'self transmatrix: ', self.transmatrix
        ;print, 'transmatrix = ', transmatrix
        self.transmatrix = transmatrix
    endif
    IF (N_ELEMENTS(density) EQ 1) THEN $
        self.density = density



    ; Rebuild the polygon according to keyword settings.
    self->BuildPoly
END

PRO Ellipsoid::GetProperty, POS=pos, RX=rx, RY=ry, RZ=rz, TRANSMATRIX=transmatrix, DENSITY=density,$
                         POBJ=pobj, _REF_EXTRA=re

    self->IDLgrModel::GetProperty, _EXTRA=re
    self.oPoly->GetProperty, _EXTRA=re

    pos = self.pos
    rx = self.rx
    ry = self.ry
    rz = self.rz
    density = self.density
    transmatrix = self.transmatrix
    pobj = self.oPoly
END

PRO Ellipsoid::Print
    PRINT, self.pos
    PRINT, self.rx, self.ry, self.rz
    PRINT, self.transmatrix
    PRINT, self.density
END

PRO Ellipsoid::BuildPoly
    ; Build the orb.

    Volume = FLTARR(20, 20, 20)
    FOR X=0,19 DO FOR Y=0,19 DO FOR Z=0,19 DO $
        Volume(X, Y, Z) = SQRT(((X-10))^2 + ((Y-10))^2 + ((Z-10))^2)
    SHADE_VOLUME, Volume, 8.0, V1, P1

    V1 = (V1 - 10) / 8.0
    phi=atan(self.pos[1]/self.pos[0])
    transmatrix2=[[cos(phi),sin(phi),0.0],[-sin(phi), cos(phi),0.0],[0.0,0.0,1]]
    ; scale the sphere into an ellipsoid
     V1[0, *] = V1[0, *] * self.rx
     V1[1, *] = V1[1, *] * self.ry
     V1[2, *] = V1[2, *] * self.rz
     ;print, self.transmatrix
     ; transform from the normal coordinate space back to the space
     ; of the scattering plane
     v1=self.transmatrix#v1
     ; rotate the ellipsoid about the axis defined by the incident vector
     v1=transmatrix2#v1

     ;  Translate the ellipsoid
     V1[0, *] = V1[0, *] + self.pos[0]
     V1[1, *] = V1[1, *] + self.pos[1]
     V1[2, *] = V1[2, *] + self.pos[2]


    ;transmatrix=[[1.0,0.0,0.0],[0.0,cos(!dtor*30.0),sin(!dtor*30.0)], [0.0,-sin(!dtor*30.0), cos(!dtor*30.0)]]



    self.oPoly->SetProperty, DATA=V1, POLYGONS=P1

    ; print, V1, '***'
    ; print, P1

END

PRO ellipsoid__define
    struct = { ellipsoid, $
               INHERITS IDLgrModel, $
               pos: [0.0,0.0,0.0], $
               rx:1.0, ry:1.0, rz:1.0, $
               transmatrix: [[1.0,0.0,0.0],[0.0,1.0,0.0], [0.0,0.0,1.0]], $
               density: 1.0, $
               oPoly: OBJ_NEW() $
             }
END







