; $Id$
;###############################################################################
;
;CLASS NAME:
;    pro ooDisplayEchoTreeSet__define,class
;    end;ooDisplayEchoTreeSet__define
;
;PURPOSE:
;
;CATEGORY:
;
;SUPERCLASSES:
;                    inherits myproperties}
;
;METHODS:
;    ooDisplayEchoTreeSet::remove
;    ooDisplayEchoTreeSet::cleanup
;    ooDisplayEchoTreeSet_cleanup
;    ooDisplayEchoTreeSet::init
;    ooDisplayEchoTreeSet__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
;   ooDisplayEchoTreeSet.pro
;
;   PURPOSE
;       DEFINE A 'SET' OBJECT FOR THE TREE WIDGET
;       IN ooDisplayEcho.  THIS WILL CONTAIN A SINGLE
;       GROUP OF DATA FOR A PARTICULAR Q-VALUE.
;
;       THE DATA OBJECTS WILL BE REFERRED TO BY THEIR
;       POSITIONS IN THE dataContainer TO PREVENT
;       CONFLICTS WITH THE PREVIOUS WAYS OF REFERRING
;       TO THE DATA OBJECTS.
;
;

pro ooDisplayEchoTreeSet::remove,objref
;
;NAME:
;        ooDisplayEchoTreeSet::remove
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

    ;REMOVE A SET FROM THE DATA OBJECT

    ;NEED TO SET THIS UP TO RECOGNIZE /res, /dat, /bkg




end;remove
pro ooDisplayEchoTreeSet::cleanup
;
;NAME:
;        ooDisplayEchoTreeSet::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;    obj_destroy,self.setContainer
end;cleanup
pro ooDisplayEchoTreeSet_cleanup
;
;NAME:
;        ooDisplayEchoTreeSet_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

end;ooDisplayEchoTreeSet_cleanup
function ooDisplayEchoTreeSet::init,q=q,name=name,index=index,$
                                    container=container
;
;NAME:
;        ooDisplayEchoTreeSet::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;

    ;INITIALIZE INDICES AND FILE NAMES
    self.resIndex = -1
    self.datIndex = -1
    self.bkgIndex = -1
    self.resFilename = ''
    self.datFilename = ''
    self.bkgFilename = ''


    ;DEFINE q
    if n_elements(q) gt 0 then begin
        self.q = q
    endif else begin
        self.q = 0.0
    endelse

    ;DEFINE name
    if n_elements(name) gt 0 then begin
        self.name = name
    endif else begin
        self.name = 'Set'
    endelse

;    ;DEFINE setContainer
;    self.setContainer = obj_new('IDL_Container')
;    if (n_elements(obj) gt 0) and (obj_valid(obj) gt 0) then begin
;        self.setContainer->add,obj
;    endif
    if n_elements(index) gt 0 then begin
        if ((n_elements(container) gt 0) and $
                    (obj_valid(container) gt 0)) then begin

            type = (container->get(position=$
                            index))->getproperty(tag='type')
            filename = (container->get(position=$
                            index))->getproperty(tag='filename')

            case type of
                0:begin
                    print,'SELECTED OBJECT IS UNTYPED.'
                end
                1:begin
                    self.resIndex = index
                    self.resFilename = filename
                end
                2:begin
                    self.datIndex = index
                    self.datFilename = filename
                end
                3:begin
                    self.bkgIndex = index
                    self.bkgFilename = filename
                end
                else:begin
                    print,'OBJECT TYPE IS INVALID.'
                end
            endcase
        endif else begin
            print,'PROBLEM WITH DATA CONTAINER.'
        endelse
    endif;index

    return,1
end;init


pro ooDisplayEchoTreeSet__define,class
;
;NAME:
;        ooDisplayEchoTreeSet__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

    class = {ooDisplayEchoTreeSet,$
                name:'Set',$
                q:0.0,$
                resIndex:-1,$       ;NEED LONGER NAME TO PREVENT
                datIndex:-1,$       ;CONFLICT IN myProperties
                bkgIndex:-1,$
                resFilename:'',$    ;FOR ADDED OBJECT ID PURPOSES.
                datFilename:'',$
                bkgFilename:'',$
                $;setContainer:obj_new(),$
                inherits myproperties}

end;ooDisplayEchoTreeSet__define



