; $Id$
;###############################################################################
;
;FILENAME:
;launch_nse.pro
;
;PURPOSE:
;           Launch NSE Data reduction from DAVE.
;CATEGORY:
;
;
;METHODS IN FILE:
;
;    launch_nse
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
;
pro launch_nse,event,DAVETool=DAVETool,group_leader=group_leader,workDir=workDir,dataDir=dataDir
;
;NAME:
;        launch_nse
;
;PURPOSE:
;           Launch NSE Data reduction from DAVE.
;PARAMETERS:
;           event   Event to launch the module.
;KEYWORDS:
;           None.

print,'launch_nse'

n_instances = checkforobjinstance('ooDisplayEcho',ref=ref)

if n_elements(event) eq 0 then begin
  onse = obj_new('ooDisplayEcho',$
                                group_leader = group_leader,$
                                work_dir = workDir, $
                                data_dir = dataDir,$
                                dave_id=group_leader,$
                                DAVETool=DAVETool)

endif else begin
          ; Launching program for the NSE data reduction module.
          this_event = tag_names(event,/structure_name)
          
          case this_event of
          'WIDGET_BUTTON': $
              begin
                  work_dir = (*!dave_defaults).workDir
                  data_dir = (*!dave_defaults).datDir
                  device,decomposed = 0
                  if n_instances eq 0 then begin
                      onse = obj_new('ooDisplayEcho',notify_ids = [event.id,event.top], $
                          group_leader = event.top,work_dir = work_dir,data_dir = data_dir,dave_id=event.top)
                  endif else begin
                      tlb = ref->getproperty(/atlb)
                      widget_control,tlb,/show
                  endelse
          
              end
          'WIDGET_TREE_SEL': $
              begin
                  device,decomposed = 0
                  work_dir = (*!dave_defaults).workDir
                  data_dir = (*!dave_defaults).datDir
                  if n_instances eq 0 then begin
                      onse = obj_new('ooDisplayEcho',notify_ids = [event.id,event.top], $
                          group_leader = event.top,work_dir = work_dir, data_dir = data_dir,dave_id=event.top)
                  endif else begin
                      tlb = ref->getproperty(/atlb)
                      widget_control,tlb,/show
                  endelse
              end
          'NSE_EVENT': $
              begin
                  widget_control,event.top,/show,/input_focus,iconify = 0
              end
          else:
          endcase
  endelse;event
end;launch_nse
