;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PAF_Quit,event
widget_control,event.top,get_uvalue = pState
wdelete,(*pState).winPixAare30
wdelete,(*pState).winPixAare60
wdelete,(*pState).winPixAare90
wdelete,(*pState).winPixAare120
wdelete,(*pState).winPixAare150
wdelete,(*pState).winPixBerg30
wdelete,(*pState).winPixBerg60
wdelete,(*pState).winPixBerg90
wdelete,(*pState).winPixBerg120
wdelete,(*pState).winPixBerg150
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PAF_Events,event

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Plot_AutoVanFits,lambda_array,Area_Array,PolyFitArray,area_calc_array, lambda, $
                 good_det,group_leader=group_leader

  tlb = widget_base(group_leader = group_leader, /col,/modal, $
        title = 'Data Generated from Automatic Vanadium Fits Procedure')


InelasticDetectors=strarr(10)
InelasticDetectors[0]='Aare30'
InelasticDetectors[1]='Aare60'
InelasticDetectors[2]='Aare90'
InelasticDetectors[3]='Aare120'
InelasticDetectors[4]='Aare150'
InelasticDetectors[5]='Berg30'
InelasticDetectors[6]='Berg60'
InelasticDetectors[7]='Berg90'
InelasticDetectors[8]='Berg120'
InelasticDetectors[9]='Berg150'



opt_tab=widget_tab(tlb)
BaseAare30 = widget_base(opt_tab,/col,title=InelasticDetectors[0])
BaseAare60 = widget_base(opt_tab,/col,title=InelasticDetectors[1])
BaseAare90 = widget_base(opt_tab,/col,title=InelasticDetectors[2])
BaseAare120 = widget_base(opt_tab,/col,title=InelasticDetectors[3])
BaseAare150 = widget_base(opt_tab,/col,title=InelasticDetectors[4])
BaseBerg30 = widget_base(opt_tab,/col,title=InelasticDetectors[5])
BaseBerg60 = widget_base(opt_tab,/col,title=InelasticDetectors[6])
BaseBerg90 = widget_base(opt_tab,/col,title=InelasticDetectors[7])
BaseBerg120 = widget_base(opt_tab,/col,title=InelasticDetectors[8])
BaseBerg150 = widget_base(opt_tab,/col,title=InelasticDetectors[9])

GoldenRatio=0.5*(1.0+sqrt(5.0))
xsize = 700 & ysize = xsize/GoldenRatio
plotBaseAare30 = widget_base(BaseAare30)
winAare30 = widget_draw(plotBaseAare30,xsize = xsize,ysize = ysize)

plotBaseAare60 = widget_base(BaseAare60)
winAare60 = widget_draw(plotBaseAare60,xsize = xsize,ysize = ysize)

plotBaseAare90 = widget_base(BaseAare90)
winAare90 = widget_draw(plotBaseAare90,xsize = xsize,ysize = ysize)

plotBaseAare120 = widget_base(BaseAare120)
winAare120 = widget_draw(plotBaseAare120,xsize = xsize,ysize = ysize)

plotBaseAare150 = widget_base(BaseAare150)
winAare150 = widget_draw(plotBaseAare150,xsize = xsize,ysize = ysize)

plotBaseBerg30 = widget_base(BaseBerg30)
winBerg30 = widget_draw(plotBaseBerg30,xsize = xsize,ysize = ysize)

plotBaseBerg60 = widget_base(BaseBerg60)
winBerg60 = widget_draw(plotBaseBerg60,xsize = xsize,ysize = ysize)

plotBaseBerg90 = widget_base(BaseBerg90)
winBerg90 = widget_draw(plotBaseBerg90,xsize = xsize,ysize = ysize)

plotBaseBerg120 = widget_base(BaseBerg120)
winBerg120 = widget_draw(plotBaseBerg120,xsize = xsize,ysize = ysize)

plotBaseBerg150 = widget_base(BaseBerg150)
winBerg150 = widget_draw(plotBaseBerg150,xsize = xsize,ysize = ysize)


geom = widget_info(BaseAare30,/geometry)
newysize = geom.ysize
widget_control,winAare30,draw_ysize = newysize
widget_control,winAare60,draw_ysize = newysize
widget_control,winAare90,draw_ysize = newysize
widget_control,winAare120,draw_ysize = newysize
widget_control,winAare150,draw_ysize = newysize
widget_control,winBerg30,draw_ysize = newysize
widget_control,winBerg60,draw_ysize = newysize
widget_control,winBerg90,draw_ysize = newysize
widget_control,winBerg120,draw_ysize = newysize
widget_control,winBerg150,draw_ysize = newysize


courier_hugefont = get_font_name(/huge, /courier)

void = widget_button(tlb,value = 'Close',event_pro = 'PAF_Quit',font=courier_hugefont)

widget_control,tlb,/realize

widget_control,winAare30,get_value = winVisAare30
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPixAare30 = !d.window
;
widget_control,winAare60,get_value = winVisAare60
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPixAare60 = !d.window
;
widget_control,winAare90,get_value = winVisAare90
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPixAare90 = !d.window
;
widget_control,winAare120,get_value = winVisAare120
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPixAare120 = !d.window
;
widget_control,winAare150,get_value = winVisAare150
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPixAare150 = !d.window
;
widget_control,winBerg30,get_value = winVisBerg30
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPixBerg30 = !d.window
;
widget_control,winBerg60,get_value = winVisBerg60
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPixBerg60 = !d.window
;
widget_control,winBerg90,get_value = winVisBerg90
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPixBerg90 = !d.window
;
widget_control,winBerg120,get_value = winVisBerg120
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPixBerg120 = !d.window
;
widget_control,winBerg150,get_value = winVisBerg150
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPixBerg150 = !d.window
;
x=lambda_array
;((x[1]-x[0])/2.0)
xwidth=max(x)-min(x)
xrange=[min(x)-0.1*xwidth,max(x)+0.1*xwidth]
y=reform(Area_Array[0,*])
ywidth=max(y)-min(y)
yrange=[min(y)-0.1*ywidth,max(y)+0.1*ywidth]
xtitle='Lambda / A'
ytitle='Intensity'
title='Data and Fits for Detector Aare30'
wset,winPixAare30
plot,x,y,psym = 4, xstyle = 1,ystyle = 1,xtitle = xtitle, ytitle = ytitle, title = title, $
    xrange=xrange,yrange=yrange,color=6,symsize=2
y=reform(PolyFitArray[0,*])
oplot,x,y,psym=0,color=3
xp=make_array(1,value=lambda)
yp=make_array(1,value=area_calc_array[0])
oplot,xp,yp,psym=5,color=10,symsize=2
xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.1
ypos=ylims[0]+(ylims[1]-ylims[0])*0.9
xyouts,xpos,ypos,"Data",color=6
ypos=ylims[0]+(ylims[1]-ylims[0])*0.85
xyouts,xpos,ypos,"Fit",color=3
ypos=ylims[0]+(ylims[1]-ylims[0])*0.8
xyouts,xpos,ypos,"Calculated Point",color=10
wheregood=where(good_det eq 0)
if wheregood eq -1 then begin
ypos=ylims[0]+(ylims[1]-ylims[0])*0.75
xyouts,xpos,ypos,"Dead Detector",color=12
endif
wset,winVisAare30
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPixAare30]
;
y=reform(Area_Array[1,*])
ywidth=max(y)-min(y)
yrange=[min(y)-0.1*ywidth,max(y)+0.1*ywidth]
title='Data and Fits for Detector Aare60'
wset,winPixAare60
plot,x,y,psym = 4, xstyle = 1,ystyle = 1,xtitle = xtitle, ytitle = ytitle, title = title, $
    xrange=xrange,yrange=yrange,color=6,symsize=2
y=reform(PolyFitArray[1,*])
oplot,x,y,psym=0,color=3
xp=make_array(1,value=lambda)
yp=make_array(1,value=area_calc_array[1])
oplot,xp,yp,psym=5,color=10,symsize=2
wheregood=where(good_det eq 1)
if wheregood eq -1 then begin
xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.1
ypos=ylims[0]+(ylims[1]-ylims[0])*0.75
xyouts,xpos,ypos,"Dead Detector",color=12
endif
wset,winVisAare60
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPixAare60]
;
y=reform(Area_Array[2,*])
ywidth=max(y)-min(y)
yrange=[min(y)-0.1*ywidth,max(y)+0.1*ywidth]
title='Data and Fits for Detector Aare90'
wset,winPixAare90
plot,x,y,psym = 4, xstyle = 1,ystyle = 1,xtitle = xtitle, ytitle = ytitle, title = title, $
    xrange=xrange,yrange=yrange,color=6,symsize=2
y=reform(PolyFitArray[2,*])
oplot,x,y,psym=0,color=3
xp=make_array(1,value=lambda)
yp=make_array(1,value=area_calc_array[2])
oplot,xp,yp,psym=5,color=10,symsize=2
wheregood=where(good_det eq 2)
if wheregood eq -1 then begin
xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.1
ypos=ylims[0]+(ylims[1]-ylims[0])*0.75
xyouts,xpos,ypos,"Dead Detector",color=12
endif
wset,winVisAare90
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPixAare90]
;
y=reform(Area_Array[3,*])
ywidth=max(y)-min(y)
yrange=[min(y)-0.1*ywidth,max(y)+0.1*ywidth]
title='Data and Fits for Detector Aare120'
wset,winPixAare120
plot,x,y,psym = 4, xstyle = 1,ystyle = 1,xtitle = xtitle, ytitle = ytitle, title = title, $
    xrange=xrange,yrange=yrange,color=6,symsize=2
y=reform(PolyFitArray[3,*])
oplot,x,y,psym=0,color=3
xp=make_array(1,value=lambda)
yp=make_array(1,value=area_calc_array[3])
oplot,xp,yp,psym=5,color=10,symsize=2
wheregood=where(good_det eq 3)
if wheregood eq -1 then begin
xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.1
ypos=ylims[0]+(ylims[1]-ylims[0])*0.75
xyouts,xpos,ypos,"Dead Detector",color=12
endif
wset,winVisAare120
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPixAare120]
;
y=reform(Area_Array[4,*])
ywidth=max(y)-min(y)
yrange=[min(y)-0.1*ywidth,max(y)+0.1*ywidth]
title='Data and Fits for Detector Aare150'
wset,winPixAare150
plot,x,y,psym = 4, xstyle = 1,ystyle = 1,xtitle = xtitle, ytitle = ytitle, title = title, $
    xrange=xrange,yrange=yrange,color=6,symsize=2
y=reform(PolyFitArray[4,*])
oplot,x,y,psym=0,color=3
xp=make_array(1,value=lambda)
yp=make_array(1,value=area_calc_array[4])
oplot,xp,yp,psym=5,color=10,symsize=2
wheregood=where(good_det eq 4)
if wheregood eq -1 then begin
xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.1
ypos=ylims[0]+(ylims[1]-ylims[0])*0.75
xyouts,xpos,ypos,"Dead Detector",color=12
endif
wset,winVisAare150
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPixAare150]
;
y=reform(Area_Array[5,*])
ywidth=max(y)-min(y)
yrange=[min(y)-0.1*ywidth,max(y)+0.1*ywidth]
title='Data and Fits for Detector Berg30'
wset,winPixBerg30
plot,x,y,psym = 4, xstyle = 1,ystyle = 1,xtitle = xtitle, ytitle = ytitle, title = title, $
    xrange=xrange,yrange=yrange,color=6,symsize=2
y=reform(PolyFitArray[5,*])
oplot,x,y,psym=0,color=3
xp=make_array(1,value=lambda)
yp=make_array(1,value=area_calc_array[5])
oplot,xp,yp,psym=5,color=10,symsize=2
wheregood=where(good_det eq 5)
if wheregood eq -1 then begin
xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.1
ypos=ylims[0]+(ylims[1]-ylims[0])*0.75
xyouts,xpos,ypos,"Dead Detector",color=12
endif
wset,winVisBerg30
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPixBerg30]
;
y=reform(Area_Array[6,*])
ywidth=max(y)-min(y)
yrange=[min(y)-0.1*ywidth,max(y)+0.1*ywidth]
title='Data and Fits for Detector Berg60'
wset,winPixBerg60
plot,x,y,psym = 4, xstyle = 1,ystyle = 1,xtitle = xtitle, ytitle = ytitle, title = title, $
    xrange=xrange,yrange=yrange,color=6,symsize=2
y=reform(PolyFitArray[6,*])
oplot,x,y,psym=0,color=3
xp=make_array(1,value=lambda)
yp=make_array(1,value=area_calc_array[6])
oplot,xp,yp,psym=5,color=10,symsize=2
wheregood=where(good_det eq 6)
if wheregood eq -1 then begin
xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.1
ypos=ylims[0]+(ylims[1]-ylims[0])*0.75
xyouts,xpos,ypos,"Dead Detector",color=12
endif
wset,winVisBerg60
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPixBerg60]
;
y=reform(Area_Array[7,*])
ywidth=max(y)-min(y)
yrange=[min(y)-0.1*ywidth,max(y)+0.1*ywidth]
title='Data and Fits for Detector Berg90'
wset,winPixBerg90
plot,x,y,psym = 4, xstyle = 1,ystyle = 1,xtitle = xtitle, ytitle = ytitle, title = title, $
    xrange=xrange,yrange=yrange,color=6,symsize=2
y=reform(PolyFitArray[7,*])
oplot,x,y,psym=0,color=3
xp=make_array(1,value=lambda)
yp=make_array(1,value=area_calc_array[7])
oplot,xp,yp,psym=5,color=10,symsize=2
wheregood=where(good_det eq 7)
if wheregood eq -1 then begin
xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.1
ypos=ylims[0]+(ylims[1]-ylims[0])*0.75
xyouts,xpos,ypos,"Dead Detector",color=12
endif
wset,winVisBerg90
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPixBerg90]
;
y=reform(Area_Array[8,*])
ywidth=max(y)-min(y)
yrange=[min(y)-0.1*ywidth,max(y)+0.1*ywidth]
title='Data and Fits for Detector Berg120'
wset,winPixBerg120
plot,x,y,psym = 4, xstyle = 1,ystyle = 1,xtitle = xtitle, ytitle = ytitle, title = title, $
    xrange=xrange,yrange=yrange,color=6,symsize=2
y=reform(PolyFitArray[8,*])
oplot,x,y,psym=0,color=3
xp=make_array(1,value=lambda)
yp=make_array(1,value=area_calc_array[8])
oplot,xp,yp,psym=5,color=10,symsize=2
wheregood=where(good_det eq 8)
if wheregood eq -1 then begin
xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.1
ypos=ylims[0]+(ylims[1]-ylims[0])*0.75
xyouts,xpos,ypos,"Dead Detector",color=12
endif
wset,winVisBerg120
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPixBerg120]
;
y=reform(Area_Array[9,*])
ywidth=max(y)-min(y)
yrange=[min(y)-0.1*ywidth,max(y)+0.1*ywidth]
title='Data and Fits for Detector Berg150'
wset,winPixBerg150
plot,x,y,psym = 4, xstyle = 1,ystyle = 1,xtitle = xtitle, ytitle = ytitle, title = title, $
    xrange=xrange,yrange=yrange,color=6,symsize=2
y=reform(PolyFitArray[9,*])
oplot,x,y,psym=0,color=3
xp=make_array(1,value=lambda)
yp=make_array(1,value=area_calc_array[9])
oplot,xp,yp,psym=5,color=10,symsize=2
wheregood=where(good_det eq 9)
if wheregood eq -1 then begin
xlims=!x.crange
ylims=!y.crange
xpos=xlims[0]+(xlims[1]-xlims[0])*0.1
ypos=ylims[0]+(ylims[1]-ylims[0])*0.75
xyouts,xpos,ypos,"Dead Detector",color=12
endif
wset,winVisBerg150
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPixBerg150]
;
state = {winPixAare30:winPixAare30, $
       winPixAare60:winPixAare60, $
       winPixAare90:winPixAare90, $
       winPixAare120:winPixAare120, $
       winPixAare150:winPixAare150, $
       winPixBerg30:winPixBerg30, $
       winPixBerg60:winPixBerg60, $
       winPixBerg90:winPixBerg90, $
       winPixBerg120:winPixBerg120, $
       winPixBerg150:winPixBerg150}

pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState

xmanager,'Plot_AutoVanFits',tlb,event_handler = 'PAF_Events'


end