; $Id$

pro MACS_plotsq,z,xi,yi,AXIS=axis,RATIO=ratio,zran=zran	$
	,xran=xran,yran=yran				$
	,title=title,xtitle=xtitle,ytitle=ytitle	$
	,logscal=logscal,white=white,_extra=_extra

if n_elements(white) ne 1 then white=!values.f_nan
n_x=n_elements(z(*,0))
n_y=n_elements(z(0,*))
syi	=	size(yi)
sxi	=	size(xi)
if sxi(0) eq 1 then begin
	x	=	z
	for i=0,n_y-1 do x(*,i)=xi
endif else x=xi
if syi(0) eq 1 then begin
	y	=	z
	for i=0,n_x-1 do y(i,*)=yi
endif else y=yi


; now make the 2d plot

if n_elements(xran) ne 2 then begin
	xmin=min(x) & xmax=max(x)
	dx	=	(xmax-xmin)/20.
	xran	=	[xmin-dx,xmax+dx]
endif  else begin
	dx	=	(xran(1)-xran(0))/20.
	xmin	=	xran(0)+dx
	xmax	=	xran(1)-dx
endelse

if n_elements(yran) ne 2 then begin
	ymin=min(y) & ymax=max(y)
	dy	=	(ymax-ymin)/20.
	yran	=	[ymin-dy,ymax+dy]
endif else begin
	dy	=	(yran(1)-yran(0))/20.
	ymin	=	yran(0)+dy
	ymax	=	yran(1)-dy
endelse

if n_elements(zran) ne 2 then zran	=	[min(z),max(z)]
if n_elements(title) ne 1 then title	=	'!6'
if n_elements(xtitle) ne 1 then xtitle	=	'!6Q (!SA!R!9%!6!E-1!N)'
if n_elements(ytitle) ne 1 then ytitle	=	'!6E (meV)'

if (keyword_set(RATIO)) then ra=ratio else ra=1.

; draw the frame
plot,title=title,xrange=xran,yrange=yran, $
  xtitle=xtitle,ytitle=ytitle,/nodata,findgen(1), $
  charsize=2.0,xstyle=1,ystyle=1,_extra=_extra

; now fill in the data

for i=0,n_y-2 do begin
    for j=0,n_x-2 do begin
    	zs	=	[z(j,i),z(j,i+1),z(j+1,i),z(j+1,i+1)]
    	lis	=	where(zs ne white and zs ne !values.f_nan,nlis)
    	if nlis gt 0 then zav	=	total(zs(lis))/nlis else zav=white
        if ( x(j,i) GE xmin and x(j+1,i) LE xmax and $
             y(j,i) GE ymin and y(j,i+1) LE ymax and zav ne white) then begin
	    		if n_elements(logscal) eq 0 then color=(zav-zran(0))/(zran(1)-zran(0))*255.*ra else $
            	if zav ge zran(0)+1 then color=alog(zav-zran(0))/alog(zran(1)-zran(0))*255.*ra else color=0
            	if color GT 254 then color=254
            	if color LE 0 then color = 0
            	polyfill,[x(j,i),x(j,i+1),x(j+1,i+1),x(j+1,i)], $
              		[y(j,i),y(j,i+1),y(j+1,i+1),y(j+1,i)],color=color
        endif
    endfor
endfor


end
