; $Id$
;###############################################################################
;
; NAME:
;  HFBSDETSF
;
; PURPOSE:
;
; CATEGORY:
;  DAVE, HFBS, data reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro hfbsDetSFQuit,event
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro hfbsDetSF_event,event
widget_control,event.top,get_uvalue = pState
uname = widget_info(event.id,/uname)
case strupcase(uname) of
'COPY':	begin
			widget_control,(*pState).f,get_value = val
			(*pState).sf = float(val[0])+fltarr((*pState).n)
			for i = 0,(*pState).n-1 do begin
			  widget_control,(*pState).f1[i],set_value = val
			endfor
			end
'CANCEL':	begin
			(*pState).sf = 1+fltarr((*pState).n)
			widget_control,event.top,/destroy
			end
'ACCEPT':	begin
			for i = 0,(*pState).n-1 do begin
			  widget_control,(*pState).f1[i],get_value = val
			  (*pState).sf[i] = float(val[0])
			endfor
			widget_control,event.top,/destroy
			end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function hfbsDetSF,group_leader = group_leader,sf = sf
tlb = widget_base(group_leader = group_leader,title = 'Detector scale factors', $
		/row,/modal)
colBase1 = widget_base(tlb,/col,/grid_layout,/base_align_right)
n = 16
f1 = lonarr(n)
if n_elements(sf) eq 0 then sf = 1+fltarr(n)
for i = 0,n/2-1 do begin
  strout = 'Group #'+strtrim(string(i+1),2)
  f1[i] = cw_field(colBase1,xsize = 5,/row,value = strtrim(string(sf[i]),2), $
          title = strout)
endfor

void = widget_button(colBase1,value = 'Accept',uname = 'accept')
colBase2 = widget_base(tlb,/col,/grid_layout,/base_align_right)
for i = n/2,n-1 do begin
  strout = 'Group #'+strtrim(string(i+1),2)
  f1[i] = cw_field(colBase2,xsize = 5,/row,value = strtrim(string(sf[i]),2), $
          title = strout)
endfor
void = widget_button(colBase2,value = 'Cancel',uname = 'cancel')
colBase3 = widget_base(tlb,/col,/grid_layout,/base_align_right)
f = cw_field(colBase3,xsize = 5,/row,value = '1.0', $
          title = 'All groups')
void = widget_button(colBase3,value = 'Copy above to all',uname = 'copy')

widget_control,tlb,/realize

state = {f1:f1,n:n,sf:sf,f:f}
pState = ptr_new(state)
widget_control,tlb,set_uvalue = pState

xmanager,'hfbsDetSF',tlb
sf = (*pState).sf
ptr_free,pState
return,sf
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;