; $Id$;
;###############################################################################
;
; NAME:
;  OPAN_REBIN_FOCUS_Energy_WIDGET
;
; PURPOSE:
;  This widget dialog allows the user to type in preferences for rebinning
;  the currently-loaded data set.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;Based on the Program  opan_rebin_widget.pro by:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro opan_focus_Energy_rw,event
widget_control,event.top,get_uvalue = pState
case event.id of




(*pState).ResetButton: $
         begin
        widget_control,(*pState).ndesired_nb,set_value =(*pState).original.orig_nb_nbins
        widget_control,(*pState).xlo_nb,set_value = (*pState).original.orig_nb_xlo
        widget_control,(*pState).xhi_nb,set_value = (*pState).original.orig_nb_xhi
        widget_control,(*pState).ndesired_b,set_value =(*pState).original.orig_b_nbins
        widget_control,(*pState).xhi_b,set_value = (*pState).original.orig_b_xhi
        widget_control,(*pState).xlo_b,set_value = (*pState).original.orig_b_xlo
        widget_control,(*pState).step_size,set_value = (*pState).original.orig_step
        widget_control,(*pState).ndesired_i,set_value = (*pState).original.orig_i_nbins
        widget_control,(*pState).xlo_i,set_value = (*pState).original.orig_i_xlo
        widget_control,(*pState).xhi_i,set_value = (*pState).original.orig_i_xhi
        widget_control,(*pState).units,set_value = (*pState).original.orig_unit
       (*pState).out.unit=(*pState).original.orig_unit
        (*pState).x=(*pState).original.orig_x
       (*pState).total_bins=(*pState).original.orig_total_bins
        return
         end


(*pState).cancelButton: $
         begin
           (*pState).out.cancel = 1
           widget_control,event.top,/destroy
           return
         end
(*pState).acceptButton: $
         begin
;      Try and avoid errors here from the user pressing accept button before
;      pressing return carriage
        widget_control,(*pState).ndesired_nb,get_value = nb_nbins
        (*pState).out.nb_nbins = fix(nb_nbins[0])
         widget_control,(*pState).xlo_nb,get_value = nb_xlo
         (*pState).out.nb_xlo = double(nb_xlo[0])
         widget_control,(*pState).xhi_nb,get_value = nb_xhi
         (*pState).out.nb_xhi = double(nb_xhi[0])
        widget_control,(*pState).ndesired_b,get_value = b_nbins
         (*pState).out.b_nbins = fix(b_nbins[0])
         widget_control,(*pState).xhi_b,get_value = b_xhi
         (*pState).out.b_xhi = double(b_xhi[0])
         widget_control,(*pState).xlo_b,get_value = b_xlo
         (*pState).out.b_xlo = double(b_xlo[0])
         widget_control,(*pState).step_size,get_value = step
         (*pState).out.step = double(step[0])
         widget_control,(*pState).ndesired_i,get_value = i_nbins
         (*pState).out.i_nbins = fix(i_nbins[0])
         widget_control,(*pState).xhi_i,get_value = i_xhi
         (*pState).out.i_xhi = double(i_xhi[0])
         widget_control,(*pState).xlo_i,get_value = i_xlo
         (*pState).out.i_xlo = double(i_xlo[0])

       (*pState).out.total_bins=(*pState).total_bins

         widget_control,(*pState).units,get_value = unit
         (*pState).out.unit=fix(unit[0])

       ;
         (*pState).out.cancel = 0
;
         widget_control,event.top,/destroy
         return
       end
else:
endcase
uname=widget_info(event.id,/uname)
;print,'uname =',uname
case uname of
'Units':    $
begin
       widget_control,(*pState).units, get_value = unit
;      help,unit
;       help,fix(unit[0])
 ;      print,unit
       unit_arr=[(*pState).out.unit,fix(unit[0])]
       (*pState).out.unit=unit
;       help,unit_arr
;       print,unit_arr
;print,(*pState).unit_arr
if unit_arr[0] ne unit_arr[1] then begin
;print,unit_arr
unit_change_Energy,event,unit_arr=unit_arr
endif
end
'step_size':  $
    begin
;   here the step size is specified.  We have to update the other fields
    widget_control,(*pState).step_size,get_value = step
    widget_control,(*pState).xlo_b,get_value = b_xlo
    widget_control,(*pState).xhi_b,get_value = b_xhi
    step=double(step[0])
    b_xlo=double(b_xlo[0])
    b_xhi=double(b_xhi[0])
;
;    print,b_xhi
;
if step eq 0.0 then return
    b_nbins=(step+b_xhi-b_xlo)/step
;    print,b_nbins
    b_nbins=round(b_nbins)
;    print,b_nbins

 ;  prevent b_nbins exceeding the number of original data points in this range
 where1=where((*pState).x ge b_xlo,count)
    if count ne 0 then begin
    where2=where(float((*pState).x[where1]) le float(b_xhi),count)
    endif
     if count ne 0 then begin
    if b_nbins gt count then begin
    b_nbins=count
    step=(double(b_xhi[0])-double(b_xlo[0]))/(fix(b_nbins[0])-1.0)
     widget_control,(*pState).step_size,set_value = step
    endif
    endif


 ;    b_xhi=b_xlo+b_nbins*step
;    print,b_xhi
 ;   widget_control,(*pState).xhi_b,set_value = b_xhi
    widget_control,(*pState).ndesired_b,set_value = b_nbins
    widget_control,(*pState).ndesired_nb,get_value = nb_nbins
      b_nbins=fix(b_nbins[0])
     nb_nbins=fix(nb_nbins[0])


     (*pState).total_bins=b_nbins+nb_nbins
;
;   update fields in interpolated area
       ;   find interpolated range
   ;   print,'woof'
    x=(*pState).x
    widget_control,(*pState).xlo_nb,get_value = nb_xlo
    nb_xlo=nb_xlo[0]

    where_x_lt_b_xhi=where(x lt double(b_xhi[0])-step/100.0,count)
  ;  print, 'woof'
  ;  print,(fix(nb_nbins[0])+1)
  ;  print,n_elements(where_x_le_b_xhi)
  ;  print,'woof'
    if nb_nbins eq 0 then nb_nbins = 1
    nodatabins=n_elements(where(x lt nb_xlo))
    ;print,'nodatabins =',nodatabins
    ix=x[nodatabins+fix(nb_nbins[0])-1:count]
    ;ix=x[(fix(nb_nbins[0])+1):*]
    ix_plus=ix[1:*]
    ix_minus=ix[0:(n_elements(ix)-1)]
    ix_diff=ix_plus-ix_minus
    ;print,ix_diff
    u=1+bytarr(n_elements(ix_diff))
    ustep=step*u
    where_int=where(ix_diff gt ustep,count)
    ;print,'where_int =',where_int
    ;print,'where_int + 1 =',where_int+1
    if count ge 1 then begin
;   help,ix
    ix=[ix[0],ix[(where_int+1)]]
;   help,ix
    i_xlo=b_xlo
    i_xhi=max(ix)
    i_nbins=round((step+i_xhi-i_xlo)/step)
    endif else begin
    i_nbins=0
    i_xlo=b_xlo
    i_xhi=b_xlo
    endelse
    widget_control,(*pState).ndesired_i,set_value = i_nbins
    widget_control,(*pState).xlo_i,set_value = i_xlo
    widget_control,(*pState).xhi_i,set_value = i_xhi



    end
'first_bin_point':  $
    begin
;    print,'woof'
    widget_control,event.id,get_value=b_xlo
    widget_control,(*pState).xhi_b,get_value = b_xhi
    b_xlo=double(b_xlo[0])
    b_xhi=double(b_xhi[0])
;   prevent first bin point being set to a value greater than the last bin point
    if b_xlo ge b_xhi then begin
    x=(*pState).x
    where_lt=where(x lt b_xhi,count)
;    print,count
    b_xlo=x[where_lt[count-2]]
        widget_control,event.id,set_value=b_xlo
;    print,b_xlo
    endif
;    print,b_xlo
;    print,b_xhi

    widget_control,(*pState).xlo_nb,get_value = nb_xlo
    nb_xlo=double(nb_xlo[0])
;   help,nb_xlo
   ;  print,nb_xlo
 ;  prevent first bin point being set to a value less than the lowest non-bin point
         if b_xlo lt nb_xlo then $
    widget_control,event.id,set_value=nb_xlo
  ; prevent first bin point being set to a value greater than the maximum value of x
        if b_xlo gt max((*pState).x) then $
    widget_control,event.id,set_value=max((*pState).x)
;
    widget_control,event.id,get_value=b_xlo
    b_xlo=double(b_xlo[0])
;   There are two ways of accessing widget information,and sadly I use both
;   Set the last non-bin point to the value of the first binned-point
    last_non_bin_point_id=widget_info(event.top, $
    find_by_uname='last_non_bin_point')
;    print,'val =',val
    widget_control,last_non_bin_point_id,set_value=b_xlo
;   now change bin entries
    widget_control,(*pState).xlo_nb,get_value = nb_xlo
    widget_control,(*pState).xhi_nb,get_value = nb_xhi
     x=(*pState).x
     nb_xlo=double(nb_xlo[0])
     nb_xhi=double(nb_xhi[0])
     ;print,nb_xlo
     ;print,nb_xhi
     ;help,nb_xlo

    upper_cond=where(x lt nb_xhi)
    if upper_cond[0] eq -1 then begin
    nb_nbins = 0
    widget_control,(*pState).xlo_nb,set_value = nb_xhi
    endif else begin
     xtemp=x[upper_cond]
     lower_cond=where(xtemp ge nb_xlo)
           if lower_cond[0] eq -1 then begin
    nb_nbins = 0
    widget_control,(*pState).xlo_nb,set_value = nb_xhi
           endif else begin
     xtemp1=x[lower_cond]
;     print,'xtemp1 =',xtemp1
    nb_nbins=n_elements(xtemp1)
         endelse
    endelse
  ;  help,nb_nbins
     widget_control,(*pState).ndesired_nb,set_value = nb_nbins
;     widget_control,(*pState).ndesired_b,get_value = b_nbins
;     b_nbins=fix(b_nbins[0])
;
;     b_nbins=(*pState).total_bins-fix(nb_nbins[0])
;     widget_control,(*pState).ndesired_b,set_value = b_nbins

    widget_control,(*pState).step_size,get_value = step
    step=double(step[0])

    b_nbins=(step+b_xhi-b_xlo)/step
   ; print,b_nbins
    b_nbins=round(b_nbins)
;    print,b_nbins
 ;  prevent b_nbins exceeding the number of original data points in this range
  ;   widget_control,(*pState).ndesired_nb,get_value = nb_nbins
  ;  nb_nbins=fix(nb_nbins[0])
     where1=where((*pState).x ge b_xlo,count)
     if count ne 0 then begin
  ;   print,'n_elements((*pState).x): ',n_elements((*pState).x)
  ;  print,'(*pState).x:',(*pState).x
  ;  print,'where1: ',where1
    where2=where((*pState).x[where1] le b_xhi,count)
    endif
     if count ne 0 then begin
    if b_nbins gt count then begin
    b_nbins=count
    step=(double(b_xhi[0])-double(b_xlo[0]))/(fix(b_nbins[0])-1.0)
     widget_control,(*pState).step_size,set_value = step
    endif
    endif

  ;   b_xhi=b_xlo+b_nbins*step
;    print,b_xhi
  ;  widget_control,(*pState).xhi_b,set_value = b_xhi
    widget_control,(*pState).ndesired_b,set_value = b_nbins
     (*pState).total_bins=b_nbins+nb_nbins

    ;   find interpolated range
    x=(*pState).x
    widget_control,(*pState).xlo_nb,get_value = nb_xlo
    nb_xlo=nb_xlo[0]
;    print,(fix(nb_nbins[0])+1)
;    print,(fix(nb_nbins[0])+1)+fix(b_nbins[0])
;   This next bit is diffiuclt to avoid bugs
    where_x_lt_b_xhi=where(x lt double(b_xhi[0])-step/100.0,count)
;    print,(fix(nb_nbins[0])+1)
;    print,n_elements(where_x_le_b_xhi)
;    print,'woof',double(b_xhi[0])
;   Since the last index is count and not count-1, we are including the last entry
    if nb_nbins eq 0 then nb_nbins = 1
    nodatabins=n_elements(where(x lt nb_xlo))
    ix=x[nodatabins+nb_nbins-1:count]
  ;  help,ix
    ;ix=x[(fix(nb_nbins[0])+1):*]
    ix_plus=ix[1:*]
    ix_minus=ix[0:(n_elements(ix)-1)]
    ix_diff=ix_plus-ix_minus
    ;print,ix_diff
    u=1+bytarr(n_elements(ix_diff))
    ustep=step*u
    where_int=where(ix_diff gt ustep,count)
    ;print,'where_int =',where_int
    ;print,'where_int + 1 =',where_int+1
    if count ge 1 then begin
;   help,ix
    ix=[ix[0],ix[(where_int+1)]]
;   help,ix
    i_xlo=b_xlo
    i_xhi=max(ix)
    i_nbins=round((step+i_xhi-i_xlo)/step)
    endif else begin
    i_nbins=0
    i_xlo=b_xlo
    i_xhi=b_xlo
    endelse
    widget_control,(*pState).ndesired_i,set_value = i_nbins
    widget_control,(*pState).xlo_i,set_value = i_xlo
    widget_control,(*pState).xhi_i,set_value = i_xhi


    end

'b_bins':    $
    begin
  ;  print,'(*pState).total_bins =',(*pState).total_bins
    nb_bin_id=widget_info(event.top,  $
    find_by_uname='nb_bins')
    widget_control,nb_bin_id,get_value=nb_nbins
    widget_control,event.id,get_value=b_nbins
    nb_nbins=fix(nb_nbins[0])
    b_nbins=fix(b_nbins[0])

;
    widget_control,(*pState).xlo_b,get_value = b_xlo
    widget_control,(*pState).xhi_b,get_value = b_xhi
    b_xlo=double(b_xlo[0])
    b_xhi=double(b_xhi[0])


 ;  prevent b_nbins exceeding the number of original data points in this range
     widget_control,(*pState).ndesired_nb,get_value = nb_nbins
    nb_nbins=fix(nb_nbins[0])
     where1=where((*pState).x ge b_xlo,count)
     if count ne 0 then begin
;     print, 'count1 =',count
;     print, 'where1 =',where1
;
    where2=where((*pState).x[where1] le b_xhi,count)
;     print, 'where2 =',where2
    endif
     if count ne 0 then begin
    if b_nbins gt count then begin
;     print, 'count2 =',count
    b_nbins=count
    widget_control,(*pState).ndesired_b,set_value = b_nbins
    step=(double(b_xhi[0])-double(b_xlo[0]))/(fix(b_nbins[0])-1.0)
     widget_control,(*pState).step_size,set_value = step
    endif
    endif
    ;   Calculate step size
    widget_control,(*pState).xlo_b,get_value = b_xlo
    widget_control,(*pState).xhi_b,get_value = b_xhi
    widget_control,(*pState).ndesired_b,get_value = b_nbins
    b_nbins=float(b_nbins[0])
    b_nbins=round(b_nbins)
    if (b_nbins-1) le 0 then begin
    step=0.0
    i_nbins=0
    i_xlo=double(b_xlo[0])
    i_xhi=double(b_xlo[0])
    b_xhi=double(b_xlo[0])
    widget_control,(*pState).ndesired_i,set_value = i_nbins
    widget_control,(*pState).xlo_i,set_value = i_xlo
    widget_control,(*pState).xhi_i,set_value = i_xhi
    widget_control,(*pState).xhi_b,set_value = b_xhi
    endif else begin
    step=(double(b_xhi[0])-double(b_xlo[0]))/(double(b_nbins)-1.0)


    endelse
     widget_control,(*pState).step_size,set_value = step
     (*pState).total_bins=b_nbins+nb_nbins
;
        ;   find interpolated range
    x=(*pState).x
    widget_control,(*pState).xlo_nb,get_value = nb_xlo
    nb_xlo=nb_xlo[0]
;
    where_x_lt_b_xhi=where(x lt double(b_xhi[0])-step/100.0,count)
  ;  print, 'woof'
  ;  print,n_elements(where_x_le_b_xhi)
  ;  print,'woof'
    nodatabins=n_elements(where(x lt nb_xlo))
;    print,'nodatabins =',nodatabins
;    print,'fix(nb_nbins[0])-1 =',fix(nb_nbins[0])-1
 ;   print, 'woof1'
    ix=x[nodatabins+fix(nb_nbins[0])-1:count]
 ;   print, 'woof2'
    ;ix=x[(fix(nb_nbins[0])+1):*]
    ix_plus=ix[1:*]
    ix_minus=ix[0:(n_elements(ix)-2)]
    ix_diff=ix_plus-ix_minus
;    print,'ix_diff =',ix_diff
;    print,'n_elements(ix_plus) =',n_elements(ix_plus)
;    print,'n_elements(ix_minus) =',n_elements(ix_minus)
;    print,'n_elements(ix_diff) =',n_elements(ix_diff)
   u=1+bytarr(n_elements(ix_diff))
    ustep=step*u
    where_int=where(ix_diff gt ustep,count)
    ;print,'where_int =',where_int
    ;print,'where_int + 1 =',where_int+1
    if count ge 1 then begin
;   help,ix
    ix=[ix[0],ix[(where_int+1)]]
;   help,ix
    i_xlo=b_xlo
    i_xhi=max(ix)
    i_nbins=round((step+i_xhi-i_xlo)/step)
    endif else begin
    i_nbins=0
    i_xlo=b_xlo
    i_xhi=b_xlo
    endelse
    widget_control,(*pState).ndesired_i,set_value = i_nbins
    widget_control,(*pState).xlo_i,set_value = i_xlo
    widget_control,(*pState).xhi_i,set_value = i_xhi


  end
'last_bin_point':    $
begin
    widget_control,event.id,get_value=b_xhi
    b_xhi=double(b_xhi[0])
 ;  prevent last bin point being set to a value greater than max(x)
    if b_xhi gt max((*pState).x) then begin
    b_xhi=max((*pState).x)
    widget_control,event.id,set_value=b_xhi
    endif

;   calculate number of steps
    widget_control,(*pState).xlo_b,get_value = b_xlo
    b_xlo=double(b_xlo[0])

    widget_control,(*pState).step_size,get_value = step
    step=double(step[0])


    b_nbins=(step+b_xhi-b_xlo)/step
;    print,b_nbins
    b_nbins=round(b_nbins)
;    print,b_nbins
 ;  prevent b_nbins exceeding the number of original data points in this range
     widget_control,(*pState).ndesired_nb,get_value = nb_nbins
    nb_nbins=fix(nb_nbins[0])
     where1=where((*pState).x ge b_xlo,count)
     if count ne 0 then begin
    where2=where((*pState).x[where1] le b_xhi,count)
    endif
     if count ne 0 then begin
    if b_nbins gt count then begin
    b_nbins=count
    step=(double(b_xhi[0])-double(b_xlo[0]))/(fix(b_nbins[0])-1.0)
     widget_control,(*pState).step_size,set_value = step
    endif
    endif
;     b_xhi=b_xlo+b_nbins*step
;    print,b_xhi
 ;   widget_control,(*pState).xhi_b,set_value = b_xhi
    widget_control,(*pState).ndesired_b,set_value = b_nbins
     (*pState).total_bins=b_nbins+nb_nbins
  ;  print,'woof'
        ;   find interpolated range
    x=(*pState).x
    widget_control,(*pState).xlo_nb,get_value = nb_xlo
    nb_xlo=nb_xlo[0]

    where_x_lt_b_xhi=where(x lt b_xhi-step/100.0,count)
    if nb_nbins eq 0 then nb_nbins = 1
    nodatabins=n_elements(where(x lt nb_xlo))
    ix=x[nodatabins+fix(nb_nbins[0])-1:count]
    ix_plus=ix[1:*]
    ix_minus=ix[0:(n_elements(ix)-1)]
    ix_diff=ix_plus-ix_minus
    ;print,ix_diff
    u=1+bytarr(n_elements(ix_diff))
    ustep=step*u
    where_int=where(ix_diff gt ustep,count)
    ;print,'where_int =',where_int
    ;print,'where_int + 1 =',where_int+1
    if count ge 1 then begin
;   help,ix
    ix=[ix[0],ix[(where_int+1)]]
;   help,ix
    i_xlo=b_xlo
    i_xhi=max(ix)
    i_nbins=round((step+i_xhi-i_xlo)/step)
    endif else begin
    i_nbins=0
    i_xlo=b_xlo
    i_xhi=b_xlo
    endelse
    widget_control,(*pState).ndesired_i,set_value = i_nbins
    widget_control,(*pState).xlo_i,set_value = i_xlo
    widget_control,(*pState).xhi_i,set_value = i_xhi


end

'Range_Types':    $
begin
        widget_control,(*pState).Accept_Range,get_value = Range_Types
 ;   Range_Types_id=widget_info(event.top,  $
 ;   find_by_uname='Range_Types')
 ;   widget_control,Range_Types_id,get_value=Range_Types
 ;   help,Range_Types
  ;  print,Range_Types
(*pState).out.Range=Range_Types
end


'first_non_bin_point':    $
begin
    widget_control,(*pState).xlo_nb,get_value = nb_xlo
    widget_control,(*pState).xhi_nb,get_value = nb_xhi
     x=(*pState).x
     nb_xlo=double(nb_xlo[0])
     nb_xhi=double(nb_xhi[0])

    if nb_xlo lt min(x) then begin
    nb_xlo=min(x)
    widget_control,event.id,set_value=nb_xlo
    endif


;    help,nb_xlo
;    help,nb_xhi
;
 ;
    upper_cond=where(x lt nb_xhi)
    if upper_cond[0] eq -1 then begin
    nb_nbins = 0
    widget_control,(*pState).xlo_nb,set_value = nb_xhi
    endif else begin
     xtemp=x[upper_cond]
     lower_cond=where(xtemp ge nb_xlo)
           if lower_cond[0] eq -1 then begin
    nb_nbins = 0
    widget_control,(*pState).xlo_nb,set_value = nb_xhi
           endif else begin
     xtemp1=x[lower_cond]
;     print,'xtemp1 =',xtemp1
    nb_nbins=n_elements(xtemp1)
         endelse
    endelse
  ;  help,nb_nbins
     widget_control,(*pState).ndesired_nb,set_value = nb_nbins
     widget_control,(*pState).ndesired_b,get_value = b_nbins
     b_nbins=fix(b_nbins[0])
     (*pState).total_bins=b_nbins+nb_nbins
 ;          print, '(*pState).total_bins  =',(*pState).total_bins

end


else:
endcase

return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro unit_change_Energy,event,unit_arr=unit_arr
widget_control,event.top,get_uvalue = pState
;print,''
;print,'unit_arr =',unit_arr
; convert from meV to wavenumbers
if unit_arr[0] eq 0 and unit_arr[1] eq 1 then conv=8.06554097d
; convert from meV to GHz
if unit_arr[0] eq 0 and unit_arr[1] eq 2 then conv=241.7989052d
; convert from meV to THz
if unit_arr[0] eq 0 and unit_arr[1] eq 3 then conv=0.2417989052d
; convert from meV to K
if unit_arr[0] eq 0 and unit_arr[1] eq 4 then conv=11.604615407811d
;
; convert from wavenumbers to meV
if unit_arr[0] eq 1 and unit_arr[1] eq 0 then conv=0.123984244d
; convert from wavenumbers to GHz
if unit_arr[0] eq 1 and unit_arr[1] eq 2 then conv=29.97925447d
; convert from wavenumbers to THz
if unit_arr[0] eq 1 and unit_arr[1] eq 3 then conv=0.02997925447d
; convert from wavenumbers to K
if unit_arr[0] eq 1 and unit_arr[1] eq 4 then conv=1.4387894688d
;
; convert from GHz to meV
if unit_arr[0] eq 2 and unit_arr[1] eq 0 then conv=double(4.135668022e-3)
; convert from GHz to wavenumbers
if unit_arr[0] eq 2 and unit_arr[1] eq 1 then conv=0.03335639987d
; convert from GHz to THz
if unit_arr[0] eq 2 and unit_arr[1] eq 3 then conv=double(1e-3)
; convert from GHz to K
if unit_arr[0] eq 2 and unit_arr[1] eq 4 then conv=0.04799283685d
;
; convert from THz to meV
if unit_arr[0] eq 3 and unit_arr[1] eq 0 then conv=4.135668022d
; convert from THz to wavenumbers
if unit_arr[0] eq 3 and unit_arr[1] eq 1 then conv=33.35639987d
; convert from THz to GHz
if unit_arr[0] eq 3 and unit_arr[1] eq 2 then conv=double(1e3)
; convert from THz to K
if unit_arr[0] eq 3 and unit_arr[1] eq 4 then conv=47.99283685d
;
; convert from K to meV
if unit_arr[0] eq 4 and unit_arr[1] eq 0 then conv=0.08617261019498424682d
; convert from K to wavenumbers
if unit_arr[0] eq 4 and unit_arr[1] eq 1 then conv=0.695028718d
; convert from K to GHz
if unit_arr[0] eq 4 and unit_arr[1] eq 2 then conv=20.836442803443d
; convert from K to THz
if unit_arr[0] eq 4 and unit_arr[1] eq 3 then conv=0.0208364428034431d
;
;
;
;
;
     widget_control,(*pState).xlo_nb,get_value = nb_xlo
nb_xlo=float(nb_xlo[0]*conv)
     widget_control,(*pState).xlo_nb,set_value = nb_xlo
;
     widget_control,(*pState).xhi_nb,get_value = nb_xhi
nb_xhi=float(nb_xhi[0]*conv)
     widget_control,(*pState).xhi_nb,set_value = nb_xhi
;
     widget_control,(*pState).xlo_b,get_value = b_xlo
b_xlo=float(b_xlo[0]*conv)
     widget_control,(*pState).xlo_b,set_value = b_xlo
;
     widget_control,(*pState).xhi_b,get_value = b_xhi
b_xhi=float(b_xhi[0]*conv)
     widget_control,(*pState).xhi_b,set_value = b_xhi
;
     widget_control,(*pState).xlo_i,get_value = i_xlo
i_xlo=float(i_xlo[0]*conv)
     widget_control,(*pState).xlo_i,set_value = i_xlo
;
     widget_control,(*pState).xhi_i,get_value = i_xhi
i_xhi=float(i_xhi[0]*conv)
     widget_control,(*pState).xhi_i,set_value = i_xhi
;
     widget_control,(*pState).step_size,get_value = step_size
step_size=float(step_size[0]*conv)
     widget_control,(*pState).step_size,set_value = step_size
;
    (*pState).x*=conv
;print,unit_arr
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function opan_rebin_focus_Energy_widget, x,nb_xlo=nb_xlo,nb_xhi=nb_xhi,nb_nbins=nb_nbins, $
                    b_xlo=b_xlo,b_xhi=b_xhi,b_nbins=b_nbins,step=step, $
                    i_xlo=i_xlo,i_xhi=i_xhi,i_nbins=i_nbins, total_bins=total_bins, $
                    range=range,unit=unit,group_leader = group_leader
;
nb_nbins=fix(nb_nbins)
b_nbins=fix(b_nbins)
i_nbins=fix(i_nbins)
range=fix(range)
unit=fix(unit)
total_bins=fix(total_bins)
;print,'unit =',unit
orig_nb_nbins=nb_nbins
orig_nb_xlo=nb_xlo
orig_nb_xhi=nb_xhi
orig_b_nbins=b_nbins
orig_b_xlo=b_xlo
orig_b_xhi=b_xhi
orig_step=step
orig_i_nbins=i_nbins
orig_i_xlo=i_xlo
orig_i_xhi=i_xhi
orig_x=x
orig_unit=unit
orig_total_bins=total_bins
;print,'total_bins =',total_bins
;
;
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = 'Energy Rebinning Utility',/tlb_frame_attr,/align_center)
endif else begin
  tlb = widget_base(group_leader = group_leader, /col,/modal, $
        title = 'Energy Rebinning Utility',/tlb_frame_attr,/align_center)
endelse
base = widget_base(tlb,/row)
basel = widget_base(base,/col)
baser = widget_base(base,/col)
base1 = widget_base(basel,/col,/frame)
void = widget_label(base1,value = 'Range Without Binning')
ndesired_nb = cw_field(base1,/row,uname='nb_bins',value = string(nb_nbins),title = '# of channels',/noedit)
xlo_nb = cw_field(base1,/row,uname='first_non_bin_point',value = string(nb_xlo),title = 'Lower limit',/return_events)
xhi_nb = cw_field(base1,/row,uname='last_non_bin_point',value =string(nb_xhi),title = 'Upper limit',/noedit)

base2 = widget_base(basel,/col,/frame)
void = widget_label(base2,value = 'Range With Binning')
ndesired_b = cw_field(base2,/row,uname='b_bins',value = string(b_nbins),title = '# of channels',/return_events)
xlo_b = cw_field(base2,/row,uname='first_bin_point',value = string(b_xlo),title = 'Lower limit',/return_events)
xhi_b = cw_field(base2,/row,uname='last_bin_point',value = string(b_xhi),title = 'Upper limit',/return_events)
step_size = cw_field(base2,/row,uname='step_size',value = string(step),title = 'Step Size',/return_events)

base3 = widget_base(baser,/col,/frame)
void = widget_label(base3,value = 'Binned Range With Interpolation')
ndesired_i = cw_field(base3,/row,uname='i_bins',value = string(i_nbins),title = '# of channels',/noedit)
xlo_i = cw_field(base3,/row,uname='first_i_point',value = string(i_xlo),title = 'Lower limit',/noedit)
xhi_i = cw_field(base3,/row,uname='last_i_point',value = string(i_xhi),title = 'Upper limit',/noedit)

base4 = widget_base(baser,/col,/frame)





Accept_Range_Types = ['All',$
              'Binned', $
              'Binned Without Interpolation']
;range=1
Accept_Range = cw_bgroup(base4,Accept_Range_Types,/col,/exclusive,label_top='Range to Include',$
           set_value = range,/return_index, /frame,$
           uname = 'Range_Types')



Unit_Types = ['meV',$
              'cm-1', $
              'GHz', $
              'THz',  $
               'K']
;unit=0
Units = cw_bgroup(base4,Unit_Types,row=2,/exclusive,label_top='Units', $
           set_value = Unit,/return_index, /frame,$
           uname = 'Units')



;base5 = widget_base(basel,/row,/base_align_right)

ResetButton = widget_button(base2,value = 'Reset')
cancelButton = widget_button(base2,value = 'Cancel')
acceptButton = widget_button(base2,value = 'Accept')
;woofButton = widget_button(base5,/align_center,value = 'woof')

widget_control,tlb,/realize

out = {nb_xlo:nb_xlo,nb_xhi:nb_xhi,nb_nbins:nb_nbins,b_xlo:b_xlo,b_xhi:b_xhi,b_nbins:b_nbins, $
       i_xlo:i_xlo,i_xhi:i_xhi,i_nbins:i_nbins,step:step, total_bins:total_bins,  $
       range:range, unit:unit, cancel:1}


 original={orig_nb_nbins:orig_nb_nbins,orig_nb_xlo:orig_nb_xlo,orig_nb_xhi:orig_nb_xhi, $
 orig_b_nbins:orig_b_nbins,orig_b_xlo:orig_b_xlo,orig_b_xhi:orig_b_xhi,orig_step:orig_step, $
 orig_i_nbins:orig_i_nbins,orig_i_xlo:orig_i_xlo,orig_i_xhi:orig_i_xhi,orig_x:orig_x, $
 orig_unit:orig_unit,orig_total_bins:orig_total_bins}

state = {original:original, $
       out:out, $
        x:x,   $
         ndesired_nb:ndesired_nb, xlo_nb:xlo_nb, xhi_nb:xhi_nb, $
         ndesired_b:ndesired_b, xlo_b:xlo_b, xhi_b:xhi_b, step_size:step_size, $
         ndesired_i:ndesired_i, xlo_i:xlo_i, xhi_i:xhi_i, Accept_Range:Accept_Range,   $
         units:units, total_bins:total_bins,  $
         cancelButton:cancelButton, $
         ResetButton:ResetButton, $
         acceptButton:acceptButton}

pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState
xmanager,'opan_rebin_focus_Energy_widget',tlb,event_handler = 'opan_focus_Energy_rw'

out = (*pState).out
ptr_free,pState
;print,'out =',out
return,out
end