;-------------------------------------------------------------------------------
; Purpose
;   Get method
;===============================================================================
pro IDLitVisbond::cleanup
compile_opt idl2

obj_destroy, self._bond

self->IDLitVisualization::cleanup

end;IDLitVisbond::cleanup


;-------------------------------------------------------------------------------
; Purpose
;   Get method
;===============================================================================
pro IDLitVisbond::setProperty, parent=parent $
    ,transparency=transparency $
    ,xpos=xpos $
    ,ypos=ypos $
    ,zpos=zpos $
    ,xbeg=xbeg $
    ,ybeg=ybeg $
    ,zbeg=zbeg $
    ,xend=xend $
    ,yend=yend $
    ,zend=zend $
    ,color=color $
    ,_EXTRA=etc
compile_opt idl2

;; Parent requires careful handling since any IDLitComponent should
;; only have 1 parent
if (n_elements(parent) gt 0) then $
    self->IDLgrModel::setProperty, parent=parent

if (n_elements(transparency) gt 0) then $ ; convert transparency to alpha_channel
    self._bond->setProperty, alpha_channel=0 > ((100.0 - transparency)/100) < 1

;print,'IDLitVisbond::setProperty'
;help,color
if (n_elements(color) eq 3) then $
    self._bond->setProperty, color=color
     
if (n_elements(xpos) gt 0) then begin
    self._bond->getProperty, pos=pos
    pos[0] = xpos
    self._bond->setProperty, pos=pos
endif
if (n_elements(ypos) gt 0) then begin
    self._bond->getProperty, pos=pos
    pos[1] = ypos
    self._bond->setProperty, pos=pos
endif
if (n_elements(zpos) gt 0) then begin
    self._bond->getProperty, pos=pos
    pos[2] = zpos
    self._bond->setProperty, pos=pos
endif


;011808
;SETTING UP BOND PROPERTIES IS A LITTLE TRICKY:
;FIRST NEED BOND CLASS, THEN NEED BOND PROPERTIES
;
if (n_elements(xbeg) gt 0) then begin
    self._bond->getProperty, bondbegin=bondbegin
    bondbegin[0] = xbeg
    self._bond->setProperty, bondbegin=bondbegin
endif
if (n_elements(ybeg) gt 0) then begin
    self._bond->getProperty, bondbegin=bondbegin
    bondbegin[1] = ybeg
    self._bond->setProperty, bondbegin=bondbegin
endif
if (n_elements(zbeg) gt 0) then begin
    self._bond->getProperty, bondbegin=bondbegin
    bondbegin[2] = zbeg
    self._bond->setProperty, bondbegin=bondbegin
endif



if (n_elements(xend) gt 0) then begin
    self._bond->getProperty, bondend=bondend
    bondend[0] = xend
    self._bond->setProperty, bondend=bondend
endif
if (n_elements(yend) gt 0) then begin
    self._bond->getProperty, bondend=bondend
    bondend[1] = yend
    self._bond->setProperty, bondend=bondend
endif
if (n_elements(zend) gt 0) then begin
    self._bond->getProperty, bondend=bondend
    bondend[2] = zend
    self._bond->setProperty, bondend=bondend
endif



            
;; Call the set method on the base class and bond component
if (n_elements(etc) gt 0) then begin
    self._bond->setProperty, _EXTRA=etc
    self->IDLitVisualization::setProperty, _EXTRA=etc
endif


end;IDLitVisbond::setProperty


;-------------------------------------------------------------------------------
; Purpose
;   Get method
;===============================================================================
pro IDLitvisbond::getProperty, transparency=transparency $
    ,xpos=xpos $
    ,ypos=ypos $
    ,zpos=zpos $
    ,xbeg=xbeg $
    ,ybeg=ybeg $
    ,zbeg=zbeg $
    ,xend=xend $
    ,yend=yend $
    ,zend=zend $
    ,color=color $
    ,_REF_EXTRA=etc
compile_opt idl2


if arg_present(transparency) then begin
    self._bond->getProperty, alpha_channel=alpha
    transparency = 0 > fix(100 - alpha * 100) < 100
endif

if (arg_present(xpos) || arg_present(ypos) || arg_present(zpos)) then begin
    self._bond->getProperty, pos=pos
    xpos = pos[0]
    ypos = pos[1]
    zpos = pos[2]
endif

if (arg_present(xbeg) || arg_present(ybeg) || arg_present(zbeg)) then begin
    self._bond->getProperty, bondbegin=bondbegin
    xbeg = bondbegin[0]
    ybeg = bondbegin[1]
    zbeg = bondbegin[2]
endif

if (arg_present(xend) || arg_present(yend) || arg_present(zend)) then begin
    self._bond->getProperty, bondend=bondend
    xend = bondend[0]
    yend = bondend[1]
    zend = bondend[2]
endif

if arg_present(color) then begin
    self._bond->getProperty,color=color
endif

;; Call the get method on the base class and bond component
if (n_elements(etc) gt 0) then begin
    self._bond->getproperty, _EXTRA=etc
    self->IDLitVisualization::getProperty, _EXTRA=etc
endif

end;IDLitvisbond::getProperty



;-------------------------------------------------------------------------------
; IDLitVisbond::Restore
;
; Purpose:
;   This procedure method performs any cleanup work required after
;   an object of this class has been restored from a save file to
;   ensure that its state is appropriate for the current revision.
;
;===============================================================================
pro IDLitvisbond::Restore
compile_opt idl2

;; Call superclass restore.
self->_IDLitVisualization::Restore

;; Call ::GetProperty on each aggregated graphic object
;; to force its internal restore process to be called, thereby
;; ensuring any new properties are registered.


;011808
;DOES THIS WORK????????????????????????????????????????

print,'IDLitvisbond::Restore'
print,'DOES THIS WORK????????????????????????????????????????'
if (obj_valid(self._bond)) then self._bond->GetProperty

;; Register new properties.
self->IDLitVisbond::_RegisterProperties, update_from_version=self.idlitcomponentversion

end


;===============================================================================
function IDLitvisbond::init, name=name, description=desc, _REF_EXTRA=etc
compile_opt idl2


;print,'IDLitvisbond::init'

;help,/traceback
if (~keyword_set(name)) then name = 'Bond'
if (~keyword_set(desc)) then desc = 'Cylindrical Graphic Atom'

;; Initialize superclass
if (not self->IDLitVisualization::Init(name=name $
                                       ,type='IDLBOND' $
                                       ,icon='demo' $
                                       ,description=desc $
                                       ,/MANIPULATOR_TARGET $
                                       ,_EXTRA=etc)) $
  then begin
  
;  print,'In IDLitvisbond::init: '
  return, 0

endif

; Create an bond and add it to self
; use /private so that this bond will not be displayed seperately in the iTool browser window
; use /register_properties to register properties defined within the bond class

;011708
;
;THIS NEXT STEP NEEDS TO HAVE A "bond" CLASS THAT IS CREATED FROM CRAIG'S g3dviewmaketube


;self._bond = obj_new('orb',/register_properties,_EXTRA=etc,/private)
self._bond = obj_new('denprobond',/register_properties,_EXTRA=etc,/private)



self->add, self._bond, /aggregate


;self->RegisterParameter, 'GRAPHICS OBJECT', $
;  DESCRIPTION='A IDL Object Graphics element.', $
;  /OPTARGET, /INPUT, TYPES='IDLGROBJECT'


;; Register properties
self->registerProperty,'RADIUS',/float,name='Bond radius',description='Radius of sphere in data units'

self->registerProperty,'DENSITY',/float,name='Density' $
  ,description='Density at which vertices are generated along the bond surface'

self->registerProperty,'STYLE',name='Style',description='Style polygon to be drawn',enumlist=['0','1','2']

self->registerProperty,'COLOR',/color,name='Color',description='Bond Color'

self->registerProperty,'SPECULAR',/color,name='Specular highlight color',description='Specify the color of the specular highlights of this object'

self->registerProperty,'SHADING',name='Shading',description='Type of shading to use',enumlist=['0','1']

desc = 'Higher values of shininess concentrate specular highlights into smaller and brighter areas'
self->registerProperty,'SHININESS',/float,name='Shininess',description=desc,valid_range=[0.0,128.0,5.0]

self->registerProperty, 'TRANSPARENCY', /INTEGER, name='Transparency',description='Transparency of Bond',valid_range=[0,100,5]

self->registerProperty,'XPOS',/float,name='X Position',description='X Coordinate of Bond'
self->registerProperty,'YPOS',/float,name='Y Position',description='Y Coordinate of Bond'
self->registerProperty,'ZPOS',/float,name='Z Position',description='Z Coordinate of Bond'
self->registerProperty,'XBEG',/float,name='X Begin',description='X Coordinate of Beginning of Bond'
self->registerProperty,'YBEG',/float,name='Y Begin',description='Y Coordinate of Beginning of Bond'
self->registerProperty,'ZBEG',/float,name='Z Begin',description='Z Coordinate of Beginning of Bond'
self->registerProperty,'XEND',/float,name='X End',description='X Coordinate of End of Bond'
self->registerProperty,'YEND',/float,name='Y End',description='Y Coordinate of End of Bond'
self->registerProperty,'ZEND',/float,name='Z End',description='Z Coordinate of End of Bond'






self->aggregate, self._Bond      ; aggregate the Bond properties (ie those defined for its IDLgrPolygon component)


return, 1                       ; Success

end


;===============================================================================
pro IDLitvisBond__Define
compile_opt idl2

struct = {IDLitvisBond,           $
          inherits IDLitVisualization $ ; Superclass: _IDLitVisualization
          ,_Bond:obj_new() $
         }

end
