

;BORROWED FROM g3dview:
;CREATES AN IDLgrPolygon AND AN IDLgrPolyline TO CREATE A CYLINDER TO REPRESENT A BOND.
function denPro_g3dviewmakeTube, v0, v1, tubedia, tubecolor, p1, _extra=e

;print,'DenProBond::g3dviewmakeTube'
;help,v0,v1,tubedia,tubecolor,p1,e


    ;  MESH_OBJ params
    p2 = v0
    p3 = v1 - v0

    ;  Calculate the x-product
    ;  You'll have to handle special case where p3==[0,0,1]
    if p3[0] eq 0 and p3[1] eq 0 then begin
    cp = CROSSP(p3,[0.,1.,0.])
    endif else begin
    cp = CROSSP(p3,[0.,0.,1.])
    endelse
    ;  Normalize x-product
    s = SQRT(TOTAL(cp^2))
    cp = cp / s
    ;  Create the line to rotate
    array1 = [[v0],[v1]] - REBIN(tubedia * cp, 3, 2)
    ;  Create the mesh
    MESH_OBJ, 6, verts, polys, array1, P1=p1, P2=p2, P3=p3
    ;MESH_OBJ, 3, verts, polys, array1, P1=p1, P2=p2, P3=p3

    ;  Create a polygon and a line representing the original vector
    if n_elements(tubecolor) ne 3 then tubecolor=[255b,0b,0b]
    ;print,'DenProBond::g3dviewmakeTube, tubecolor=',tubecolor
;help,/traceback
    oTube = OBJ_NEW('IDLgrPolygon', verts, POLYGONS=polys, $
        COLOR=tubecolor, STYLE=2, _extra=e)
    oVec = OBJ_NEW('IDLgrPolyline', [[v0],[v1]], COLOR=tubecolor)

    RETURN, [oTube, oVec]
end;DenProBond::g3dviewmakeTube

