; $Id$
;
;Following Richard's manual p. 31ff.
;
;

function DAVEReadGRD::IsA,strFilename
compile_opt idl2


  catch,err
  if err ne 0 then begin
    catch,/cancel
    return,0
  endif
PRINT,'THIS VERSION IS CURRENT AS OF 5/30/08'
  print,'DAVEReadGRD::IsA   -   Checking '+strFilename

  ;CALL THE BASE CLASS READER TO DETERMINE IF THE EXTENSION IS RIGHT.
  if (~self->IDLitReader::IsA(strFilename)) then return,0

  print,'DAVEReadGRD::IsA    -    There is a GRD or grd EXTENSION.'
  ;FOR THE REAL CHECK I MAY NEED TO SIMPLY READ THE FILE AND SEE WHAT HAPPENS.


  return,1
end;DAVEReadGRD::IsA


;DAVEreadGRD::getData  IS SUPPOSED TO DO ALL OF THE WORK OF READING THE DATA. 
function DAVEreadGRD::getData,oData
compile_opt idl2

print,'DAVEreadGRD::getData'

  catch,err
  if err ne 0 then begin
    catch,/cancel
    return,0
  endif

  oTool = self->getTool()
  if (not obj_valid(oTool)) then return,0
  
  filename = self->getFilename()

  ;NOW I NEED TO CALL threeDenPro_readGRD
  ret = 1
  ret = threeDenPro_readgrid(abc,abg,vol,nx,ny,nz,fn=filename,x=x,y=y,z=z,datapath=datapath)

  abcdata = obj_new('idlitDataIDLVector',abc,name='abc',type='IDLVECTOR')
  abgdata = obj_new('idlitDataIDLVector',abg,name='abg',type='IDLVECTOR')
  voldata = obj_new('IDLitDataIDLArray3d',vol,name='vol',type='IDLARRAY3D')
  nxdata = obj_new('idlitdata',nx,name='nx')
  nydata = obj_new('idlitdata',ny,name='ny')
  nzdata = obj_new('idlitdata',nz,name='nz')
  xdata = obj_new('idlitDataIDLVector',x,name='x')
  ydata = obj_new('idlitDataIDLVector',y,name='y')
  zdata = obj_new('idlitDataIDLVector',z,name='z')

  datapathdata = obj_new('idlitdata',datapath,name='datapath',type='STRING')  
  
  filenamedata = obj_new('idlitdata',filename,name='filename',type='STRING')
  


  ;NOW I NEED TO CONVERT THIS TO AN OBJECT 
  ;THE DATA WILL BE PUT INTO oData.
;  oData = obj_new('IDLitParameterSet',name=file_basename(filename),identifier='id_'+filename,type='DAVEGRDDATASET')
  oData = obj_new('IDLitParameterSet',name=file_basename(filename),identifier='id_'+file_basename(filename),type='DAVEGRDDATASET')
  oData->add,voldata,parameter_name='vol'

  oData->add,xdata,parameter_name='x'
  oData->add,ydata,parameter_name='y'
  oData->add,zdata,parameter_name='z'

  oData->add,nxdata,parameter_name='nx'
  oData->add,nydata,parameter_name='ny'
  oData->add,nzdata,parameter_name='nz'

  oData->add,abcdata,parameter_name='abc'
  oData->add,abgdata,parameter_name='abg'
  
  odata->add,datapathdata,parameter_name='datapath'
  oData->add,filenamedata,parameter_name='filename'


  return,ret

end;DAVEreadGRD::getData


;----------------------------------------------------------------------------
; Purpose:
;   This reader reads GRD data.
;
function DAVEReadGRD::Init, _Ref_Extra=etc
    compile_opt idl2, hidden

  print,'DAVEReadGRD::Init'
    ; Init superclass
    if (self->IDLitReader::Init(['grd','GRD'], $
        NAME='GRID Density File', $
        DESCRIPTION="GRID Density File (GRD)", $
        _EXTRA=_extra) eq 0) then $
        return, 0

    if n_elements(etc) gt 0 then self->setProperty,_Extra=etc

    return, 1
end;DAVEReadGRD::Init


;---------------------------------------------------------------------------
; Definition
;---------------------------------------------------------------------------
; DAVEReadGRD__Define
;
; Purpose:
; Class definition for the DAVEReadGRD class
;

pro DAVEReadGRD__Define
  ; Pragmas
  compile_opt idl2, hidden
print,'DAVEReadGRD__Define'

  void = {DAVEReadGRD, $
          inherits IDLitReader}
end;DAVEReadGRD__Define


