;************************************************************************************************
pro dcs_multiplot_Saveplot,event
;************************************************************************************************
; This routine saves the information required to restore the plot. This
; information is contained in pState.
;
compile_opt strictarr
;
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'dcs_multiplot_saveplot: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif

widget_control,event.top,get_uvalue=pState

filename=dialog_pickfile(title="Enter saved plot file name.",filter="*.plt",$
    path=(*pState).workdir)
if (filename eq "") then return
if (strpos(filename,".plt") eq -1) then filename=filename+".plt"
;

tmp=(*pState).plotWin
(*pState).plotWin=obj_new()
;
save,filename=filename,pState
;
(*pState).plotWin=tmp
widget_control,event.top,set_uvalue=pState
;
end


;************************************************************************************************
pro dcs_multiplot_Restoreplot,event
;************************************************************************************************
; This routine reads in a saved plot file, restores the information to the
; appropriate variables and resconstructs the plot.
;
compile_opt strictarr
;
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'dcs_multiplot_restoreplot: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif


widget_control,event.top,get_uvalue=pState
;
filename=dialog_pickfile(title="Enter name of plot file to be restored.",$
filter="*.plt",path=(*pState).workdir)
if (filename eq "") then return
;
; First of all store the current values of the pixmap and screen windows,
; the draw window, and all the various widget IDs created in the widget
; definition module.
objectgraphics=(*pState).objectgraphics
plotWin=(*pState).plotWin
drawbase=(*pState).drawbase
winPix=(*pState).winstate.winPix
winVis=(*pState).winstate.winVis
drawwindow=(*pState).winstate.drawwindow
filemenu=(*pState).filemenu
    filebutton_print=(*pState).filebutton_print
    filebutton_printer=(*pState).filebutton_printer
    filebutton_ps=(*pState).filebutton_ps
    filebutton_splot=(*pState).filebutton_splot
    filebutton_rplot=(*pState).filebutton_rplot
    filebutton_sdata=(*pState).filebutton_sdata
    filebutton_mplot=(*pState).filebutton_mplot
abscmenu=(*pState).abscmenu
    abscbutton_x=(*pState).abscbutton_x
    abscbutton_y=(*pState).abscbutton_y
grupmenu=(*pState).grupmenu
    grupbutton_single=(*pState).grupbutton_single
    grupbutton_several=(*pState).grupbutton_several
    grupbutton_all=(*pState).grupbutton_all
gnopmenu=(*pState).gnopmenu
    gnopbutton_errorbar=(*pState).gnopbutton_errorbar
    gnopbutton_joinpts=(*pState).gnopbutton_joinpts
    gnopbutton_showgrid=(*pState).gnopbutton_showgrid
    gnopbutton_crosshair=(*pState).gnopbutton_crosshair
    gnopbutton_normalize=(*pState).gnopbutton_normalize
    gnopbutton_plotsettings=(*pState).gnopbutton_plotsettings
    gnopbutton_plotsetdefs=(*pState).gnopbutton_plotsetdefs
rawxmenu=(*pState).rawxmenu
    rawxbutton_plotvst=(*pState).rawxbutton_plotvst
    rawxbutton_plotvsE=(*pState).rawxbutton_plotvsE
    rawxbutton_plott4E=(*pState).rawxbutton_plott4E
    rawxbutton_plott4EDB=(*pState).rawxbutton_plott4EDB
    rawxbutton_plotdos=(*pState).rawxbutton_plotdos
    rawxbutton_plotdosDB=(*pState).rawxbutton_plotdosDB
    rawxbutton_revert=(*pState).rawxbutton_revert
rawymenu=(*pState).rawymenu
    rawybutton_plotv2th=(*pState).rawybutton_plotv2th
    rawybutton_plotva2th=(*pState).rawybutton_plotva2th
    rawybutton_revert=(*pState).rawybutton_revert
dsetmenu=(*pState).dsetmenu
    dsetbutton_activ=(*pState).dsetbutton_activ
    dsetbutton_hilite=(*pState).dsetbutton_hilite
    dsetbutton_renorm=(*pState).dsetbutton_renorm
    dsetbutton_rotate=(*pState).dsetbutton_rotate
    dsetbutton_temper=(*pState).dsetbutton_temper
showmenu=(*pState).showmenu
    showbutton_duration=(*pState).showbutton_duration
prefmenu=(*pState).prefmenu
    prefbutton_dirobj=(*pState).prefbutton_dirobj
    prefbutton_masking=(*pState).prefbutton_masking
    prefbutton_detnumb=(*pState).prefbutton_detnumb
;
mainbase=(*pState).mainbase
base1row1=(*pState).base1row1
    butt_groupcenter=(*pState).butt_groupcenter
    butt_grouphwidth=(*pState).butt_grouphwidth
    butt_abscrebin=(*pState).butt_abscrebin
base1row2=(*pState).base1row2
    butt_xmin=(*pState).butt_xmin
    butt_xmax=(*pState).butt_xmax
    butt_ymin=(*pState).butt_ymin
    butt_ymax=(*pState).butt_ymax
base2row1=(*pState).base2row1
    butt_numgroups=(*pState).butt_numgroups
    butt_groupnumber=(*pState).butt_groupnumber
base2row2=(*pState).base2row2
    textcoord=(*pState).textcoord
    textgroup=(*pState).textgroup
;
infobase=(*pState).infobase
infowindow=(*pState).infowindow
;remove the existing pointers in pState
if (ptr_valid(pState)) then begin
	tags=tag_names(*pState)
    if (ptr_valid((*pState).pqty)) then ptr_free,(*pState).pqty
    if (ptr_valid((*pState).perr)) then ptr_free,(*pState).perr
    if (ptr_valid((*pState).px)) then ptr_free,(*pState).px
    if (ptr_valid((*pState).py)) then ptr_free,(*pState).py
    if (ptr_valid((*pState).tchansPtr)) then ptr_free,(*pState).tchansPtr
    if (ptr_valid((*pState).timesPtr)) then ptr_free,(*pState).timesPtr
    if (ptr_valid((*pState).energiesPtr)) then ptr_free,(*pState).energiesPtr
    if (ptr_valid((*pState).activePtr)) then ptr_free,(*pState).activePtr
    if (ptr_valid((*pState).hilitePtr)) then ptr_free,(*pState).hilitePtr
    if (ptr_valid((*pState).multiplierPtr)) then ptr_free,(*pState).multiplierPtr
    if (ptr_valid((*pState).constantsPtr)) then ptr_free,(*pState).constantsPtr
    if (ptr_valid((*pState).filesPtr)) then ptr_free,(*pState).filesPtr
    if (ptr_valid((*pState).durationsPtr)) then ptr_free,(*pState).durationsPtr
    if (ptr_valid((*pState).srdenomsPtr)) then ptr_free,(*pState).srdenomsPtr
    if (ptr_valid((*pState).temperaturesPtr)) then ptr_free,(*pState).temperaturesPtr
    if (ptr_valid((*pState).commentsPtr)) then ptr_free,(*pState).commentsPtr
    if (ptr_valid((*pState).ksPtr)) then ptr_free,(*pState).ksPtr
    if (ptr_valid((*pState).kePtr)) then ptr_free,(*pState).kePtr
    index=where(tags eq strupcase('informationPtr'))
		if (index ge 0) then begin
    	if (ptr_valid((*pState).informationPtr)) then ptr_free,(*pState).informationPtr
    endif
    if (ptr_valid((*pState).pmask)) then ptr_free,(*pState).pmask
    if ((*pState).nodavePtr) then begin
       ptr_free,(*(*(*pState).davePtr).dataStrPtr).commonStr.histPtr
       ptr_free,(*(*(*pState).davePtr).dataStrPtr).commonStr.treatmentPtr
       ptr_free,(*(*(*pState).davePtr).dataStrPtr).specificPtr
       ptr_free,(*(*pState).davePtr).dataStrPtr
       ptr_free,(*pState).davePtr
    endif
    ptr_free,pState
endif
;
; Now restore the plot.
restore,filename=filename
tags=tag_names(*pState)
nt=n_elements(tags)
if (nt lt 167) then begin
	res=dialog_message(["N.B. Number of tags ="+strcompress(nt)+"<166",$
	"'Restore plot' may not work properly",$
	"since the .plt file is somewhat old.",$
	"If this is a problem please inform us."])
endif
;
; Next, substitute, back into pState, the current values of the pixmap and
; screen windows, the draw window, and all the various widget IDs created in
; the widget definition module.
obj_destroy,(*pState).plotWin
if (*pState).objectgraphics ne objectgraphics then begin
   (*pState).objectgraphics=objectgraphics
   (*pState).symsize=([0.8,0.006])[(*pState).objectgraphics]
endif
(*pState).plotWin=plotWin
(*pState).drawbase=drawbase
(*pState).winstate.winPix=winPix
(*pState).winstate.winVis=winVis
(*pState).winstate.drawwindow=drawwindow
(*pState).filemenu=filemenu
    (*pState).filebutton_print=filebutton_print
    (*pState).filebutton_printer=filebutton_printer
    (*pState).filebutton_ps=filebutton_ps
    (*pState).filebutton_splot=filebutton_splot
    (*pState).filebutton_rplot=filebutton_rplot
    (*pState).filebutton_sdata=filebutton_sdata
    (*pState).filebutton_mplot=filebutton_mplot
(*pState).abscmenu=abscmenu
    (*pState).abscbutton_x=abscbutton_x
    (*pState).abscbutton_y=abscbutton_y
(*pState).grupmenu=grupmenu
    (*pState).grupbutton_single=grupbutton_single
    (*pState).grupbutton_several=grupbutton_several
    (*pState).grupbutton_all=grupbutton_all
(*pState).gnopmenu=gnopmenu
    (*pState).gnopbutton_errorbar=gnopbutton_errorbar
    (*pState).gnopbutton_joinpts=gnopbutton_joinpts
    (*pState).gnopbutton_showgrid=gnopbutton_showgrid
    (*pState).gnopbutton_crosshair=gnopbutton_crosshair
    (*pState).gnopbutton_normalize=gnopbutton_normalize
    (*pState).gnopbutton_plotsettings=gnopbutton_plotsettings
    (*pState).gnopbutton_plotsetdefs=gnopbutton_plotsetdefs
(*pState).rawxmenu=rawxmenu
    (*pState).rawxbutton_plotvst=rawxbutton_plotvst
    (*pState).rawxbutton_plotvsE=rawxbutton_plotvsE
    (*pState).rawxbutton_plott4E=rawxbutton_plott4E
    (*pState).rawxbutton_plott4EDB=rawxbutton_plott4EDB
    (*pState).rawxbutton_plotdos=rawxbutton_plotdos
    (*pState).rawxbutton_plotdosDB=rawxbutton_plotdosDB
    (*pState).rawxbutton_revert=rawxbutton_revert
(*pState).rawymenu=rawymenu
    (*pState).rawybutton_plotv2th=rawybutton_plotv2th
    (*pState).rawybutton_plotva2th=rawybutton_plotva2th
    (*pState).rawybutton_revert=rawybutton_revert
(*pState).dsetmenu=dsetmenu
    (*pState).dsetbutton_activ=dsetbutton_activ
    (*pState).dsetbutton_hilite=dsetbutton_hilite
    (*pState).dsetbutton_renorm=dsetbutton_renorm
    (*pState).dsetbutton_rotate=dsetbutton_rotate
    (*pState).dsetbutton_temper=dsetbutton_temper
(*pState).showmenu=showmenu
    (*pState).showbutton_duration=showbutton_duration
(*pState).prefmenu=prefmenu
    (*pState).prefbutton_dirobj=prefbutton_dirobj
    (*pState).prefbutton_masking=prefbutton_masking
    (*pState).prefbutton_detnumb=prefbutton_detnumb
;
(*pState).mainbase=mainbase
(*pState).base1row1=base1row1
    (*pState).butt_groupcenter=butt_groupcenter
    (*pState).butt_grouphwidth=butt_grouphwidth
    (*pState).butt_abscrebin=butt_abscrebin
(*pState).base1row2=base1row2
    (*pState).butt_xmin=butt_xmin
    (*pState).butt_xmax=butt_xmax
    (*pState).butt_ymin=butt_ymin
    (*pState).butt_ymax=butt_ymax
(*pState).base2row1=base2row1
    (*pState).butt_numgroups=butt_numgroups
    (*pState).butt_groupnumber=butt_groupnumber
(*pState).base2row2=base2row2
    (*pState).textcoord=textcoord
    (*pState).textgroup=textgroup
;
(*pState).infobase=infobase
(*pState).infowindow=infowindow
;
; Start sensitizing widgets.
;
; Sensitize the menu widgets.
readDAVE=widget_info(event.top,find_by_uname="readDAVE")
readDCS=widget_info(event.top,find_by_uname="readDCS")
readDCShigh=widget_info(event.top,find_by_uname="readDCShigh")
readDAVEsum=widget_info(event.top,find_by_uname="readDAVEsum")
readDCSsum=widget_info(event.top,find_by_uname="readDCSsum")
readingDAVE=(1-(*pState).readingDCS) and (1-(*pState).readingDCShigh)
widget_control,readDCS,sensitive=(*pState).readingDCS
widget_control,readDCShigh,sensitive=(*pState).readingDCShigh
widget_control,readDAVE,sensitive=readingDAVE
widget_control,readDCSsum,sensitive=(*pState).readingDCS
widget_control,readDAVEsum,sensitive=readingDAVE
widget_control,(*pState).filebutton_print,/sensitive
widget_control,(*pState).filebutton_splot,/sensitive
widget_control,(*pState).filebutton_sdata,/sensitive
widget_control,(*pState).abscmenu,/sensitive
widget_control,(*pState).grupmenu,/sensitive
widget_control,(*pState).gnopmenu,/sensitive
widget_control,(*pState).rawxmenu,sensitive=((*pState).readingDCS and (*pState).plot_vs_x)
widget_control,(*pState).rawymenu,sensitive=((*pState).readingDCS and (*pState).plot_vs_y)
widget_control,(*pState).dsetmenu,/sensitive
widget_control,(*pState).dsetbutton_rotate,sensitive=(*pState).readingDCS and (*pState).equaltimes
widget_control,(*pState).dsetbutton_temper,sensitive=(*pState).readingDCS
widget_control,(*pState).showmenu,/sensitive
;
; Sensitize the rebin button.
widget_control,(*pState).butt_abscrebin,/sensitive
;
; Set the sensitivity of the "Number of groups" button.
if ((*pState).one) then widget_control,(*pState).base2row1,sensitive=0
if ((*pState).some) then widget_control,(*pState).base2row1,sensitive=1
if ((*pState).all) then widget_control,(*pState).base2row1,sensitive=0
;
; Define slider maximum values and current values.
dims=[(*pState).xdim,(*pState).ydim]
plotx=(*pState).plot_vs_x
widget_control,(*pState).butt_numgroups,set_slider_max=dims[plotx]; (used to be 31)
widget_control,(*pState).butt_groupcenter,set_slider_max=dims[plotx]
widget_control,(*pState).butt_grouphwidth,set_slider_max=dims[plotx]/2
widget_control,(*pState).butt_abscrebin,set_slider_max=dims[1-plotx]/10 > 6
;
; If plotting vs. x (y), index = 0 (1).
index=1-(*pState).plot_vs_x
;
if (plotx) then begin
    widget_control,(*pState).butt_numgroups,set_value=(*pState).yngroups
    widget_control,(*pState).butt_groupnumber,set_slider_max=(*pState).yngroups
    widget_control,(*pState).butt_groupnumber,set_value=(*pState).ygroupnum
    widget_control,(*pState).butt_groupcenter,set_value=(*pState).yvalue
    widget_control,(*pState).butt_grouphwidth,set_value=(*pState).ywidth
    widget_control,(*pState).butt_abscrebin,set_value=(*pState).xrebin
endif else begin
    widget_control,(*pState).butt_numgroups,set_value=(*pState).xngroups
    widget_control,(*pState).butt_groupnumber,set_slider_max=(*pState).xngroups
    widget_control,(*pState).butt_groupnumber,set_value=(*pState).xgroupnum
    widget_control,(*pState).butt_groupcenter,set_value=(*pState).xvalue
    widget_control,(*pState).butt_grouphwidth,set_value=(*pState).xwidth
    widget_control,(*pState).butt_abscrebin,set_value=(*pState).yrebin
endelse
;
; Set x and y plot ranges.
widget_control,(*pState).butt_xmin,set_value=strcompress((*pState).winState.xrange[0,index])
widget_control,(*pState).butt_xmax,set_value=strcompress((*pState).winState.xrange[1,index])
widget_control,(*pState).butt_ymin,set_value=strcompress((*pState).winState.yrange[0,index])
widget_control,(*pState).butt_ymax,set_value=strcompress((*pState).winState.yrange[1,index])
;
; Populate the file information box.
n=n_elements(*(*pState).filesPtr)
index=where(tags eq strupcase('informationPtr'))
if (index lt 0) then begin
	information=strcompress(string(indgen(n)+1))+"  "+*(*pState).filesPtr
endif else begin
	information=*(*pState).informationPtr
endelse
widget_control,(*pState).infowindow,set_value=information
;
; Update labels on certain menu items.
if (plotx) then begin
    widget_control,(*pState).abscbutton_x,set_value='['+(*pState).xlabel+']'
    widget_control,(*pState).abscbutton_y,set_value=(*pState).ylabel
endif else begin
    widget_control,(*pState).abscbutton_x,set_value=(*pState).xlabel
    widget_control,(*pState).abscbutton_y,set_value='['+(*pState).ylabel+']'
endelse
;
if ((*pState).one) then begin
    widget_control,(*pState).grupbutton_single,set_value='[Single group]'
    widget_control,(*pState).grupbutton_several,set_value='Several groups'
    widget_control,(*pState).grupbutton_all,set_value='All in one group'
endif
if ((*pState).some) then begin
    widget_control,(*pState).grupbutton_single,set_value='Single group'
    widget_control,(*pState).grupbutton_several,set_value='[Several groups]'
    widget_control,(*pState).grupbutton_all,set_value='All in one group'
endif
if ((*pState).all) then begin
    widget_control,(*pState).grupbutton_single,set_value='Single group'
    widget_control,(*pState).grupbutton_several,set_value='Several groups'
    widget_control,(*pState).grupbutton_all,set_value='[All in one group]'
endif
;
if ((*pState).plot_eb) then $
    widget_control,(*pState).gnopbutton_errorbar,set_value="Hide error bars" $
else widget_control,(*pState).gnopbutton_errorbar,set_value="Show error bars"
;
if ((*pState).join_pts eq 1) then $
    widget_control,(*pState).gnopbutton_joinpts,set_value="Do not join points"
if ((*pState).join_pts eq -1) then $
    widget_control,(*pState).gnopbutton_joinpts,set_value="Join points"
;
if ((*pState).show_grid eq 1) then $
    widget_control,(*pState).gnopbutton_showgrid,set_value="Do not show grid"
if ((*pState).show_grid eq -1) then $
    widget_control,(*pState).gnopbutton_showgrid,set_value="Show grid"
;
if ((*pState).cross_hair eq 1) then $
    widget_control,(*pState).gnopbutton_crosshair,set_value="Hide cursor cross hair"
if ((*pState).cross_hair eq -1) then $
    widget_control,(*pState).gnopbutton_crosshair,set_value="Show cursor cross hair"
;
if ((*pState).norm_d) then $
    widget_control,(*pState).gnopbutton_normalize,set_value="Do not normalize to duration" $
else widget_control,(*pState).gnopbutton_normalize,set_value="Normalize to duration"
;
; Update the plot.
;wset,(*pState).winstate.winPix
widget_control,event.top,set_uvalue=pState
dcs_multiplot_Plot,event
widget_control,event.top,get_uvalue=pState
;wset,(*pState).winstate.winVis
;device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winstate.winPix]
if (*pState).objectgraphics eq 0 then $
   wshow,(*pState).winstate.winVis
widget_control,event.top,set_uvalue=pState
;
end


;************************************************************************************************
pro dcs_multiplot_Clear,event
;************************************************************************************************
; This routine is used to clear the plot window and reset everything to initial
; conditions.
;
compile_opt strictarr
;
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'dcs_multiplot_clear: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif


widget_control,event.top,get_uvalue=pState
;
; Set the sensitivity of the menu widgets.
readDAVE=widget_info(event.top,find_by_uname="readDAVE")
readDCS=widget_info(event.top,find_by_uname="readDCS")
readDCShigh=widget_info(event.top,find_by_uname="readDCShigh")
readDAVEsum=widget_info(event.top,find_by_uname="readDAVEsum")
readDCSsum=widget_info(event.top,find_by_uname="readDCSsum")

widget_control,readDCS,sensitive=1
widget_control,readDCShigh,sensitive=1
widget_control,readDAVE,sensitive=1
widget_control,readDCSsum,sensitive=1
widget_control,readDAVEsum,sensitive=1
widget_control,(*pState).filebutton_print,sensitive=0
widget_control,(*pState).filebutton_splot,sensitive=0
widget_control,(*pState).filebutton_sdata,sensitive=0
widget_control,(*pState).abscmenu,sensitive=0
widget_control,(*pState).grupmenu,sensitive=0
widget_control,(*pState).gnopmenu,sensitive=0
widget_control,(*pState).rawxmenu,sensitive=0
widget_control,(*pState).rawymenu,sensitive=0
widget_control,(*pState).dsetmenu,sensitive=0
widget_control,(*pState).showmenu,sensitive=0
widget_control,(*pState).prefmenu,sensitive=1
;
; Sensitize the rebin button.
widget_control,(*pState).butt_abscrebin,sensitive=1
;
; Define slider maximum values and current values.
widget_control,(*pState).butt_numgroups,set_slider_max=1; (used to be 31)
widget_control,(*pState).butt_numgroups,set_value=1
widget_control,(*pState).butt_groupnumber,set_slider_max=1
widget_control,(*pState).butt_groupnumber,set_value=0
;
widget_control,(*pState).butt_groupcenter,set_slider_max=100
widget_control,(*pState).butt_grouphwidth,set_slider_max=100
widget_control,(*pState).butt_abscrebin,set_slider_max=100
widget_control,(*pState).butt_groupcenter,set_value=1
widget_control,(*pState).butt_grouphwidth,set_value=0
widget_control,(*pState).butt_abscrebin,set_value=1
;
; Clear the file information box.
widget_control,(*pState).infowindow,set_value=""
;
; Update labels on certain menu items.
widget_control,(*pState).abscbutton_x,set_value='x: (not yet defined)'
widget_control,(*pState).abscbutton_y,set_value='y: (not yet defined)'
;
widget_control,(*pState).grupbutton_single,set_value='Single group'
widget_control,(*pState).grupbutton_several,set_value='Several groups'
widget_control,(*pState).grupbutton_all,set_value='[All in one group]'
;
widget_control,(*pState).gnopbutton_errorbar,set_value="Show error bars"
widget_control,(*pState).gnopbutton_joinpts,set_value="Join points"
widget_control,(*pState).gnopbutton_showgrid,set_value="Show grid"
widget_control,(*pState).gnopbutton_crosshair,set_value="Show cursor cross hair"
widget_control,(*pState).gnopbutton_normalize,set_value="Normalize to duration"
;
widget_control,(*pState).prefbutton_masking,set_button=0
widget_control,(*pState).prefbutton_detnumb,set_button=0
;
; Initialize variables in (*pState).winstate
(*pState).winstate.xbox=[0.0,1.0]
(*pState).winstate.xrange=[[0.0d0,1.0d0],[0.0d0,1.0d0]]
(*pState).winstate.ybox=[0.0,1.0]
(*pState).winstate.yrange=[[0.0d0,1.0d0],[0.0d0,1.0d0]]
(*pState).winstate.autoscale=[1,1]
;
; Initialize variables in (*pState)
(*pState).xngroups=1
(*pState).xgroupnum=0
(*pState).yngroups=1
(*pState).ygroupnum=0
(*pState).ndatasets=0
(*pState).xvalue=1
(*pState).yvalue=1
(*pState).xwidth=0
(*pState).ywidth=0
(*pState).xrebin=1
(*pState).yrebin=1
(*pState).plot_vs_x=1
(*pState).plot_vs_y=0
(*pState).plot_eb=0
(*pState).join_pts=-1
(*pState).show_grid=-1
(*pState).cross_hair=-1
(*pState).norm_d=0
(*pState).dmask=0
(*pState).dnumb=0
(*pState).plotv2th=0
(*pState).plota2th=0
(*pState).plotvst=0
(*pState).plotvsE=0
(*pState).plott4E=0
(*pState).plott4EDB=0
(*pState).plotdos=0
(*pState).plotdosDB=0
(*pState).one=0
(*pState).some=0
(*pState).all=1
(*pState).thick=(*pState).defthick
(*pState).symsize=(*pState).defsymsize
(*pState).initsym=(*pState).definitsym
(*pState).fadefactor=(*pState).deffadefactor
;
(*pState).xdim=1
(*pState).ydim=1
;
if (*pState).objectgraphics then $
   (*pState).plotWin->erase $
else begin
   ; Clear the pixmap window and copy it to the screen window.
   wset,(*pState).winstate.winPix
   xsize=!d.x_size
   ysize=!d.y_size
   wdelete,(*pState).winstate.winPix
   window,/free,/pixmap,xsize=xsize,ysize=ysize
   winPix=!d.window
   (*pState).winstate.winPix=winPix
   wset,(*pState).winstate.winVis
   device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winstate.winPix]
   wshow,(*pState).winstate.winVis
endelse
; Save everything in the pointer pState.
widget_control,event.top,set_uvalue=pState
;
end


