; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro DCSToolsRevenge_cleanup,tlb
;************************************************************************************************
;
compile_opt strictarr
;
end


;************************************************************************************************
pro DCSToolsRevenge_handler,event
;************************************************************************************************
;
compile_opt strictarr
;
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'DCSToolsRevenge_handler: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif


widget_control,event.top,get_uvalue=state
intab1=state.intab1
intab2=state.intab2
outtab1=state.outtab1
outlist=state.outlist
calc=state.calc
examp=state.examp
done=state.done
input1=state.input1
input2=state.input2
id=event.id
;
if (id eq done) then begin
	widget_control,event.top,/destroy
	return
endif
;
values=strarr(7)
if (id eq examp) then begin
	input1={ms:'20000.0  ',scs:'15000.0  ',sc:'5  '}
endif else widget_control,intab1,get_value=input1
widget_control,intab1,set_value=input1
;
if (id eq examp) then begin
  phases=[24.96,12.52,195.39,312.02,307.20,136.58,124.16]
endif else widget_control,intab2,get_value=phases
input2[0,*]=string(format="(f10.2)",phases)+"  "
widget_control,intab2,set_value=input2
;
if (id eq calc) then begin
	speeds=fltarr(7)+input1.ms
	speeds[input1.sc-1]=input1.scs
	phases=float(phases)
	dcs_calculate_revenge,speeds,phases,distances,angles,$
		wavelength,mspeed,resmode,num,denom,slowchopper,calcphases,error
	outline=strarr(6)
	errmsg=0
	if (strlen(error) gt 0) then begin
		outline[0]=error
		widget_control,outlist,set_value=outline
	endif else begin
		diffs=phases-calcphases
		scn=input1.sc-1
		scdiff=diffs[scn]
		hstep=0.5*360.0/scn
		while (scdiff ge hstep) do scdiff=scdiff-2.0*hstep
		while (scdiff lt -hstep) do scdiff=scdiff+2.0*hstep
		diffs[scn]=scdiff
		calcphases[scn]=phases[scn]-diffs[scn]
		outline[0]="Wavelength = "+strcompress(wavelength)
		outline[1]="Master speed = "+strcompress(mspeed)
		outline[2]="Resolution mode = "+strcompress(resmode)
		outline[3]="Slow chopper speed ratio = "+$
			strcompress(num)+"/"+strcompress(denom,/remove_all)
		criterion=max(abs(diffs))
		if (criterion gt 0.05) then outline[5]=$
			"WARNING: Calculated phases do not quite agree with actual phases."
		if (criterion gt 0.5) then begin
			outline=strarr(6)
			outline[0]=$
			"FATAL: Calculated phases do not agree with actual phases."
		endif
		widget_control,outlist,set_value=outline
		output=strarr(4,7)
		output[0,*]=[string(format="(f10.1)",speeds)]
		output[1,*]=[string(format="(f10.2)",phases)]
		output[2,*]=[string(format="(f10.2)",calcphases)]
		output[3,*]=[string(format="(f10.2)",diffs)+"  "]
		widget_control,outtab1,set_value=output
	endelse
endif
;
end


;************************************************************************************************
pro DCSToolsRevenge,$
	group_leader = group_leader,$
;	notify_ids = notify_ids,$
	register_name = register_name, $
	_EXTRA=etc

;************************************************************************************************
;
compile_opt strictarr
;
;
;;;;;;;added following 4 lines for non-modal widget action
if n_elements(group_leader) eq 0 then group_leader = 0L
;if n_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
if n_elements(register_name) eq 0 then register_name = 'DCSToolsRevenge'
if xregistered(register_name) then return
;
; Lines commented out.
;widget_control,group_leader,get_uvalue=statePtr
;davePtr=(*statePtr).davePtr
dcs_sysvars,davePtr=davePtr
;
; Lines commented out.
;tvlct,r,g,b,/get
;rgbptr=ptr_new({r:r,g:g,b:b})
;
input1={ms:"  ",scs:"  ",sc:" 5  "}
input2=strarr(1,7)
;
input_names1=["Master speed","Slow chopper speed","Slow Chopper"]
input_names2=string("  Chopper")+strcompress(indgen(7)+1)+string(" Phase   ")
output_names=string("Chopper")+strcompress(indgen(7)+1)
column_labels=["Speed","Input Phase","Calc. Phase","Difference"]
output=strarr(4,7)
column_widths=[70,70,70,70]
;
title="Revenge calculation using chopper speeds and phases to "+$
	"determine wavelength etc."
tlb=widget_base(title=title,/col,group_leader=group_leader)
	tables=widget_base(tlb,/row)
	buttons=widget_base(tlb,/row)
	intab=widget_base(tables,/col)
	intab1=widget_table(intab,/editable,/sensitive,column_widths=[80],$
		column_labels=["INPUT "],row_labels=input_names1,xsize=1,ysize=3,$
		/column_major,value=input1,alignment=2)
	intab2=widget_table(intab,/editable,/sensitive,column_widths=[80],$
		column_labels=["INPUT "],row_labels=input_names2,xsize=1,ysize=7,$
		value=input2,alignment=2)
	outtab=widget_base(tables,/col)
	outtab1=widget_table(outtab,column_widths=column_widths,$
		column_labels=column_labels,row_labels=output_names,xsize=4,ysize=7,$
		value=output,alignment=2)
	outlist=widget_list(outtab,xsize=20,ysize=6)
	examp=widget_button(buttons,value="Example input")
	calc=widget_button(buttons,value="Calculate")
	done=widget_button(buttons,value="Done")
widget_control,tlb,/realize
;
state={intab1:intab1,intab2:intab2,outtab1:outtab1,outlist:outlist,$
	calc:calc,examp:examp,done:done,input1:input1,input2:input2}
widget_control,tlb,set_uvalue=state
widget_control,outlist,set_value=strarr(8)
;
output=strarr(5,7)
widget_control,outtab1,set_value=output
;
; added register_name variable to the call to xmanager.
xmanager,register_name,tlb,/no_block,cleanup='DCSToolsRevenge_cleanup',$
	event_handler="DCSToolsRevenge_handler"
;
; Lines commented out.
;dave_makeDavePtr,davePtr=davePtr
;(*statePtr).davePtr=davePtr
;tvlct,(*rgbptr).r,(*rgbptr).g,(*rgbptr).b
;ptr_free,rgbptr
;
end
