; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_superstring_wrap,insuperstring,maxlen,outsuperstring,err
;************************************************************************************************
;
compile_opt strictarr
;
; This procedure wraps an input string called "instring",
; creating an output string array called "outstring" which
; consists of 1 or more strings, each of which is no longer
; than maxlen. On normal output err=0, abnormal output err<>0.
;	A "\\" in the input string means start a new line.
; To include a blank line use "\\ \\"
;
; A test input string is used if instring is null.;
if (strlen(insuperstring) eq 0) then insuperstring=$
"The 1st cat sat on the mat.  The 2nd cat sat on the mat.   "+$
"The 3rd cat sat on the mat.\\ \\  The 4th cat sat on the mat.   "+$
"The 5th cat sat on the mat.  The 6th cat sat on the mat.   "+$
"The 7th cat sat on the mat. \\ The 8th cat sat on the mat.   "+$
"The 9th cat sat on the mat.  The 10th cat sat on the mat.   "
;
; Break input superstring into paragraphs.
instrings=strsplit(insuperstring,'\\',/extract)
;
; Create temporary output superstring array. The length of this array
; is obtained from an estimate based on the total number of characters
; and the maximum line length.
maxlines=fix(strlen(insuperstring)/maxlen*3+1)
maxlines=maxlines>100
wrapped_superstring=strarr(maxlines)
;
superstringline=-1
for k=0,n_elements(instrings)-1 do begin
	instring=instrings[k]
	words=strsplit(instring,' ',/extract)
	nwords=n_elements(words); number of words
	nchars=long(total(strlen(words))); number of characters (other than spaces)
;
; Create temporary output string array. The length of this array is obtained from an
; estimate based on the total number of characters and the maximum line lemgth.
	maxlines=fix(strlen(instring)/maxlen*3+1)
	wrapped_string=strarr(maxlines)
;
; Loop over words in input string.
	wrapped_string[0]=words[0]
	line=0
	err=0
	for i=1,nwords-1 do begin
		str_temp=wrapped_string[line]+" "+words[i]
		if (strlen(str_temp) le maxlen) then begin
			wrapped_string[line]=str_temp
		endif else begin
			line=line+1
			if (line+1 gt maxlines) then begin
				err=-1
				if (!debug) then print," FAILURE IN superstring_wrap.pro: #lines > maxlines"
				return
			endif
			wrapped_string[line]=words[i]
		endelse
	endfor
;
; Create output string array.
	nlines=line+1
	outstring=strarr(nlines)
	nwords_out=0l
	nchars_out=0l
	for line=0,nlines-1 do begin
		outstring[line]=wrapped_string[line]
		words_out=strsplit(outstring[line],' ',/extract)
		nwords_out=nwords_out+n_elements(words_out)
		nchars_out=nchars_out+fix(total(strlen(words_out)))
	endfor
;
; Errors occur if the numbers of words and/or the numbers of
; characters for the input and output strings do not match.
	if (nwords ne nwords_out) then begin
		if (!debug) then print," FAILURE IN superstring_wrap.pro: #words in ne #words out"
		err=1
	endif
	if (nchars ne nchars_out) then begin
		if (!debug) then print," FAILURE IN superstring_wrap.pro: #chars in ne #chars out"
		err=2
	endif
;
	for line=0,nlines-1 do begin
		superstringline=superstringline+1
		wrapped_superstring[superstringline]=outstring[line]
	endfor
endfor
;
nlines=superstringline+1
outsuperstring=wrapped_superstring[0:superstringline]
end