; $Id: dm_plot_slice.pro,v 1.35 2016/03/31 17:01:38 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_plot_slice
;
; PURPOSE:
;  plot the slice
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  March, 2025
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

pro dcs_mslice::dm_plot_slice,overplot=overplot,surfplot=surfplot
    if (~ self->pd_valid()) then return
    WIDGET_CONTROL,/HOURGLASS
    
    ;select data
    if (~self.errbar) or ((self.samp_typ ge 0) and self.absp_asint) then $
       self->dm_choose_slicedata,xdat=xdat,ydat=ydat,zdat=zdat,xinfo=xinfo,xtit=xtit,yinfo=yinfo,ytit=ytit,ztit=ztit,zmin=zmin,surfplot=surfplot,extra_tit=extra_tit,error=error $
    else $
       self->dm_choose_slicedata,xdat=xdat,ydat=ydat,zdat=zdat,zerr=zerr,xinfo=xinfo,xtit=xtit,yinfo=yinfo,ytit=ytit,ztit=ztit,zmin=zmin,surfplot=surfplot,extra_tit=extra_tit,error=error
    
    if keyword_set(error) then return
    
    contourplot = (n_elements(xdat) eq n_elements(zdat))   
    usepolygon  = 1b

    ;extra info in the title
    if (strlen(self.titl_lab) eq 0) or (strlen(extra_tit) eq 0) then sep='' else sep=', '
    title = self.titl_lab+sep+extra_tit
    
    ;warning if data are not plotable
    if n_elements(xdat) lt 2 then mesg = 'xdat has only one data.'
    if n_elements(ydat) lt 2 then begin
       if n_elements(mesg) eq 0 then mesg = 'ydat has only one data.' $
       else mesg = [mesg,'ydat has only one data.']
    endif
    if n_elements(mesg) ne 0 then begin
       if (self.instrname eq 'macs') and (self.macsintn_typ ne 0) then mesg = [mesg,'Please try using SPEC detectors.']
       ok = dialog_message(mesg,dialog_parent=self.tlb,/error,/center)
       return
    endif

    ;plot the data
    isnew = 0b
    if self.useitool then begin
       ok = dialog_message('Itools plotting is not implemented yet. Soooorry!',dialog_parent=self.tlb)
       return
    endif else begin
       self.current = self->searchcurrent(crossplot=crossplot,keep=keep)
       if (~obj_valid(self.current)) or (keyword_set(crossplot) and (~keyword_set(overplot))) or keyword_set(keep) then begin
          self.current = obj_new('dm_plot',xdat,ydat,zdat,zerr=zerr,xtit=xtit,ytit=ytit,ztit=ztit,itit=ztit,xsize=(*self.pdim_list)[0,self.pdim_choice],ysize=(*self.pdim_list)[1,self.pdim_choice],$
                /no_copy,parentobj=self,xran=self.slice_xran,yran=self.slice_yran,shading=self.slice_shading,coltable=self.slice_color,iran=self.slice_iran,title=title,zmin=zmin,surfplot=surfplot,$
                contourplot=contourplot,usepolygon=usepolygon,/hidelegend,path=self.dirs[1],background=(['black','white'])[self.pbgcol_bw],vt_col=self.ppvc_choice,render_method=self.ptrm_choice,$
                tickdir=self.tdir_choice,notooltip=self.pnotooltip,/isolatin1,xinfo=xinfo,yinfo=yinfo,qoffsetthreshold=self.qoffsetthreshold,cutcolor=self.slice_cutcolor,wtitle='Slice')
          isnew = 1b & crossplot = 0b
       endif else begin
          if keyword_set(overplot) then $
             self.current->add_plot,xdat,ydat,zdat,zerr=zerr,itit=ztit,/no_copy,shading=self.slice_shading,coltable=self.slice_color,usepolygon=usepolygon,zmin=zmin,iran=self.slice_iran,contourplot=contourplot $
          else $
             self.current->setproperty,xdat=xdat,ydat=ydat,zdat=zdat,zerr=zerr,xtit=xtit,ytit=ytit,ztit=ztit,itit=ztit,/no_copy,vt_col=self.ppvc_choice,tickdir=self.tdir_choice,iso3dtype=0,gridontop=1,$
                xran=self.slice_xran,yran=self.slice_yran,shading=self.slice_shading,coltable=self.slice_color,iran=self.slice_iran,title=title,zmin=zmin,surfplot=surfplot,contourplot=contourplot,$
                cutcolor=self.slice_cutcolor,usepolygon=usepolygon,/nodraw,/hidelegend,bgcolor=self.pbgcol_bw,xinfo=xinfo,yinfo=yinfo,qoffsetthreshold=self.qoffsetthreshold,wtitle='Slice'
       endelse
       ;add powder lines in diffuse scattering mode and powder mode
       if ptr_valid(self.powd_line) then begin
          tmp = size(*self.powd_line)
          if tmp[0] eq 2 then tmp=1 else tmp=tmp[tmp[0]]
          if self.samp_typ eq 0 then begin    ;powder type
             if self.slice_y[0] eq 1 then ix = 1
             if self.slice_x[0] eq 1 then ix = 0
             if n_elements(ix) ne 0 then iy = 1-ix
          endif else begin
             ix = self.slice_x[self.samp_typ]
             iy = self.slice_y[self.samp_typ]
             if (self.instrname ne 'macs') and (self.instrname ne 'wand') then imax = 1+self.extravaxis_yn[0] else imax = 1
             if self.samp_typ ne 2 and n_elements(ix) ne 0 then begin ;check if elastic energy is covered
                if finite(self.slice_t1ran[0]) then begin
                   if self.slice_t1ran[0] gt 0 then ix = 100  ;not covered
                endif 
                if finite(self.slice_t1ran[1]) then begin
                   if self.slice_t1ran[1] lt 0 then ix = 100  ;not covered
                endif
             endif
             if max([ix,iy]) gt imax then iy = temporary(ix)  ;no powder line
          endelse
          if n_elements(ix) ne 0 then begin
             for i=0L,tmp-1 do begin
                 self.current->add_plot,(*self.powd_line)[*,ix,i],(*self.powd_line)[*,iy,i],psym='no symbol',$
                        color='dark yellow',linestyle='solid',layer=layer,legend=(['',(['Al','Cu','Stainless Steel','Specified'])[(self.powd_typ-1)>0]+' powder line'])[i eq 0]
             endfor
          endif
       endif
       if obj_valid(self.current) then self.current->draw else return
    endelse
    
    if ~keyword_set(crossplot) then begin
       title = ((strlen(self.titl_lab) eq 0)?xtit+' vs. '+ytit:title)
       if keyword_set(overplot) and (~isnew) then $
          self->dm_add_plotwindow,type=0,title=title+'[overplot]' $
       else $
          self->dm_add_plotwindow,type=0,title=title
    endif
end