; $Id: dm_choose_file.pro,v 1.13 2016/02/04 20:41:38 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_choose_file
;
; PURPOSE:
;  a simple function which opens a file dialog and will take care of the file extensions
;
; CATEGORY:
;  general
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  May, 2022
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

;parameter:
;   filetype:   scalar string, should be without '.', for multiple file types, use ',' to separate, eg. 'prm,txt'
function dm_choose_file,filetype,write=write,read=read,dialog_parent=dialog_parent,directory=directory,title=title,deviceKeywords=deviceKeywords,path=path,inch=inch,landscape=landscape,xsize=xsize,ysize=ysize,$
    xoffset=xoffset,yoffset=yoffset,_extra=_extra
    if n_elements(path) ne 0 then begin
       if file_test(path,/directory) then cd,path
    endif
    if n_elements(filetype) eq 0 then type='' $
    else type = strtrim(strlowcase(filetype),2)
    if type eq '' then $
       filter = '*' $
    else if (type eq 'jpg') or (type eq 'jpeg') then $
       filter = ['*.jpeg','*.jpg'] $
    else if (type eq 'ps') or (type eq 'eps') then $
       filter = ['*.ps','*.eps'] $
    else $
       filter = '*.'+strsplit(type,',',/extract)
    done = 0b
    if n_elements(title) eq 0 then begin
       title = 'Please select a '+type+([' ',''])[strlen(type) eq 0]+(['file','directory'])[keyword_set(directory)]
       if keyword_set(write) then title = title+' for writing'
    endif
    while (~ done) do begin
       done = 1b
       if ((type eq 'ps') or (type eq 'pdf')) and keyword_set(write) then begin
          if n_elements(inch) eq 0 then inch=1b
          if n_elements(xsize) eq 0 then xsize=5.5
          if n_elements(xoffset) eq 0 then xoffset=1.5
          if type eq 'ps' then $
             deviceKeywords = PSConfig(cancel=canceled,group_leader=dialog_parent,inch=inch,landscape=landscape,xsize=xsize,ysize=ysize,xoffset=xoffset,yoffset=yoffset,directory=path)$
          else $
             deviceKeywords = PDFConfig(cancel=canceled,group_leader=dialog_parent,inch=inch,landscape=landscape,xsize=xsize,ysize=ysize,xoffset=xoffset,yoffset=yoffset,directory=path,filename='idl.pdf')
          if canceled eq 1 then file='' else begin
             file = deviceKeywords.filename
             adir = file_test(file,/directory)
             if adir then begin
                ok   = dialog_message(file+' is a directory.',/error,dialog_parent=dialog_parent,/center)
                file = ''
             endif
          endelse
       endif else begin
          file = dialog_pickfile(filter=filter,read=read,write=write,dialog_parent=dialog_parent,title=title,directory=directory,_extra=_extra)
          file = strtrim(file,2)
       endelse
       if (strlen(file[0]) ne 0) then begin
          if keyword_set(write) then begin
             file = file[0]
             if (type ne '') and (type ne '*') then begin
                tmp = strsplit(file,'.',/extract) & count = n_elements(tmp)
                if count le 1 then file=file+'.'+type else begin
                   last = strlowcase(tmp[count-1])
                   tmp  = last+type
                   if last ne type then begin
                      if (tmp ne 'jpgjpeg') and (tmp ne 'jpegjpg') and (tmp ne 'pseps') and (tmp ne 'epsps') then $
                         file = file+'.'+type
                   endif
                endelse
             endif
             exist = file_test(file)
             if exist and ~keyword_set(directory) then begin
                ok = dialog_message([file+' already exists.','Do you want to replace it?'],/question,title='Save As',dialog_parent=dialog_parent,/center)
                if ok eq 'No' then done = 0b
             endif
          endif else if keyword_set(read) then begin
             exist = file_test(file,/read)
             if total(exist) ne n_elements(exist) then begin
                ok = dialog_message("Can't open the file '"+file+"'.",/error,dialog_parent=dialog_parent,/center)
                file = ''
             endif
          endif
       endif
    endwhile
    if (strlen(file[0]) ne 0) and (float(!version.release) ge 6.0) then begin
       if keyword_set(directory) then path = file[0] else path = file_dirname(file[0])
       if ~file_test(path,/directory,write=write) then begin
          ok = dialog_message(["Can't write in "+file[0]],dialog_parent=dialog_parent,/center)
          file = ''
       endif
    endif
    return,file
end