; $Id: dm_check_macskidney.pro,v 1.9 2016/04/07 17:45:21 ymqiu Exp $
;#######################################################################
; 
; NAME:
;  dm_check_macskidney
;
; PURPOSE:
;  check macs kideney angle to see if it is out of range
;  
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  January, 2018
; 
; HISTORY:
; 02/2013: use NG0 limits
; 04/2013: update with BT9 limits
; 08/2013: update after installing the proximity sensor stopper
; 04/2016: add 17 meV
; 01/2018: update after new floor
; 
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

;check kidney position, return the index of good kidney angles
;parameters:
;  kidney:      kidney angles [nkid], software angle
;  Ei:          Ei values [nkid]  
;  count:       return the number of good kidney angles
;keyword:
;  complement:  return the index of bad kidney angles
;  ncomplement: return the number of bad kidney angles
;  limits:      save the limits [ne,3], hardware angle
;  llim:        [nkid], lower kidney range for Ei, software angle
;  ulim:        [nkid], upper kidney range for Ei, software angle
;  offset:      hardware offset angle, it corresponds to the hardware angle when software angle is 0
;  extra keywords are for interpol routine
function dm_check_macskidney,kidney,Ei,count,complement=complement,ncomplement=ncomplement,limits=limits,llim=llim,ulim=ulim,offset=offset,_ref_extra=_extra
    if n_elements(offset) eq 0 then offset=-1  ;(0  as measured on 1/9/2018) ;-2;based on 3/8/2018 5 meV data; 
    limits = [[2.35000,      30.9256,      44.9709],$
              [2.40000,      27.3092,      43.8543],$
              [2.50000,      21.5270,      41.6376],$
              [2.60000,      16.4137,      39.6199],$
              [2.70000,      11.5105,      37.5027],$
              [2.80000,      7.54140,      35.5569],$
              [2.90000,      3.62210,      33.6885],$
              [3.00000,      0.13400,      31.8477],$
              [3.10000,     -2.81240,      30.1672],$
              [3.20000,     -5.49890,      28.4480],$
              [3.30000,     -7.90360,      26.9112],$
              [3.40000,     -9.86600,      25.2916],$
              [3.50000,     -11.9998,      23.7493],$
              [3.60000,     -13.8903,      22.2457],$
              [3.70000,     -15.7311,      20.8139],$
              [3.80000,     -17.3066,      19.4154],$
              [3.90000,     -18.8931,      18.1053],$
              [4.00000,     -20.3469,      16.7896],$
              [4.10000,     -21.7510,      15.6896],$
              [4.20000,     -23.0058,      14.3352],$
              [4.30000,     -24.2828,      13.1909],$
              [4.40000,     -25.4215,      12.0301],$
              [4.50000,     -26.5382,      10.8139],$
              [4.60000,     -27.5830,      9.84100],$
              [4.70000,     -28.5448,      8.77410],$
              [4.80000,     -29.5343,      7.77360],$
              [4.90000,     -30.4077,      7.00520],$
              [5.00000,     -31.2259,      6.02120],$
              [5.10000,     -32.0495,      4.82170],$
              [5.20000,     -32.8234,      3.73820],$
              [5.30000,     -33.6029,      2.75980],$
              [5.40000,     -34.3325,      1.79240],$
              [5.50000,     -35.0346,     0.648100],$
              [6.00000,     -37.9920,     -3.80190],$
              [6.50000,     -40.2972,     -7.88150],$
              [7.00000,     -42.2098,     -11.4359],$
              [7.50000,     -43.8571,     -14.3491],$
              [8.00000,     -45.8638,     -17.2015],$
              [8.50000,     -46.8864,     -20.1866],$
              [9.00000,     -47.5719,     -22.6686],$
              [9.50000,     -48.4895,     -24.9738],$
              [10.0000,     -49.4016,     -27.0523],$
              [10.5000,     -50.1811,     -29.0976],$
              [11.0000,     -50.7947,     -30.9329],$
              [11.5000,     -51.4525,     -32.6742],$
              [12.0000,     -52.0716,     -34.2883],$
              [12.5000,     -52.5968,     -35.7919],$
              [13.0000,     -52.9450,     -37.1463],$
              [13.5000,     -53.4868,     -38.0915],$
              [14.0000,     -54.0009,     -39.4569],$
              [14.5000,     -54.4099,     -41.1374],$
              [15.0000,     -54.7527,     -42.2540],$
              [15.5000,     -54.8853,     -43.5973],$
              [16.0000,     -54.3381,     -44.4597]];,$
              ;[17.0000,     -54-1.5+offset,-48.2+1.5+offset]]
    limits = transpose(limits)
    n_kid  = n_elements(kidney)
    count  = n_kid & ncomplement = 0 & complement = -1
    if n_kid eq 0 then return,-1
    if n_elements(Ei) ne n_kid then return,-1
    llim   = interpol(limits[*,1],limits[*,0],Ei,_extra=_extra)-offset
    ulim   = interpol(limits[*,2],limits[*,0],Ei,_extra=_extra)-offset
    index  = where((kidney ge llim) and (kidney le ulim),count,complement=complement,ncomplement=ncomplement)
    return,index
end