; $Id$
;#######################################################################
;
; NAME:
;  dm_calc_dwfactor
;
; PURPOSE:
;   calculate Debye-Waller factor
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  December, 2009
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

; parameter:
;   temperature:  of the sample, in K
;   tth:          scattering angle
;   ei:           neutron energy, in meV
; keyword:
;   dt:           Debye temperature, default is vanadium's 390K
;   ma:           atomic mass, default is vanadium's 50.94
;   maskdet:      detectors to be masked
function dm_calc_dwfactor,temperature,tth,ei,ma=ma,dt=dt,maskdet=maskdet
    if n_elements(dt) eq 0 then dt = 390.0    ;vanadium
    if n_elements(ma) eq 0 then ma = 50.9415  ;vanadium
    lambdasq = 81.8042/ei
    
    x  = dt/temperature
    fx = interpol([1.000000,0.975278,0.951111,0.927498,0.904437,0.881927,0.859964,0.838545,0.817665,0.797320,$
                   0.777505,0.758213,0.739438,0.721173,0.703412,0.669366,0.637235,0.606947,0.578427,0.551596,$
                   0.526375,0.502682,0.480435,0.459555,0.439962,0.421580,0.404332,0.388148,0.372958,0.358696,$
                   0.345301,0.332713,0.320876,0.294240,0.271260,0.251331,0.233948,0.218698,0.205239,0.193294,$
                   0.182633,0.173068,0.164443],$
                  [0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,$
                   1.0,1.1,1.2,1.3,1.4,1.6,1.8,2.0,2.2,2.4,$
                   2.6,2.8,3.0,3.2,3.4,3.6,3.8,4.0,4.2,4.4,$
                   4.6,4.8,5.0,5.5,6.0,6.5,7.0,7.5,8.0,8.5,$
                   9.0,9.5,10.0],$
                  x) 
    fx = 0.>(fx)  ;make sure the interpolation is positive
    M  = 1.14e4/ma/dt/lambdasq*(sin(tth/2*!dtor))^2*(0.25+fx/x)  ;from John
    if n_elements(maskdet) ne 0 then M[maskdet] = 0.0
    return,exp(-2.*M)
end