; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
function dcs_interpoldate,dt1,dt2,f,return_difference=r_d
;************************************************************************************************
; Given two date/time strings, e.g. '18-Nov-2004 17:53:49' and '18-Nov-2004 19:24:35', and a
; fraction f, e.g. 0.5, this function returns the interpolated date (here '11/18/04 18:39').
; If return_difference is set the time difference in days, here 0.063032407, is returned.
;
compile_opt strictarr
;
;months=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]
;;
;d1=strmid(dt1,0,2)
;m1=strmid(dt1,3,3)
;m1=where(m1 eq months)+1
;y1=strmid(dt1,7,4)
;h1=strmid(dt1,12,2)
;n1=strmid(dt1,15,2)
;s1=strmid(dt1,18,2)
;;
;d2=strmid(dt2,0,2)
;m2=strmid(dt2,3,3)
;m2=where(m2 eq months)+1
;y2=strmid(dt2,7,4)
;h2=strmid(dt2,12,2)
;n2=strmid(dt2,15,2)
;s2=strmid(dt2,18,2)
;;
;val1=julday(m1,d1,y1,h1,n1,s1)
;val2=julday(m2,d2,y2,h2,n2,s2)
;
val1=dcs_juldate(dt1)
val2=dcs_juldate(dt2)
;
diff=val2-val1
if (keyword_set(r_d)) then return,diff
;
val=val1+f*diff
caldat,val,M,D,Y,H,N
return,dcs_clean_date(M[0],D[0],Y[0],H[0],N[0])
;
end
