; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_getangles,nhedet=nhedet,angles,banks,azim_angles,racks
;************************************************************************************************
;
compile_opt strictarr
;
;inputfile=file_which("dcs_DetPos2.dat",/include_current_dir)
inputfile=!DAVE_AUXILIARY_DIR+'dcs_DetPos2.dat'
;
openr,unit,inputfile,/get_lun
;
content=strarr(nhedet+1)
readf,unit,content
;
free_lun,unit
;
pos=strpos(content[1:nhedet]," ",/reverse_search)
angles=fltarr(nhedet)
banks=intarr(nhedet)
azim_angles=fltarr(nhedet)
racks=intarr(nhedet)
;
hgt=531.0
rad=4000.0
for k=0,nhedet-1 do begin
	angles[k]=float(strmid(content[k+1],pos[k]))
	x=strsplit(content[k+1],/extract)
	banks[k]=fix(x[6])
	racks[k]=fix(x[5])
	angles[k]=float(x[8])
	case banks[k] of
		0: azim_angles[k]=0.0
		else: azim_angles[k]=banks[k]*!radeg*asin(hgt/(rad*sin(angles[k]*!dtor)))
	endcase
	azim_angles[k]=azim_angles[k]+180.0*(angles[k] lt 1)
endfor
;
end
