; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
function dcs_dec2bin,decimal
;************************************************************************************************
; This function returns a string of bits corresponding to a decimal input integer.
; For example dcs_dec2bin(9999) returns the 20-character string "010 011 100 001 111 ".
;
compile_opt strictarr
;
octal=string(decimal,format='(o)'); convert to octal.
lstr=strlen(octal); length of octal string.
outbit=''
;
; Treat each octal number, replacing it with a 4-character string.
for i=0,lstr-1 do begin
	x=strmid(octal,i,1)
	case x of
		'0': outbit=outbit+'000 '
		'1': outbit=outbit+'001 '
		'2': outbit=outbit+'010 '
		'3': outbit=outbit+'011 '
		'4': outbit=outbit+'100 '
		'5': outbit=outbit+'101 '
		'6': outbit=outbit+'110 '
		'7': outbit=outbit+'111 '
		else: outbit=''
	endcase
endfor
;
return,outbit
end