; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_calculate_phases,wavelength,inmasterspeed,resmode,srnum,srdenom,$
	slowchopper,addedfrac,tsdmin,distances,outangles,speeds,phases,delays,mspeed_corr,$
	adjust_t0,addf_corr,delay0
;************************************************************************************************
;
compile_opt strictarr
;
nmperiod=round(15000000.0/inmasterspeed)*4
masterspeed=60000000.0/nmperiod
mspeed_corr=masterspeed
;
dcs_chopper_info,distances,angles
;
tau0=wavelength/!dcs_hom
rawdelays=fltarr(7)
delays=fltarr(7)
speeds=fltarr(7)
phases=fltarr(7)
;
minphase=10.0
delta_addedfrac=minphase/360.0
;
ok=0
while (not ok) do begin
	addedtime=addedfrac*60000000.0/masterspeed
	for i=0,6 do begin
		if (i+1 eq slowchopper) then begin
			speed=masterspeed*srnum/srdenom
			pulserep=masterspeed/(srdenom*60)
		endif else begin
			speed=masterspeed
		endelse
		period=60000000.0/speed
		angle=angles[i,resmode-1]
		dval=-tau0*distances[i]+(30-angle)*(period/360.0)+tsdmin
		rawdelays[i]=round(dval*1000)*0.001
		while (dval ge period) do dval=dval-period
		while (dval lt 0) do dval=dval+period
		delays[i]=round(dval*10)*0.1
		time=tau0*distances[i]+addedtime
			if (i ne 0) then time=time-0.1666667
		value=360*time/period-(30-angle)
		while (value ge 360.0) do value=value-360.0
		while (value lt 0.0) do value=value+360.0
		value=0.01*long(value*100+0.5)
		phases[i]=value
		speeds[i]=speed
		dval=tsdmin+addedtime
		while (dval ge period) do dval=dval-period
		while (dval lt 0) do dval=dval+period
		delay0=round(dval*10)*0.1
	endfor
	;
	if (not adjust_t0) then ok=1 else begin
		whichones=where((phases lt minphase) or (360-phases lt minphase),count)
		ok=count eq 0
		if (not ok) then addedfrac=addedfrac+delta_addedfrac
	endelse
endwhile
;
addf_corr=addedfrac
outangles=angles[*,resmode-1]
end

