; $Id$
; Purpose:
;   This file implements the DAVEWriteISV class.
;

;---------------------------------------------------------------------------
; Lifecycle Routines
;---------------------------------------------------------------------------
; Purpose:
;   The constructor of the object.
;
; Arguments:
;   None.
;
; Keywords:
;   All superclass keywords.
;
function DAVEWriteISV::Init, _EXTRA=_extra
compile_opt idl2

                                ; Init superclass
if (self->IDLitWriter::Init('disv', $
                            TYPES="DAVEISV", $
                            NAME="DAVE Project", $
                            DESCRIPTION="DAVE Project (disv)", $
                            _EXTRA=_extra) eq 0) then $
                              return, 0
return, 1
end


;---------------------------------------------------------------------------
; Purpose:
; The destructor for the class.
;
; Arguments:
;   None.
;
; Keywords:
;   None.
;
;pro DAVEWriteISV::Cleanup
;    compile_opt idl2, hidden
;    ; Cleanup superclass
;    self->IDLitWriter::Cleanup
;end


;===============================================================================
; DAVEWriteISV::SetData
; 
; PURPOSE:
;   Save a DAVE project session (data + visualizations)
;
; PARAMETERS:
;   oTool [in] - The object reference of the main tool.
;
; KEYWORDS:
;   None.
;
; RETURN:
;   1 ==> Success; 0 ==> Failure
;
function DAVEWriteISV::SetData, oTool
compile_opt idl2

nullObj = 0
oldTool = oTool
if (~obj_valid(oTool)|| ~obj_isa(oTool,'DAVETool')) then begin
   oTool = Self->GetTool()   ; fudge for version >=7.1 - a null object was being passed to the writer!
   nullObj = 1
endif

if (~obj_valid(oTool) || ~obj_isa(oTool,'DAVETool')) then $
        return, 0
oTool->GetProperty, _TOOL_NAME=toolName, VERSION=toolVersion $
                    ,dave_major_version=dave_major_version $
                    ,dave_minor_version=dave_minor_version

; Get current data from the DAVE Data Manager folder
__datasets = oTool->GetDAVEDataManagerContents(count=nDatasets)

if (nDataSets < 0) then begin
   oTool->ErrorMessage,['Project contains no data!','Cannot proceed with save action'] $
                       ,title='DAVE Save Project'
   if (nullObj) then oTool = oldTool ; reset oTool to it's original value
   return, 1
endif

; Record the data entries in the main Data Manager folder
__sysData = oTool->GetSystemDataManagerContents(count=nSysData)

__visIDCount = oTool->GetVisIDCount()

; Get obj ref for all vis tools
visToolRefs = oTool->GetVisToolObjRefs(count=nVisTools)
;while (nVisTools-- gt 0) do begin
for i=0,nVisTools-1 do begin
   oVisTool = visToolRefs[i]
   if (~obj_valid(oVisTool)) then continue
   oVisTool->GetProperty, _tool_name=toolname, version=toolversion, nameTag=title
   oWin = oVisTool->GetCurrentWindow()
   if (~obj_valid(oWin)) then continue
   oWin->GetProperty, current_zoom=currentZoom
   oWin->ClearSelections
   ;oWin->SetCurrentZoom, 1
   oWin->GetProperty, layout_index=layoutIndex, view_grid=viewGrid, zoom_on_resize=zoomOnResize $
                      ,minimum_virtual_dimensions=minVirtualDims, virtual_dimensions=virtualDimensions $
                      ,auto_resize=autoResize,dimensions=winDimensions $
                      ,visible_location=visibleLocation,viewport_dimensions=viewportDimensions

   oPrintOperation = oVisTool->GetByIdentifier('Operations/File/Print')
   if (OBJ_VALID(oPrintOperation)) then begin
       oPrintOperation->GetProperty,PRINT_ORIENTATION=print_orientation $
         ,PRINT_XMARGIN=print_xmargin, PRINT_YMARGIN=print_ymargin $
         ,PRINT_WIDTH=print_width, PRINT_HEIGHT=print_height $
         ,PRINT_UNITS=print_units, PRINT_CENTER=print_center
   endif else begin
       print_orientation = 0
       print_xmargin = 0
       print_ymargin = 0
       print_width = 0
       print_height = 0
       print_units = 0
       print_center = 0
   endelse

   ;; We want to save the draw widget viewport dimensions.
   ;; Unfortunately, on Windows this includes the scroll bar size.
   dimensions = [0., 0.]

   ;; So if there is a scroll bar (virtual > window dims)
   ;; then use the window dimensions instead.
   dimensions[0] = (virtualDimensions[0] gt winDimensions[0]) ? winDimensions[0] : viewportDimensions[0]
   dimensions[1] = (virtualDimensions[1] gt winDimensions[1]) ? winDimensions[1] : viewportDimensions[1]
   


   oScene = oWin->GetScene()
   ;oWin->SetCurrentZoom, currentZoom
   tmpStr = {title:title $
             ,toolName:toolName $
             ,toolVersion:toolVersion $
             ,autoResize:autoResize $
             ,winDimensions:winDimensions $
             ,dimensions:dimensions $
             ,visibleLocation:visibleLocation $
             ,viewportDimensions:viewportDimensions $
             ,viewGrid:viewGrid $
             ,layoutIndex:layoutIndex $
             ,virtualDimensions:virtualDimensions $
             ,minVirtualDims:minVirtualDims $
             ,currentZoom:currentZoom $
             ,zoomOnResize:zoomOnResize $
             ,scene:oScene $
             ,print_orientation:print_orientation $
             ,print_xmargin:print_xmargin $
             ,print_ymargin:print_ymargin $
             ,print_width:print_width $
             ,print_height:print_height $
             ,print_units:print_units $
             ,print_center:print_center $
            }
   __visToolDesc = (n_elements(__visToolDesc) gt 0)? [__visToolDesc,tmpStr] : tmpStr
endfor 
;endwhile

; Save the project data
nVisTools = n_elements(__visToolDesc)
filename = self->GetFilename()
if (nVisTools gt 0) then begin
    save, __datasets, __sysData, __visIDCount, __visToolDesc $
          ,dave_major_version,dave_minor_version,/compress, filename=filename
    ;; 
    for i=0,nVisTools-1 do visToolRefs[i]->SetProperty, tool_filename=filename
endif else begin
    save, __datasets, __sysData, __visIDCount $
          ,dave_major_version,dave_minor_version,/compress, filename=filename   
endelse

if (nullObj) then oTool = oldTool ; reset oTool to it's original value
return, 1

end


;---------------------------------------------------------------------------
; Definition
;---------------------------------------------------------------------------
; Purpose:
;   Class definition.
;
pro DAVEWriteISV__Define
compile_opt idl2

void = {DAVEWriteISV $
        ,inherits IDLitWriter $
       }
end
