; $Id$
;###############################################################################
;+
; NAME:
;   DAVESetup
;
; PURPOSE:
;   Perform system setup/initialization consisting mainly of
;   registration of various iTools components with the system object
;   that have global consequences.
;
; CATEGORY:
;   IDL iTools
;
; PARAMETERS
;
; KEYWORDS:
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; October 2004
;-
;###############################################################################


;===============================================================================
; DAVEtool::RegisterVisualizations
; 
; PURPOSE:
;   Register visualization components. These are typically lightly
;   tweaked versions of the default iTool versions. The default ones
;   are removed!
;
; PARAMETERS
;   oSystem - the iTool system object
;
;   xmlDoc  - an xml document object
;
; KEYWORDS:
;
function RegisterVisualizations, oSystem, xmlDoc
compile_opt idl2

;------------------------------------------------------------------------------
; - Unregister all visualizations that are registered by default by the system object
;   that either require alteration before use in DAVE or are not currently
;   supported in DAVE


;LRK
;070208
;THE VOLUME VISUALIZATION IS REQUIRED FOR 3DenPro.  
;Unregistering it here deletes DenPro Functionality. 
oSystem->UnRegisterVisualization, 'Volume'



oSystem->UnRegisterVisualization, 'IDL Graphics Object'
oSystem->UnRegisterVisualization, 'Streamline'
oSystem->UnRegisterVisualization, 'Vector'
oSystem->UnRegisterVisualization, 'Shape Point'
oSystem->UnRegisterVisualization, 'Shape Polyline'
oSystem->UnRegisterVisualization, 'Shape Polygon'
oSystem->UnRegisterVisualization, 'Plot'
oSystem->UnRegisterVisualization, 'Plot3D'
oSystem->UnRegisterVisualization, 'Image'
oSystem->UnRegisterVisualization, 'Contour'
oSystem->UnRegisterVisualization, 'Surface'


;;------------------------------------------------------------------------------
;; Plot viz
;oSystem->RegisterVisualization, 'Plot','DAVEvisPlot',icon='plot';,type='DAVEVIS'
;
;; Plot 3D viz
;oSystem->RegisterVisualization, 'Plot3D', 'IDLitVisPlot3D', icon='plot'
;
;; Image viz
;oSystem->RegisterVisualization, 'Image','DAVEvisImage',icon='image';,type='DAVEVIS'
;
;; Contour viz
;oSystem->RegisterVisualization, 'Contour','DAVEvisContour',icon='contour';,type='DAVEVIS'
;
;; Surface viz
;oSystem->RegisterVisualization, 'Surface','DAVEvisSurface',icon='surface';,type='DAVEVIS'
;


visList = xmlDoc->GetElementsByTagName("visualization")
nVis = visList->GetLength()

i = 0
while (nVis-- gt 0) do begin
   vis = visList->Item(i++)
   attributeList = vis->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'NAME': name = attValue
            'CLASS': class = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor
      
      if (strlen(name) gt 0) then begin
         oSystem->UnRegisterVisualization, name
         oSystem->RegisterVisualization, name, class, _EXTRA=etc
      endif
   endif
endwhile


;------------------------------------------------------------------------------
; Create and add a utility object that will be used for specifying
; options for plot3d visualizations 
obj = obj_new('plot3dOptions')
oSystem->AddByIdentifier, '/Registry/Misc',obj

oSystem->Unregister,'/REGISTRY/OPERATIONS/IDLIMAGE/PLOT PROFILE'
oSystem->Unregister,'/REGISTRY/OPERATIONS/IDLSURFACE/PLOT PROFILE'
;------------------------------------------------------------------------------
; Plot Profile Operation
oSystem->RegisterToolOperation, 'IDLIMAGE', 'Plot Profile','DAVEopPlotProfile' $
                                ,NAME=IDLitLangCatQuery('Menu:Operations:PlotProfile') $
                                ,IDENTIFIER='Operations/Plot Profile', ICON='profile'
oSystem->RegisterToolOperation, 'IDLSURFACE', 'Plot Profile','DAVEopPlotProfile' $
                                ,NAME=IDLitLangCatQuery('Menu:Operations:PlotProfile') $
                                ,IDENTIFIER='Operations/Plot Profile', ICON='profile'

return, 1
end


;===============================================================================
; DAVEtool::RegisterUserInterface
; 
; PURPOSE:
;   Register User Interface procedures: these are routines that are
;   used for building the main user interface for a tool.
;
; PARAMETERS
;   oSystem - the iTool system object
;
; KEYWORDS:
;
function RegisterUserInterface, oSystem, xmlDoc
compile_opt idl2

;; The default user interface used by visualization tools 
;oSystem->RegisterUserInterface, 'DAVE VisTool Interface' $
;  ,'wd_DAVEvisToolbase',description='Default User Interface for Visualization Tools'


uiList = xmlDoc->GetElementsByTagName("userinterface")
nUi = uiList->GetLength()

i = 0
while (nUi-- gt 0) do begin
   ui = uiList->Item(i++)
   attributeList = ui->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'NAME': name = attValue
            'PROCEDURE': procedure = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor
      
      if (strlen(name) gt 0) then oSystem->RegisterUserInterface, name, procedure, _EXTRA=etc

   endif
endwhile


return, 1
end


;===============================================================================
; DAVEtool::RegisterUIServices
; 
; PURPOSE:
;   Register UI Services. Some only have DAVETool scope.
;
; PARAMETERS
;   oSystem - the iTool system object
;
;   xmlDoc  - an xml document object
;
; KEYWORDS:
;
function RegisterUIServices, oSystem, xmlDoc
compile_opt idl2

;------------------------------------------------------------------------------
;oSystem->RegisterUIService, 'AddVisItem', 'ui_AddVisItem'    ; adds a nw entry in Viz Browser tree
;
;oSystem->RegisterUIService, 'SetDataAxesLabels', 'ui_setDataAxesLabels' ; use by data readers
;oSystem->RegisterUIService, 'AboutDAVE', 'ui_aboutDave'               ; Provides info about DAVE
;oSystem->RegisterUIService, 'SelectDirectory', 'ui_selectDir'         ; work/data directory chooser
;oSystem->RegisterUIService, 'DavePreferences', 'IDLitUIPrefs'         ; 
;
;;------------------------------------------------------------------------------
;; Data Reduction Modules
;oSystem->RegisterUIService, 'FANS Data Reduction','ui_launchFANSReduction'   ; Launcher for FANS Reduction


uisList = xmlDoc->GetElementsByTagName("uiservice")
nUis = uisList->GetLength()

i = 0
while (nUis-- gt 0) do begin
   uis = uisList->Item(i++)
   attributeList = uis->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'NAME': name = attValue
            'PROCEDURE': procedure = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor
      
      if (strlen(name) gt 0) then oSystem->RegisterUIService, name, procedure, _EXTRA=etc

   endif
endwhile

return, 1
end


;===============================================================================
; RegisterReaderWriters
; 
; PURPOSE:
;   Register file writers and readers to augment system ones.
;
; PARAMETERS
;   oSystem - the iTool system object
;
;   xmlDoc  - an xml document object
;
; KEYWORDS:
;
function RegisterReaderWriters, oSystem, xmlDoc
compile_opt idl2

;; Unregister system readers/writers that need to be replaced.
;oSystem->UnRegisterFileReader, 'ASCII text'
;oSystem->UnRegisterFileWriter, 'ASCII text'
;
;;------------------------------------------------------------------------------
;; Register readers
;oSystem->RegisterFileReader, 'DAVE1x','DAVEreadDAVE1',icon='open'
;oSystem->RegisterFileReader, 'DAVE Project','DAVEreadISV',icon='open'
;oSystem->RegisterFileReader, 'ASCII text', 'DAVEreadASCII', icon='ascii'
;
;;------------------------------------------------------------------------------
;; Register writers
;oSystem->RegisterFileWriter, 'DAVE1x','DAVEwriteDAVE1',icon='save'
;oSystem->RegisterFileWriter, 'ASCIICOL', 'DAVEwriteASCIICOL', icon='ascii'
;oSystem->RegisterFileWriter, 'ASCIIGRP', 'DAVEwriteASCIIGRP', icon='ascii'
;oSystem->RegisterFileWriter, 'ASCIISPE', 'DAVEwriteASCIISPE', icon='ascii'
;oSystem->RegisterFileWriter, 'DAVE Project','DAVEwriteISV',icon='save'


; Deal with Readers
readerList = xmlDoc->GetElementsByTagName("reader")
nReader = readerList->GetLength()

i = 0
while (nReader-- gt 0) do begin
   reader = readerList->Item(i++)
   attributeList = reader->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'NAME': name = attValue
            'CLASS': class = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor
      
      if (strlen(name) gt 0) then begin
         oSystem->UnRegisterFileReader, name
         oSystem->RegisterFileReader, name, class, _EXTRA=etc
      endif
   endif
endwhile

; Deal with Writers
writerList = xmlDoc->GetElementsByTagName("writer")
nwriter = writerList->GetLength()

i = 0
while (nwriter-- gt 0) do begin
   writer = writerList->Item(i++)
   attributeList = writer->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'NAME': name = attValue
            'CLASS': class = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor
      
      if (strlen(name) gt 0) then begin
         oSystem->UnRegisterFileWriter, name
         oSystem->RegisterFileWriter, name, class, _EXTRA=etc
      endif
   endif
endwhile

return, 1
end


;===============================================================================
; DAVEtool::addServices
; 
; PURPOSE:
;   Create services
;
; PARAMETERS
;   oSystem - the iTool system object
;
; KEYWORDS:
;
function AddServices, oSystem
compile_opt idl2

oSystem->AddService, OBJ_NEW("DAVEsrvHelp", NAME="DAVEHELP")

return, 1
end


;===============================================================================
; DAVEtool::RegisterMiscTools
; 
; PURPOSE:
;   Register Miscellaneous Tools. 
;
; PARAMETERS
;
; KEYWORDS:
;
function RegisterMiscTools, oSystem, xmlDoc
compile_opt idl2

return, 1
end


;===============================================================================
; DAVEtool::RegisterRedTools
; 
; PURPOSE:
;   Register Tools (Components that can exist independently with own user interface window).
;
; PARAMETERS
;   oSystem - the iTool system object
;
;   xmlDoc  - an xml document object
;
; KEYWORDS:
;
function RegisterTools, oSystem, xmlDoc
compile_opt idl2

;;------------------------------------------------------------------------------
;; Base Visualization Tool. This tool provides all the
;; necessary functionality requied to interact with and manipulate a
;; visualization component. Hence whenever a visualization is
;; requested, a visualization tool will be created as well.
;oSystem->RegisterTool, "DAVE VisTool", "DAVEvisToolbase", $
;        DESCRIPTION="DAVE Base Visualization Tool"

toolList = xmlDoc->GetElementsByTagName("tool")
ntool = toolList->GetLength()

i = 0
while (ntool-- gt 0) do begin
   tool = toolList->Item(i++)
   attributeList = tool->GetAttributes()
   nAttributes = attributeList->GetLength()
   if (nAttributes gt 0) then begin
      etc = {empty:''}
      for j=0, nAttributes-1 do begin
         attribute = attributeList->Item(j)
         attName = attribute->GetName()
         attValue = attribute->GetValue()
         case strupcase(attName) of
            'NAME': name = attValue
            'CLASS': class = attValue
            else: begin
               tagnames = tag_names(etc)
               etc = (strcmp(tagnames[0],'EMPTY'))? $
                     create_struct(attName,attValue) : $
                     create_struct(attName,attValue,etc)
            end
         endcase
      endfor
      
      if (strlen(name) gt 0) then begin
         ;oSystem->UnRegister, name
         oSystem->RegisterTool, name, class, _EXTRA=etc
      endif
   endif
endwhile


return, 1
end


;===============================================================================
; DAVEtool::defineDirHierarchy
; 
; PURPOSE:
;   Define directories that are expected and used in the DAVE hierarchy
;
; PARAMETERS
;
; KEYWORDS:
;
function defineDirHierarchy
compile_opt idl2

; Define directory hierarchies in the DAVE distributions
; !DAVE_DIR is (and must be) defined in dave.pro
delim = path_sep()
defsysv,'!DAVE_AUXILIARY_DIR',!DAVE_DIR+delim+'auxiliary'+delim
;defsysv,'!DAVE_SUMMARYFILES_DIR',!DAVE_DIR+delim+'summaryfiles'+delim
defsysv,'!DAVE_SUMMARYFILES_DIR',!DAVE_AUXILIARY_DIR+'summaryfiles'+delim
defsysv,'!DAVE_BITMAP_DIR',!DAVE_DIR+delim+'resource'+delim+'bitmaps'+delim
defsysv,'!DAVE_HELP_DIR',!DAVE_DIR+delim+'help'+delim
defsysv,'!DAVE_PDFHELP_DIR',!DAVE_DIR+delim+'help'+delim+'dave_online_help'+delim+'pdf'+delim
defsysv,'!DAVE_TASPOLARIZEDBEAMCOR_DIR',!DAVE_AUXILIARY_DIR+'tas_pbcor'+delim



return, 1
end

;===============================================================================
; DAVEtool::DAVE2SETUP
; 
; PURPOSE:
;   Perform system setup/initialization consisting mainly of the
;   registration of various iTools components with the system object. 
;
; PARAMETERS
;
; KEYWORDS:
;
function DAVESetup
compile_opt idl2

; Define global directory hierarchy
if (~defineDirHierarchy()) then return, 0

; Retrieve the system object
oSystem = _IDLitSys_GetSystem()

; Retrieve the components.xml file which specifies components to be registered
xmlfile = file_which(!DAVE_AUXILIARY_DIR,'components.xml')
xmlDoc = OBJ_NEW('IDLffXMLDOMDocument', filename=xmlfile)
; Ensure document has the "dave2_menu" element
element = xmldoc->GetElementsByTagName("dave2_component")
if (~obj_valid(element) || (element->GetLength() lt 1)) then return, 0


; Register tools
if (~RegisterTools(oSystem, xmlDoc)) then begin
    obj_destroy, xmlDoc
    return, 0
endif

; Register visualizations
if (~RegisterVisualizations(oSystem, xmlDoc)) then begin
    obj_destroy, xmlDoc
    return, 0
endif

; Register User Interfaces
if (~RegisterUserInterface(oSystem, xmlDoc)) then begin
    obj_destroy, xmlDoc
    return, 0
endif

; Register UI Services
if (~RegisterUIServices(oSystem, xmlDoc)) then begin
    obj_destroy, xmlDoc
    return, 0
endif

; Register additional readers and writers
if (~RegisterReaderWriters(oSystem, xmlDoc)) then begin
    obj_destroy, xmlDoc
    return, 0
endif

;; Register Miscellaneous tools
;if (~RegisterMiscTools(oSystem, xmlDoc)) then return, 0

; Add Services
if (~AddServices(oSystem)) then return, 0

obj_destroy, xmlDoc

;if (!version.os_family eq 'Windows') then begin
;  ; IDL ICE stuff
;  new_var = 'IDLJAVAB_CONFIG='+!DAVE_AUXILIARY_DIR+'idljavabrc'
;  setenv,new_var
;  print,getenv('IDLJAVAB_CONFIG')
;endif

return, 1
end
