; $Id$
;###############################################################################
;+
; FUNCTION:
;   Partype
;
; PURPOSE:
;   Determine a suitable parameter type (not the same as intrinsic
;   data type) to be assigned for the given variable. This is based on the
;   nos of dimensions of the variable.
;
; CATEGORY:
;   Miscellaneous
;
; PARAMETERS
;   variable - The variable whose parameter type is required
;
; KEYWORDS:
;
; RETURN VALUE:
;    If successful, the parameter type (string)
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; September 2004
;-
;###############################################################################
function partype, variable

case size(variable,/n_dimensions) of
    0: typeString = 'IDLSCALER'
    1: typeString = 'IDLVECTOR'
    2: typeString = 'IDLARRAY2D'
    3: typeString = 'IDLARRAY3D'
    else: typeString = 'IDLVOLUME'
endcase

return, typeString
end
