; $Id$
;###############################################################################
;
;FILENAME:
;nse_legend.pro
;
;PURPOSE:
;           Place a legend at a selected location in a plot window.
;CATEGORY:
;           Data visulization.
;
;METHODS IN FILE:
;
;    nse_legend
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
;
;
;TITLE      nse_legend.pro
;
;AUTHOR     Larry Kneller
;
;
;PURPOSE    THIS PROCEDURE PLACES A LEGEND AT THE
;           SELECTED NORMALIZED COORDINATE IN THE
;           CHOSEN WINDOW.
;


pro nse_legend,win,xnorm,ynorm,str,$;xrange,yrange,str,$
            color=color,psym=psym,symsize=symsize,_extra=extra
            ;,xlog=xlog,ylog=ylog,
;
;NAME:
;        nse_legend
;
;PURPOSE:
;           Create a legend at the selected location in the selected window.
;PARAMETERS:
;           win         id of window to insert legend
;           xnorm       normalized position value of x coordinate
;           ynorm       normalized position value of y coordinate
;           xrange      xaxis range
;           yrange      yaxis range
;           str         Sting in the legend.
;KEYWORDS:
;           xlog        Indicates whether x axis is log (1) or lin (0).
;           ylog        Indicates whether y axis is log (1) or lin (0).
;           color       Color of the legend
;           psym        Symbol in the legend
;           symsize     Size of the symbol in the legend
;

    ;PLACES A LEGEND AT THE SELECTED NORMALIZED COORDINATES.

        if n_elements(xlog) eq 0 then xlog = 0
        if n_elements(ylog) eq 0 then ylog = 0
        if n_elements(color) eq 0 then color = -1
        if n_elements(psym) eq 0 then psym = 0
        if psym gt 8 then psym = 8
        if n_elements(symsize) eq 0 then symsize=1


        ;GET CURRENT WINDOW
        dwin = !D.window

        ;SET TO WINDOW OF LEGEND
        wset,win
        xrange = !x.crange
        yrange = !y.crange
        xlog = !x.type
        ylog = !y.type


        ;NOTE THAT WHILE xyouts ALLOWS THE "normal" FLAG,
        ;oplot DOES NOT.  THIS IS THE REASON nse_normalizecoord
        ;IS REQUIRED.

        rdata = nse_normalizecoord(xnorm,ynorm,$
                                xrange,yrange,xlog,ylog)
        xyouts, [rdata[0]],[rdata[1]],str,color = color,charsize=0.85;,_extra=extra

        rdata = nse_normalizecoord(xnorm-0.04,ynorm+0.01,$
                                xrange,yrange,xlog,ylog)
        ;print,'nse_legend rnorm = ',rnorm
        oplot, [rdata[0]],[rdata[1]],$
                color=color,$
                psym=psym,symsize=symsize,_extra=extra


        ;RESET WINDOW TO PREVIOUS WINDOW.
        wset,dwin

end;nse_legend



;;;;;function nse_normalizecoord,x,y,xrange,yrange,xlog,ylog
;;;;;
;;;;;    ;PRODUCE A NORMALIZED COORDINATE BASED ON THE x,y
;;;;;    ;POSITIONS AND xrange,yrange.
;;;;;    ;
;;;;;    ;THE PURPOSE OF THIS IS TO GIVE THE COORDINATE OF THE
;;;;;    ;NORMALIZED POSITINO ON THE PLOT.
;;;;;    ;
;;;;;    ;e.g. x = 0.5, y=0.5
;;;;;    ;
;;;;;
;;;;;    ;xlog = self.xlog & ylog = self.ylog
;;;;;
;;;;;;    if xlog eq 1 then xrange = 10.0^xrange
;;;;;;    if ylog eq 1 then yrange = 10.0^yrange
;;;;;
;;;;;;    print,'nse_normalizecoord xrange=',xrange
;;;;;;    print,'nse_normalizecoord yrange=',yrange
;;;;;
;;;;;
;;;;;    x1 = xrange[1] & x0 = xrange[0]
;;;;;    y1 = yrange[1] & y0 = yrange[0]
;;;;;
;;;;;    xnorm = x*(x1-x0) + x0
;;;;;    ynorm = y*(y1-y0) + y0
;;;;;
;;;;;    if xlog eq 1 then xnorm = 10.0^xnorm
;;;;;    if ylog eq 1 then ynorm = 10.0^ynorm
;;;;;
;;;;;    return,[xnorm,ynorm]
;;;;;end;nse_normalizecoord
