; $Id$

;LRK  
;THIS FILE IS USED TO CREATE THE DAVE CITATIONS TRACKING HTML FROM THE EXCEL SPREADSHEET.  
;I HAVE CONVERTED THE CITATION SHEET CONTENTS INTO A MySQL TABLE AND 
;CREATED PHP SCRIPTS TO HANDLE THE INSERTION OF NEW CITATIONS (MOSTLY DONE) AND 
;THE CREATION OF AN INTERACTIVE HTML PAGE (COMPLETED).  I WILL MAKE THE PHP CODE AVAILABLE
;BEFORE I LEAVE IN JULY.
;
;THE "alt" OPTION INCLUDES PAPERS WHERE THE AUTHORS PERSONALLY ACKNOWLEDGED USING DAVE FOR 
;THEIR WORK, WHILE THE MAIN OPTION STRICTLY INCLUDES PAPERS THAT CITE DAVE.  
;
;MOST PEOPLE ARE PRETTY GOOD ABOUT PERSONALLY ACKNOWLEDGING EVEN IF THEY ALMOST NEVER CITE.
;
;
;
;THE EXCEL TRACKING SHEET INCLUDES YEAR, TITLE, AUTHOR, CITATION, ETC. ALL WITH AN 
;'@' SYMBOL AT THE END OF EACH FIELD.  THE EXCEL SHEET IS SAVED AS A TAB-DELIMITED TEXT
;FILE, AND THAT FILE IS READ BY THE PROGRAMS HERE.
;



pro makeDAVEPubsAlt,n,s,ofnalt


        sout = ['']


        sout = [sout,'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">']
        sout = [sout,'<html>']
        sout = [sout,'<?php']
        sout = [sout,'include("./dave_header.html");']
        sout = [sout,'?>']
        sout = [sout,'<br>']
        sout = [sout,'<head>']
        sout = [sout,'  <meta http-equiv="content-type"']
        sout = [sout,' content="text/html charset=ISO-8859-1">']
        sout = [sout,'  <title>Publications with DAVE citations</title>']
        sout = [sout,'  <meta name="author" content="Larry Kneller">']
        sout = [sout,'</head>']
        sout = [sout,'<body>']
        sout = [sout,'<h1>']
        sout = [sout,'Publications for which authors acknowledge the use of']
        sout = [sout,'<a href="http://www.ncnr.nist.gov/dave">DAVE</a>']
        sout = [sout,'software']
        sout = [sout,'']
        sout = [sout,'</h1>']
        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'<// ################## ACKNOWLEDGMENT REFERENCE SECTION ############>']
;        sout = [sout,'<font face="arial, helvetica, sans-serif"><u>Acknowledging use of DAVE</u>']
;        sout = [sout,'in publications may be done by making a reference to the DAVE web site.']
;        sout = [sout,'For example:<br>']
;        sout = [sout,'"The DAVE software package was used for elements of the data reduction']
;        sout = [sout,'and analysis. [1]"<br>']
;        sout = [sout,'<!-- [1] http://www.ncnr.nist.gov/dave</font> -->']
        sout = [sout,'<font face="arial, helvetica, sans-serif"><u>']
        sout = [sout,'If you reduced, analyzed or visualized your data using DAVE, please acknowledge its']
        sout = [sout,'use by including the following reference</u>:</font>']
        sout = [sout,'']
        sout = [sout,'<br><br>']
        sout = [sout,'<font face="arial, helvetica, sans-serif">']
        sout = [sout,'<a href="http://nvl.nist.gov/pub/nistpubs/jres/114/6/V114.N06.A04.pdf">']
        sout = [sout,'[1]</a><span style="font-style:italic;"> ']
        sout = [sout,'DAVE: A comprehensive software suite for the reduction, visualization, and analysis of low energy neutron spectroscopic data'] 
        sout = [sout,'</span>,']
        sout = [sout,'R.T. Azuah, L.R. Kneller, Y. Qiu, P.L.W. Tregenna-Piggott, C.M. Brown, J.R.D. Copley, and R.M. Dimeo,'] 
        sout = [sout,'<a href="http://nvl.nist.gov/pub/nistpubs/jres/114/6/V114.N06.A04.pdf">']
        sout = [sout,'<b>J. Res. Natl. Inst. Stan. Technol. 114, 341</b> (2009).</font>']
        sout = [sout,'</a>']
        sout = [sout,'<br><br>']
        sout = [sout,'<font face="arial, helvetica, sans-serif">']
        sout = [sout,'Note: For 2006 forward, items marked with a * include citations or']
        sout = [sout,'acknowledgments of use of DAVE or its modules in their' ]
        sout = [sout,'']
        sout = [sout,'<a href="http://www.ncnr.nist.gov/dave/dave_citations.html">text</a>,']
        sout = [sout,'while for all others the authors personally acknowledge use of DAVE software.']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'<// #################  GOTO LINKS ###################>']
        sout = [sout,'<hr style="width: 100%; height: 2px;">']
        sout = [sout,'<h2><a href="#Submitted">Submitted</a>,' ]
        sout = [sout,'<a href="#In_press">In press</a>,' ]


        ;RUN THROUGH LIST AND GET ALL YEARS AND MAKE LINKS.
        allyears = [2107]
        for i =1,n-1 do begin
            tempsegs = strsplit(s[i],'@',/regex,/extract)
            if n_elements(tempsegs) gt 5 and $
                stregex(tempsegs[0],'Press',/fold_case,/boolean) eq 0 and $
                    stregex(tempsegs[0],'Submit',/fold_case,/boolean) eq 0 then begin
                        if fix(strmid(tempsegs[0],0,4)) ne allyears[n_elements(allyears)-1] then begin
                            ;print,'strmid(tempsegs[0],0,4)=',strmid(tempsegs[0],0,4)
                            allyears = [allyears,fix(strmid(tempsegs[0],0,4))]
                        endif
            endif;>5 segs AND NOT IN PRESS
        endfor;i
        for i=1,n_elements(allyears)-2 do begin
            sout = [sout,'<a href="#'+strtrim(string(allyears[i]),2)+'">' + $
                         strtrim(string(allyears[i]),2)+'</a>, ']
        endfor;i
        sout = [sout,'<a href="#'+strtrim(string(allyears[n_elements(allyears)-1]),2)+'">' + $
                     strtrim(string(allyears[n_elements(allyears)-1]),2)+'</a>']


        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'</h2>']
        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'<// ################ PUBLICATIONS ##################### >']

        sout = [sout,'']
        sout = [sout,'<// #################  SUBMITTED FOR PUBLICATION SECTION ###################>']
        sout = [sout,'<a name="Submitted"></a>']
        sout = [sout,'<hr style="width: 100%; height: 2px;">']
        sout = [sout,'<span style="font-weight: bold;"><font size="+1">Submitted</font></bold>']
        sout = [sout,'</span>']
        sout = [sout,'<hr style="width: 100%; height: 2px;">']
        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'']


        ;GET THE IN PRESS PUBS FIRST.
        for i=0,n-1 do begin

            segs = strsplit(s[i],'@',/regex,/extract)

            if stregex(segs[0],'Submitted',/fold_case,/boolean) eq 1 and $
                n_elements(segs) ge 5 then begin
                   if stregex(segs[4],'Missing',/fold_case,/boolean) le 0 then begin                                        

                    ;TITLE
                    newsegs = strsplit(segs[1],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    title = strtrim(newsegs,2)+', '

                    ;AUTHORS
                    newsegs = strsplit(segs[2],'"',/extract)

                    if n_elements(newsegs) eq 1 then newsegs = newsegs[0] else newsegs = newsegs[1]
                    authors = strtrim(newsegs,2)+', '

                    newsegs = strsplit(segs[3],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    journ = strtrim(newsegs,2)
                    newsegs = strsplit(segs[4],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    source = strtrim(newsegs,2)

                    news = ''
                    sout = [sout,news]

                    (news='<span style="font-style:italic;"> '+title+'</span>')
                    sout = [sout,news]

                    (news=authors)
                    sout = [sout,news]

                    (news='<span style="font-weight: bold;">'+journ+'</span>'+' ('+segs[0]+').'+'<br><br>')
                    sout = [sout,news]
                  endif;not missing
            endif;In Press AND nsegs ge 5

        endfor;i


        sout = [sout,'']
        sout = [sout,'<// #################  IN PRESS SECTION ###################>']
        sout = [sout,'<a name="In_press"></a>']
        sout = [sout,'<hr style="width: 100%; height: 2px;">']
        sout = [sout,'<span style="font-weight: bold;"><font size="+1">In press</font></bold>']
        sout = [sout,'</span>']
        sout = [sout,'<hr style="width: 100%; height: 2px;">']
        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'']


        ;GET THE IN PRESS PUBS FIRST.
        for i=0,n-1 do begin

            segs = strsplit(s[i],'@',/regex,/extract)

            if stregex(segs[0],'Press',/fold_case,/boolean) eq 1 and $
                n_elements(segs) ge 5 then begin

                   if stregex(segs[4],'Missing',/fold_case,/boolean) le 0 then begin                                        

                          ;TITLE
                          newsegs = strsplit(segs[1],'"',/extract)
                          if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                          title = strtrim(newsegs,2)+', '
      
                          ;AUTHORS
                          newsegs = strsplit(segs[2],'"',/extract)
      
                          if n_elements(newsegs) eq 1 then newsegs = newsegs[0] else newsegs = newsegs[1]
                          authors = strtrim(newsegs,2)+', '
      
                          newsegs = strsplit(segs[3],'"',/extract)
                          if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                          journ = strtrim(newsegs,2)
                          newsegs = strsplit(segs[4],'"',/extract)
                          if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                          source = strtrim(newsegs,2)
      
                          news = ''
                          sout = [sout,news]
      
                          (news='<span style="font-style:italic;"> '+title+'</span>')
                          sout = [sout,news]
      
                          (news=authors)
                          sout = [sout,news]
      
                          (news='<span style="font-weight: bold;">'+journ+'</span>'+' ('+segs[0]+').'+'<br><br>')
                          sout = [sout,news]
                   endif;not Missing
            endif;In Press AND nsegs ge 5

        endfor;i



        help,s
        ;print,transpose(s)


;CREATE PAGE

        currentyear = 2107
        for i=0,n-1 do begin

            segs = strsplit(s[i],'@',/regex,/extract)


            ;print,n_elements(segs)

;            if n_elements(segs) eq 6 then begin
            if n_elements(segs) ge 6 then begin

                if stregex(segs[0],'year',/fold_case,/boolean) ne 1 and $
                    stregex(segs[0],'Press',/fold_case,/boolean) ne 1 and $
                     stregex(segs[0],'Submitted',/fold_case,/boolean) ne 1 then begin


                    ;print,segs[0]
                    newsegs = strsplit(segs[0],'"',/extract)
                    year = strtrim(newsegs[0],2);long(segs[0])

                    ;IF NEW YEAR, THEN ADD A HEADER WITH LINK
                    if fix(year) ne currentyear then begin
                        currentyear = fix(year)
                        (news = '<// ################ '+year+' PUBLICATIONS ####################>')
                        sout = [sout,news]



                        ;PLACE LINK
                        (news = '<a name="'+year+'"></a>')
                        sout = [sout,news]


                        ;PLACE DIVIDER LINE
                        (news='<hr style="width: 100%; height: 2px;">')
                        sout = [sout,news]


                        ;WRITE IN YEAR
                        (news='<span style="font-weight: bold;"><font size="+1">'+year+'</font></span>')
                        sout = [sout,news]


                        ;NEED TO RUN THROUGH LIST ONCE AND COUNT
                        yearcount = 0
                        citecount = 0
                        Personalcount = 0
                        for ii=0,n-1 do begin
                            tempsegs = strsplit(s[ii],'@',/regex,/extract)
                            if n_elements(tempsegs) gt 5 and stregex(tempsegs[0],'year',/fold_case,/boolean) eq 0 $
                                and stregex(tempsegs[0],'Press',/fold_case,/boolean) eq 0 then begin
                                    if fix(strmid(tempsegs[0],0,4)) eq currentyear then begin
                                        ;print,'strmid(tempsegs[0],0,4)=',strmid(tempsegs[0],0,4)
                                        ;yearcount++
                                        if stregex(tempsegs[4],'Missing',/fold_case,/boolean) le 0 then yearcount++                                        
                                        if stregex(tempsegs[4],'Personal',/fold_case,/boolean) gt 0 then personalcount++
                                        if stregex(tempsegs[4],'Cite',/fold_case,/boolean) gt 0 then citecount++
                                    endif
                            endif; NOT BLANK LINE, HEADER LINE OR IN PRESS.
                        endfor;ii

                        (news='(' + strtrim(yearcount,2) + ' publications: '+ strtrim(citecount,2) + $
                              ' in text, ' + strtrim(personalcount,2) + ' personal acknowledgments)')
                        sout = [sout,news]

                        (news='<span style="font-weight: bold;"><br></span>')
                        sout = [sout,news]
                        (news='<hr style="width: 100%; height: 2px;">')
                        sout = [sout,news]


                    endif;new year header

                    ;TITLE
                    newsegs = strsplit(segs[1],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    title = strtrim(newsegs,2)+', '

                    ;AUTHORS
                    newsegs = strsplit(segs[2],'"',/extract)

                    if n_elements(newsegs) eq 1 then newsegs = newsegs[0] else newsegs = newsegs[1]
                    authors = strtrim(newsegs,2)+', '

                    newsegs = strsplit(segs[3],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    journ = strtrim(newsegs,2)
                    newsegs = strsplit(segs[4],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    source = strtrim(newsegs,2)



                    news = ''
                    sout = [sout,news]

                    ;ELIMINATE THE "NoCite" ITEMS USED TO RECORD POSSIBLE DAVE PAPERS. 
                    if stregex(source,'missing',/fold_case,/boolean) eq 0 then begin
                          if stregex(source,'cit',/fold_case,/boolean) eq 1 then begin
                              (news='<span style="font-style:italic;"> * '+title+'</span>')
                              sout = [sout,news]
                          endif else begin
                              (news='<span style="font-style:italic;"> '+title+'</span>')
                              sout = [sout,news]
                          endelse
                          (news=authors)
                          sout = [sout,news]
      
                          (news='<span style="font-weight: bold;">'+journ+'</span>'+' ('+segs[0]+').'+'<br><br>')
                          sout = [sout,news]
                    endif;CITE NOT MISSING

                endif;NOT FIRST LINE OF EXCEL FILE (CONTAINING 'Year')
            endif;n_elements(segs) ge 6 (i.e. DATA LINE.)


        endfor;i


        sout = [sout,'<br>']
        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'<p:colorscheme']
        sout = [sout,' colors="#FFFFFF,#000000,#1C1C1C,#333399,#00E4A8,#FFCF01,#FF0000,#3333CC"></p:colorscheme><br>']
        sout = [sout,'</body>']
        sout = [sout,'<?php']
        ;sout = [sout,'include("./dave_footer.html");']
        sout = [sout,'include("./dave_footer_alt.html");']
        sout = [sout,'?>']
        sout = [sout,'</html>']


        openw,olun,ofnalt,/get_lun
        printf,olun,transpose(sout)
        free_lun,olun

        ;###########################################################################
        ;END OF ALT PAGE WITH BOTH CITES AND PERSONAL ACKNOWLEDGMENTS.
        ;###########################################################################


end;makeDAVEPubsAlt


pro makeDAVEPubs,n,s,ofn


        sout = ['']


        sout = [sout,'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">']
        sout = [sout,'<html>']
        sout = [sout,'<?php']
        sout = [sout,'include("./dave_header.html");']
        sout = [sout,'?>']
        sout = [sout,'<br>']        
        sout = [sout,'<head>']
        sout = [sout,'  <meta http-equiv="content-type"']
        sout = [sout,' content="text/html charset=ISO-8859-1">']
        sout = [sout,'  <title>Publications with DAVE citations</title>']
        sout = [sout,'  <meta name="author" content="Larry Kneller">']
        sout = [sout,'</head>']
        sout = [sout,'<body>']
        sout = [sout,'<h1>']
        sout = [sout,'Publications in which ']
        sout = [sout,'<a href="http://www.ncnr.nist.gov/dave">DAVE</a>']
        sout = [sout,'software is cited']
        sout = [sout,'']
        sout = [sout,'</h1>']
        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'<// ################## ACKNOWLEDGMENT REFERENCE SECTION ############>']
;        sout = [sout,'<font face="arial, helvetica, sans-serif"><u>Acknowledging use of DAVE</u>']
;        sout = [sout,'in publications may be done by making a reference to the DAVE web site.']
;        sout = [sout,'For example:<br>']
;        sout = [sout,'<br>']
;        sout = [sout,'"The DAVE software package was used for elements of the data reduction']
;        sout = [sout,'and analysis. [1]"<br>']
;        sout = [sout,'<!-- [1] http://www.ncnr.nist.gov/dave</font> -->']
;        sout = [sout,'[1] R.T. Azuah, L.R. Kneller, Y. Qiu, P.L.W. Tregenna-Piggott, C.M. Brown, J.R.D. Copley, and R.M. Dimeo,'] 
;        sout = [sout,'"DAVE: A comprehensive software suite for the reduction, visualization, and analysis of low energy neutron spectroscopic data",'] 
;        sout = [sout,'J. Res. Natl. Inst. Stan. Technol. (in press).</font>']

        sout = [sout,'<font face="arial, helvetica, sans-serif"><u>']
        sout = [sout,'If you reduced, analyzed or visualized your data using DAVE, please acknowledge its']
        sout = [sout,'use by including the following reference</u>:</font>']
        sout = [sout,'']
        sout = [sout,'<br><br>']
        sout = [sout,'<font face="arial, helvetica, sans-serif">']
        sout = [sout,'<a href="http://nvl.nist.gov/pub/nistpubs/jres/114/6/V114.N06.A04.pdf">']
        sout = [sout,'[1]</a><span style="font-style:italic;"> ']
        sout = [sout,'DAVE: A comprehensive software suite for the reduction, visualization, and analysis of low energy neutron spectroscopic data'] 
        sout = [sout,'</span>,']
        sout = [sout,'R.T. Azuah, L.R. Kneller, Y. Qiu, P.L.W. Tregenna-Piggott, C.M. Brown, J.R.D. Copley, and R.M. Dimeo,'] 
        sout = [sout,'<a href="http://nvl.nist.gov/pub/nistpubs/jres/114/6/V114.N06.A04.pdf">']
        sout = [sout,'<b>J. Res. Natl. Inst. Stan. Technol. 114, 341</b> (2009).</font>']
        sout = [sout,'</a>']        
        sout = [sout,'<br><br>']






        sout = [sout,'<// #################  GOTO LINKS ###################>']
        sout = [sout,'<hr style="width: 100%; height: 2px;">']
        sout = [sout,'<h2><a href="#Submitted">Submitted</a>,' ]
        sout = [sout,'<a href="#In_press">In press</a>,' ]


        ;RUN THROUGH LIST AND GET ALL YEARS AND MAKE LINKS.
        allyears = [2107]
        for i =1,n-1 do begin
            tempsegs = strsplit(s[i],'@',/regex,/extract)
            if n_elements(tempsegs) gt 5 and $
                stregex(tempsegs[0],'Press',/fold_case,/boolean) eq 0 and $
                    stregex(tempsegs[0],'Submitted',/fold_case,/boolean) eq 0 then begin
                    if fix(strmid(tempsegs[0],0,4)) ne allyears[n_elements(allyears)-1] then begin
                        allyears = [allyears,fix(strmid(tempsegs[0],0,4))]
                    endif
            endif;>5 segs AND NOT IN PRESS
        endfor;i
        for i=1,n_elements(allyears)-2 do begin
            sout = [sout,'<a href="#'+strtrim(string(allyears[i]),2)+'">' + $
                         strtrim(string(allyears[i]),2)+'</a>, ']
        endfor;i
        sout = [sout,'<a href="#'+strtrim(string(allyears[n_elements(allyears)-1]),2)+'">' + $
                     strtrim(string(allyears[n_elements(allyears)-1]),2)+'</a>']


        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'</h2>']
        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'<// ################ PUBLICATIONS ##################### >']
        sout = [sout,'']
        sout = [sout,'<// #################  SUBMITTED SECTION ###################>']
        sout = [sout,'<a name="Submitted"></a>']
        sout = [sout,'<hr style="width: 100%; height: 2px;">']
        sout = [sout,'<span style="font-weight: bold;"><font size="+1">Submitted</font></bold>']
        sout = [sout,'</span>']
        sout = [sout,'<hr style="width: 100%; height: 2px;">']
        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'']



        ;GET THE SUBMITTED PUBS FIRST.
        for i=0,n-1 do begin

            segs = strsplit(s[i],'@',/regex,/extract)

            if stregex(segs[0],'Submitted',/fold_case,/boolean) eq 1  and $
                n_elements(segs) ge 5 then begin

                  if stregex(segs[4],'Missing',/fold_case,/boolean) le 0 then begin                                        

                    ;TITLE
                    newsegs = strsplit(segs[1],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    title = strtrim(newsegs,2)+', '

                    ;AUTHORS
                    newsegs = strsplit(segs[2],'"',/extract)

                    if n_elements(newsegs) eq 1 then newsegs = newsegs[0] else newsegs = newsegs[1]
                    authors = strtrim(newsegs,2)+', '

                    newsegs = strsplit(segs[3],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    journ = strtrim(newsegs,2)
                    newsegs = strsplit(segs[4],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    source = strtrim(newsegs,2)

                    news = ''
                    sout = [sout,news]

                    (news='<span style="font-style:italic;"> '+title+'</span>')
                    sout = [sout,news]

                    (news=authors)
                    sout = [sout,news]

                    (news='<span style="font-weight: bold;">'+journ+'</span>'+' ('+segs[0]+').'+'<br><br>')
                    sout = [sout,news]
                  endif;NOT MISSING
            endif;In Press & NSEGS GE 5

        endfor;i


        sout = [sout,'']
        sout = [sout,'<// #################  IN PRESS SECTION ###################>']
        sout = [sout,'<a name="In_press"></a>']
        sout = [sout,'<hr style="width: 100%; height: 2px;">']
        sout = [sout,'<span style="font-weight: bold;"><font size="+1">In press</font></bold>']
        sout = [sout,'</span>']
        sout = [sout,'<hr style="width: 100%; height: 2px;">']
        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'']



        ;GET THE IN PRESS PUBS FIRST.
        for i=0,n-1 do begin

            segs = strsplit(s[i],'@',/regex,/extract)

            if stregex(segs[0],'Press',/fold_case,/boolean) eq 1  and $
                n_elements(segs) ge 5 then begin

                  if stregex(segs[4],'Missing',/fold_case,/boolean) le 0 then begin                                        

                    ;TITLE
                    newsegs = strsplit(segs[1],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    title = strtrim(newsegs,2)+', '

                    ;AUTHORS
                    newsegs = strsplit(segs[2],'"',/extract)

                    if n_elements(newsegs) eq 1 then newsegs = newsegs[0] else newsegs = newsegs[1]
                    authors = strtrim(newsegs,2)+', '

                    newsegs = strsplit(segs[3],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    journ = strtrim(newsegs,2)
                    newsegs = strsplit(segs[4],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    source = strtrim(newsegs,2)

                    news = ''
                    sout = [sout,news]

                    (news='<span style="font-style:italic;"> '+title+'</span>')
                    sout = [sout,news]

                    (news=authors)
                    sout = [sout,news]

                    (news='<span style="font-weight: bold;">'+journ+'</span>'+' ('+segs[0]+').'+'<br><br>')
                    sout = [sout,news]
                  endif;not Missing
            endif;In Press & NSEGS GE 5

        endfor;i





        help,s
        ;print,transpose(s)

        currentyear = 2107
        for i=0,n-1 do begin

            segs = strsplit(s[i],'@',/regex,/extract)


            ;print,n_elements(segs)

;            if n_elements(segs) eq 6 then begin
            if n_elements(segs) ge 6 then begin

                if stregex(segs[0],'year',/fold_case,/boolean) ne 1 and $
                    stregex(segs[0],'Press',/fold_case,/boolean) ne 1 and $
                     stregex(segs[0],'Submitted',/fold_case,/boolean) ne 1 then begin
                    ;print,segs[0]
                    newsegs = strsplit(segs[0],'"',/extract)
                    year = strtrim(newsegs[0],2);long(segs[0])

                    ;IF NEW YEAR, THEN ADD A HEADER WITH LINK
                    if fix(year) ne currentyear then begin
                        currentyear = fix(year)
                        (news = '<// ################ '+year+' PUBLICATIONS ####################>')
                        sout = [sout,news]

                        (news = '<a name="'+year+'"></a>')
                        sout = [sout,news]


                        ;PLACE DIVIDER LINE
                        (news='<hr style="width: 100%; height: 2px;">')
                        sout = [sout,news]

                        (news='<span style="font-weight: bold;"><font size="+1">'+year+'</font></span>')
                        sout = [sout,news]


                        ;NEED TO RUN THROUGH LIST ONCE AND COUNT
                        yearcount = 0
                        citecount = 0
                        Personalcount = 0
                        for ii=0,n-1 do begin
                            tempsegs = strsplit(s[ii],'@',/regex,/extract)
                            if n_elements(tempsegs) gt 5 and stregex(tempsegs[0],'year',/fold_case,/boolean) eq 0 and $
                                stregex(tempsegs[0],'Press',/fold_case,/boolean) eq 0 then begin
                                    print,'strmid(tempsegs[0],0,4)=',strmid(tempsegs[0],0,4)
                                    if fix(strmid(tempsegs[0],0,4)) eq currentyear then begin
                                        
                                        if stregex(tempsegs[4],'Missing',/fold_case,/boolean) le 0 then yearcount++
                                        ;if stregex(tempsegs[4],'Personal',/fold_case,/boolean) gt 0 then personalcount++
                                        if stregex(tempsegs[4],'Cite',/fold_case,/boolean) gt 0 then citecount++
                                    endif
                            endif; NOT BLANK, HEADER or IN PRESS
                        endfor;ii

                        (news='(' + strtrim(citecount,2) + ' publications)')
                        sout = [sout,news]

                        (news='<span style="font-weight: bold;"><br></span>')
                        sout = [sout,news]
                        (news='<hr style="width: 100%; height: 2px;">')
                        sout = [sout,news]


                    end;new year header


                    ;TITLE
                    newsegs = strsplit(segs[1],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    title = strtrim(newsegs,2)+', '

                    ;AUTHORS
                    newsegs = strsplit(segs[2],'"',/extract)

                    if n_elements(newsegs) eq 1 then newsegs = newsegs[0] else newsegs = newsegs[1]
                    authors = strtrim(newsegs,2)+', '

                    newsegs = strsplit(segs[3],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    journ = strtrim(newsegs,2)
                    newsegs = strsplit(segs[4],'"',/extract)
                    if n_elements(newsegs) gt 1 then newsegs = newsegs[1] else newsegs = newsegs[0]
                    source = strtrim(newsegs,2)



                    news = ''
                    sout = [sout,news]

                    if stregex(source,'cit',/fold_case,/boolean) eq 1 then begin
                        (news='<span style="font-style:italic;"> '+title+'</span>')
                        sout = [sout,news]
                        (news=authors)
                        sout = [sout,news]

                        (news='<span style="font-weight: bold;">'+journ+'</span>'+' ('+segs[0]+').'+'<br><br>')
                        sout = [sout,news]
                    endif

                endif
            endif


        endfor;i


        sout = [sout,'<br>']
        sout = [sout,'<br>']
        sout = [sout,'']
        sout = [sout,'']
        sout = [sout,'<p:colorscheme']
        sout = [sout,' colors="#FFFFFF,#000000,#1C1C1C,#333399,#00E4A8,#FFCF01,#FF0000,#3333CC"></p:colorscheme><br>']
        sout = [sout,'</body>']
        sout = [sout,'<?php']
        ;sout = [sout,'include("./dave_footer.html");']
        sout = [sout,'include("./dave_footer_alt.html");']
        sout = [sout,'?>']
        sout = [sout,'</html>']


        openw,olun,ofn,/get_lun
        printf,olun,transpose(sout)
        free_lun,olun

        ;###########################################################################
        ;END OF BASIC PAGE WITH BOTH CITES ONLY
        ;###########################################################################


end;makeDAVEPubs

pro makePubsHTML

    case strupcase(!version.os_family) of 
    'WINDOWS':begin
      ;new for Windows 7:
      citationsdir = 'C:\Users\kneller\Desktop\PAPERS\DAVEPapers\'
      inputFilename = 'DavePublicationsAtSep.txt'      
      outputFilenameAlt = 'DavePubsWebPageTextALT.html'
      outputFilename = 'DavePubsWebPageText.html'

      ;fn = 'C:\Documents and Settings\kneller\Desktop\Work\PAPERS\DAVEPapers\DavePublicationsSemicolon.txt'
      ;fn = 'C:\Documents and Settings\kneller\Desktop\Work\PAPERS\DAVEPapers\DavePublicationsAtSep.txt'
      fn = citationsdir+inputFilename
      
      if file_test(fn) eq 0 then begin
          void = dialog_message('CITATIONS FILE DOES NOT EXIST, PLEASE LOCATE:',title='FILE NOT FOUND:')
          fn = dialog_pickfile(title='LOCATE DAVE CITATIONS FILE:',filter='*.txt',path='.')
          if fn ne '' then begin
            citationsdir = file_dirname(fn)+path_sep()
          endif else begin
            return
          endelse
      endif 
      
      ;ofnalt = 'C:\Documents and Settings\kneller\Desktop\Work\PAPERS\DAVEPapers\DavePubsWebPageTextALT.html'
      ofnalt = citationsDir + outputFilenameAlt
      
      ;ofn = 'C:\Documents and Settings\kneller\Desktop\Work\PAPERS\DAVEPapers\DavePubsWebPageText.html'
      ofn = citationsDir + outputFilename
      
    end;WINDOWS
    'UNIX':begin
      fn = '/Users/larryjr/Documents/DAVEPapers/DavePublicationsAtSep.txt'
      ofnalt = '/Users/larryjr/Documents/DAVEPapers/DavePubsWebPageTextALT.html'
      ofn = '/Users/larryjr/Documents/DAVEPapers/DavePubsWebPageText.html'

      citationsdir = '/Users/larryjr/Documents/DAVEPapers/'
      inputFilename = 'DavePublicationsAtSep.txt'      
      outputFilenameAlt = 'DavePubsWebPageTextALT.html'
      outputFilename = 'DavePubsWebPageText.html'

      fn = citationsdir+inputFilename
      
      if file_test(fn) eq 0 then begin
          void = dialog_message('CITATIONS FILE DOES NOT EXIST, PLEASE LOCATE:',title='FILE NOT FOUND:')
          fn = dialog_pickfile(title='LOCATE DAVE CITATIONS FILE:',filter='*.txt',path='.')
          if fn ne '' then begin
            citationsdir = file_dirname(fn)+path_sep()
          endif else begin
            return
          endelse
      endif 
      
      ofnalt = citationsDir + outputFilenameAlt
      ofn = citationsDir + outputFilename
 
     end;DARWIN
     else:begin
        void = dialog_message('I do not know where I am.  Help me locate files.')
        inputFilename = 'DavePublicationsAtSep.txt'      
        outputFilenameAlt = 'DavePubsWebPageTextALT.html'
        outputFilename = 'DavePubsWebPageText.html'
  
        fn = dialog_pickfile(title='LOCATE DAVE CITATIONS FILE:',filter='*.txt',path='.')
        if fn ne '' then begin
          citationsdir = file_dirname(fn)+path_sep()
        endif else begin
          return
        endelse
        
        ofnalt = citationsDir + outputFilenameAlt
        ofn = citationsDir + outputFilename

     endelse
     endcase
     
 
    n = file_lines(fn)
    s = strarr(n)

    openr,lun,fn,/get_lun
    readf,lun,s
    free_lun,lun

    makeDAVEPubsAlt,n,s,ofnalt
    makeDAVEPubs,n,s,ofn

end;makePubsHTML
