; $Id$


;GET ALL THE DIRECT GRAPICS WINDOWS AVAILABLE AND LET USER PRINT THEM TO PRINTER


;NOW TO ADD THE OPTION TO CHOOSE A PRINTER VIA A DIALOG:
;
;REQUIRES:
;LK_PrintDirectGraphicsWindowToDefaultPrinter, wid, Landscape=landscape, NoScale=noscale, NoCenter=nocenter,true=true


function LK_DirectGraphicsPrintApp_getExt,s,iext=iext,len=len,base=base
        if n_elements(s) eq 0 then return,''
        iext = strpos(s,'.',/reverse_search)
;print,iext
        if (iext ne -1) and (iext-strlen(s) lt 10) then begin
            len  = strlen(s)
            ext  = strmid(s,iext+1,len-iext)
            base  = strmid(s,0,iext)
            ;print,ext
            ;print,base
        endif else begin
            ext = ''
            base=s
        endelse
        return,ext

end;LK_DirectGraphicsPrintApp_getExt
pro LK_DirectGraphicsPrintApp_addDotEXT,ofn,newext
        ext = LK_DirectGraphicsPrintApp_getExt(ofn,iext=iext,len=len,base=base)
        ofn = base+'.'+newext
end;MACSRunner_v1_addDotEXT


pro LK_DirectGraphicsPrintApp_printPDF,event
 

  ; Get the image to plot
  
  widget_control,event.handler,get_uvalue=pstate
  
  winindex = nse_comboindex((*pstate).wincombo)
  widget_control,(*pstate).wincombo,get_value=winlist
  usewin = long(winlist[winindex])
print,'usewin=',usewin  
  WSet, usewin
  image = TVRD(true=1)
 
  xsize = !D.X_Size
  ysize = !D.Y_Size

  ; Set up the graphics tree

  oModel = OBJ_NEW('IDLgrModel')

  sz = size(image)
  print,'sz=',sz
  print,'xsize,ysize=',xsize,ysize
  ratio = float(xsize)/float(ysize)
  
  minsize = min([xsize,ysize])
  maxsize = max([xsize,ysize])

  ratio = float(maxsize)/float(minsize)

  
  ;oView = OBJ_NEW('IDLgrView', VIEWPLANE_RECT=[0,0,xsize,fix(ysize/ratio)]);min([xsize,ysize]),min([xsize,ysize])]);sz[2],sz[3]])
  ;oView = OBJ_NEW('IDLgrView', VIEWPLANE_RECT=[0,0,maxsize,fix(ratio*maxsize)]);sz[2],sz[3]])
  oView = OBJ_NEW('IDLgrView', VIEWPLANE_RECT=[0,0,sz[2],sz[3]])

  oImage = OBJ_NEW('IDLgrImage', image,dimensions=[sz[2],sz[3]])

  ;oTitle = OBJ_NEW('IDLgrText', LOCATION=[100,0], ALIGNMENT=0.5)

  oModel->Add,oImage

  oView->Add, oModel

  oPDF = OBJ_NEW('IDLgrPDF')

; 
;
;  ; Add a PDF page.
;  
;  oPDF->AddPage ; Default layout is portrait, 8.5"x11"
;  
     
  oPDF->AddPage;,/landscape ; Default layout is portrait, 8.5"x11"
  oPDF->Draw, oView,vector = 1

  
   
  
  ; Save the output to a PDF file in the current directory.
;  fn = 'example.pdf'
  fn = dialog_pickfile(filter='*.pdf',path=(*pstate).workdir,dialog_parent=(*pstate).tlb)
  LK_DirectGraphicsPrintApp_addDotEXT,fn,'pdf'
  if fn ne '' then begin
    workdir = file_dirname(fn)
    (*pstate).workdir = workdir
    oPDF->Save, fn
  endif
  
  obj_destroy,[omodel,oview,oimage,opdf];otitle,opdf]

END;LK_DirectGraphicsPrintApp_printPDF

 
pro LK_GetDirectGraphicsWindowsInUse,goodwins,nwin


  device,window_state=s
;  window,/free,xpos=1600
;  win = !d.window
  goodwins = where(s eq 1,nwin)
;  if nwin ne 0 then begin
;    for i=0,n_elements(wh)-1 do begin
;      wset,wh[i]
;      im=tvrd(/true)
;      wset,win
;      plotimage,bytscl(im),/noaxes
;    endfor;i
;  endif
;  wdelete,win

end;LK_GetDirectGraphicsWindowsInUse
pro LK_DirectGraphicsPrintApp_draw,event

  widget_control,event.handler,get_uvalue=pstate

  winindex = nse_comboindex((*pstate).wincombo)
  widget_control,(*pstate).wincombo,get_value=winlist
  usewin = long(winlist[winindex])

  WSet, usewin
  image = TVRD(/true)
  
  device,get_decomposed=dc
  device,decomposed=1
  wset,(*pstate).winpix
  plotimage,bytscl(image),/noaxes,background=(2L)^24-1
  wset,(*pstate).winvis
  device,copy=[0,0,(*pstate).xsize,(*pstate).ysize,0,0,(*pstate).winpix]


  device,decomposed=dc

end;LK_DirectGraphicsPrintApp_draw

pro LK_DirectGraphicsPrintApp_event,event
  widget_control,event.handler,get_uvalue=pstate

  case event.id of
  (*pstate).quit:widget_control,(*pstate).tlb,/destroy
  (*pstate).getWindows:begin
    lk_getDirectGraphicsWindowsInUse,goodwins,nwins
    widget_control,(*pstate).wincombo,set_value=strtrim(string(goodwins),2)
    widget_control,(*pstate).wincombo,set_combobox_select=0
    LK_DirectGraphicsPrintApp_draw,event
  end;(*pstate).getWindows
  (*pstate).wincombo:begin
    LK_DirectGraphicsPrintApp_draw,event
  end;(*pstate).wincombo
  (*pstate).selectbutton:begin
  end;selectButton
  (*pstate).leftbutton:begin
    newindex = 0
    winindex = nse_comboindex((*pstate).wincombo)
    widget_control,(*pstate).wincombo,get_value=winlist
    if winindex eq 0 then newindex = n_elements(winlist)-1 else newindex = winindex - 1
    widget_control,(*pstate).wincombo,set_combobox_select=newindex
    LK_DirectGraphicsPrintApp_draw,event
  end;(*pstate).leftbutton
  (*pstate).rightbutton:begin
    newindex = 0
    winindex = nse_comboindex((*pstate).wincombo)
    widget_control,(*pstate).wincombo,get_value=winlist
    if winindex eq n_elements(winlist)-1 then newindex = 0 else newindex = winindex + 1
    widget_control,(*pstate).wincombo,set_combobox_select=newindex
    LK_DirectGraphicsPrintApp_draw,event

  end;(*pstate).rightbutton
  (*pstate).printbutton:begin
    winindex = nse_comboindex((*pstate).wincombo)
    widget_control,(*pstate).wincombo,get_value=winlist
    usewin = long(winlist[winindex])
    LK_PrintDirectGraphicsWindowToDefaultPrinter, usewin, /Landscape,/true
    void = dialog_message('Window contents printed to default printer.',dialog_parent=(*pstate).tlb,/info)
  end;(*pstate).printwindow
  (*pstate).PDFbutton:begin
    LK_DirectGraphicsPrintApp_printPDF,event
;    winindex = nse_comboindex((*pstate).wincombo)
;    widget_control,(*pstate).wincombo,get_value=winlist
;    usewin = long(winlist[winindex])
;    LK_PrintDirectGraphicsWindowToDefaultPrinter, usewin, /Landscape,/true
  end;(*pstate).PDFwindow
  (*pstate).selectButton:begin
    print,'SET UP THE PRINTER CHOICE DIALOG AND MAYBE STORE THAT INFO IN THE STATE'
  end;(*pstate).selectButton
  else:
  endcase
  
end;LK_DirectGraphicsPrintApp_event
pro LK_DirectGraphicsPrintApp_cleanup,id
  widget_control,id,get_uvalue=pstate
  ptr_free,(*pstate).xptr
  ptr_free,(*pstate).yptr
  ptr_free,pstate
end;LK_DirectGraphicsPrintApp_cleanup

pro LK_DirectGraphicsPrintApp
  
  tlb = widget_base(title='Direct Graphics Window Printer',mbar=bar,/row)
  panel1 = widget_base(tlb,/col)
  panel2 = widget_base(tlb,/col)

  file = widget_button(bar,value='File',/menu)
  quit = widget_button(file,value='Quit')
  workdir = '.'

  getWindows = widget_button(panel1,value='Get Windows')
  combobase = widget_base(panel1,/row)
  leftbutton = widget_button(combobase,value='<')
  wincombo = widget_combobox(combobase,value=['-1'],xsize=50)
  rightbutton = widget_button(combobase,value='>')
  printbutton = widget_button(panel1,value='Print to Printer')
  PDFbutton = widget_button(panel1,value='Print To PDF')
  selectbutton = widget_button(panel1,value='Select Printer')

  xsize= 600
  ysize=500
  window,/free,/pixmap,xsize=xsize,ysize=ysize
  winpix = !d.window
  draw = widget_draw(panel2,xsize=xsize,ysize=ysize)
  xptr = ptr_new(!x)
  yptr = ptr_new(!y)

  widget_control,tlb,/realize
  widget_control,draw,get_value=winvis

  state = {tlb:tlb,panel1:panel1,panel2:panel2,quit:quit,$
           getWindows:getWindows,draw:draw,winvis:winvis,winpix:winpix,$
           xsize:xsize,ysize:ysize,xptr:xptr,yptr:yptr,$
           wincombo:wincombo,printbutton:printbutton,PDFButton:PDFButton,$
           leftbutton:leftbutton,rightbutton:rightbutton,workdir:workdir}
  pstate = ptr_new(state)
  widget_control,tlb,set_uvalue=pstate
  
  xmanager,'LK_DirectGraphicsPrintApp',tlb,/no_block, $
            event_handler='LK_DirectGraphicsPrintApp_event', $
            cleanup='LK_DirectGraphicsPrintApp_cleanup'

  LK_DirectGraphicsPrintApp_event,{handler:tlb,id:getWindows}
  
end;LK_DirectGraphicsPrintApp


