; $Id$
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;
; Written by J.R.D. Copley.
;************************************************************************************************
pro dave_get_values_event,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue=state
;
; Respond to "Cancel" button if present.
if (event.id eq state.cbut) then begin
	*(state.cancelPtr)=1
	widget_control,event.top,set_uvalue=state
	widget_control,event.top,/destroy
	return
endif
;
; Respond to "Help" button if present.
if (event.id eq state.hbut) then begin
	res=dialog_message(state.help,/information)
	return
endif
;
; The following code is executed if "Done" is clicked or if there is a <CR>.
nonblank=1
for k=0,state.nvals-1 do begin
	widget_control,state.dialog[k],get_value=strng
	(*(state.ptr))[k]=strng
	nonblank=nonblank and (strng ne "")
endfor
;
; If required, check that all fields are non-blank.
if (state.checkall and not nonblank[0]) then begin
	x=dialog_message("All fields must be non-blank")
endif else begin
	widget_control,event.top,/destroy
endelse
;
return
;
end


;************************************************************************************************
pro dave_get_values,title,text,value,group_leader=group_leader,checkall=checkall,$
	cancel=cancel,help=help
;************************************************************************************************
; This routine, which is not unlike Ronn Kling's "informationpanel.pro", is used to solicit one
; or more strings from the user. The widget's title is title. The fields are labeled with strings
; from the string array called text. Initial values (if supplied) are elements of the array value
; and the output is returned in value.
; 	An example of a call looks like this:
;		text=['MONTH','TIME','YEAR']
; 	value=['March','1440','1999']
; 	dave_get_values,'example input',text,value
;
;	Specifying the group_leader keyword creates a blocking widget centered over the parent.
; If checkall is true all output fields must be non-blank.
; The help keyword, if supplied, is a string or string array. If it is supplied a help button is
; included. Clicking this button reveals the content of the keyword..
; If the cancel keyword is supplied a cancel button is included. If this button is pressed, cancel
; is returned true.
;
compile_opt strictarr
;
; Top level base.
if (not keyword_set(group_leader)) then begin
	tlb=widget_base(title=title,/col)
endif else begin
	tlb=widget_base(group_leader=group_leader,/modal,title=title,/col,/align_center)
endelse
nvals=n_elements(text)
;
; Define value as a string array.
if (n_elements(value) gt 0) then begin
	if (size(value,/type) ne 7) then value=string(value)
endif else begin
	value=strarr(nvals)
endelse
;
; Pad the text entries with blanks so that the boxes line up.
maxlgth=max(strlen(text))
blanket=strjoin(strarr(maxlgth+1)+" ")
for k=0,nvals-1 do begin
	temp=blanket
	strput,temp,text[k]
	text[k]=temp
endfor
;
; Define a compound widget for each entry.
dialog=lonarr(nvals)
for k=0,nvals-1 do begin
	dialog[k]=cw_field(tlb,title=text[k],value=value[k],font="courier",/return_events)
endfor
;
; The bottom line.
bottom=widget_base(tlb,/row,/align_left,/grid_layout)
done=widget_button(bottom,value="    Done    ")
widget_control,tlb,default_button=done
if (n_elements(cancel) gt 0) then begin
	cbut=widget_button(bottom,value='Cancel')
	widget_control,tlb,cancel_button=cbut
endif else begin
	cbut=-1
endelse
if (n_elements(help) gt 0) then begin
	hbut=widget_button(bottom,value="Help")
endif else begin
	help=""
	hbut=-1
endelse
;
centertlb,tlb
widget_control,tlb,/realize
;
ptr=ptr_new(strarr(nvals))
if (not keyword_set(checkall)) then checkall=0
cancelPtr=ptr_new(0)
;
state={dialog:dialog,$
	done:done,$
	cbut:cbut,$
	cancelPtr:cancelPtr,$
	hbut:hbut,$
	help:help,$
	ptr:ptr,$
	nvals:nvals,$
	checkall:checkall,$
	checked:bytarr(nvals)}
;
widget_control,tlb,set_uvalue=state
xmanager,'dave_get_values',tlb
;
; Recover values.
value=*ptr
ptr_free,ptr
cancel=*cancelPtr
ptr_free,cancelPtr
end
