; $Id$
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dave_find_all_draw_widgets,tlb,REVERSE_IDS = reverse_ids
; First get all of the draw widget ids in the hierarchy whose top is TLB.
ids = get_all_ids(tlb);dave_get_all_ids(tlb)
n = n_elements(ids)
if n_elements(ids) eq 0 then begin
   ids = 0L
   *(!dave_e_window) = ids[0]
   return,1
endif
count_draw = 0
draw_ids = 0L
for i = 0,n-1 do begin
   if widget_info(ids[i],/valid_id) then begin
      if widget_info(ids[i],/name) eq 'DRAW' then begin
         if count_draw eq 0 then draw_ids = ids[i] else $
            draw_ids = [draw_ids,ids[i]]
         count_draw = count_draw + 1
      endif
   endif
endfor
if keyword_set(reverse_ids) then draw_ids = reverse(draw_ids)
*(!dave_e_window) = draw_ids[uniq(draw_ids)]
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
