;+; 
; FUNCTION:
;   datestring2Datelong
;
; PURPOSE:
;   Convert dateString in form DD-MMM-YYYY to form YYYYMMDD
;   Example 21-May-2017 to 20170521 where the input dateString
;   is 21-May-2017 and the returned value is 20170521 as a long integer
;
; CATEGORY:
;   Utility used by hfbs_readhscn.pro
;
; PARAMETERS
;   dateString - The input date string eg 21-May-2017
;
; KEYWORDS:
;
; RETURN VALUE:
;    if successful the date as a long integer like 20170521 or 0 otherwise
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May, 2017

;-
function datestring2Datelong, dateString

  if (N_elements(dateString) eq 0) then Return, 0L

  toks = strtok(dateString,'-',/extract,count=ntoks)
  if (ntoks ne 3) then Return, 0L
  case Strlowcase(toks[1]) of
    'jan': mm='01'
    'feb': mm='02'
    'mar': mm='03'
    'apr': mm='04'
    'may': mm='05'
    'jun': mm='06'
    'jul': mm='07'
    'aug': mm='08'
    'sep': mm='09'
    'oct': mm='10'
    'nov': mm='11'
    'dec': mm='12'
    'else': Return, 0L
  endcase

  Return, Long(toks[2]+mm+toks[0])

end