; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_drawplot_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;
;METHODS:
;    cwo_drawplot_data::calculate
;    cwo_drawplot_data::draw
;    cwo_drawplot_data::legend
;    cwo_drawplot_data::xrange
;    cwo_drawplot_data::yrange
;    cwo_drawplot_data::toggleHide
;    cwo_drawplot_data::hide
;    cwo_drawplot_data::show
;    cwo_drawplot_data::hideLegend
;    cwo_drawplot_data::showLegend
;    cwo_drawplot_data::getproperty
;    cwo_drawplot_data::setproperty
;    cwo_drawplot_data::cleanup
;    cwo_drawplot_data::init
;    cwo_drawplot_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################



;###############################################################################
;
;NAME:
;        cwo_drawplot_data::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::calculate,_ref_extra=extra

;THIS METHOD WILL BE OVERRIDDEN IN THE SUBCLASSES TO BE APPROPRIATE FOR
;THE GIVEN DATA TYPE.
;
;e.g.
;1) IN THE CASE OF A CRYSTAL LATTICE, IT WILL CALCULATE THE LATTICE POSITIONS AND
;STRUCTURE FACTORS.  IN THAT CASE THERE WILL ALSO BE A 3d SET OF COORDINATES
;FROM WHICH Qx,y,z WILL BE DERIVED.
;
;2) IN THE CASE OF AN EXPERIMENTAL DATA SET, THESE VALUES WILL BE SUBMITTED
;AT THE TIME OF OBJECT CREATION AND calculate WILL DO NOTHING.
;


end;calculate


;###############################################################################
;
;NAME:
;        cwo_drawplot_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::draw,win,_ref_extra=extra


        self->calculate,_extra=extra
        wset,win

        device,get_decomposed=dc
        device,decomposed=1


        self->getproperty,x=px,y=py,sy=psy,color=color,psym=psym,$
                linestyle=linestyle,legend=legend,showdata=showdata,$
                showlegend=showlegend,ebshow=ebshow,thesymsize=symsize
;print,'cwo_drawplot_data::draw',showlegend
        if showdata ne 0 then begin
            x = *px
            y = *py
            sy = *psy
    ;        x  = *(ref->getproperty(/x))
    ;        y  = *(ref->getproperty(/y))
    ;        sy = *(ref->getproperty(/sy))

            yu = y + sy
            yd = y - sy

    ;        color = ref->getproperty(/color)
    ;        psym = ref->getproperty(/psym)
    ;        legend = ref->getproperty(/legend)

            oplot,x,y,color = color,psym =  psym,linestyle=linestyle,symsize=symsize
            if ebshow gt 0 then errplot,x,yd,yu,color = color
        endif;show

        device, decomposed = dc

end;cwo_drawplot_data::draw

;###############################################################################
;
;NAME:
;        cwo_drawplot_data::legend
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::legend,win,xlegend,ylegend,symsize=symsize,_ref_extra=extra

  wset,win
  
  ; store current device settings
  Device,get_decomposed = dc, get_current_font=existing_font_name
  existing_font_setting = !P.font

  ; use Courier TT fonts instead of the default device fonts for direct graphics plots
  !P.font = 1
  Device, set_font='Courier', /TT_FONT, set_character_size=[10,13]



    if self.showlegend eq 1 then begin
        if n_elements(color) eq 0 then color = 0L
        if n_elements(psym) eq 0 then psym = 0
        if n_elements(symsize) eq 0 then symsize=self.thesymsize

        color = self.color
        psym = self.psym


        if n_elements(xlegend) eq 0 then xlegend = 0.5
        if n_elements(ylegend) eq 0 then ylegend = 0.5

        plot,[0,1],[0,1],xstyle=4,ystyle=4,/nodata,position=[0,0,1,1],/noerase,background=self.white

        symoffset = 0.01

        textcoords = [xlegend,ylegend]
        symcoords  = [xlegend-2.0*symoffset,ylegend+symoffset]

        xsym  = symcoords[0]
        ysym  = symcoords[1]

        xtext = textcoords[0]
        ytext = textcoords[1]


        if self.showlegend gt 0 then begin
            oplot,[xsym],[ysym],$
                    color=color,$
                    psym=psym,$
                    symsize=symsize,$
                    linestyle=linestyle,$
                    _extra=extra

            xyouts, xtext,ytext,self.legend,color = color,charsize=1.15,$;0.85,$
                        _extra=extra
        endif;showlegend
    endif;self.showlegend   (PLOT SELECTION)

  ; retore previous device ettings
  Device,decomposed = dc, set_font=existing_font_name
  !P.font=existing_font_setting

end;cwo_drawplot_data::legend




;###############################################################################
;
;NAME:
;        cwo_drawplot_data::xrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_data::xrange

;print,'cwo_drawplot_data::xrange'
;print,[min(*self.x),max(*self.x)]
;help,/traceback
    return,[min(*self.x),max(*self.x)]

end;xrange
;###############################################################################
;
;NAME:
;        cwo_drawplot_data::yrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_data::yrange

	y  = *self.y
	sy = *self.sy

	fy = finite(y,/nan)
	fsy = finite(sy,/nan)


	;CHECK FOR ALL NaN DATA SET.  cwo_drawplot WILL NEED TO CHECK FOR ALL NaN RANGES.
	whnan = where(finite(*self.y,/nan),ycount)
	if ycount eq n_elements(y) then ret = [!values.d_nan,!values.d_nan]


	if total(fsy) ne n_elements(fsy) then begin
	    ret = [min(*self.y),max(*self.y)]
	endif else begin
	    ret = [min(*self.y - *self.sy),max(*self.y + *self.sy)]
	endelse


	return,ret


end;yrange






;###############################################################################
;
;NAME:
;        cwo_drawplot_data::toggleHide
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::toggleHide
    self.showdata = (self.showdata eq 1 ? 0 : 1)
end;hide

;###############################################################################
;
;NAME:
;        cwo_drawplot_data::hide
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::hide
    self.showdata = 0
end;hide
;###############################################################################
;
;NAME:
;        cwo_drawplot_data::show
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::show
    self.showdata = 1
end;show
;###############################################################################
;
;NAME:
;        cwo_drawplot_data::hideLegend
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::hideLegend
    self.showlegend = 0
end;hide
;###############################################################################
;
;NAME:
;        cwo_drawplot_data::showLegend
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::showLegend
    self.showlegend = 1
end;show

;###############################################################################
;
;NAME:
;        cwo_drawplot_data::writeASCII
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::writeASCII

        fn = dialog_pickfile(path=self.workdir,$
                             title='OUTPUT FILE FOR: '+self.legend,$
                             OVERWRITE_PROMPT=1)

        if fn ne '' then begin

            self.workdir = file_dirname(fn)
            self->getproperty,x=px,y=py,sy=psy

            x = *px
            y = *py
            sy = *psy

            format = '(3g15.7)'
            header = string('x','y','sy',format='(3A15)')

            openw,lun,fn,/get_lun
            printf,lun,header
            for i=0,n_elements(x)-1 do begin
                printf,lun,x[i],y[i],sy[i],format=format
            endfor;i
            free_lun,lun

        endif;show

end;cwo_drawplot_data::writeASCII

;###############################################################################
;
;NAME:
;        cwo_drawplot_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::getproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            workdir=workdir,$
                            _ref_extra=extra

;print,'cwo_drawplot_data::getproperty'
;help,showlegend
;print,arg_present(showlegend)

                if arg_present(id) gt 0 then id = self.id
                if arg_present(x) gt 0 then x = self.x
                if arg_present(y) gt 0 then y = self.y
                if arg_present(sy) gt 0 then sy = self.sy
                if arg_present(legend) gt 0 then legend = self.legend
                if arg_present(color) gt 0 then color = self.color
                if arg_present(psym) gt 0 then psym = self.psym
                if arg_present(linestyle) gt 0 then linestyle = self.linestyle
                if arg_present(thesymsize) gt 0 then thesymsize = self.thesymsize
                if arg_present(showdata) gt 0 then showdata = self.showdata
                if arg_present(showlegend) gt 0 then showlegend = self.showlegend
                if arg_present(ebshow) gt 0 then ebshow = self.ebshow
                if arg_present(workdir) gt 0 then workdir = self.workdir

end;getproperty
;###############################################################################
;
;NAME:
;        cwo_drawplot_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::setproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            workdir=workdir,$
                            _ref_extra=extra

;print,'cwo_drawplot_data::setproperty'
                if n_elements(id) gt 0 then self.id = id
                if n_elements(x) gt 0 then self.x = x
                if n_elements(y) gt 0 then self.y = y
                if n_elements(sy) gt 0 then self.sy = sy
                if n_elements(legend) gt 0 then self.legend = legend
                if n_elements(color) gt 0 then self.color = color
                if n_elements(psym) gt 0 then self.psym = psym
                if n_elements(thesymsize) gt 0 then self.thesymsize = thesymsize
                if n_elements(linestyle) gt 0 then self.linestyle = linestyle
                if n_elements(workdir) gt 0 then self.workdir = workdir

                if n_elements(showdata) gt 0 then begin

                    self.showdata = showdata
                    ;print,showdata
                endif

                if n_elements(showlegend) gt 0 then self.showlegend = showlegend

;if self.showlegend eq 1 then print,'cwo_drawplot_data::setproperty showlegend=',showlegend

;print,self.showlegend
                if n_elements(ebshow) gt 0 then self.ebshow = ebshow

end;setproperty




;###############################################################################
;
;NAME:
;        cwo_drawplot_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data::cleanup
    ;print,'cwo_drawplot_data::cleanup'
    ptr_free,self.x
    ptr_free,self.y
    ptr_free,self.sy
end;cwo_drawplot_data::cleanup
;###############################################################################
;
;NAME:
;        cwo_drawplot_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_data::init,x,y,sy,legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,ebshow=ebshow,$
                                 showlegend=showlegend,thesymsize=symsize,id=id,$
                                 workdir=workdir,$
                                 _ref_extra=extra


    if n_elements(x) gt 0 then begin
        self.x  = ptr_new([x])

        ;ADDING THE NEXT LINE FOR THE CASE WHERE Y IS NOT AVAILABLE?
        if n_elements(y) ne n_elements(x) then y=0*x
        self.y  = ptr_new([y])
        if n_elements(sy) ne n_elements(y) then sy = 0.0*y
        self.sy = ptr_new([sy])
    endif else begin
        self.x  = ptr_new([0.0])
        self.y  = ptr_new([0.0])
        self.sy = ptr_new([0.0])
    endelse

    if n_elements(id) eq 0 then self.id = '' else self.id = id

    if n_elements(workdir) eq 0 then workdir = '.'
    self.workdir = workdir

;print,'cwo_drawplot_data::init self.id=',self.id

        if n_elements(legend) eq 0 then legend = ''
        if n_elements(psym) eq 0 then psym = 0
        if n_elements(color) eq 0 then color = 0L
        if n_elements(linestyle) eq 0 then linestyle = 0
        if n_elements(showdata) eq 0 then showdata = 1
        if n_elements(showlegend) eq 0 then showlegend = 1
        if n_elements(symsize) eq 0 then symsize = 1

    ;print,ebshow
        if n_elements(ebshow) eq 0 then ebshow = 1

        self.legend = legend
        self.psym = psym
        self.color = color
        self.linestyle = linestyle  ;0-5
        self.thesymsize = symsize
        self.showdata = showdata
        self.showlegend = showlegend
        self.ebshow = ebshow

        self.black = 0L                 ;COLORS
        self.red = 255L
        self.green = 256L*255L
        self.blue = 256L*256L*255L
        self.white = 255L + 256L*(255L + 256L*255L)

    return,1

end;cwo_drawplot_data::init

;###############################################################################
;
;NAME:
;        cwo_drawplot_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_data__define,class

    class = {   cwo_drawplot_data,$
                ;inherits myproperties,$
                x:ptr_new(),$
                y:ptr_new(),$
                sy:ptr_new(),$
                workdir:'',$
                legend:'',$
                color:0L,$
                psym:0,$
                linestyle:0,$
                thesymsize:1.0,$
                showdata:0,$
                showlegend:0,$
                ebshow:0,$
                black:0L,$              ;COLORS
                red:255L,$
                green:256L*255L,$
                blue:256L*256L*255L,$
                white:255L + 256L*(255L + 256L*255L),$
                ID:''}


end;cwo_drawplot_data__define
