; $Id$
;###############################################################################
;
;FILENAME:
;        bits2bytes.pro
;
;PURPOSE:
;
;CATEGORY:
;
;
;METHODS IN FILE:
;
;METHODS:
;    bits2bytes
;
;
; AUTHOR:
; John Copley
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; john.copley@nist.gov  301-975-5133
; Tue Feb 13 19:30:57 2007
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        bits2bytes
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;RETURN VALUE:
;
;###############################################################################
function bits2bytes,bits0
    ;
    ; Given a 2-d array of bits (ones and zeros), comprising nc columns and nr rows,
    ;	this function adds up to 7 zeros to the corresponding 1-d array, such that the
    ; number of elements in the resulting array, ntp, is a multiple of 8.
    ; The array is then converted to an array of ntp/8 bytes which is returned to
    ; the calling program.
    n=size(bits0,/dimensions)

    if n_elements(n) gt 1 then begin
      nc=n[0]
      nr=n[1]
    endif else begin
      nc = n[0]
      nr = 1
    endelse
    nt=nc*nr
    ncp=8
    nrp=nt/8
    ntp=ncp*nrp
    bits=reform(bits0,nt)
    if (ntp ne nt) then begin
    	bits=[bits,bytarr(8-nt+ntp)]
    	nrp=nrp+1
    endif
    bitvec=reform(bits,ncp,nrp)
    power2=2^(7-bindgen(8))
    return,byte(total(bitvec*(power2#(bytarr(nrp)+1)),1))
end;bits2bytes
