; $Id$
;###############################################################################
;+
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the DAVETool.
;
; CATEGORY:
;   DAVE Main Tool

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of the DAVETool object
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2004
;-
;###############################################################################





;===============================================================================
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the DAVETool.
;
; CATEGORY:
;   DAVE Main Tool

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of the DAVETool object
;
pro dave, identifier=identifier, _EXTRA=extra
compile_opt idl2


; Where are we executing from (=install directory, hopefully)
defsysv,'!DAVE_DIR', sourcepath()


; DAVE 1.x compatibility setup
colorset
DAVE1Setup, error=error
if (error) then return

; DAVE 2 System setup - register/unregister various components 
if (~DAVESetup()) then return

; version info: == 2.0
versFile = !DAVE_AUXILIARY_DIR+'version.txt'
if (file_test(versfile,/read)) then begin
  line = ''
  openr,unit, versFile, /get_lun
  readf, unit, line
  free_lun, unit, /force
  toks = strsplit(line,' ',/extract,count=ntoks)
  toks = strsplit(toks[1],'.',/extract,count=ntoks)
  DAVE_MAJOR_VERSION = fix(toks[0])
  DAVE_MINOR_VERSION = fix(toks[1])
endif else begin
  DAVE_MAJOR_VERSION=2
  DAVE_MINOR_VERSION=1  
endelse


; Display first-time user message
void = daveInitMessage()

;register the Main Tool
itregister, "DAVEMain", "DAVETool"

;register the main user interface widget creation routine
itregister, "DAVEMain_UI", "wd_davetool", /USER_INTERFACE

;Okay, launch the Main Tool
title = "Data Analysis and Visualization Environment"
identifier = IDLITSYS_CREATETOOL("DAVEMain", name="DAVE Main Tool" $
                                 ,title=title $
                                 ,USER_INTERFACE="DAVEMain_UI" $
                                 ,dave_major_version=DAVE_MAJOR_VERSION $
                                 ,dave_minor_version=DAVE_MINOR_VERSION $
                                )

; Set system preferences
oSystem = _IDLitSys_GetSystem()
oDAVETool = oSystem->GetByIdentifier(identifier)
if (obj_valid(oDAVETool)) then  oDAVETool->InitPreferences


end
