; $Id: getkikf.pro,v 1.2 2012/06/26 15:11:33 kneller Exp $

;Get ki,kf values for the given Qxy, Ei, and Ef.




;####################################################################
function getkikf,Ei,Ef,Qxy,closed


    ;RETURNS ki,kf IN x,y COORDINATES IN UNITS OF �^-1

    ;I WILL GET E, Ei or Ef FIXED, AND DETERMINE WHICH IS FIXED.
    thetaq = atan(Qxy[1]/Qxy[0])

    Q = sqrt(dotp(Qxy,Qxy))

    ki = calc_kmag_from_E(Ei)
    kf = calc_kmag_from_E(Ef)

    ;CHECK THAT SCATTERING TRIANGLE CAN CLOSE WITH THE LAW OF COSINES
    ;Q^2 = ki^2 + kf^2 - 2*ki*kf*cos(angQ)
    check = (ki^2 + kf^2 - Q^2)/(2*ki*kf)
;print,'In getkikf:'
;print,'check=',check
;print,'Ei,f=',Ei,Ef
;help,/traceback
    if abs(check) gt 1 or (finite(check,/nan) ne 0) then begin
        closed = 0
;        print,'SCATTERING TRIANGLE CANNOT CLOSE WITH THE VALUES:'
;        print,'cos(angQ)=',check
;        print,'Ei=',Ei
;        print,'Ef=',Ef
;        print,'ki=',ki
;        print,'kf=',kf
;        print,'Q =['+strtrim(string(Qxy[0]),2)+','+strtrim(string(Qxy[1]),2)+']'
;        help,/traceback
        kivec = double(['NaN','NaN','NaN'])
        kfvec = double(['NaN','NaN','NaN'])

    endif else begin
        closed = 1
        ;kf^2 = ki^2 + Q^2 -2kiQcos(thetaQ-thetai)
        ;thetaQ-thetai = acos((ki^2+Q^2-kf^2)/2kiQ)
        ;thetaQ-acos(arg)=thetai
        arg = (ki^2 + Q^2 - kf^2)/(2*ki*Q)
        thetai = thetaq - acos(arg)

        kivec = ki*[cos(thetai),sin(thetai),0.0]
        kfvec = kivec - Qxy
    endelse

    return,{ki:kivec,kf:kfvec}

end;getkikf

