/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.aqua.AquaLookAndFeelAddons;
import org.jdesktop.swingx.plaf.metal.MetalLookAndFeelAddons;
import org.jdesktop.swingx.plaf.motif.MotifLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsLookAndFeelAddons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentAddon
implements ComponentAddon {
    private String name;

    protected AbstractComponentAddon(String string) {
        this.name = string;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void initialize(LookAndFeelAddons lookAndFeelAddons) {
        lookAndFeelAddons.loadDefaults(this.getDefaults(lookAndFeelAddons));
    }

    @Override
    public void uninitialize(LookAndFeelAddons lookAndFeelAddons) {
        lookAndFeelAddons.unloadDefaults(this.getDefaults(lookAndFeelAddons));
    }

    protected void addBasicDefaults(LookAndFeelAddons lookAndFeelAddons, List<Object> list) {
    }

    protected void addMacDefaults(LookAndFeelAddons lookAndFeelAddons, List<Object> list) {
        this.addBasicDefaults(lookAndFeelAddons, list);
    }

    protected void addMetalDefaults(LookAndFeelAddons lookAndFeelAddons, List<Object> list) {
        this.addBasicDefaults(lookAndFeelAddons, list);
    }

    protected void addMotifDefaults(LookAndFeelAddons lookAndFeelAddons, List<Object> list) {
        this.addBasicDefaults(lookAndFeelAddons, list);
    }

    protected void addWindowsDefaults(LookAndFeelAddons lookAndFeelAddons, List<Object> list) {
        this.addBasicDefaults(lookAndFeelAddons, list);
    }

    private Object[] getDefaults(LookAndFeelAddons lookAndFeelAddons) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.isWindows(lookAndFeelAddons)) {
            this.addWindowsDefaults(lookAndFeelAddons, arrayList);
        } else if (this.isMetal(lookAndFeelAddons)) {
            this.addMetalDefaults(lookAndFeelAddons, arrayList);
        } else if (this.isMac(lookAndFeelAddons)) {
            this.addMacDefaults(lookAndFeelAddons, arrayList);
        } else if (this.isMotif(lookAndFeelAddons)) {
            this.addMotifDefaults(lookAndFeelAddons, arrayList);
        } else {
            this.addBasicDefaults(lookAndFeelAddons, arrayList);
        }
        return arrayList.toArray();
    }

    protected void addResource(List<Object> list, String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            list.add(string2);
            list.add(resourceBundle.getObject(string2));
        }
    }

    protected boolean isWindows(LookAndFeelAddons lookAndFeelAddons) {
        return lookAndFeelAddons instanceof WindowsLookAndFeelAddons;
    }

    protected boolean isMetal(LookAndFeelAddons lookAndFeelAddons) {
        return lookAndFeelAddons instanceof MetalLookAndFeelAddons;
    }

    protected boolean isMac(LookAndFeelAddons lookAndFeelAddons) {
        return lookAndFeelAddons instanceof AquaLookAndFeelAddons;
    }

    protected boolean isMotif(LookAndFeelAddons lookAndFeelAddons) {
        return lookAndFeelAddons instanceof MotifLookAndFeelAddons;
    }

    protected boolean isPlastic() {
        return UIManager.getLookAndFeel().getClass().getName().contains("Plastic");
    }

    protected boolean isSynth() {
        return UIManager.getLookAndFeel().getClass().getName().contains("ynth");
    }
}

